/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.httpClient.HttpClientUtil;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.PwyHelper;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.app.service.ProductCodeMatchTccCodeStrategy;
import com.kingdee.eas.tm.im.basedata.MatchTccStrategyEnum;
import com.kingdee.eas.tm.im.common.comm.CommunicationSetFactory;
import com.kingdee.eas.tm.im.common.comm.CommunicationSetInfo;
import com.kingdee.eas.tm.im.common.comm.LogStatusEnum;
import com.kingdee.eas.tm.im.common.comm.TaxMsgSettingInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogFactory;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.TransDestSystemEnum;
import com.kingdee.eas.tm.im.common.comm.TransOperTypeEnum;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.service.LogService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class ProductCodeMatchTccCodeService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.service.ProductCodeMatchTccCodeService");
    private Context ctx = null;
    private IObjectCollection productCodes = null;
    private String baseURL = null;
    private PwySettingInfo setting = null;
    private String token = null;
    private int goodsCodeInfoLimit = 5;
    private String defaultTaxNumber = null;
    private boolean ignoreMatched = true;
    private Map<String, IObjectCollection> tccInfoMap = new HashMap<String, IObjectCollection>();
    private MatchTccStrategyEnum matchTccStrategy = MatchTccStrategyEnum.KeyMatch;
    private TaxMsgSettingInfo tokenSettingInfo = null;
    private TaxMsgSettingInfo tccQuerySettingInfo = null;

    public void match(Context ctx, IObjectCollection productCodes, MatchTccStrategyEnum matchTccStrategy, boolean ignoreMatched) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.productCodes = productCodes;
        this.matchTccStrategy = matchTccStrategy;
        this.ignoreMatched = ignoreMatched;
        boolean isInitSuccess = this.init();
        if (!isInitSuccess) {
            return;
        }
        this.matchTccCode();
    }

    protected boolean init() throws BOSException, EASBizException {
        this.loadParams();
        this.initCommunicationSet();
        this.initPwysetting();
        this.initToken();
        return this.setting != null && !StringUtils.isEmpty((String)this.token);
    }

    protected void loadParams() throws EASBizException, BOSException {
        String goodsCodeInfoLimitParam = IMFacadeFactory.getLocalInstance(this.ctx).getParamByKey("goodsCodeInfoLimit");
        if (!StringUtils.isEmpty((String)goodsCodeInfoLimitParam)) {
            this.goodsCodeInfoLimit = Integer.valueOf(goodsCodeInfoLimitParam);
        }
        logger.error((Object)("[matchTccCode] loadParam,goodsCodeInfoLimitParam:" + goodsCodeInfoLimitParam));
    }

    protected void initCommunicationSet() throws BOSException {
        String baseUrl = "https://api.piaozone.com";
        CommunicationSetInfo info = CommunicationSetFactory.getLocalInstance(this.ctx).getCommunicationSetCollection().get(0);
        baseUrl = info.isIsPwyDev() ? info.getPwyURL() : info.getPwyDevURL();
        this.setBaseURL(baseUrl);
        this.setDefaultTaxNumber(info.getDefaultTaxNumber());
        logger.error((Object)("[matchTccCode] initCommunicationSet,baseUrl:" + baseUrl + ",defaultTaxNumber" + this.defaultTaxNumber));
        this.tokenSettingInfo = PwyServiceHelper.getMsgSetting(this.ctx, "9003");
        this.tccQuerySettingInfo = PwyServiceHelper.getMsgSetting(this.ctx, "CODE0001");
    }

    protected void initPwysetting() throws EASBizException, BOSException {
        CompanyOrgUnitCollection companys;
        CompanyOrgUnitInfo currentFIUnit;
        CompanyOrgUnitInfo company = currentFIUnit = ContextUtil.getCurrentFIUnit((Context)this.getCtx());
        if (!StringUtils.isEmpty((String)this.getDefaultTaxNumber()) && (companys = CompanyOrgUnitFactory.getLocalInstance((Context)this.getCtx()).getCompanyOrgUnitCollection("where taxNumber = '" + this.getDefaultTaxNumber() + "'")).size() > 0) {
            int index = -1;
            int size = companys.size();
            for (int i = 0; i < size; ++i) {
                if (!currentFIUnit.equals((Object)companys.getObject(i))) continue;
                index = i;
            }
            if (index == -1) {
                company = companys.get(0);
            }
        }
        PwySettingInfo setting = (PwySettingInfo)PwySettingFactory.getLocalInstance(this.getCtx()).getPwySetting(company.getId().toString(), OPTypeEnum.MakeInvoice, null, null);
        this.setSetting(setting);
        if (setting == null) {
            logger.error((Object)("[matchTccCode] not pwysetting : companyID:" + company.getId().toString() + ",companyName:" + company.getName().toString()));
            throw new IMException(IMException.ERRORMSG, new Object[]{company.getName() + IMUtils.getIMResource(this.getCtx(), "NO_PWYSETTING", new String[0])});
        }
    }

    protected void initToken() throws EASBizException, BOSException {
        TaxTransLogInfo pwyLog;
        String token;
        block7: {
            if (this.getSetting() == null) {
                return;
            }
            token = null;
            String url = this.getBaseURL() + "/base/oauth/token";
            Map tokenParamMap = PwyHelper.getSfrz(this.getSetting().getClientId(), this.getSetting().getClientSecret());
            String tokenParam = Kson.getGson().toJson((Object)tokenParamMap);
            pwyLog = this.createPwyLog();
            pwyLog.setCompany(this.getSetting().getCompany());
            pwyLog.setUrl(url);
            pwyLog.setLogType(PwyServiceType.OPR_WEB_GETTOKEN_MAKEINV);
            pwyLog.setSendMsg(tokenParam);
            pwyLog.setSendTime(new Timestamp(System.currentTimeMillis()));
            try {
                String result = HttpClientUtil.doPost((String)url, (String)tokenParam);
                pwyLog.setIsSended(true);
                pwyLog.setRevMsg(result);
                pwyLog.setRevTime(new Timestamp(System.currentTimeMillis()));
                try {
                    JSONObject resultJson = new JSONObject(result);
                    String errcode = resultJson.getString("errcode");
                    if ("0000".equals(errcode)) {
                        token = resultJson.getString("access_token");
                        pwyLog.setLogStatus(LogStatusEnum.FINISH);
                        break block7;
                    }
                    String description = resultJson.getString("description");
                    logger.error((Object)("[matchTccCode] get token failure : " + description));
                    pwyLog.setLogStatus(LogStatusEnum.FAILURE);
                    pwyLog.setDescription(description);
                    pwyLog.setLogDetail(description);
                }
                catch (JSONException e) {
                    logger.error((Object)("[matchTccCode] parse token error : \n" + result.toString()));
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    pwyLog.setLogStatus(LogStatusEnum.SUCCESS);
                    pwyLog.setDescription(e.getMessage());
                }
            }
            catch (Exception e) {
                logger.error((Object)("[matchTccCode] get token failure, url : " + url + " tokenParam : " + tokenParam));
                logger.error((Object)e.getMessage(), (Throwable)e);
                pwyLog.setLogStatus(LogStatusEnum.FAILURE);
                pwyLog.setDescription(e.getMessage());
            }
        }
        this.setToken(token);
        this.addLog2Queue(pwyLog);
        if (token == null) {
            String errorMsg = IMUtils.getString("com.kingdee.eas.tm.im.common.comm.IMCommResource", "GET_TOKEN_ERROR", this.ctx.getLocale());
            throw new IMException(IMException.ERRORMSG, new Object[]{pwyLog.getLogDetail() != null ? pwyLog.getLogDetail() : errorMsg});
        }
    }

    protected TaxTransLogInfo createPwyLog() throws EASBizException, BOSException {
        TaxTransLogInfo pwyLog = TaxTransLogFactory.getLocalInstance(this.ctx).createNewData();
        pwyLog.setSrcSystem(TransSrcSystemEnum.easgui);
        pwyLog.setDestSystem(TransDestSystemEnum.pwy);
        pwyLog.setOperType(TransOperTypeEnum.makeinvoice);
        return pwyLog;
    }

    public void addLog2Queue(TaxTransLogInfo pwyLog) throws EASBizException, BOSException {
        if (this.isNeedWriterLog(pwyLog.getLogType())) {
            new LogService().addLog2Queue(this.ctx, pwyLog);
        }
    }

    protected boolean isNeedWriterLog(PwyServiceType logType) {
        if (PwyServiceType.OPR_WEB_GETTOKEN_MAKEINV.equals((Object)logType)) {
            return this.tokenSettingInfo.isIsWriterLog();
        }
        if (PwyServiceType.OPR_INV_GOODSCODEINFO_QUERY.equals((Object)logType)) {
            return this.tccQuerySettingInfo.isIsWriterLog();
        }
        return false;
    }

    protected void matchTccCode() throws BOSException, EASBizException {
        if (this.isInvokeMultithread()) {
            this.matchTccCodeWithMultithread();
        } else {
            ProductCodeInfo product = null;
            int size = this.getProductCodes().size();
            for (int i = 0; i < size; ++i) {
                product = (ProductCodeInfo)this.getProductCodes().getObject(i);
                if (this.isIgnoreMatched() && product.getTaxClassificationCode() != null) continue;
                this.matchTccCodeSingle(this.getCtx(), product);
            }
        }
    }

    protected void matchTccCodeWithMultithread() throws BOSException {
        ExecutorService service = null;
        try {
            int defaultThreadPoolSize = 8;
            int size = this.productCodes.size();
            int threadPoolsize = size > defaultThreadPoolSize ? defaultThreadPoolSize : size;
            service = Executors.newFixedThreadPool(threadPoolsize);
            CountDownLatch latch = new CountDownLatch(size);
            ProductCodeInfo product = null;
            for (int i = 0; i < size; ++i) {
                product = (ProductCodeInfo)this.productCodes.getObject(i);
                MatchTccCodeTask task = new MatchTccCodeTask(this.ctx, product, latch);
                service.execute(task);
            }
            latch.await();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
    }

    protected void matchTccCodeSingle(Context ctx, ProductCodeInfo product) throws EASBizException, BOSException {
        ArrayList<String> tcccodes;
        TaxTransLogInfo pwyLog;
        block12: {
            if (this.isIgnoreMatched() && product.getTaxClassificationCode() != null) {
                return;
            }
            String goodsNameEncode = "";
            String goodsName = product.getName(ctx.getLocale());
            if (StringUtils.isEmpty((String)goodsName)) {
                return;
            }
            try {
                goodsNameEncode = URLEncoder.encode(goodsName, "utf-8");
            }
            catch (Exception e) {
                logger.error((Object)("[matchTccCode] goodsCodeInfo:" + e.getMessage()), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            String url = this.getBaseURL() + "/m7/bill/invoice/goodsCodeInfo/query?access_token=" + this.token + "&goodsName=" + goodsNameEncode + "&limit=" + this.getGoodsCodeInfoLimit();
            pwyLog = this.createPwyLog();
            pwyLog.setCompany(this.getSetting().getCompany());
            pwyLog.setUrl(url);
            pwyLog.setSendMsg("?access_token=" + this.token + "&goodsName=" + goodsName + "&limit=" + this.getGoodsCodeInfoLimit());
            pwyLog.setLogType(PwyServiceType.OPR_INV_GOODSCODEINFO_QUERY);
            pwyLog.setSendTime(new Timestamp(System.currentTimeMillis()));
            tcccodes = new ArrayList<String>();
            try {
                String result = HttpClientUtil.doGet((String)url);
                pwyLog.setIsSended(true);
                pwyLog.setRevMsg(result);
                pwyLog.setRevTime(new Timestamp(System.currentTimeMillis()));
                try {
                    logger.error((Object)("[matchTccCode] goodsCodeInfo result : \n" + result));
                    JSONObject resultJson = new JSONObject(result);
                    String errcode = resultJson.getString("errcode");
                    if ("0000".equals(errcode)) {
                        JSONObject dataJson = resultJson.getJSONObject("data");
                        JSONArray listJson = dataJson.getJSONArray("list");
                        String taxClassificationCode = null;
                        if (listJson.length() > 0) {
                            for (int i = 0; i < listJson.length(); ++i) {
                                taxClassificationCode = listJson.getJSONObject(i).getString("goodsCode");
                                tcccodes.add(taxClassificationCode);
                            }
                        }
                        pwyLog.setLogStatus(LogStatusEnum.FINISH);
                        break block12;
                    }
                    String description = resultJson.getString("description");
                    logger.error((Object)("[matchTccCode] goodsCodeInfo failure : \n" + description));
                    pwyLog.setLogStatus(LogStatusEnum.FAILURE);
                    pwyLog.setDescription(description);
                }
                catch (JSONException e) {
                    logger.error((Object)("[matchTccCode] parse goodsCodeInfo error : \n" + e.getMessage()), (Throwable)e);
                    pwyLog.setLogStatus(LogStatusEnum.SUCCESS);
                    pwyLog.setDescription(e.getMessage());
                }
            }
            catch (Exception e) {
                logger.error((Object)("[matchTccCode] goodsCodeInfo failure, url : " + url + "\n"));
                logger.error((Object)e.getMessage(), (Throwable)e);
                pwyLog.setLogStatus(LogStatusEnum.FAILURE);
                pwyLog.setDescription(e.getMessage());
            }
        }
        this.addLog2Queue(pwyLog);
        if (tcccodes.isEmpty()) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mergeCode", new HashSet(tcccodes), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true, CompareType.EQUALS));
        view.setFilter(filter);
        TaxClassificationCodeCollection taxCodeColl = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(view);
        this.tccInfoMap.put(product.getId().toString(), (IObjectCollection)taxCodeColl);
        TaxClassificationCodeCollection orderTaxCodeColl = this.orderBySort(tcccodes, taxCodeColl);
        this.setProductTccCode(product, orderTaxCodeColl);
    }

    protected TaxClassificationCodeCollection orderBySort(List tcccodes, TaxClassificationCodeCollection taxCodeColl) {
        HashMap<String, TaxClassificationCodeInfo> tccMap = new HashMap<String, TaxClassificationCodeInfo>();
        TaxClassificationCodeInfo tccInfo = null;
        int size = taxCodeColl.size();
        for (int i = 0; i < size; ++i) {
            tccInfo = taxCodeColl.get(i);
            tccMap.put(tccInfo.getMergeCode(), tccInfo);
        }
        TaxClassificationCodeCollection orderTaxCodeColl = new TaxClassificationCodeCollection();
        int size2 = tcccodes.size();
        for (int i = 0; i < size2; ++i) {
            String taxCode = (String)tcccodes.get(i);
            tccInfo = (TaxClassificationCodeInfo)tccMap.get(taxCode);
            if (tccInfo == null) continue;
            orderTaxCodeColl.add(tccInfo);
        }
        return orderTaxCodeColl;
    }

    protected void setProductTccCode(ProductCodeInfo product, TaxClassificationCodeCollection taxCodeColl) {
        ProductCodeMatchTccCodeStrategy strategy = new ProductCodeMatchTccCodeStrategy();
        TaxClassificationCodeInfo tccInfo = strategy.getProductTccCode(product, taxCodeColl, this.getMatchTccStrategy());
        if (tccInfo != null) {
            product.setTaxClassificationCode(tccInfo);
            String vatSpecialManagement = tccInfo.getVATSpecialManagement();
            if (PreferentialPoliciesEnum.NoTaxation.getAlias().equals(vatSpecialManagement) && BigDecimal.ZERO.equals(tccInfo.getTaxRate())) {
                product.setTaxRate(BigDecimal.ZERO);
                product.setHasPreferential(true);
                product.setPreferentialPolicies(PreferentialPoliciesEnum.NoTaxation);
            } else {
                product.setHasPreferential(false);
                product.setPreferentialPolicies(PreferentialPoliciesEnum.Null);
            }
            product.setTaxClass(tccInfo.getParent());
            product.setTaxRate(tccInfo.getTaxRate());
        }
    }

    protected boolean isInvokeMultithread() {
        return this.productCodes.size() > 1;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public IObjectCollection getProductCodes() {
        return this.productCodes;
    }

    public void setProductCodes(IObjectCollection productCodes) {
        this.productCodes = productCodes;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public PwySettingInfo getSetting() {
        return this.setting;
    }

    public void setSetting(PwySettingInfo setting) {
        this.setting = setting;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public int getGoodsCodeInfoLimit() {
        return this.goodsCodeInfoLimit;
    }

    public void setGoodsCodeInfoLimit(int goodsCodeInfoLimit) {
        this.goodsCodeInfoLimit = goodsCodeInfoLimit;
    }

    public String getDefaultTaxNumber() {
        return this.defaultTaxNumber;
    }

    public void setDefaultTaxNumber(String defaultTaxNumber) {
        this.defaultTaxNumber = defaultTaxNumber;
    }

    public Map<String, IObjectCollection> getTccInfoMap() {
        return this.tccInfoMap;
    }

    public void setTccInfoMap(Map<String, IObjectCollection> tccInfoMap) {
        this.tccInfoMap = tccInfoMap;
    }

    public boolean isIgnoreMatched() {
        return this.ignoreMatched;
    }

    public void setIgnoreMatched(boolean ignoreMatched) {
        this.ignoreMatched = ignoreMatched;
    }

    public MatchTccStrategyEnum getMatchTccStrategy() {
        return this.matchTccStrategy;
    }

    public void setMatchTccStrategy(MatchTccStrategyEnum matchTccStrategy) {
        this.matchTccStrategy = matchTccStrategy;
    }

    class MatchTccCodeTask
    implements Runnable {
        private Context ctx = null;
        private CountDownLatch latch = null;
        private ProductCodeInfo product = null;

        public MatchTccCodeTask(Context ctx, ProductCodeInfo product, CountDownLatch latch) {
            this.ctx = ctx;
            this.latch = latch;
            this.product = product;
        }

        @Override
        public void run() {
            try {
                ProductCodeMatchTccCodeService.this.matchTccCodeSingle(this.ctx, this.product);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

