/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.MakeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.RowType;
import com.kingdee.eas.tm.im.app.service.SplitLimitAmtService;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.common.model.SplitLimitAmtParams;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.apache.log4j.Logger;

public class SplitLimitAmt4NoTaxAmtService
extends SplitLimitAmtService {
    private static Logger logger = Logger.getLogger(SplitLimitAmt4NoTaxAmtService.class);

    public SplitLimitAmt4NoTaxAmtService(SplitLimitAmtParams params) {
        super(params);
    }

    @Override
    public void splitLimitAmtEntry(MakeInvoiceInfo makeInvoice, MakeInvoiceEntryCollection oldEntrys, MakeInvoiceEntryCollection newEntrs, MakeInvoiceEntryInfo oldEntry, MakeInvoiceEntryInfo entryClone) throws EASBizException, BOSException {
        BigDecimal beforeAmt = entryClone.getPriceTax();
        BigDecimal limitAmt = makeInvoice.getLimitAmt();
        BigDecimal newTotalTaxAmt = BigDecimal.ZERO;
        BigDecimal newTotalNoTaxAmt = BigDecimal.ZERO;
        BigDecimal newTotalDeductAmt = BigDecimal.ZERO;
        boolean hasSplit = false;
        MakeInvoiceEntryCollection curNewEntrs = new MakeInvoiceEntryCollection();
        BigDecimal realNoTaxAmt = oldEntry.getActualNoTaxAmt(this.getParams().getDiscountAmtMap());
        entryClone.setOriginRealNoTaxAmt(realNoTaxAmt);
        if (BigDecimal.ZERO.compareTo(limitAmt) != 0 && realNoTaxAmt.divide(limitAmt, 0, 1).intValue() > this.getParams().getSplitLimitAmtMaxCount()) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Split_OverMaxCount_DataError", this.getParams().getCtx().getLocale(), new Object[]{this.getParams().getSplitLimitAmtMaxCount()})});
        }
        while (realNoTaxAmt.compareTo(limitAmt) > 0) {
            BigDecimal oldEntryQty;
            hasSplit = true;
            MakeInvoiceEntryInfo newEntry = (MakeInvoiceEntryInfo)oldEntry.clone();
            newEntry.setId(BOSUuid.create((String)"5A63A7BA"));
            newEntry.setBoolean("KEY_IS_CONSTANTQTY", true);
            BigDecimal newEntryQty = BigDecimal.ZERO;
            BigDecimal bigDecimal = oldEntryQty = oldEntry.getQuantity() == null ? BigDecimal.ZERO : oldEntry.getQuantity();
            if (oldEntryQty.compareTo(BigDecimal.ZERO) == 0) {
                newEntry.setNoTaxAmt(limitAmt);
                oldEntry.setNoTaxAmt(oldEntry.getNoTaxAmt().subtract(limitAmt));
            } else {
                newEntryQty = this.getNewEntryQty(makeInvoice, oldEntry, limitAmt, entryClone);
                oldEntry.setQuantity(oldEntry.getQuantity().subtract(newEntryQty));
                if (BigDecimal.ZERO.compareTo(newEntryQty) == 0) {
                    throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Split_DataError", this.getParams().getCtx().getLocale())});
                }
            }
            this.calcEntryByQty(oldEntry, makeInvoice, entryClone);
            makeInvoice.getEntries().add(oldEntry);
            newEntry.setQuantity(newEntryQty);
            this.calcEntryByQty(newEntry, makeInvoice, entryClone);
            newEntrs.add(newEntry);
            curNewEntrs.add(newEntry);
            newTotalTaxAmt = newTotalTaxAmt.add(newEntry.getPriceTax());
            newTotalNoTaxAmt = newTotalNoTaxAmt.add(newEntry.getNoTaxAmt());
            newTotalDeductAmt = newTotalDeductAmt.add(IMUtils.isNullToZero(newEntry.getDeductAmt()));
            this.splitDiscountEntry(makeInvoice, oldEntrys, newEntrs, oldEntry, newEntry, beforeAmt, curNewEntrs);
            realNoTaxAmt = oldEntry.getActualNoTaxAmt(this.getParams().getDiscountAmtMap());
        }
        BigDecimal entryTaxAmt = entryClone.getPriceTax();
        BigDecimal entryNoTaxAmt = entryClone.getNoTaxAmt();
        BigDecimal entryDeductAmt = IMUtils.isNullToZero(entryClone.getDeductAmt());
        BigDecimal priceTaxAmt = entryTaxAmt.subtract(newTotalTaxAmt);
        BigDecimal noTaxAmt = entryNoTaxAmt.subtract(newTotalNoTaxAmt);
        BigDecimal deductAmt = entryDeductAmt.subtract(newTotalDeductAmt);
        if (hasSplit && (BigDecimal.ZERO.compareTo(priceTaxAmt) > 0 || BigDecimal.ZERO.compareTo(noTaxAmt) > 0 || BigDecimal.ZERO.compareTo(deductAmt) > 0)) {
            logger.error((Object)"\u62c6\u5206\u5931\u8d25\u573a\u666f:\u4ef7\u7a0e\u5408\u8ba1\u3001\u4e0d\u542b\u7a0e\u91d1\u989d\u3001\u6263\u9664\u989d \u4e0d\u6ee1\u8db3\u6362\u7b97\u516c\u5f0f");
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Split_DataError", this.getParams().getCtx().getLocale())});
        }
        BigDecimal noTaxPrice = oldEntry.getNoTaxPrice();
        BigDecimal price = oldEntry.getPrice();
        oldEntry.setPriceTax(priceTaxAmt);
        oldEntry.setPrice(price);
        oldEntry.setNoTaxAmt(noTaxAmt);
        oldEntry.setNoTaxPrice(noTaxPrice);
        oldEntry.setDeductAmt(makeInvoice.isIsDiffTax() ? deductAmt : null);
        oldEntry.setTaxAmt(oldEntry.getPriceTax().subtract(oldEntry.getNoTaxAmt()));
        if (hasSplit) {
            this.calInvoiceEntryFields(oldEntry);
            oldEntry.setBoolean("KEY_IS_CONSTANTQTY", true);
        }
        makeInvoice.getEntries().add(oldEntry);
        this.doEntryDiffer(makeInvoice, oldEntry, curNewEntrs);
    }

    protected BigDecimal getNewEntryQty(MakeInvoiceInfo makeInvoice, MakeInvoiceEntryInfo oldEntry, BigDecimal limitAmt, MakeInvoiceEntryInfo entryClone) {
        BigDecimal newEntyQty = BigDecimal.ZERO;
        if (makeInvoice.getLimitSplitMethod() == 0) {
            BigDecimal tempQty = limitAmt.multiply(entryClone.getQuantity()).divide(entryClone.getOriginRealNoTaxAmt(), 10, 1);
            newEntyQty = new BigDecimal(tempQty.intValue());
            if (BigDecimal.ZERO.compareTo(newEntyQty) == 0) {
                newEntyQty = tempQty.setScale(this.getQuantitySplitPrecision(), RoundingMode.DOWN);
            }
        } else if (makeInvoice.getLimitSplitMethod() == 1) {
            BigDecimal tempQty;
            newEntyQty = tempQty = limitAmt.divide(oldEntry.getNoTaxPrice(), IMConstant.QTY_PRECISION, RoundingMode.DOWN);
        }
        return newEntyQty;
    }

    private void calcEntryByQty(MakeInvoiceEntryInfo entryInfo, MakeInvoiceInfo invoice, MakeInvoiceEntryInfo entryClone) {
        BigDecimal qty = entryInfo.getQuantity();
        if (qty.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal tax;
            BigDecimal noTaxAmt = entryInfo.getNoTaxAmt();
            BigDecimal taxRate = entryInfo.getTaxRate();
            if (invoice.isIsDiffTax()) {
                entryInfo.setDeductAmt(noTaxAmt.multiply(entryClone.getDeductAmt()).divide(entryClone.getNoTaxAmt(), 2, 4));
                tax = noTaxAmt.subtract(entryInfo.getDeductAmt()).multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
            } else {
                entryInfo.setDeductAmt(null);
                tax = noTaxAmt.multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
            }
            BigDecimal entryTaxAmt = noTaxAmt.add(tax);
            entryInfo.setTaxAmt(tax);
            entryInfo.setPriceTax(entryTaxAmt);
        } else if (invoice.isIsDiffTax()) {
            BigDecimal noTaxPrice = entryInfo.getNoTaxPrice();
            BigDecimal taxRate = entryInfo.getTaxRate();
            entryInfo.setNoTaxAmt(qty.multiply(noTaxPrice).setScale(2, 4));
            entryInfo.setDeductAmt(entryInfo.getNoTaxAmt().multiply(entryClone.getDeductAmt()).divide(entryClone.getNoTaxAmt(), 2, 4));
            BigDecimal tax = entryInfo.getNoTaxAmt().subtract(entryInfo.getDeductAmt()).multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
            entryInfo.setTaxAmt(tax);
            entryInfo.setPriceTax(entryInfo.getNoTaxAmt().add(entryInfo.getTaxAmt()));
        } else {
            BigDecimal noTaxPrice = entryInfo.getNoTaxPrice();
            entryInfo.setNoTaxAmt(qty.multiply(noTaxPrice).setScale(2, 4));
            entryInfo.setDeductAmt(null);
            entryInfo.setTaxAmt(entryInfo.getNoTaxAmt().multiply(entryInfo.getTaxRate()).setScale(2, 4));
            entryInfo.setPriceTax(entryInfo.getNoTaxAmt().add(entryInfo.getTaxAmt()));
        }
    }

    @Override
    protected void allocEntryDiffer(MakeInvoiceInfo invoice, MakeInvoiceEntryInfo entry, MakeInvoiceEntryCollection curNewEntrs, Map<String, MakeInvoiceEntryInfo> entryMap, RowType allocRowType) throws EASBizException, BOSException {
        BigDecimal diffFactor;
        BigDecimal totalDiffAmount;
        MakeInvoiceEntryInfo beforeEntry = null;
        if (RowType.DISCOUNT_ROW.equals((Object)allocRowType)) {
            String discountRowId = this.getParams().getSrcMap().get(entry.getId().toString());
            beforeEntry = entryMap.get(discountRowId);
        } else {
            beforeEntry = entry;
        }
        if (beforeEntry == null) {
            return;
        }
        if (!this.isNotSatisfyRelations(invoice, beforeEntry)) {
            return;
        }
        if (invoice.isIsDiffTax()) {
            totalDiffAmount = invoice.getDiffTotalDiffAmount(beforeEntry);
            diffFactor = invoice.getDiffFactor();
        } else {
            totalDiffAmount = invoice.getTotalDiffAmount(beforeEntry);
            diffFactor = invoice.getDiffFactor();
        }
        if (BigDecimal.ZERO.compareTo(IMUtils.isNullToZero(diffFactor)) == 0) {
            logger.error((Object)("diffFactor:" + diffFactor));
            return;
        }
        if (totalDiffAmount.compareTo(BigDecimal.ZERO) > 0) {
            diffFactor = diffFactor.negate();
        }
        int totalDiffRow = totalDiffAmount.divide(diffFactor, 0, RoundingMode.UP).abs().intValue();
        int curDiffRow = 1;
        BigDecimal curDiffAmount = BigDecimal.ZERO;
        MakeInvoiceEntryInfo diffEntry = null;
        MakeInvoiceEntryInfo guessEntry = null;
        String discountedRowId = null;
        MakeInvoiceEntryInfo discountedRow = null;
        for (int i = curNewEntrs.size() - 1; i >= 0; --i) {
            diffEntry = curNewEntrs.get(i);
            if (!diffEntry.getBillRowType().equals((Object)beforeEntry.getBillRowType())) continue;
            guessEntry = (MakeInvoiceEntryInfo)diffEntry.clone();
            this.adjustDiff(invoice, guessEntry, diffFactor, false);
            this.calInvoiceEntryFields(guessEntry);
            BigDecimal actualNoTaxAmt = null;
            if (RowType.DISCOUNT_ROW.equals((Object)allocRowType)) {
                discountedRowId = this.getParams().getDestMap().get(guessEntry.getId().toString());
                discountedRow = entryMap.get(discountedRowId);
                actualNoTaxAmt = discountedRow.getNoTaxAmt().add(guessEntry.getNoTaxAmt());
            } else {
                actualNoTaxAmt = guessEntry.getActualNoTaxAmt(this.getParams().getDiscountAmtMap());
            }
            if (actualNoTaxAmt.compareTo(invoice.getLimitAmt()) > 0 || this.isNotSatisfyRelations(invoice, guessEntry)) continue;
            if (curDiffRow > totalDiffRow) break;
            BigDecimal diffAmt = diffFactor;
            if (curDiffRow == totalDiffRow) {
                diffAmt = totalDiffAmount.add(curDiffAmount).negate();
                diffAmt = diffAmt.setScale(2, 1);
            }
            this.adjustDiff(invoice, diffEntry, diffAmt, false);
            this.calInvoiceEntryFields(diffEntry);
            ++curDiffRow;
            curDiffAmount = curDiffAmount.add(diffAmt);
        }
        this.adjustDiff(invoice, beforeEntry, curDiffAmount, true);
        this.calInvoiceEntryFields(beforeEntry);
    }

    private void adjustDiff(MakeInvoiceInfo invoice, MakeInvoiceEntryInfo entry, BigDecimal diffFactor, boolean isLast) {
        if (isLast) {
            entry.setTaxAmt(entry.getTaxAmt().subtract(diffFactor));
        } else {
            entry.setTaxAmt(entry.getTaxAmt().add(diffFactor));
        }
        entry.setPriceTax(entry.getTaxAmt().add(entry.getNoTaxAmt()));
    }
}

