/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.app.util.IMServiceCache;
import com.kingdee.eas.tm.im.common.model.ClassfiyOverLengthField;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IMServerUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.util.IMServerUtil");
    public static final String NEWLINE = ";\r\n";
    private static Map<String, Class> classCache = new HashMap<String, Class>();
    private static Map<String, Method> methodCache = new HashMap<String, Method>();
    private static Map<String, Object> instanceCache = new HashMap<String, Object>();

    public static void clearTrimInfo(IObjectValue info, String[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            String value = info.getString(fields[i]);
            if (StringUtils.isEmpty((String)value)) continue;
            info.put(fields[i], (Object)value.trim());
        }
    }

    public static void checkEmptyFields(Context ctx, IObjectValue info, String[] fields, Map fieldAlias) throws EASBizException, BOSException {
        IMServerUtil.checkEmptyFields(ctx, info, fields, fieldAlias, "MSG_NOTNULL");
    }

    public static void checkEmptyFields(Context ctx, IObjectValue info, String[] fields, Map fieldAlias, String errorMsgStr) throws EASBizException, BOSException {
        ArrayList<String> billFields = new ArrayList<String>();
        ArrayList<String> entryFields = new ArrayList<String>();
        String field2 = null;
        String entriesName = null;
        for (String field2 : fields) {
            if (field2.indexOf(".") > 0) {
                entryFields.add(field2.split("\\.")[1]);
                entriesName = field2.split("\\.")[0];
                continue;
            }
            billFields.add(field2);
        }
        StringBuffer errorMsg = new StringBuffer();
        if (billFields.size() > 0) {
            IMServerUtil.checkBillEmptyFields(ctx, info, billFields, errorMsg, fieldAlias, errorMsgStr);
        }
        if (entryFields.size() > 0 && !StringUtils.isEmpty(entriesName) && info.get(entriesName) instanceof IObjectCollection) {
            IObjectCollection entries = (IObjectCollection)info.get(entriesName);
            IObjectValue entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.getObject(i);
                IMServerUtil.checkEntryEmptyFields(ctx, i + 1, entry, entryFields, errorMsg, fieldAlias);
            }
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    private static void checkBillEmptyFields(Context ctx, IObjectValue info, List<String> fields, StringBuffer errorMsg, Map fieldAlias, String errorMsgStr) throws EASBizException, BOSException {
        String bosType = info.getBOSType().toString();
        EntityObjectInfo entity = IMServiceCache.getEntity(ctx, bosType);
        PropertyInfo property = null;
        StringBuffer emptyFields = new StringBuffer();
        Set<Object> fieldsSet = new HashSet();
        if (fieldAlias != null) {
            fieldsSet = fieldAlias.keySet();
        }
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            property = entity.getPropertyByName(field);
            if (!IMServerUtil.isEmpty(info, field)) continue;
            if (fieldsSet.contains(field) && fieldAlias != null && fieldAlias.get(field) instanceof String && !StringUtils.isEmpty((String)((String)fieldAlias.get(field)))) {
                emptyFields.append((String)fieldAlias.get(field)).append("\u3001");
                continue;
            }
            emptyFields.append(property.getAlias(ctx.getLocale())).append("\u3001");
        }
        if (emptyFields.length() > 0) {
            errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", errorMsgStr, ctx.getLocale(), new Object[]{emptyFields.substring(0, emptyFields.length() - 1)}));
            if (!"BUSINESSUNITERROR".equals(errorMsgStr)) {
                errorMsg.append(NEWLINE);
            }
        }
    }

    private static void checkEntryEmptyFields(Context ctx, int index, IObjectValue info, List<String> fields, StringBuffer errorMsg, Map fieldAlias) throws EASBizException, BOSException {
        String bosType = info.getBOSType().toString();
        EntityObjectInfo entity = IMServiceCache.getEntity(ctx, bosType);
        PropertyInfo property = null;
        StringBuffer emptyFields = new StringBuffer();
        Set<Object> fieldsSet = new HashSet();
        if (fieldAlias != null) {
            fieldsSet = fieldAlias.keySet();
        }
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            property = entity.getPropertyByName(field);
            if (!IMServerUtil.isEmpty(info, field)) continue;
            if (fieldsSet.contains(field) && fieldAlias != null && fieldAlias.get(field) instanceof String && !StringUtils.isEmpty((String)((String)fieldAlias.get(field)))) {
                emptyFields.append((String)fieldAlias.get(field)).append("\u3001");
                continue;
            }
            emptyFields.append(property.getAlias(ctx.getLocale())).append("\u3001");
        }
        if (emptyFields.length() > 0) {
            errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_ENTRY_NOTNULL", ctx.getLocale(), new Object[]{index, emptyFields.substring(0, emptyFields.length() - 1)})).append(NEWLINE);
        }
    }

    private static boolean isEmpty(IObjectValue value, String field) {
        return value.get(field) == null || value.get(field) instanceof String && StringUtils.isEmpty((String)((String)value.get(field)));
    }

    public static void checkLengthFields(Context ctx, IObjectValue info, String[] fields) throws EASBizException, BOSException {
        ArrayList<String> billFields = new ArrayList<String>();
        ArrayList<String> entryFields = new ArrayList<String>();
        String field2 = null;
        String entriesName = null;
        for (String field2 : fields) {
            if (field2.indexOf(".") > 0) {
                entryFields.add(field2.split("\\.")[1]);
                entriesName = field2.split("\\.")[0];
                continue;
            }
            billFields.add(field2);
        }
        StringBuffer errorMsg = new StringBuffer();
        if (billFields.size() > 0) {
            IMServerUtil.checkBillOverLengthFields(ctx, info, billFields, errorMsg);
        }
        if (entryFields.size() > 0 && !StringUtils.isEmpty(entriesName) && info.get(entriesName) instanceof IObjectCollection) {
            IObjectCollection entries = (IObjectCollection)info.get(entriesName);
            IObjectValue entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.getObject(i);
                IMServerUtil.checkEntryOverLengthFields(ctx, i + 1, entry, entryFields, errorMsg);
            }
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    private static void checkBillOverLengthFields(Context ctx, IObjectValue model, List<String> fields, StringBuffer errorMsg) throws EASBizException, BOSException {
        String bosType = model.getBOSType().toString();
        EntityObjectInfo entity = IMServiceCache.getEntity(ctx, bosType);
        String field = null;
        int maxLength = 0;
        int strLength = 0;
        PropertyInfo property = null;
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            field = fields.get(i);
            String value = model.getString(field);
            if (StringUtils.isEmpty((String)value) || (maxLength = IMServerUtil.getMaxLength(ctx, model, field)) == -1 || (strLength = value.getBytes().length) <= maxLength) continue;
            property = entity.getPropertyByName(field);
            String fieldName = property.getAlias(ctx.getLocale());
            String error = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_OVER_LENGTH", ctx.getLocale(), new Object[]{fieldName, maxLength, strLength});
            errorMsg.append(error).append(NEWLINE);
        }
    }

    private static void checkEntryOverLengthFields(Context ctx, int index, IObjectValue entry, List<String> fields, StringBuffer errorMsg) throws EASBizException, BOSException {
        String bosType = entry.getBOSType().toString();
        EntityObjectInfo entity = IMServiceCache.getEntity(ctx, bosType);
        String field = null;
        int maxLength = 0;
        int strLength = 0;
        PropertyInfo property = null;
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            field = fields.get(i);
            String value = entry.getString(field);
            if (StringUtils.isEmpty((String)value) || (maxLength = IMServerUtil.getMaxLength(ctx, entry, field)) == -1 || (strLength = value.getBytes().length) <= maxLength) continue;
            property = entity.getPropertyByName(field);
            String fieldName = property.getAlias(ctx.getLocale());
            String error = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_ENTRY_OVER_LENGTH", ctx.getLocale(), new Object[]{index, fieldName, maxLength, strLength});
            errorMsg.append(error).append(NEWLINE);
        }
    }

    public static void cutOverLengthFields(Context ctx, IObjectValue info, ClassfiyOverLengthField classfiyField) throws Exception {
        ArrayList<String> billFields = new ArrayList<String>();
        ArrayList<String> entryFields = new ArrayList<String>();
        String field2 = null;
        String entriesName = null;
        for (String field2 : classfiyField.getOverLengthFields()) {
            if (field2.indexOf(".") > 0) {
                entryFields.add(field2.split("\\.")[1]);
                entriesName = field2.split("\\.")[0];
                continue;
            }
            billFields.add(field2);
        }
        if (billFields.size() > 0) {
            IMServerUtil.cutBillOverLengthFields(ctx, info, billFields, classfiyField);
        }
        if (entryFields.size() > 0 && !StringUtils.isEmpty(entriesName) && info.get(entriesName) instanceof IObjectCollection) {
            IObjectCollection entries = (IObjectCollection)info.get(entriesName);
            IObjectValue entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.getObject(i);
                IMServerUtil.cutEntryOverLengthFields(ctx, i + 1, entriesName, entry, entryFields, classfiyField);
            }
        }
    }

    private static void cutBillOverLengthFields(Context ctx, IObjectValue model, List<String> fields, ClassfiyOverLengthField classfiyField) throws Exception {
        String bosType = model.getBOSType().toString();
        EntityObjectInfo entity = IMServiceCache.getEntity(ctx, bosType);
        String field = null;
        Integer maxLength = null;
        String fieldAlias = null;
        StringBuffer headLog = new StringBuffer();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            String value;
            field = fields.get(i);
            if (!IMServerUtil.isStringProperty(entity, field) || StringUtils.isEmpty((String)(value = model.getString(field)))) continue;
            maxLength = classfiyField.getFieldLengthMap().get(field);
            if (maxLength == null) {
                maxLength = IMServerUtil.getMaxLength(ctx, model, field);
            }
            if (maxLength == -1 || value.getBytes("UTF-8").length <= maxLength) continue;
            value = IMServerUtil.subStr(value, maxLength);
            model.put(field, (Object)value);
            fieldAlias = classfiyField.getFieldAliasMap().get(field);
            if (StringUtils.isEmpty((String)fieldAlias)) {
                fieldAlias = entity.getPropertyByName(field).getAlias(ctx.getLocale());
            }
            if (headLog.length() > 0) {
                headLog.append("\u3001");
            }
            headLog.append(fieldAlias);
        }
        if (headLog.length() > 0) {
            classfiyField.getOverLengthLogs().append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_OVERLENGTH_LOG", ctx.getLocale()));
            classfiyField.getOverLengthLogs().append(headLog.toString());
        }
    }

    public static boolean isStringProperty(EntityObjectInfo entity, String field) {
        PropertyInfo property = entity.getPropertyByName(field);
        if (property == null) {
            return false;
        }
        if (property instanceof LinkPropertyInfo) {
            return false;
        }
        String dataType = property.get("dataType").toString();
        return DataType.STRING.toString().equals(dataType);
    }

    public static boolean isLinkProperty(EntityObjectInfo entity, String field) {
        PropertyInfo property = entity.getPropertyByName(field);
        if (property == null) {
            return false;
        }
        return property instanceof LinkPropertyInfo;
    }

    private static void cutEntryOverLengthFields(Context ctx, int index, String entriesName, IObjectValue entry, List<String> fields, ClassfiyOverLengthField classfiyField) throws Exception {
        String bosType = entry.getBOSType().toString();
        EntityObjectInfo entity = IMServiceCache.getEntity(ctx, bosType);
        String field = null;
        Integer maxLength = 0;
        StringBuffer entryLog = new StringBuffer();
        String fieldAlias = null;
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            String value;
            field = fields.get(i);
            if (!IMServerUtil.isStringProperty(entity, field) || StringUtils.isEmpty((String)(value = entry.getString(field)))) continue;
            maxLength = classfiyField.getFieldLengthMap().get(entriesName + "." + field);
            if (maxLength == null) {
                maxLength = IMServerUtil.getMaxLength(ctx, entry, field);
            }
            if (maxLength == -1 || value.getBytes("UTF-8").length <= maxLength) continue;
            if (entryLog.length() == 0) {
                entryLog.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_ENTRY_SEQ", ctx.getLocale(), new Object[]{index})).append(",");
            }
            value = IMServerUtil.subStr(value, maxLength);
            entry.put(field, (Object)value);
            fieldAlias = classfiyField.getFieldAliasMap().get(entriesName + "." + field);
            if (StringUtils.isEmpty((String)fieldAlias)) {
                fieldAlias = entity.getPropertyByName(field).getAlias(ctx.getLocale());
            }
            if (entryLog.length() > 0) {
                entryLog.append("\u3001");
            }
            entryLog.append(fieldAlias);
        }
        if (entryLog.length() > 0) {
            if (classfiyField.getOverLengthLogs().length() > 0) {
                classfiyField.getOverLengthLogs();
            }
            classfiyField.getOverLengthLogs().append(entryLog.toString());
        }
    }

    private static String subStr(String str, int subSLength) throws UnsupportedEncodingException {
        if (str == null) {
            return "";
        }
        int tempSubLength = subSLength;
        String subStr = str.substring(0, str.length() < subSLength ? str.length() : subSLength);
        int subStrByetsL = subStr.getBytes("UTF-8").length;
        while (subStrByetsL > tempSubLength) {
            int subSLengthTemp;
            subStr = str.substring(0, (subSLengthTemp = --subSLength) > str.length() ? str.length() : subSLengthTemp);
            subStrByetsL = subStr.getBytes("UTF-8").length;
        }
        return subStr;
    }

    private static int getMaxLength(Context ctx, IObjectValue value, String field) {
        DataTableInfo tableInfo;
        ColumnInfo columnInfo;
        String bosType = value.getBOSType().toString();
        EntityObjectInfo entity = IMServiceCache.getEntity(ctx, bosType);
        PropertyInfo property = entity.getPropertyByName(field);
        if (property != null && property.getMappingField() != null && property.getMappingField().getName() != null) {
            field = property.getMappingField().getName();
        }
        if ((columnInfo = (tableInfo = entity.getTable()).getColumnByName(field)) == null) {
            return -1;
        }
        SQLType sqlType = columnInfo.getTypeName();
        if (!SQLType.NVARCHAR.equals((Object)sqlType) && !SQLType.VARCHAR.equals((Object)sqlType)) {
            return -1;
        }
        return columnInfo.getLength();
    }

    public static int getThreadPoolSize(Context ctx) throws BOSException, EASBizException {
        int threadPoolSize = 8;
        String threadPoolSizeValue = IMFacadeFactory.getLocalInstance(ctx).getParamByKey("IMThreadPoolSize");
        if (!StringUtils.isEmpty((String)threadPoolSizeValue)) {
            threadPoolSize = Integer.valueOf(threadPoolSizeValue);
        }
        return threadPoolSize;
    }

    public static Object doMethodWithTransaction(String className, String methodName, Class<?>[] classTypes, Object[] params, int transactionLevel) throws EASBizException, BOSException {
        try {
            Object instance;
            String methodkey;
            Method method;
            Class<?> clazz = classCache.get(className);
            if (clazz == null) {
                clazz = Class.forName(className);
                classCache.put(className, clazz);
            }
            if ((method = methodCache.get(methodkey = IMServerUtil.getMethodKey(className, methodName, classTypes))) == null) {
                method = clazz.getDeclaredMethod(methodName, classTypes);
                method.setAccessible(true);
                methodCache.put(methodkey, method);
            }
            if ((instance = instanceCache.get(className)) == null) {
                instance = clazz.newInstance();
                instanceCache.put(className, instance);
            }
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)instance);
            Object value = txInvoker.invoke(method, params, transactionLevel);
            return value;
        }
        catch (Throwable e) {
            if (e instanceof EASBizException) {
                throw (EASBizException)e;
            }
            if (e instanceof BOSException) {
                throw (BOSException)e;
            }
            throw new BOSException(e);
        }
    }

    private static String getMethodKey(String className, String methodName, Class<?>[] classTypes) {
        StringBuilder key = new StringBuilder();
        key.append(className).append("_").append(methodName);
        Class<?> clazz2 = null;
        for (Class<?> clazz2 : classTypes) {
            key.append("_").append(clazz2.getName());
        }
        return key.toString();
    }
}

