/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.utils.TMSqlUtil;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.MakeInvoiceReqBillTypeEnum;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.basedata.InvoiceScanException;
import com.kingdee.eas.tm.im.basedata.QrGenerateRecordCollection;
import com.kingdee.eas.tm.im.basedata.QrGenerateRecordFactory;
import com.kingdee.eas.tm.im.basedata.QrGenerateRecordInfo;
import com.kingdee.eas.tm.im.basedata.QrKeyRelationCollection;
import com.kingdee.eas.tm.im.basedata.QrKeyRelationFactory;
import com.kingdee.eas.tm.im.basedata.QrKeyRelationInfo;
import com.kingdee.eas.tm.im.common.comm.LocalServiceFactory;
import com.kingdee.eas.tm.im.common.comm.LocalServiceInfo;
import com.kingdee.eas.tm.im.common.comm.LogStatusEnum;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.RemoteServiceInfo;
import com.kingdee.eas.tm.im.common.comm.ServiceStateEnum;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogFactory;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.TransDestSystemEnum;
import com.kingdee.eas.tm.im.common.comm.TransOperTypeEnum;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.LogService;
import com.kingdee.eas.tm.im.common.comm.service.util.CommUtil;
import com.kingdee.eas.tm.im.common.comm.service.util.FpyServiceHelper;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.util.IMMutexHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.ws.model.ResultData;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

public class InvoiceScanUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.util.InvoiceScanUtil");
    public static final String INVOICESCAN_RESOURCE = "com.kingdee.eas.tm.im.basedata.InvoiceScanResource";
    public static final String lockSrcString = "_InvoiceScan_";
    public static Map<String, String> qrCache = new ConcurrentHashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCloud(Context ctx, CompanyOrgUnitInfo company, Map param) throws EASBizException, BOSException {
        RemoteServiceInfo remoteServiceInfo = FpyServiceHelper.getRemoteService(ctx);
        if (ServiceStateEnum.INITED.equals((Object)remoteServiceInfo.getState())) {
            return;
        }
        try {
            IMMutexHelper.requestMutex(ctx, remoteServiceInfo.getId().toString());
            InvoiceScanUtil.invokeInitCloud(ctx, company, param);
        }
        finally {
            IMMutexHelper.releaseMutex(ctx, remoteServiceInfo.getId().toString());
        }
    }

    public static String buildKey(IObjectValue info, List<String> propList) {
        StringBuffer retValue = new StringBuffer();
        for (int i = 0; i < propList.size(); ++i) {
            String prop = propList.get(i);
            Object obj = info.get(prop);
            if (obj instanceof IObjectValue) {
                retValue.append(((IObjectValue)obj).get("id").toString());
            } else if (obj != null) {
                retValue.append(obj.toString());
            }
            retValue.append("_");
        }
        return retValue.toString();
    }

    public static void syncQrKey(Context ctx, CompanyOrgUnitInfo company, Map param) throws EASBizException, BOSException {
        if (qrCache.size() == 0) {
            InvoiceScanUtil.batchFetchQrKey(ctx);
        }
        if (!qrCache.containsKey(company.getTaxNumber())) {
            InvoiceScanUtil.loadQrKey(ctx, company.getTaxNumber());
        }
        if (!qrCache.containsKey(company.getTaxNumber())) {
            InvoiceScanUtil.invokeSyncQrKey(ctx, company, param);
        }
    }

    public static String getQrKeyFromCache(Context ctx, String taxNumber) throws EASBizException, BOSException {
        return qrCache.get(taxNumber);
    }

    public static MakeInvoiceReqBillTypeEnum getBillType(String bosType) throws InvoiceScanException {
        MakeInvoiceReqBillTypeEnum billType = null;
        if ("AC368D2D".equals(bosType)) {
            billType = MakeInvoiceReqBillTypeEnum.MakeInvoiceReq;
        } else if ("FC910EF3".equals(bosType)) {
            billType = MakeInvoiceReqBillTypeEnum.OtherReceiveBill;
        } else {
            throw new InvoiceScanException(InvoiceScanException.EXP_BOSTYPE_NOTSUPPORT, new String[]{bosType});
        }
        return billType;
    }

    public static void generateQrUrl(Context ctx, QrGenerateRecordInfo recordInfo) throws EASBizException, BOSException {
        RemoteServiceInfo remoteService = FpyServiceHelper.getRemoteService(ctx);
        String md5Value = DigestUtils.md5Hex((String)(recordInfo.getQrKey() + new StringBuilder(recordInfo.getQrKey()).reverse().toString()));
        long timestamps = System.currentTimeMillis();
        StringBuilder qrUrl = new StringBuilder();
        qrUrl.append(remoteService.getQrUrl());
        qrUrl.append("?k=").append(recordInfo.getQrKey()).append(",");
        qrUrl.append(recordInfo.getBillNo()).append(",");
        qrUrl.append(recordInfo.getTotalAmount().toPlainString()).append(",");
        qrUrl.append(timestamps).append(",");
        qrUrl.append(md5Value);
        qrUrl.append("&lx=2");
        recordInfo.setQrUrl(qrUrl.toString());
    }

    private static void invokeInitCloud(Context ctx, CompanyOrgUnitInfo company, Map param) throws EASBizException, BOSException {
        RemoteServiceInfo remoteServiceInfo = FpyServiceHelper.getRemoteService(ctx);
        if (ServiceStateEnum.INITED.equals((Object)remoteServiceInfo.getState())) {
            return;
        }
        LocalServiceInfo localServiceInfo = remoteServiceInfo.getLocalService();
        if (localServiceInfo != null && ServiceStateEnum.UNINIT.equals((Object)localServiceInfo.getState())) {
            localServiceInfo.setAccountId(CommUtil.nextId());
            localServiceInfo.setState(ServiceStateEnum.INITED);
            LocalServiceFactory.getLocalInstance(ctx).save((CoreBaseInfo)localServiceInfo);
        }
        boolean isFromWeb = param.get("isFromWeb") == null ? false : (Boolean)param.get("isFromWeb");
        TransSrcSystemEnum ownerSystem = isFromWeb ? TransSrcSystemEnum.easweb : TransSrcSystemEnum.easgui;
        PwyServiceType serviceType = PwyServiceType.OPR_INV_INVOICE_SCAN_INITCLOUD;
        PwyActionParam actionParam = new PwyActionParam(serviceType, ownerSystem, company.getId().toString(), null, null);
        actionParam.setParams(new HashMap());
        PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getLocalInstance(ctx).invoke(actionParam);
        IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, invokeParam);
        pwyService.invoke();
        if (!pwyService.isSuccess()) {
            throw new InvoiceScanException(InvoiceScanException.EXP_INITCLOUD_FAILURE, new Object[]{pwyService.getInvokeParam().getDescription()});
        }
    }

    private static void batchFetchQrKey(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("taxNumber"));
        sic.add(new SelectorItemInfo("qrKey"));
        view.setSelector(sic);
        QrKeyRelationCollection coll = QrKeyRelationFactory.getLocalInstance(ctx).getQrKeyRelationCollection(view);
        QrKeyRelationInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            qrCache.put(info.getTaxNumber(), info.getQrKey());
        }
    }

    private static void loadQrKey(Context ctx, String taxNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taxNumber", (Object)taxNumber, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("taxNumber"));
        sic.add(new SelectorItemInfo("qrKey"));
        view.setSelector(sic);
        QrKeyRelationCollection coll = QrKeyRelationFactory.getLocalInstance(ctx).getQrKeyRelationCollection(view);
        QrKeyRelationInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            qrCache.put(info.getTaxNumber(), info.getQrKey());
        }
    }

    private static void invokeSyncQrKey(Context ctx, CompanyOrgUnitInfo company, Map param) throws EASBizException, BOSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taxNos", company.getTaxNumber());
        boolean isFromWeb = param.get("isFromWeb") == null ? false : (Boolean)param.get("isFromWeb");
        TransSrcSystemEnum ownerSystem = isFromWeb ? TransSrcSystemEnum.easweb : TransSrcSystemEnum.easgui;
        PwyServiceType serviceType = PwyServiceType.OPR_INV_INVOICE_SCAN_SYNCKEY;
        PwyActionParam actionParam = new PwyActionParam(serviceType, ownerSystem, company.getId().toString(), null, null);
        actionParam.setParams(params);
        PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getLocalInstance(ctx).invoke(actionParam);
        IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, invokeParam);
        pwyService.invoke();
        if (pwyService.isSuccess()) {
            List qrList = (List)pwyService.getInvokeParam().getInvokeActionMap().get("qrList");
            if (qrList != null && qrList.size() > 0) {
                String qrKey = qrList.get(0).toString().split("_")[0];
                qrCache.put(company.getTaxNumber(), qrKey);
            }
        } else {
            throw new InvoiceScanException(InvoiceScanException.EXP_SYNCKEY_FAILURE, new Object[]{pwyService.getInvokeParam().getDescription()});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String parsePurchaseTitle(Context ctx, String dataJSON) throws EASBizException, BOSException {
        TaxTransLogInfo pwyLog = TaxTransLogFactory.getLocalInstance(ctx).createNewData();
        pwyLog.setSrcSystem(TransSrcSystemEnum.easweb);
        pwyLog.setDestSystem(TransDestSystemEnum.ifpy);
        pwyLog.setOperType(TransOperTypeEnum.makeinvoice);
        pwyLog.setUrl("/easportal/openapi/api");
        JSONObject json = null;
        String type = null;
        try {
            pwyLog.setSendMsg(dataJSON);
            pwyLog.setIsSended(true);
            pwyLog.setSendTime(new Timestamp(System.currentTimeMillis()));
            json = new JSONObject(dataJSON);
            type = json.getString("interfaceCode");
            if (!"BUYER.TITLE".equals(type)) throw new InvoiceScanException(IMException.ERRORMSG, new Object[]{IMUtils.getString(INVOICESCAN_RESOURCE, "MSG_BACKCALL_ERROR", ctx.getLocale())});
            pwyLog.setLogType(PwyServiceType.OPR_INV_INVOICE_PURCHASETITLE);
            JSONObject billObject = json.getJSONObject("data");
            String billNo = billObject.getString("billNo");
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billNo", (Object)billNo, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            QrGenerateRecordCollection coll = QrGenerateRecordFactory.getLocalInstance(ctx).getQrGenerateRecordCollection(viewInfo);
            if (coll.size() <= 0) throw new InvoiceScanException(IMException.ERRORMSG, new Object[]{IMUtils.getString(INVOICESCAN_RESOURCE, "MSG_NOTEXIST_RECORD", ctx.getLocale())});
            Object recordInfo = null;
            String billIds = "";
            for (int i = 0; i < coll.size(); ++i) {
                MakeInvoiceReqBillTypeEnum billType = coll.get(i).getBillType();
                billIds = coll.get(i).getBillIDs();
                if (IMUtils.isEmpty(billIds)) throw new InvoiceScanException(IMException.ERRORMSG, new Object[]{IMUtils.getString(INVOICESCAN_RESOURCE, "MSG_NOTEXIST_BILL", ctx.getLocale())});
                HashSet idSet = InvoiceScanUtil.stringConverHashSet(billIds);
                String srcTable = "";
                String formatSql = "";
                if (MakeInvoiceReqBillTypeEnum.OtherReceiveBill.equals((Object)billType)) {
                    srcTable = "T_AR_OtherBill";
                    InvoiceScanUtil.checkOtherbillHasMakeInvoiceReq(ctx, idSet);
                    InvoiceScanUtil.checkHasMakeInvoice(ctx, idSet, srcTable);
                    formatSql = "UPDATE T_AR_OtherBill set FComInvoiceName = {0},FTaxNo = {1},FOBankAndAcountNum = {2},FAddressAndTel = {3},FRecBillPhone = {4},FRecBillEmail = {5} where FID in ({6})";
                } else {
                    if (!MakeInvoiceReqBillTypeEnum.MakeInvoiceReq.equals((Object)billType)) throw new InvoiceScanException(IMException.ERRORMSG, new Object[]{IMUtils.getString(INVOICESCAN_RESOURCE, "MSG_NOTSUPPORT_BILLTYPE", ctx.getLocale())});
                    srcTable = "T_IM_MakeInvoiceReq";
                    InvoiceScanUtil.checkHasMakeInvoice(ctx, idSet, srcTable);
                    formatSql = "UPDATE T_IM_MakeInvoiceReq set FRecOrgName = {0},FTaxNumber = {1},FBankAccount = {2},FAddress = {3},FRecBillPhone = {4},FRecBillEmail = {5} where FID in ({6})";
                }
                String buyerProperty = InvoiceScanUtil.emptyFormat(billObject.getString("buyerProperty"));
                String buyerName = InvoiceScanUtil.emptyFormat(billObject.getString("buyerName"));
                String buyerTaxpayerId = InvoiceScanUtil.emptyFormat(billObject.getString("buyerTaxpayerId"));
                String buyerBankAndAccount = InvoiceScanUtil.emptyFormat(billObject.getString("buyerBankAndAccount"));
                String buyerAddressAndTel = InvoiceScanUtil.emptyFormat(billObject.getString("buyerAddressAndTel"));
                String buyerRecipientPhone = InvoiceScanUtil.emptyFormat(billObject.getString("buyerRecipientPhone"));
                String buyerRecipientMail = InvoiceScanUtil.emptyFormat(billObject.getString("buyerRecipientMail"));
                TMSqlUtil.executeNotInject((Context)ctx, (String)formatSql, (Object[])new Object[]{buyerName, buyerTaxpayerId, buyerBankAndAccount, buyerAddressAndTel, buyerRecipientPhone, buyerRecipientMail, idSet});
            }
        }
        catch (Exception e) {
            pwyLog.setLogStatus(LogStatusEnum.FAILURE);
            pwyLog.setRevMsg(ResultData.buildSubmitFailure(e.getMessage()));
            pwyLog.setRevTime(new Timestamp(System.currentTimeMillis()));
            pwyLog.setDescription(e.getMessage());
            new LogService().addLog2Queue(ctx, pwyLog);
            throw new BOSException(e.getMessage());
        }
        pwyLog.setLogStatus(LogStatusEnum.FINISH);
        String successRevMsg = ResultData.buildSuccess(IMUtils.getString(INVOICESCAN_RESOURCE, "MSG_PURCHASETITLE_SUBMIT_SUCCESS", ctx.getLocale()));
        pwyLog.setRevMsg(successRevMsg);
        pwyLog.setRevTime(new Timestamp(System.currentTimeMillis()));
        new LogService().addLog2Queue(ctx, pwyLog);
        return successRevMsg;
    }

    private static void checkOtherbillHasMakeInvoiceReq(Context ctx, Set<String> idSet) throws EASBizException, BOSException {
        if (idSet.isEmpty()) {
            return;
        }
        if (!InvoiceScanUtil.checkIsField(ctx)) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select ar.fid from t_ar_otherbill ar");
        sql.append(" inner join t_ar_otherbillEntry are on  ar.fid = are.FParentID");
        sql.append(" where ar.fid  IN ({0}) ");
        sql.append(" and (are.FInvoiceReqBaseQty!=0 or are.FInvoiceReqAmountLocal!=0)");
        IRowSet rs = TMSqlUtil.executeQueryNotInject((Context)ctx, (String)sql.toString(), (Object[])new Object[]{idSet});
        try {
            if (rs.next()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString(INVOICESCAN_RESOURCE, "MSG_HAS_MAKEINVOICEREQ", ctx.getLocale())});
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private static boolean checkIsField(Context ctx) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_AR_OtherBillEntry' AND KSQL_COL_NAME = 'FInvoiceReqBaseQty'");
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return false;
    }

    protected static void checkHasMakeInvoice(Context ctx, Set<String> idSet, String srcTable) throws EASBizException, BOSException {
        if (idSet.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select fbizbillid from t_im_makeinvoicerelation t1 ");
        sql.append(" inner join t_im_makeinvoice t2 on t1.FINVOICEBILLID = t2.fid ");
        sql.append(" inner join " + srcTable + " src on t1.fbizbillid = src.fid");
        sql.append(" where t1.fbizbillid  IN ({0}) ");
        sql.append(" and (");
        sql.append(" src.FInvoicedAmt <> 0");
        sql.append(" or  ");
        sql.append(" t2.fid  in  ( SELECT fid FROM  t_im_makeinvoice  where FStatus in ('1','2','3') ) ");
        sql.append(")");
        IRowSet rs = TMSqlUtil.executeQueryNotInject((Context)ctx, (String)sql.toString(), (Object[])new Object[]{idSet});
        try {
            if (rs.next()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString(INVOICESCAN_RESOURCE, "MSG_HAS_MAKEINVOICE", ctx.getLocale())});
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private static HashSet stringConverHashSet(String billIds) {
        String[] billIDs = billIds.split(";");
        HashSet<String> idSet = new HashSet<String>();
        for (String billID : billIDs) {
            idSet.add(billID);
        }
        return idSet;
    }

    private static String emptyFormat(String str) {
        if ("".equals(str) || "null".equals(str)) {
            return null;
        }
        return str;
    }
}

