/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqCollection;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqEntryCollection;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqEntryFactory;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqFactory;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqInfo;
import com.kingdee.eas.tm.im.util.IMSelectorFactory;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UsedCarServerUtil {
    public static UsedCarInvoiceReqCollection getUsedCarInvoiceReqCollection(Context ctx, Set idSet, Set entryIdSet) throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(IMSelectorFactory.getUsedCarInvoiceReqSelectors());
        UsedCarInvoiceReqCollection coll = UsedCarInvoiceReqFactory.getLocalInstance(ctx).getUsedCarInvoiceReqCollection(ev);
        if (entryIdSet == null || entryIdSet.size() == 0) {
            return coll;
        }
        UsedCarInvoiceReqCollection bizColl = new UsedCarInvoiceReqCollection();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            UsedCarInvoiceReqInfo info = (UsedCarInvoiceReqInfo)it.next();
            UsedCarInvoiceReqEntryInfo entryInfo = null;
            UsedCarInvoiceReqEntryCollection newEntries = new UsedCarInvoiceReqEntryCollection();
            int size = info.getEntries().size();
            for (int i = 0; i < size; ++i) {
                entryInfo = info.getEntries().get(i);
                if (!entryIdSet.contains(entryInfo.getId().toString())) continue;
                newEntries.add(entryInfo);
            }
            if (newEntries.size() <= 0) continue;
            info.getEntries().clear();
            info.getEntries().addCollection(newEntries);
            bizColl.add(info);
        }
        return bizColl;
    }

    public static void buildBillErrorMsg(Context ctx, Map billErrMap, StringBuffer errorMsg, List entryIds, Map billEntryErrMap) throws BOSException {
        Set idSet = billErrMap.keySet();
        if (idSet == null || idSet.size() == 0) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("entries.id");
        ev.setSelector(sic);
        UsedCarInvoiceReqCollection bizColl = UsedCarInvoiceReqFactory.getLocalInstance(ctx).getUsedCarInvoiceReqCollection(ev);
        String billType = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "UsedCarInvoiceReq", ctx.getLocale());
        for (int i = 0; i < bizColl.size(); ++i) {
            UsedCarInvoiceReqInfo info = bizColl.get(i);
            String id = info.getId().toString();
            errorMsg.append(billType + IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_BILL_ERROR", ctx.getLocale(), new Object[]{info.getNumber(), billErrMap.get(id)})).append("\r\n");
            if (entryIds == null || billEntryErrMap == null) continue;
            Iterator it = info.getEntries().iterator();
            while (it.hasNext()) {
                UsedCarInvoiceReqEntryInfo entryInfo = (UsedCarInvoiceReqEntryInfo)it.next();
                if (!entryIds.contains(entryInfo.getId().toString())) continue;
                billEntryErrMap.put(entryInfo.getId().toString(), null);
            }
        }
    }

    public static void buildEntryErrorMsg(Context ctx, Map billEntryErrMap, StringBuffer errorMsg) throws BOSException {
        HashSet<String> entryIdSet = new HashSet<String>();
        Iterator it = billEntryErrMap.keySet().iterator();
        while (it.hasNext()) {
            String entryId = it.next().toString();
            entryIdSet.add(entryId);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("parent.number");
        sic.add("seq");
        ev.setSelector(sic);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("parent.number"));
        sort.add(new SorterItemInfo("seq"));
        ev.setSorter(sort);
        UsedCarInvoiceReqEntryCollection bizEntryColl = UsedCarInvoiceReqEntryFactory.getLocalInstance(ctx).getUsedCarInvoiceReqEntryCollection(ev);
        String billType = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "UsedCarInvoiceReq", ctx.getLocale());
        for (int i = 0; i < bizEntryColl.size(); ++i) {
            UsedCarInvoiceReqEntryInfo info = bizEntryColl.get(i);
            String id = info.getId().toString();
            if (billEntryErrMap.get(id) == null) continue;
            errorMsg.append(billType + IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_ENTRY_ERROR", ctx.getLocale(), new Object[]{info.getParent().getNumber(), info.getSeq(), billEntryErrMap.get(id)})).append("\r\n");
        }
    }
}

