/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.InvoiceRespInfo;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeException;
import com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeFactory;
import com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeInfo;
import com.kingdee.eas.tm.im.basedata.AutoSchemeStatusEnum;
import com.kingdee.eas.tm.im.basedata.app.AbstractAutoMakeInvoiceFacadeControllerBean;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.util.DateUtils;
import com.kingdee.eas.tm.im.util.IMSQLUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AutoMakeInvoiceFacadeControllerBean
extends AbstractAutoMakeInvoiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.basedata.app.AutoMakeInvoiceFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _makeInvoice(Context ctx, IObjectValue autoMakeInvoiceScheme, IObjectCollection companyRange) throws BOSException, EASBizException {
        Object ruleIDs;
        logger.error((Object)"enter AutoMakeInvoiceFacadeControllerBean _makeInvoice.");
        Context newCtx = null;
        HashMap ret = new HashMap();
        try {
            newCtx = (Context)ObjectUtils.createCopy((Object)ctx);
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)"256c221a-0106-1000-e000-10d7c0a813f413B7DE7F"));
            newCtx.put((Object)"UserInfo", (Object)userInfo);
            newCtx.setCaller((IObjectPK)new ObjectUuidPK(userInfo.getId()));
            newCtx.put((Object)"currentUserID", ctx.getCaller() == null ? userInfo.getId() : ctx.getCaller());
        }
        catch (CloneNotSupportedException e1) {
            throw new BOSException((Throwable)e1);
        }
        AutoMakeInvoiceSchemeInfo schemeInfo = (AutoMakeInvoiceSchemeInfo)autoMakeInvoiceScheme;
        if (schemeInfo == null || StringUtils.isEmpty((String)schemeInfo.getId().toString())) {
            this.sendBMCMsg(newCtx, "failed", EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"CHECK_AUTO_NULL"), 0);
            return this.handleRetMap(ret, 0, 0, 0, EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"CHECK_AUTO_NULL"));
        }
        schemeInfo = AutoMakeInvoiceSchemeFactory.getLocalInstance(newCtx).getAutoMakeInvoiceSchemeInfo((IObjectPK)new ObjectUuidPK(schemeInfo.getId()), this.getSelectors());
        newCtx.put((Object)"billName", (Object)schemeInfo.getName());
        if (schemeInfo.getStatus() == AutoSchemeStatusEnum.FORBIDDEN) {
            this.sendBMCMsg(newCtx, "failed", EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"CHECK_AUTO_FORBIDDEN", (Object[])new Object[]{schemeInfo.getNumber()}), 0);
            return this.handleRetMap(ret, 0, 0, 0, EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"CHECK_AUTO_FORBIDDEN"));
        }
        Map<String, String> requiredID = this.getRequiredID(newCtx, schemeInfo, companyRange);
        if (requiredID.size() == 0) {
            this.sendBMCMsg(newCtx, "failed", EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"CHECK_AMK_NULL"), 0);
            return this.handleRetMap(ret, 0, 0, 0, EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"CHECK_AMK_NULL"));
        }
        MakeInvoiceParam param = new MakeInvoiceParam();
        String srcBosType = schemeInfo.getDataSourceBill().getBillBosType();
        if (!"412A6F98".equals(srcBosType)) {
            String destRuleId = schemeInfo.getDestCombinRule().getId().toString();
            String sourceRuleId = schemeInfo.getSrcCombinRule().getId().toString();
            ruleIDs = new HashMap<String, String>();
            ((HashMap)ruleIDs).put("destRuleID", destRuleId);
            ((HashMap)ruleIDs).put("srcRuleID", sourceRuleId);
            param.setRuleIDs((Map)ruleIDs);
        }
        if (schemeInfo.getDestInvoiceType() != null) {
            param.setInvoiceType(schemeInfo.getDestInvoiceType().getValue());
        }
        param.setPrint(false);
        param.setReq(false);
        param.setSrcBosType(srcBosType);
        if ("FC910EF3".equals(srcBosType)) {
            param.setSrcSystem(IMConstant.SRCTYPE_FI_AR);
        } else if ("3D667D4A".equals(srcBosType)) {
            param.setSrcSystem(IMConstant.SRCTYPE_IM_REQ);
        } else if ("AC368D2D".equals(srcBosType)) {
            param.setSrcSystem(IMConstant.SRCTYPE_IM_INVOICEREQ);
        }
        StringBuffer paramID = new StringBuffer();
        ArrayList<String> requiredIds = new ArrayList<String>();
        for (String id : requiredID.keySet()) {
            paramID.append(id).append(",");
            requiredIds.add(id);
        }
        param.setBilBillIds(paramID.toString());
        try {
            IMUtils.tryLock(newCtx, requiredIds);
            ruleIDs = this.makeInvoice(ctx, requiredID, srcBosType, param, requiredIds, newCtx);
            return ruleIDs;
        }
        catch (Exception e) {
            this.sendBMCMsg(newCtx, "failed", e.getMessage(), 0);
            Map map = this.handleRetMap(ret, 0, 0, 0, e.getMessage());
            return map;
        }
        finally {
            IMUtils.releaseLock(newCtx, requiredIds);
        }
    }

    private Map handleRetMap(Map ret, int state, int success, int failure, String error) {
        ret.put("state", state);
        ret.put("success", success);
        ret.put("failure", failure);
        ret.put("error", error);
        return ret;
    }

    private Map makeInvoice(Context ctx, Map<String, String> requiredID, String srcBosType, MakeInvoiceParam param, ArrayList requiredIds, Context newCtx) throws BOSException, EASBizException {
        if ("412A6F98".equals(srcBosType)) {
            return this.makeInvoice(requiredIds, param, newCtx);
        }
        return this.makeArOrReqInvoice(ctx, srcBosType, requiredID, param, newCtx);
    }

    private Map makeArOrReqInvoice(Context ctx, String srcBosType, Map<String, String> requiredID, MakeInvoiceParam param, Context newCtx) throws BOSException, EASBizException {
        int failCount = 0;
        StringBuffer invokeErrorMsg = new StringBuffer();
        HashMap ret = new HashMap();
        StringBuffer generateSuccessMsg = new StringBuffer();
        StringBuffer invokeSuccessMsg = new StringBuffer();
        InvoiceRespInfo resp = IMInvoiceFacadeFactory.getLocalInstance(newCtx).makeInvoice(param);
        String errorMsg = resp.getErrorMsg();
        ArrayList mkBillIds = resp.getMkFailBills();
        ArrayList mkToMakeBillIds = resp.getMkSucessBillIds();
        Map<String, ArrayList> relationMap = resp.getDestBillRelation();
        if (!mkToMakeBillIds.isEmpty()) {
            mkBillIds.addAll(mkToMakeBillIds);
            ArrayList list = IMInvoiceFacadeFactory.getLocalInstance(newCtx).autoBuildPwyParam(mkToMakeBillIds, TransSrcSystemEnum.easgui);
            for (int i = 0; i < list.size(); ++i) {
                Map resultMap = (Map)list.get(i);
                MakeInvoiceInfo mkBillInfo = (MakeInvoiceInfo)resultMap.get("info");
                String invoiceID = (String)resultMap.get("billId");
                PwyInvokeParam invokeParam = (PwyInvokeParam)resultMap.get("invokeParam");
                IPwyService pwyService = PwyServiceHelper.getPwyService(newCtx, invokeParam);
                pwyService.invoke();
                if (!pwyService.getInvokeParam().isSuccess()) {
                    ++failCount;
                    String arNumber = this.getArNumber(requiredID, relationMap.get(invoiceID));
                    AutoMakeInvoiceSchemeException imex = new AutoMakeInvoiceSchemeException(AutoMakeInvoiceSchemeException.MAKEINVOICE_ERROR, new Object[]{arNumber, mkBillInfo.getNumber(), pwyService.getInvokeParam().getDescription()});
                    String msg = imex.getMessage();
                    if (StringUtils.isEmpty((String)msg)) continue;
                    invokeErrorMsg.append(msg).append("\r\n");
                    continue;
                }
                invokeSuccessMsg.append(mkBillInfo.getNumber()).append("\u3001");
            }
        }
        StringBuffer msg = new StringBuffer();
        String ARORREQ = "";
        if ("FC910EF3".equals(srcBosType)) {
            ARORREQ = EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"AROtherBill");
        } else if ("AC368D2D".equals(srcBosType)) {
            ARORREQ = EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"MakeInvoiceReq");
        }
        HashSet successSourceBillIds = new HashSet();
        StringBuffer arOrReqMsg = new StringBuffer();
        Object[] relationKeys = relationMap.keySet().toArray();
        for (int i = 0; i < relationKeys.length; ++i) {
            if (!mkBillIds.contains(relationKeys[i])) continue;
            successSourceBillIds.addAll(relationMap.get(relationKeys[i]));
        }
        int successSourceBillCount = successSourceBillIds.size();
        int failSourceBillCount = requiredID.keySet().size() - successSourceBillCount;
        for (String id : successSourceBillIds) {
            arOrReqMsg.append(requiredID.get(id)).append("\u3001");
        }
        if (arOrReqMsg.length() > 0) {
            arOrReqMsg.deleteCharAt(arOrReqMsg.length() - 1);
        }
        if (invokeSuccessMsg.length() > 0) {
            invokeSuccessMsg.deleteCharAt(invokeSuccessMsg.length() - 1);
        }
        if (mkBillIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(mkBillIds), CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            view.setSelector(sic);
            MakeInvoiceCollection mkBillColl = MakeInvoiceFactory.getLocalInstance(newCtx).getMakeInvoiceCollection(view);
            for (int i = 0; i < mkBillColl.size(); ++i) {
                generateSuccessMsg.append(mkBillColl.get(i).getNumber());
                if (i == mkBillColl.size() - 1) continue;
                generateSuccessMsg.append("\u3001");
            }
        }
        msg.append(EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"AR_OR_TAXSEP_MSG", (Object[])new Object[]{ARORREQ, successSourceBillCount, failSourceBillCount, mkBillIds.size(), mkToMakeBillIds.size() - failCount, failCount, ARORREQ, arOrReqMsg, generateSuccessMsg, invokeSuccessMsg, invokeErrorMsg.append(errorMsg)}));
        this.sendBMCMsg(newCtx, invokeErrorMsg.append(errorMsg).toString(), msg.toString(), mkToMakeBillIds.size());
        return this.handleRetMap(ret, errorMsg.length() == 0 ? 1 : 0, mkToMakeBillIds.size() - failCount, failCount, EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"VC_RESULT"));
    }

    private Map makeInvoice(ArrayList requiredIds, MakeInvoiceParam param, Context newCtx) throws BOSException, EASBizException {
        int failCount = 0;
        StringBuffer invokeErrorMsg = new StringBuffer();
        StringBuffer invokeSuccessMsg = new StringBuffer();
        HashMap ret = new HashMap();
        if (!requiredIds.isEmpty()) {
            ArrayList list = IMInvoiceFacadeFactory.getLocalInstance(newCtx).autoBuildPwyParam(requiredIds, TransSrcSystemEnum.easgui);
            for (int i = 0; i < list.size(); ++i) {
                Map resultMap = (Map)list.get(i);
                if (resultMap.containsKey("exception")) {
                    ++failCount;
                    AutoMakeInvoiceSchemeException imex = new AutoMakeInvoiceSchemeException(AutoMakeInvoiceSchemeException.MAKE_ERROR, new Object[]{resultMap.get("number"), resultMap.get("exception")});
                    String msg = imex.getMessage();
                    invokeErrorMsg.append(msg).append("\r\n");
                    continue;
                }
                MakeInvoiceInfo mkBillInfo = (MakeInvoiceInfo)resultMap.get("info");
                PwyInvokeParam invokeParam = (PwyInvokeParam)resultMap.get("invokeParam");
                IPwyService pwyService = PwyServiceHelper.getPwyService(newCtx, invokeParam);
                pwyService.invoke();
                if (!pwyService.getInvokeParam().isSuccess()) {
                    ++failCount;
                    AutoMakeInvoiceSchemeException imex = new AutoMakeInvoiceSchemeException(AutoMakeInvoiceSchemeException.MAKE_ERROR, new Object[]{mkBillInfo.getNumber(), pwyService.getInvokeParam().getDescription()});
                    String msg = imex.getMessage();
                    invokeErrorMsg.append(msg).append("\r\n");
                    continue;
                }
                invokeSuccessMsg.append(mkBillInfo.getNumber()).append("\u3001");
            }
        }
        StringBuffer msg = new StringBuffer();
        int availableMkBill = requiredIds.size();
        if (invokeSuccessMsg.length() > 0) {
            invokeSuccessMsg.deleteCharAt(invokeSuccessMsg.length() - 1);
        }
        msg.append(EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"MAKEINVOICE_MSG", (Object[])new Object[]{availableMkBill - failCount, failCount, invokeSuccessMsg, invokeErrorMsg}));
        this.sendBMCMsg(newCtx, invokeErrorMsg.toString(), msg.toString(), availableMkBill - failCount);
        return this.handleRetMap(ret, invokeErrorMsg.length() == 0 ? 1 : 0, availableMkBill - failCount, failCount, EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"VC_RESULT"));
    }

    private void sendBMCMsg(Context newCtx, String errorMsg, String msg, int sucessMkBill) throws EASBizException, BOSException {
        String result = EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"ERROR");
        if (sucessMkBill > 0 && errorMsg.length() > 0) {
            result = EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"PARTIAL_SUCCESS");
        } else if (errorMsg.length() == 0) {
            result = EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"SUCCESS");
        }
        String title = EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"AUTO_MAKEINVOICE_TITLE", (Object[])new Object[]{(String)newCtx.get((Object)"billName"), result});
        IMUtils.sendBMCMsg(newCtx, msg, title, newCtx.get((Object)"currentUserID").toString());
        logger.error((Object)"exit AutoMakeInvoiceFacadeControllerBean sendBMCMsg.");
    }

    private String getArNumber(Map<String, String> arBillNumber, ArrayList arBillsID) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arBillsID.size(); ++i) {
            String id = arBillsID.get(i).toString();
            sb.append(arBillNumber.get(id)).append(",");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    protected Map<String, String> getRequiredID(Context ctx, AutoMakeInvoiceSchemeInfo schemeInfo, IObjectCollection companyRange) throws BOSException, EASBizException {
        String srcBosType = schemeInfo.getDataSourceBill().getBillBosType();
        EntityViewInfo view = new EntityViewInfo();
        HashMap<String, String> map = new HashMap<String, String>();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        String companyId = schemeInfo.getCompanyId();
        HashSet<Object> companyIds = new HashSet();
        if (companyId != null && companyRange == null) {
            companyIds = new HashSet<String>(Arrays.asList(companyId.split(",")));
            filter.getFilterItems().add(new FilterItemInfo("company.id", companyIds, CompareType.INCLUDE));
        }
        if (companyRange == null && companyId == null) {
            this.sendBMCMsg(ctx, "failed", EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"COMPANY_ISNULL"), 0);
            return map;
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", AutoMakeInvoiceFacadeControllerBean.getCompanyIds(companyRange), CompareType.INCLUDE));
        this.getDateFilter(schemeInfo.getDateRange().getValue(), schemeInfo.getDateFiled(), filter);
        try {
            if ("3D667D4A".equals(srcBosType)) {
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
            } else if ("AC368D2D".equals(srcBosType)) {
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)2, CompareType.EQUALS));
                filter.mergeFilter(new FilterInfo("isMakeInoviced=0 or isMakeInoviced is null"), "AND");
            } else if ("412A6F98".equals(srcBosType)) {
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)"3", CompareType.EQUALS));
            } else if ("FC910EF3".equals(srcBosType)) {
                filter.getFilterItems().add(new FilterItemInfo("billstatus", (Object)3, CompareType.EQUALS));
                filter.mergeFilter(new FilterInfo("ismakeinvoiced=0 or ismakeinvoiced is null"), "AND");
            }
            filter.mergeFilter(new FilterInfo(schemeInfo.getDefineConfig()), "AND");
            String sql = IMSQLUtil.autoStructureFilter(ctx, filter.toSql(), schemeInfo.getDataSourceBill().getQuery());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (rs.next()) {
                    String id = rs.getString("ID");
                    String number = rs.getString("NUMBER");
                    map.put(id, number);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        logger.error((Object)("AutoMakeInvoiceFacadeControllerBean get requiredMap=" + ((Object)map).toString()));
        return map;
    }

    public static Set<String> getCompanyIds(IObjectCollection companyRange) {
        HashSet<String> companySet = new HashSet<String>();
        if (companyRange != null) {
            for (IObjectValue companyInfo : companyRange) {
                if (null == companyInfo.get("id")) continue;
                companySet.add(companyInfo.get("id").toString());
            }
        }
        return companySet;
    }

    protected void getDateFilter(String dateRange, String dateFiled, FilterInfo filter) {
        int dateVal = Integer.parseInt(dateRange);
        String beginDate = null;
        String endDate = null;
        String dateFormat = "yyyy-MM-dd HH:mm:ss";
        switch (dateVal) {
            case 0: {
                beginDate = DateUtils.date2String(DateUtils.getDayBegin(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getDayEnd(), dateFormat);
                break;
            }
            case 1: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfWeek(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfWeek(), dateFormat);
                break;
            }
            case 2: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfMonth(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
                break;
            }
            case 3: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfLastThreeMonth(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
                break;
            }
            case 4: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfLastHalfYear(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
                break;
            }
            case 5: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfLastYear(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
            }
        }
        FilterItemCollection items = filter.getFilterItems();
        FilterItemInfo fromBillDateFilter = new FilterItemInfo(dateFiled, (Object)beginDate, CompareType.GREATER_EQUALS);
        items.add(fromBillDateFilter);
        FilterItemInfo toBillDateFilter = new FilterItemInfo(dateFiled, (Object)endDate, CompareType.LESS_EQUALS);
        items.add(toBillDateFilter);
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataSourceBill.billBosType"));
        sic.add(new SelectorItemInfo("dataSourceBill.query"));
        sic.add(new SelectorItemInfo("srcCombinRule.id"));
        sic.add(new SelectorItemInfo("destCombinRule.id"));
        return sic;
    }
}

