/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.Context2;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.basedata.CustomerMailingCollection;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryCollection;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingException;
import com.kingdee.eas.tm.im.basedata.CustomerMailingFactory;
import com.kingdee.eas.tm.im.basedata.CustomerMailingInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingStatusEnum;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.ICustomerMailing;
import com.kingdee.eas.tm.im.basedata.ICustomerTax;
import com.kingdee.eas.tm.im.basedata.MailTypeEnum;
import com.kingdee.eas.tm.im.basedata.app.AbstractCustomerMailingControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CustomerMailingControllerBean
extends AbstractCustomerMailingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.basedata.app.CustomerMailingControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CustomerMailingInfo info = (CustomerMailingInfo)model;
        this.trimNumber(ctx, info);
        this.setNewNumber(ctx, info);
        this.verifyRequiredFields(ctx, (IObjectValue)info);
        super._checkNumberDup(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
        this.verify(ctx, (IObjectValue)info);
        return super._addnew(ctx, model);
    }

    @Override
    public IObjectPK addnew(Context ctx, CustomerMailingInfo model) throws BOSException, EASBizException {
        this.updateContext(ctx);
        return super.addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CustomerMailingInfo info = (CustomerMailingInfo)model;
        this.trimNumber(ctx, info);
        this.verifyRequiredFields(ctx, (IObjectValue)info);
        super._checkNumberDup(ctx, pk, (IObjectValue)info);
        this.verify(ctx, (IObjectValue)info);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    public void update(Context ctx, IObjectPK pk, CustomerMailingInfo model) throws BOSException, EASBizException {
        this.updateContext(ctx);
        super.update(ctx, pk, model);
    }

    public void save(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        this.updateContext(ctx);
        super.save(ctx, pk, model);
    }

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.updateContext(ctx);
        return super.save(ctx, model);
    }

    public void submit(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        this.updateContext(ctx);
        super.save(ctx, pk, model);
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        this.updateContext(ctx);
        return super.save(ctx, model);
    }

    protected void verify(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        int type = -1;
        CustomerMailingInfo info = (CustomerMailingInfo)model;
        if (info.getCompany() != null && info.getCustomer() != null) {
            type = 0;
        } else if (info.getCustomer() != null) {
            type = 1;
        } else if (info.getCompany() != null) {
            type = 2;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select 1 from T_TM_CustomerMailing ");
        sql.append(" where 1=1  ");
        if (!CustomerMailingStatusEnum.Active.equals((Object)info.getStatus())) {
            return;
        }
        sql.append("  and FStatus = '2' ");
        if (type == 0) {
            sql.append(" and FCompanyID = '").append(info.getCompany().getId().toString()).append("'");
            sql.append(" and FCustomerID = '").append(info.getCustomer().getId().toString()).append("'");
        } else if (type == 1) {
            sql.append(" and FCompanyID IS NULL");
            sql.append(" and FCustomerID = '").append(info.getCustomer().getId().toString()).append("'");
        } else if (type == 2) {
            sql.append(" and FCompanyID = '").append(info.getCompany().getId().toString()).append("'");
            sql.append(" and FCustomerID IS NULL");
        }
        if (info.getId() != null) {
            sql.append(" and FID <> '").append(info.getId().toString()).append("'");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                if (type == 0) {
                    throw new CustomerMailingException(CustomerMailingException.VERIFYERROR1);
                }
                if (type == 1) {
                    throw new CustomerMailingException(CustomerMailingException.VERIFYERROR2);
                }
                if (type == 2) {
                    throw new CustomerMailingException(CustomerMailingException.VERIFYERROR3);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void verifyRequiredFields(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CustomerMailingInfo info = (CustomerMailingInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{this.getResource("CurrentNumber_NOT_NULL")});
        }
        if (MailTypeEnum.SendMail.equals((Object)info.getMailType())) {
            if (info.getCompany() == null) {
                throw new IMException(IMException.ERRORMSG, new Object[]{this.getResource("Company_NOT_NULL")});
            }
        } else if (MailTypeEnum.ReceiveMail.equals((Object)info.getMailType()) && info.getCustomer() == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{this.getResource("Customer_NOT_NULL")});
        }
        StringBuffer msg = new StringBuffer();
        CustomerMailingEntryCollection entries = info.getEntries();
        CustomerMailingEntryInfo entryInfo = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entries.get(i);
            if (!StringUtils.isEmpty((String)entryInfo.getMailbox()) || !StringUtils.isEmpty((String)entryInfo.getTelephone())) continue;
            msg.append(this.getResource("Entry_MailBoxPhone_NOT_NULL", new Object[]{i + 1})).append("\r\n");
        }
        if (msg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{msg.toString()});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CustomerMailingInfo model = CustomerMailingFactory.getLocalInstance(ctx).getCustomerMailingInfo(pk);
        if (CustomerMailingStatusEnum.Active.equals((Object)model.getStatus())) {
            throw new CustomerMailingException(CustomerMailingException.HASACTIVE);
        }
        this.recycleNumber(ctx, pk, model);
        super._delete(ctx, pk);
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.updateContext(ctx);
        super.delete(ctx, pk);
    }

    @Override
    protected void _active(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CustomerMailingInfo model = CustomerMailingFactory.getLocalInstance(ctx).getCustomerMailingInfo(pk);
        if (CustomerMailingStatusEnum.Active.equals((Object)model.getStatus())) {
            throw new CustomerMailingException(CustomerMailingException.HASACTIVE);
        }
        model.setStatus(CustomerMailingStatusEnum.Active);
        this._update(ctx, pk, (IObjectValue)model);
    }

    @Override
    public void active(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.updateContext(ctx);
        super.active(ctx, pk);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CustomerMailingInfo info = CustomerMailingFactory.getLocalInstance(ctx).getCustomerMailingInfo(pk);
        if (CustomerMailingStatusEnum.Active.equals((Object)info.getStatus())) {
            throw new CustomerMailingException(CustomerMailingException.HASACTIVE);
        }
        info.setStatus(CustomerMailingStatusEnum.Active);
        this._update(ctx, pk, (IObjectValue)info);
    }

    public void cancelCancel(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        this.updateContext(ctx);
        super.cancelCancel(ctx, pk, model);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CustomerMailingInfo info = CustomerMailingFactory.getLocalInstance(ctx).getCustomerMailingInfo(pk);
        if (!CustomerMailingStatusEnum.Active.equals((Object)info.getStatus())) {
            throw new CustomerMailingException(CustomerMailingException.NOTACTIVE);
        }
        info.setStatus(CustomerMailingStatusEnum.InActive);
        super._update(ctx, pk, (IObjectValue)info);
    }

    public void cancel(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        this.updateContext(ctx);
        super.cancel(ctx, pk, model);
    }

    @Override
    protected void _unActive(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CustomerMailingInfo model = CustomerMailingFactory.getLocalInstance(ctx).getCustomerMailingInfo(pk);
        if (!CustomerMailingStatusEnum.Active.equals((Object)model.getStatus())) {
            throw new CustomerMailingException(CustomerMailingException.NOTACTIVE);
        }
        model.setStatus(CustomerMailingStatusEnum.InActive);
        this._update(ctx, pk, (IObjectValue)model);
    }

    @Override
    public void unActive(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.updateContext(ctx);
        super.unActive(ctx, pk);
    }

    @Override
    protected Map _getDefaultCustomerMailInfo(Context ctx, Map param) throws BOSException, EASBizException {
        Map<Object, Object> entryMap = new HashMap();
        EntityViewInfo viewInfo = new EntityViewInfo();
        String comOrgUnitId = (String)param.get("comOrgUnitId");
        String customerId = (String)param.get("customerId");
        logger.info((Object)("comOrgUnitId:" + comOrgUnitId + "  customerId:" + customerId));
        ICustomerMailing iCustomer = CustomerMailingFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add(new SelectorItemInfo("entries.companyName"));
        selectorColl.add(new SelectorItemInfo("entries.address"));
        selectorColl.add(new SelectorItemInfo("entries.postalcode"));
        selectorColl.add(new SelectorItemInfo("entries.mailbox"));
        selectorColl.add(new SelectorItemInfo("entries.contacts"));
        selectorColl.add(new SelectorItemInfo("entries.telephone"));
        selectorColl.add(new SelectorItemInfo("entries.isDefault"));
        viewInfo.setSelector(selectorColl);
        if (comOrgUnitId != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)comOrgUnitId, CompareType.EQUALS));
        }
        if (customerId != null) {
            filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerId, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("mailType", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"2", CompareType.EQUALS));
        viewInfo.setFilter(filter);
        CustomerMailingCollection col = iCustomer.getCustomerMailingCollection(viewInfo);
        if (col != null && col.size() > 0) {
            logger.info((Object)("CustomerMailingCollectionSize:" + col.size()));
            CustomerMailingInfo mailinfo = col.get(0);
            CustomerMailingEntryCollection entrycols = mailinfo.getEntries();
            entryMap = this.getdefaultEntry(entrycols);
        } else {
            filter.getFilterItems().clear();
            if (customerId != null) {
                filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerId, CompareType.EQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("mailType", (Object)"1", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)"2", CompareType.EQUALS));
            viewInfo.setFilter(filter);
            col = iCustomer.getCustomerMailingCollection(viewInfo);
            if (col != null && col.size() > 0) {
                CustomerMailingInfo mailinfo = col.get(0);
                CustomerMailingEntryCollection entrycols = mailinfo.getEntries();
                entryMap = this.getdefaultEntry(entrycols);
            }
        }
        return entryMap;
    }

    private Map<String, CustomerMailingEntryInfo> getdefaultEntry(CustomerMailingEntryCollection entrycols) {
        HashMap<String, CustomerMailingEntryInfo> entryMap = new HashMap<String, CustomerMailingEntryInfo>();
        if (entrycols != null && entrycols.size() > 0) {
            CustomerMailingEntryInfo defaultEntry = null;
            for (int i = 0; i < entrycols.size(); ++i) {
                defaultEntry = entrycols.get(i);
                if (!defaultEntry.isIsDefault()) continue;
                entryMap.put("defaultEntry", defaultEntry);
                break;
            }
        }
        return entryMap;
    }

    protected CustomerMailingEntryInfo _getSenderMailData(Context ctx, String companyID, String contacts, Map cache, Map params) throws BOSException, EASBizException {
        CustomerMailingEntryInfo entryInfo = null;
        String key = companyID + "_" + contacts;
        if (cache != null) {
            entryInfo = (CustomerMailingEntryInfo)cache.get(key);
        }
        if (entryInfo == null) {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FAddress,FTelephone,FCompanyName ");
            sql.append(" FROM T_TM_CustomerMailingEntry entry ");
            sql.append(" INNER JOIN T_TM_CustomerMailing bill on entry.fparentid = bill.fid");
            sql.append(" WHERE bill.FStatus = ?");
            sql.append(" and bill.FMailType = ?");
            sql.append(" and bill.fcompanyId =?");
            sql.append(" and entry.FContacts =?");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"2", "0", companyID, contacts});
            try {
                if (rs.next()) {
                    entryInfo = new CustomerMailingEntryInfo();
                    entryInfo.setAddress(rs.getString("FAddress"));
                    entryInfo.setTelephone(rs.getString("FTelephone"));
                    entryInfo.setCompanyName(rs.getString("FCompanyName"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (cache != null && entryInfo != null) {
                cache.put(key, entryInfo);
            }
        }
        return entryInfo;
    }

    public void setNewNumber(Context ctx, CustomerMailingInfo info) throws EASBizException, BOSException {
        if (info.getNumber() != null) {
            return;
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            String number = this.getNumer(ctx, info);
            info.setNumber(number);
        }
    }

    private String getNumer(Context ctx, CustomerMailingInfo info) throws BOSException, EASBizException {
        ICustomerTax iCustomerTax = CustomerTaxFactory.getLocalInstance(ctx);
        String cuID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)info, cuID);
        if (codingRule == null) {
            throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{""});
        }
        String number = (String)info.get("number");
        int maxCycleNum = 100;
        String filterString = "where number = '" + number + "' " + (info.get("id") != null ? "and id !='" + info.get("id") + "'" : "");
        while (number == null || number.equals("") || iCustomerTax.exists(filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            number = iCodingRuleManager.getNumber((IObjectValue)info, cuID);
            filterString = "where number = '" + number + "' " + (info.get("id") != null ? "and id !='" + info.get("id") + "'" : "");
        }
        return number;
    }

    private void recycleNumber(Context ctx, IObjectPK pk, CustomerMailingInfo info) throws EASBizException, BOSException {
        if (info == null || info.getNumber() == null || info.getCompany() == null || info.getCU() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            sic.add("company.id");
            sic.add("cu.id");
            info = CustomerMailingFactory.getLocalInstance(ctx).getCustomerMailingInfo(pk, sic);
        }
        if (info.getNumber() != null) {
            String cuID = info.getCU().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, cuID);
            if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, cuID) || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)info, cuID, info.getNumber());
            }
        }
    }

    protected String getResource(String key) {
        return IMUtils.getString("com.kingdee.eas.tm.im.basedata.CustomerMailingResource", key, IMUtils.getLocale());
    }

    protected String getResource(String key, Object[] params) {
        return IMUtils.getString("com.kingdee.eas.tm.im.basedata.CustomerMailingResource", key, IMUtils.getLocale(), params);
    }

    protected FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        return null;
    }

    private void updateContext(Context ctx) {
        if (ctx instanceof Context2) {
            ((Context2)ctx).initOwnContext(ContextUtils.getContextFromSession());
        }
    }

    protected void trimNumber(Context ctx, CustomerMailingInfo info) {
        String number = info.getNumber();
        if (info.getNumber() != null) {
            number = number.trim();
            info.setNumber(number);
        }
    }
}

