/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.basedata.CustomerTaxCollection;
import com.kingdee.eas.tm.im.basedata.CustomerTaxEntryCollection;
import com.kingdee.eas.tm.im.basedata.CustomerTaxEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.basedata.CustomerTaxSourceTypeEnum;
import com.kingdee.eas.tm.im.basedata.CustomerTaxStatusEnum;
import com.kingdee.eas.tm.im.basedata.DiscountTypeEnum;
import com.kingdee.eas.tm.im.basedata.ICustomerTax;
import com.kingdee.eas.tm.im.basedata.IsPrintListEnum;
import com.kingdee.eas.tm.im.common.billimport.IMBillImportBase;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CustomerTaxDataImport
extends IMBillImportBase {
    private static final String resClassName = "com.kingdee.eas.tm.im.app.IMImportResource";
    private CustomerTaxInfo customerTaxInfo = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.CustomerTaxDataImport");
    private Hashtable firstData = null;

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CustomerTaxFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.customerTaxInfo = null;
        int k = 0;
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (k == 0) {
                try {
                    this.customerTaxInfo = new CustomerTaxInfo();
                    this.customerTaxInfo = this.doNumber(lineData, ctx, this.customerTaxInfo);
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                this.doCompany(lineData, ctx, this.customerTaxInfo);
                this.doCurrentAccountType(lineData, ctx, this.customerTaxInfo);
                this.doCustomerOrSuppiler(lineData, ctx, this.customerTaxInfo);
                this.doRecCompany(lineData, ctx, this.customerTaxInfo);
                this.doIsValueAdded(lineData, ctx, this.customerTaxInfo);
                this.doTaxNumber(lineData, ctx, this.customerTaxInfo);
                this.doAddressTel(lineData, ctx, this.customerTaxInfo);
                this.doBankAccount(lineData, ctx, this.customerTaxInfo);
                this.doIsDefault(lineData, ctx, this.customerTaxInfo);
                this.doStatus(lineData, ctx, this.customerTaxInfo);
                CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                this.customerTaxInfo.setCU(cu);
                if (this.customerTaxInfo.getSourceType() == null) {
                    this.customerTaxInfo.setSourceType(CustomerTaxSourceTypeEnum.EXCEL);
                }
            }
            CustomerTaxEntryInfo entryInfo = null;
            entryInfo = this.doInvoiceType(lineData, ctx, this.customerTaxInfo);
            if (entryInfo == null) continue;
            this.doDiscountType(lineData, ctx, entryInfo);
            this.doPrintList(lineData, ctx, entryInfo);
            this.doLimitAmt(lineData, ctx, entryInfo);
            this.doEntryIsDefault(lineData, ctx, entryInfo);
            this.customerTaxInfo.getEntries().add(entryInfo);
            ++k;
        }
        CustomerTaxEntryCollection entrycol = this.customerTaxInfo.getEntries();
        CustomerTaxEntryCollection col = new CustomerTaxEntryCollection();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < entrycol.size(); ++j) {
                CustomerTaxEntryInfo entryinfo = entrycol.get(j);
                if (entryinfo.getInvoiceType().equals((Object)PayInvoiceTypeEnum.VALUEADDEDTAXINV) && i == 0) {
                    col.add(entryinfo);
                    entrycol.remove(entryinfo);
                    continue;
                }
                if (entryinfo.getInvoiceType().equals((Object)PayInvoiceTypeEnum.COMMONINVOICE) && i == 1) {
                    col.add(entryinfo);
                    entrycol.remove(entryinfo);
                    continue;
                }
                if (entryinfo.getInvoiceType().equals((Object)PayInvoiceTypeEnum.ELECTRONICINVOICE) && i == 2) {
                    col.add(entryinfo);
                    entrycol.remove(entryinfo);
                    continue;
                }
                if (entryinfo.getInvoiceType().equals((Object)PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE) && i == 3) {
                    col.add(entryinfo);
                    entrycol.remove(entryinfo);
                    continue;
                }
                if (entryinfo.getInvoiceType().equals((Object)PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE) && i == 4) {
                    col.add(entryinfo);
                    entrycol.remove(entryinfo);
                    continue;
                }
                if (!entryinfo.getInvoiceType().equals((Object)PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE) || i != 5) continue;
                col.add(entryinfo);
                entrycol.remove(entryinfo);
            }
        }
        this.customerTaxInfo.getEntries().clear();
        this.customerTaxInfo.getEntries().addCollection(col);
        return this.customerTaxInfo;
    }

    private void doEntryIsDefault(Hashtable hsData, Context ctx, CustomerTaxEntryInfo entryInfo) throws TaskExternalException {
        String str = this.getCellStr(hsData, "FEntries_isDefault");
        if ("0".equals(str.trim()) || "false".equalsIgnoreCase(str.trim()) || IMUtils.getString(resClassName, "NO", ctx.getLocale()).equals(str.trim())) {
            entryInfo.setIsDefault(false);
        } else if ("1".equals(str.trim()) || "true".equalsIgnoreCase(str.trim()) || IMUtils.getString(resClassName, "YES", ctx.getLocale()).equals(str.trim())) {
            entryInfo.setIsDefault(true);
        } else {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"EntryIsDefaultPutInError", (Context)ctx));
        }
    }

    private void doCompany(Hashtable hsData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException {
        CompanyOrgUnitInfo companyInfo = null;
        Object numberdata = ((DataToken)hsData.get((Object)"FCompany_number")).data;
        String str = null;
        if (numberdata != null && numberdata.toString().trim().length() != 0) {
            str = numberdata.toString();
            try {
                companyInfo = DataImportUtils.getCompanyOrgUnitInfoFromNumber((Context)ctx, (String)str);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            if (companyInfo == null) {
                throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CUNOTEXISTS", (Context)ctx));
            }
            customerTaxInfo.setCompany(companyInfo);
        }
    }

    private CustomerTaxInfo doNumber(Hashtable hsData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException, EASBizException, BOSException {
        Object number = ((DataToken)hsData.get((Object)"FNumber")).data;
        if (number != null && number.toString().trim().length() > 0) {
            customerTaxInfo.setNumber(number.toString().trim());
            CustomerTaxCollection customerTaxCollection = this.getCustomerTaxCollection(ctx, number.toString().trim());
            if (!this.isSltImportUpdate()) {
                if (customerTaxCollection.size() > 0) {
                    String str = IMUtils.getResource(resClassName, "EXIST_SAME_NUMBER", ctx);
                    throw new TaskExternalException(number.toString().trim() + "  " + str);
                }
            } else if (customerTaxCollection.size() != 0) {
                String status;
                CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                if (!cu.getId().toString().equals(customerTaxCollection.get(0).getCU() == null ? "" : customerTaxCollection.get(0).getCU().getId().toString())) {
                    String str = IMUtils.getResource(resClassName, "cannotUpdateOtherCUBill", ctx);
                    throw new TaskExternalException(number.toString().trim() + "  " + str);
                }
                String string = status = customerTaxCollection.get(0).getStatus() == null ? "" : customerTaxCollection.get(0).getStatus().getValue();
                if (!"1".equals(status)) {
                    String str = IMUtils.getResource(resClassName, "BILLSTATUS_ERROR1", ctx);
                    throw new TaskExternalException(number.toString().trim() + "  " + str);
                }
                customerTaxInfo.setSourceType(customerTaxCollection.get(0).getSourceType());
                customerTaxInfo.setId(customerTaxCollection.get(0).getId());
            }
        } else {
            String str = IMUtils.getResource(resClassName, "NUMBER_IS_ISNULL", ctx);
            throw new TaskExternalException(str);
        }
        return customerTaxInfo;
    }

    private CustomerTaxCollection getCustomerTaxCollection(Context ctx, String number) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        CustomerTaxCollection coll = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxCollection(view);
        return coll;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICustomerTax iCustomerTax = (ICustomerTax)this.getController(ctx);
        this.checkIsDefault(ctx, coreBaseInfo);
        try {
            iCustomerTax.submit(coreBaseInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private void checkIsDefault(Context ctx, CoreBaseInfo coreBaseInfo) throws TaskExternalException {
        Map map = null;
        CustomerTaxInfo customerTaxInfo = null;
        if (coreBaseInfo instanceof CustomerTaxInfo) {
            customerTaxInfo = (CustomerTaxInfo)coreBaseInfo;
        }
        if (customerTaxInfo == null) {
            logger.error((Object)"customerTaxInfo is null");
            return;
        }
        try {
            String cusOrSupId = null;
            String customerTaxId = customerTaxInfo.getId() != null ? customerTaxInfo.getId().toString() : null;
            String companyId = customerTaxInfo.getCompany() != null ? customerTaxInfo.getCompany().getId().toString() : null;
            String currentAccountType = null;
            if (CurrentAccountType.CUSTOMER.equals((Object)customerTaxInfo.getCurrentAccountType())) {
                cusOrSupId = customerTaxInfo.getCustomer() != null ? customerTaxInfo.getCustomer().getId().toString() : null;
                currentAccountType = "1";
            } else if (CurrentAccountType.SUPPLIER.equals((Object)customerTaxInfo.getCurrentAccountType())) {
                cusOrSupId = customerTaxInfo.getSupplier() != null ? customerTaxInfo.getSupplier().getId().toString() : null;
                currentAccountType = "2";
            }
            map = CustomerTaxFactory.getLocalInstance(ctx).isHasDefault(cusOrSupId, customerTaxId, companyId, currentAccountType);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        boolean hasDefault = (Boolean)map.get("result");
        if (customerTaxInfo.isIsDefault() && CustomerTaxStatusEnum.USING.equals((Object)customerTaxInfo.getStatus()) && hasDefault) {
            try {
                CustomerTaxFactory.getLocalInstance(ctx).updateDefaultStatus((List)map.get("ids"));
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
    }

    private void doCustomerOrSuppiler(Hashtable lineData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException {
        if (CurrentAccountType.CUSTOMER.equals((Object)customerTaxInfo.getCurrentAccountType())) {
            this.doCustomer(lineData, ctx, customerTaxInfo);
        } else if (CurrentAccountType.SUPPLIER.equals((Object)customerTaxInfo.getCurrentAccountType())) {
            this.doSupplier(lineData, ctx, customerTaxInfo);
        }
    }

    private void doSupplier(Hashtable lineData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException {
        SupplierInfo supplierInfo = null;
        Object numberdata = ((DataToken)lineData.get((Object)"FCustomer_number")).data;
        String str = null;
        if (numberdata != null && numberdata.toString().trim().length() != 0) {
            str = numberdata.toString();
            try {
                supplierInfo = DataImportUtils.getSupplierInfoFromNumber((Context)ctx, (String)str);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            if (supplierInfo == null) {
                throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"supplierNotExist", (Context)ctx));
            }
            if (!UsedStatusEnum.APPROVED.equals((Object)supplierInfo.getUsedStatus())) {
                String supplier = IMUtils.getResource(resClassName, "Supplier", ctx);
                throw new TaskExternalException(IMUtils.getString(resClassName, "CusOrSupNotApproved", ctx.getLocale(), new Object[]{supplierInfo.getNumber(), supplier}));
            }
            customerTaxInfo.setSupplier(supplierInfo);
        }
    }

    private void doCustomer(Hashtable hsData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException {
        CustomerInfo customerInfo = null;
        Object numberdata = ((DataToken)hsData.get((Object)"FCustomer_number")).data;
        String str = null;
        if (numberdata != null && numberdata.toString().trim().length() != 0) {
            str = numberdata.toString();
            try {
                customerInfo = DataImportUtils.getCustomerInfoFromNumber((Context)ctx, (String)str);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            if (customerInfo == null) {
                throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"customerNotExist", (Context)ctx));
            }
            if (!UsedStatusEnum.APPROVED.equals((Object)customerInfo.getUsedStatus())) {
                String customer = IMUtils.getResource(resClassName, "Customer", ctx);
                throw new TaskExternalException(IMUtils.getString(resClassName, "CusOrSupNotApproved", ctx.getLocale(), new Object[]{customerInfo.getNumber(), customer}));
            }
            customerTaxInfo.setCustomer(customerInfo);
        }
    }

    private void doRecCompany(Hashtable hsData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException {
        Object o = null;
        o = ((DataToken)hsData.get((Object)"FRecCompanyName")).data;
        if (o == null || o.toString().trim().length() == 0) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "BILLTOCOMPANY_NOT_NULL", ctx));
        }
        String billToCompanyNameStr = o.toString().trim();
        if (billToCompanyNameStr.length() > 200) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "BILLTOCOMPANYNAMELENERR", ctx));
        }
        customerTaxInfo.setRecCompanyName(o.toString().trim());
    }

    private void doCurrentAccountType(Hashtable lineData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException {
        String currentAcountType = ((DataToken)lineData.get((Object)"FCurrentAccountType")).data.toString();
        String customer = IMUtils.getResource(resClassName, "Customer", ctx);
        String supplier = IMUtils.getResource(resClassName, "Supplier", ctx);
        CurrentAccountType currentAccountTypeEnum = null;
        if (customer.equals(currentAcountType) || "1".equals(currentAcountType.trim())) {
            currentAccountTypeEnum = CurrentAccountType.CUSTOMER;
        } else if (supplier.equals(currentAcountType) || "2".equals(currentAcountType.trim())) {
            currentAccountTypeEnum = CurrentAccountType.SUPPLIER;
        } else {
            throw new TaskExternalException(new IMException(IMException.ACCOUNTTYPEERROR).getMessage());
        }
        customerTaxInfo.setCurrentAccountType(currentAccountTypeEnum);
    }

    private CustomerTaxEntryInfo doInvoiceType(Hashtable hsData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException {
        String invoiceType = ((DataToken)hsData.get((Object)"FEntries_invoiceType")).data.toString();
        String commonInv = IMUtils.getResource(resClassName, "COMMONINVOICE", ctx);
        String valueInv = IMUtils.getResource(resClassName, "VALUEADDEDTAXINV", ctx);
        String electInv = IMUtils.getResource(resClassName, "ELECTRONICINVOICE", ctx);
        String eleInv = IMUtils.getResource(resClassName, "ELEINVOICE", ctx);
        String electSpeInv = IMUtils.getResource(resClassName, "ELECTRONICSPECIALINVOICE", ctx);
        String digElec = IMUtils.getResource(resClassName, "DIGITALELECTRICITYINVOICE", ctx);
        String digElecSpe = IMUtils.getResource(resClassName, "DIGITALELECTRICITYSPECIALINVOICE", ctx);
        PayInvoiceTypeEnum invoiceTypeEnum = null;
        if (commonInv.equals(invoiceType) || "0".equals(invoiceType.toString().trim())) {
            invoiceTypeEnum = PayInvoiceTypeEnum.COMMONINVOICE;
        } else if (valueInv.equals(invoiceType) || "1".equals(invoiceType.toString().trim())) {
            invoiceTypeEnum = PayInvoiceTypeEnum.VALUEADDEDTAXINV;
        } else if (electInv.equals(invoiceType) || eleInv.equals(invoiceType) || "2".equals(invoiceType.toString().trim())) {
            invoiceTypeEnum = PayInvoiceTypeEnum.ELECTRONICINVOICE;
        } else if (electSpeInv.equals(invoiceType) || "3".equals(invoiceType.toString().trim())) {
            invoiceTypeEnum = PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE;
        } else if (digElec.equals(invoiceType) || "4".equals(invoiceType.toString().trim())) {
            invoiceTypeEnum = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE;
        } else if (digElecSpe.equals(invoiceType) || "5".equals(invoiceType.toString().trim())) {
            invoiceTypeEnum = PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE;
        } else {
            throw new TaskExternalException(new IMException(IMException.INVOICETYPEERROR).getMessage());
        }
        CustomerTaxEntryCollection entries = customerTaxInfo.getEntries();
        boolean hasEntry = false;
        CustomerTaxEntryInfo entryInfo = null;
        for (int i = 0; i < entries.size(); ++i) {
            entryInfo = entries.get(i);
            if (!entryInfo.getInvoiceType().equals((Object)invoiceTypeEnum)) continue;
            hasEntry = true;
            break;
        }
        CustomerTaxEntryInfo info = null;
        if (this.isSltImportUpdate() || !hasEntry) {
            if (this.isSltImportUpdate() && hasEntry) {
                entries.remove(entryInfo);
                info = new CustomerTaxEntryInfo();
                info.setInvoiceType(invoiceTypeEnum);
            } else {
                info = new CustomerTaxEntryInfo();
                info.setInvoiceType(invoiceTypeEnum);
            }
        }
        return info;
    }

    private void doTaxNumber(Hashtable hsData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException {
        String compantTFNStr;
        Object o;
        String baseTaxNumber = "";
        CustomerInfo customer = customerTaxInfo.getCustomer();
        if (customer != null && !StringUtils.isEmpty((String)customer.getTaxRegisterNo())) {
            baseTaxNumber = customer.getTaxRegisterNo();
        }
        if (((o = ((DataToken)hsData.get((Object)"FTaxNumber")).data) == null || o.toString().trim().length() == 0) && StringUtils.isEmpty((String)baseTaxNumber) && customerTaxInfo.isIsValueAdded()) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"TAXNUMBER_NOTNULL", (Context)ctx));
        }
        if (o == null || o.toString().trim().length() == 0) {
            if (!StringUtils.isEmpty((String)baseTaxNumber)) {
                customerTaxInfo.setTaxNumber(baseTaxNumber);
            }
            return;
        }
        Pattern pattern = Pattern.compile("[0-9a-zA-Z]+");
        Matcher matcher = pattern.matcher(compantTFNStr = o.toString().trim());
        boolean b = matcher.matches();
        if (!b) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"CompantTFNComposeWithLetterNumber", (Context)ctx));
        }
        if (o.toString().trim().length() > 100) {
            throw new TaskExternalException(IMUtils.getString(resClassName, "TaxNumber_tooLong", ctx.getLocale()));
        }
        customerTaxInfo.setTaxNumber(o.toString());
    }

    private void doAddressTel(Hashtable hsData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException {
        Object o = ((DataToken)hsData.get((Object)"FAddressTel")).data;
        if ((o == null || o.toString().trim().length() == 0) && customerTaxInfo.isIsValueAdded()) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"ADDRESSTEL_NOTNULL", (Context)ctx));
        }
        if (IMUtils.getStringlength(o.toString().trim()) > 100) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"AddressTel_OverLength", (Locale)ctx.getOriginLocale()));
        }
        customerTaxInfo.setAddressTel(o.toString().trim());
    }

    private void doBankAccount(Hashtable hsData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException {
        Object o = ((DataToken)hsData.get((Object)"FBankAccount")).data;
        if ((o == null || o.toString().trim().length() == 0) && customerTaxInfo.isIsValueAdded()) {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"BANKACCOUNT_NOTNULL", (Context)ctx));
        }
        if (IMUtils.getStringlength(o.toString().trim()) > 100) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"BANKACCOUNT_OVER_LENGTH", (Locale)ctx.getOriginLocale()));
        }
        customerTaxInfo.setBankAccount(o.toString().trim());
    }

    private void doIsDefault(Hashtable hsData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException {
        String str = this.getCellStr(hsData, "FIsDefault");
        if ("0".equals(str.trim()) || "false".equalsIgnoreCase(str.trim()) || IMUtils.getString(resClassName, "NO", ctx.getLocale()).equals(str.trim())) {
            customerTaxInfo.setIsDefault(false);
        } else if ("1".equals(str.trim()) || "true".equalsIgnoreCase(str.trim()) || IMUtils.getString(resClassName, "YES", ctx.getLocale()).equals(str.trim())) {
            customerTaxInfo.setIsDefault(true);
        } else {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"IsDefaultError", (Context)ctx));
        }
    }

    private void doIsValueAdded(Hashtable hsData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException {
        String str = this.getCellStr(hsData, "FIsValueAdded");
        if ("0".equals(str.trim()) || "false".equalsIgnoreCase(str.trim()) || IMUtils.getString(resClassName, "NO", ctx.getLocale()).equals(str.trim())) {
            customerTaxInfo.setIsValueAdded(false);
        } else if ("1".equals(str.trim()) || "true".equalsIgnoreCase(str.trim()) || IMUtils.getString(resClassName, "YES", ctx.getLocale()).equals(str.trim())) {
            customerTaxInfo.setIsValueAdded(true);
        } else {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"IsValueAddedError", (Context)ctx));
        }
    }

    private String getCellStr(Hashtable hsData, String cellName) {
        String retval = "";
        Object o = ((DataToken)hsData.get((Object)cellName)).data;
        if (o != null && !"".equals(o.toString())) {
            retval = o.toString();
        }
        return retval;
    }

    private void doDiscountType(Hashtable hsData, Context ctx, CustomerTaxEntryInfo entryInfo) throws TaskExternalException {
        String str = this.getCellStr(hsData, "FEntries_discountType");
        if ("1".equals(str) || str.equals(DiscountTypeEnum.SPLIT.getAlias())) {
            entryInfo.setDiscountType(DiscountTypeEnum.SPLIT);
        } else if ("2".equals(str) || str.equals(DiscountTypeEnum.NOTSPLIT.getAlias())) {
            entryInfo.setDiscountType(DiscountTypeEnum.NOTSPLIT);
        } else if ("0".equals(str) || str.equals(DiscountTypeEnum.NULL.getAlias())) {
            entryInfo.setDiscountType(DiscountTypeEnum.NULL);
        } else {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"DiscountTypeError", (Context)ctx));
        }
    }

    private void doPrintList(Hashtable hsData, Context ctx, CustomerTaxEntryInfo entryInfo) throws TaskExternalException {
        String str = this.getCellStr(hsData, "FEntries_isPrintList");
        if ("1".equals(str) || str.equals(IsPrintListEnum.PRINTLIST.getAlias())) {
            entryInfo.setIsPrintList(IsPrintListEnum.PRINTLIST);
        } else if ("2".equals(str) || str.equals(IsPrintListEnum.NOPRINTLIST.getAlias())) {
            entryInfo.setIsPrintList(IsPrintListEnum.NOPRINTLIST);
        } else if ("0".equals(str) || str.equals(IsPrintListEnum.NULL.getAlias())) {
            entryInfo.setIsPrintList(IsPrintListEnum.NULL);
        } else {
            throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"PrintListError", (Context)ctx));
        }
        if (PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)entryInfo.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)entryInfo.getInvoiceType())) {
            entryInfo.setIsPrintList(IsPrintListEnum.NULL);
        }
    }

    private void doLimitAmt(Hashtable hsData, Context ctx, CustomerTaxEntryInfo entryInfo) throws TaskExternalException {
        String fLimitAmt = ((DataToken)hsData.get((Object)"FEntries_limitAmt")).data.toString().trim();
        DecimalFormat format = new DecimalFormat();
        try {
            Object val = null;
            if (fLimitAmt != null && !fLimitAmt.trim().isEmpty()) {
                val = format.parse(fLimitAmt);
            }
            if (val != null && new BigDecimal(val.toString()).compareTo(new BigDecimal("100000000")) > 0) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "LimitAmt_tooBig", ctx.getLocale()));
            }
            if (val != null) {
                entryInfo.setLimitAmt(new BigDecimal(val.toString()));
            }
        }
        catch (TaskExternalException e) {
            throw new TaskExternalException(IMUtils.getString(resClassName, "LimitAmt_tooBig", ctx.getLocale()));
        }
        catch (Exception e) {
            throw new TaskExternalException(IMUtils.getString(resClassName, "LimitAmt_Error", ctx.getLocale()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doStatus(Hashtable hsData, Context ctx, CustomerTaxInfo customerTaxInfo) throws TaskExternalException {
        String str = this.getCellStr(hsData, "FStatus");
        if (str == null || "".equals(str)) throw new TaskExternalException(IMUtils.getString(resClassName, "STATUS_ERROR", ctx.getLocale()));
        if (CustomerTaxStatusEnum.USING.getAlias().equals(str) || "0".equals(str.toString().trim())) {
            customerTaxInfo.setStatus(CustomerTaxStatusEnum.USING);
            return;
        } else {
            if (!CustomerTaxStatusEnum.FORBIDDEN.getAlias().equals(str) && !"1".equals(str.toString().trim())) throw new TaskExternalException(IMUtils.getString(resClassName, "STATUS_ERROR", ctx.getLocale()));
            customerTaxInfo.setStatus(CustomerTaxStatusEnum.FORBIDDEN);
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            result.put("FNumber", DataImportUtils.transformValue((Object)rs.getString("number")));
            result.put("FCompany_number", DataImportUtils.transformValue((Object)rs.getString("company.number")));
            result.put("FCurrentAccountType", DataImportUtils.transformValue((Object)((Object)CurrentAccountType.getEnum(rs.getString("currentAccountType")))));
            if ("2".equals(rs.getString("currentAccountType"))) {
                result.put("FCustomer_number", DataImportUtils.transformValue((Object)rs.getString("supplier.number")));
            } else {
                result.put("FCustomer_number", DataImportUtils.transformValue((Object)rs.getString("customer.number")));
            }
            result.put("FRecCompanyName", DataImportUtils.transformValue((Object)rs.getString("recCompanyName")));
            result.put("FTaxNumber", DataImportUtils.transformValue((Object)rs.getString("TaxNumber")));
            result.put("FAddressTel", DataImportUtils.transformValue((Object)rs.getString("addressTel")));
            result.put("FBankAccount", DataImportUtils.transformValue((Object)rs.getString("bankAccount")));
            result.put("FStatus", DataImportUtils.transformValue((Object)((Object)CustomerTaxStatusEnum.getEnum(rs.getString("status")))));
            result.put("FIsValueAdded", DataImportUtils.transformValue((Object)(Boolean.parseBoolean(rs.getString("isValueAdded")) ? IMUtils.getString("com.kingdee.eas.tm.im.basedata.CustomerTaxResource", "TRUE", ctx.getLocale()) : IMUtils.getString("com.kingdee.eas.tm.im.basedata.CustomerTaxResource", "FALSE", ctx.getLocale()))));
            result.put("FIsDefault", DataImportUtils.transformValue((Object)(Boolean.parseBoolean(rs.getString("isDefault")) ? IMUtils.getString("com.kingdee.eas.tm.im.basedata.CustomerTaxResource", "TRUE", ctx.getLocale()) : IMUtils.getString("com.kingdee.eas.tm.im.basedata.CustomerTaxResource", "FALSE", ctx.getLocale()))));
            result.put("FSourceType", DataImportUtils.transformValue((Object)((Object)CustomerTaxSourceTypeEnum.getEnum(rs.getString("sourceType")))));
            result.put("FEntries_invoiceType", DataImportUtils.transformValue((Object)PayInvoiceTypeEnum.getEnum((String)rs.getString("entries.invoiceType"))));
            result.put("FEntries_limitAmt", DataImportUtils.transformValue((Object)rs.getBigDecimal("entries.limitAmt")));
            result.put("FEntries_discountType", DataImportUtils.transformValue((Object)((Object)DiscountTypeEnum.getEnum(rs.getString("entries.discountType")))));
            result.put("FEntries_isPrintList", DataImportUtils.transformValue((Object)((Object)IsPrintListEnum.getEnum(rs.getString("entries.isPrintList")))));
            result.put("FEntries_isDefault", DataImportUtils.transformValue((Object)(Boolean.parseBoolean(rs.getString("entries.isDefault")) ? IMUtils.getString("com.kingdee.eas.tm.im.basedata.CustomerTaxResource", "TRUE", ctx.getLocale()) : IMUtils.getString("com.kingdee.eas.tm.im.basedata.CustomerTaxResource", "FALSE", ctx.getLocale()))));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.im.basedata.CustomerTaxQuery";
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        if (this.firstData != null) {
            firstNumber = (DataToken)this.firstData.get(this.getMainField());
        }
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        this.firstData = currentData;
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    public int getSubmitType() {
        return 1;
    }
}

