/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.IExpenseType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.basedata.IIncomeType;
import com.kingdee.eas.tm.im.basedata.IncomeTypeEntryCollection;
import com.kingdee.eas.tm.im.basedata.IncomeTypeEntryInfo;
import com.kingdee.eas.tm.im.basedata.IncomeTypeException;
import com.kingdee.eas.tm.im.basedata.IncomeTypeFactory;
import com.kingdee.eas.tm.im.basedata.IncomeTypeInfo;
import com.kingdee.eas.tm.im.basedata.IncomeTypeStatusEnum;
import com.kingdee.eas.tm.im.basedata.TypeEnum;
import com.kingdee.eas.tm.im.basedata.app.AbstractIncomeTypeControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.PropertyContainer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class IncomeTypeControllerBean
extends AbstractIncomeTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.basedata.app.IncomeTypeControllerBean");

    @Override
    protected IObjectValue _getRealValue(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IncomeTypeEntryInfo entryInfo;
        IncomeTypeInfo incomeTypeInfo = (IncomeTypeInfo)model;
        HashSet<String> set = new HashSet<String>();
        IncomeTypeEntryCollection coll = incomeTypeInfo.getEntries();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = coll.get(i);
            set.add(entryInfo.getTypeId());
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        ev.setFilter(filter);
        IExpenseType icorebase = null;
        if (incomeTypeInfo.getType() == TypeEnum.ExpenseType) {
            icorebase = ExpenseTypeFactory.getLocalInstance((Context)ctx);
        } else if (incomeTypeInfo.getType() == TypeEnum.RowType) {
            icorebase = RowTypeFactory.getLocalInstance((Context)ctx);
        } else {
            return null;
        }
        CoreBaseCollection typecoll = icorebase.getCollection(ev);
        int size2 = coll.size();
        for (int i = 0; i < size2; ++i) {
            CoreBaseInfo value = typecoll.get(i);
            entryInfo = coll.get(i);
            entryInfo.put("typeInfo", value);
        }
        return model;
    }

    @Override
    protected Set _getTypeId(Context ctx, String id) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT  ENTRIES.FTypeId AS id FROM T_TM_IncomeType AS INCOMETYPE LEFT OUTER JOIN T_TM_IncomeTypeEntry AS ENTRIES ON INCOMETYPE.FID = ENTRIES.FParentID where INCOMETYPE.FStatus='0' ");
        if (!IMUtils.isEmpty(id)) {
            sql.append("and INCOMETYPE.FID !='").append(id).append("' ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> typeIDs = new HashSet<String>();
        try {
            while (rs.next()) {
                if (rs.getString("id") == null) continue;
                typeIDs.add(rs.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return typeIDs;
    }

    @Override
    protected ArrayList _batchDelete(Context ctx, ArrayList pks) throws BOSException, EASBizException {
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < pks.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)pks.get(i).toString()));
            try {
                this._delete(ctx, (IObjectPK)pk);
                continue;
            }
            catch (Exception e) {
                errors.add(e.getMessage());
            }
        }
        return errors;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IncomeTypeInfo info = IncomeTypeFactory.getLocalInstance(ctx).getIncomeTypeInfo(pk);
        IObjectPK logPK = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"B7EDE389"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber().toString(), "im_incomeType_delete", info.getCU().getId().toString());
        StringBuffer sql1 = new StringBuffer();
        sql1.append(" SELECT 1 FROM T_IM_Incomeinvoice where FIncomeTypeID = '").append(pk.toString()).append("' ");
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql1.toString());
        if (rs1.size() != 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.IncomeTypeResource", (String)"CANNOTDELETE_USED", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()})});
        }
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select 1 from T_IM_TaxTransferEntry where FIncomeTypeID = '").append(pk.toString()).append("'");
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
        if (rs2.size() != 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.IncomeTypeResource", (String)"CANNOTDELETE_USED", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()})});
        }
        if (IncomeTypeStatusEnum.Active.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.IncomeTypeResource", (String)"CANNOTDELETE_ACTIVED", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()})});
        }
        super._delete(ctx, pk);
        LogUtils.afterLog(ctx, logPK);
    }

    @Override
    protected ArrayList _setActive(Context ctx, ArrayList pks) throws BOSException, EASBizException {
        boolean isActive = false;
        ArrayList<String> errors = new ArrayList<String>();
        IIncomeType localInstance = IncomeTypeFactory.getLocalInstance(ctx);
        HashSet<String> typeIDs = this.getTypeId(ctx, null);
        String statusValue = "0";
        for (int i = 0; i < pks.size(); ++i) {
            isActive = false;
            IncomeTypeInfo info = null;
            ObjectUuidPK pk = new ObjectUuidPK(pks.get(i).toString());
            info = localInstance.getIncomeTypeInfo((IObjectPK)pk);
            if (IncomeTypeStatusEnum.Active.equals((Object)info.getStatus())) {
                isActive = true;
                errors.add(ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.IncomeTypeResource", (String)"ACTIVE_ERROR", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}) + "\r\n");
                continue;
            }
            IncomeTypeEntryCollection coll = info.getEntries();
            int size = coll.size();
            for (int j = 0; j < size; ++j) {
                IncomeTypeEntryInfo entryInfo = coll.get(j);
                if (typeIDs != null && typeIDs.contains(entryInfo.getTypeId().toString())) {
                    isActive = true;
                    errors.add(ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.IncomeTypeResource", (String)"EXISTENTRIES_ACTIVED", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}) + "\r\n");
                    break;
                }
                if (typeIDs == null) {
                    typeIDs = new HashSet<String>();
                }
                typeIDs.add(entryInfo.getTypeId());
            }
            if (isActive) continue;
            this.updateStatus(ctx, statusValue, "active", info, "im_customerTax_active");
        }
        return errors;
    }

    @Override
    protected ArrayList _setUnActive(Context ctx, ArrayList pks) throws BOSException, EASBizException {
        HashSet<String> updateNumbers = new HashSet<String>();
        ArrayList<String> errors = new ArrayList<String>();
        String statusValue = "1";
        for (int i = 0; i < pks.size(); ++i) {
            IncomeTypeInfo info = null;
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)pks.get(i).toString()));
            info = IncomeTypeFactory.getLocalInstance(ctx).getIncomeTypeInfo((IObjectPK)pk);
            if (IncomeTypeStatusEnum.UnActive.equals((Object)info.getStatus())) {
                errors.add(ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.IncomeTypeResource", (String)"UNACTIVE_ERROR", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}) + "\r\n");
                continue;
            }
            updateNumbers.add(info.getNumber().toString());
            this.updateStatus(ctx, statusValue, "unActive", info, "im_incomeType_unActive");
        }
        return errors;
    }

    private void updateStatus(Context ctx, String statusValue, String methodName, IncomeTypeInfo info, String logItem) throws BOSException {
        IObjectPK logPK = LogUtils.beginLog(ctx, methodName, BOSObjectType.create((String)"B7EDE389"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber().toString(), logItem, info.getCU().getId().toString());
        String updateSql = "update t_tm_incometype set FStatus = " + statusValue + " where fid = '" + info.getId().toString() + "' ";
        DbUtil.execute((Context)ctx, (String)updateSql);
        LogUtils.afterLog(ctx, logPK);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IncomeTypeInfo incomeTypeInfo = (IncomeTypeInfo)model;
        IMUtils.trimHeadTextFields((PropertyContainer)incomeTypeInfo);
        this.checkNumber(ctx, incomeTypeInfo.getNumber(), incomeTypeInfo);
        this.checkEntry(ctx, incomeTypeInfo);
        return super._submit(ctx, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IncomeTypeInfo incomeTypeInfo = (IncomeTypeInfo)model;
        IMUtils.trimHeadTextFields((PropertyContainer)incomeTypeInfo);
        this.checkNumber(ctx, incomeTypeInfo.getNumber(), incomeTypeInfo);
        this.checkEntry(ctx, incomeTypeInfo);
        return super._addnew(ctx, model);
    }

    private void checkNumber(Context ctx, String number, IncomeTypeInfo info) throws BOSException, EASBizException {
        if (number != null && !"".equals(number.trim())) {
            boolean exists;
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            if (info.getId() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            }
            if (exists = IncomeTypeFactory.getLocalInstance(ctx).exists(filterInfo)) {
                throw new IncomeTypeException(IncomeTypeException.NUMBERNOTREPEAT);
            }
        } else {
            info.setNumber(info.getNumber().trim());
            info.setName(info.getName().trim());
        }
    }

    private void checkEntry(Context ctx, IncomeTypeInfo info) throws BOSException, EASBizException {
        HashSet<String> entryTypeIDs = new HashSet<String>();
        IncomeTypeEntryCollection entryColl = info.getEntries();
        for (int i = 0; i < entryColl.size(); ++i) {
            IncomeTypeEntryInfo entryInfo = entryColl.get(i);
            if (entryTypeIDs.contains(entryInfo.getTypeId().toString())) {
                throw new IncomeTypeException(IncomeTypeException.ENTRYNOTREPEAT);
            }
            entryTypeIDs.add(entryInfo.getTypeId().toString());
        }
        if (IncomeTypeStatusEnum.Active.equals((Object)info.getStatus())) {
            Set typeIDs = this.getTypeId(ctx, info.getId() == null ? null : info.getId().toString());
            typeIDs.retainAll(entryTypeIDs);
            if (typeIDs.size() > 0) {
                String str = ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.IncomeTypeResource", (String)"EXISTENTRIES_ACTIVED", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}) + "\r\n";
                throw new IMException(IMException.ERRORMSG, new Object[]{str});
            }
        }
    }

    @Override
    protected String _getTypeIdbyNumber(Context ctx, String number, int type) throws BOSException, EASBizException {
        String typeId = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select FID as id from ");
        if (type == 1) {
            sql.append(" T_BC_ExpenseType where FNumber='");
        } else if (type == 2) {
            sql.append(" T_SCM_RowType where FNumber='");
        } else {
            return typeId;
        }
        sql.append(number + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                typeId = rs.getString("id");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return typeId;
    }
}

