/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.InvoiceParamConfigException;
import com.kingdee.eas.tm.im.basedata.IInvoiceParamConfig;
import com.kingdee.eas.tm.im.basedata.InvoiceParamConfigCollection;
import com.kingdee.eas.tm.im.basedata.InvoiceParamConfigFactory;
import com.kingdee.eas.tm.im.basedata.InvoiceParamConfigInfo;
import com.kingdee.eas.tm.im.basedata.MeasureUnitCarryTypeEnum;
import com.kingdee.eas.tm.im.basedata.ParamConfigStatusEnum;
import com.kingdee.eas.tm.im.basedata.app.AbstractInvoiceParamConfigControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class InvoiceParamConfigControllerBean
extends AbstractInvoiceParamConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.basedata.app.InvoiceParamConfigControllerBean");
    private static final String INVOICEPARAMCONFIG_RESOURCE = "com.kingdee.eas.tm.im.InvoiceParamConfigResource";
    private int REMARK_MAX_LENGTH = 1024;
    private static final String NEXTLINE = ";\r\n";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceParamConfigInfo info = (InvoiceParamConfigInfo)model;
        info.setNumber(this.trimStr(info.getNumber()));
        this.checkNumberUnique(ctx, info);
        this.checkBeforeSubmit(ctx, info);
        this.checkUnique(ctx, info);
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        return pk;
    }

    private void checkBeforeSubmit(Context ctx, InvoiceParamConfigInfo info) throws InvoiceParamConfigException {
        StringBuffer errorMsg = new StringBuffer();
        if (info.getNumber() == null) {
            errorMsg.append(EASResource.getString((String)INVOICEPARAMCONFIG_RESOURCE, (String)"NUMBER"));
        }
        if (!info.isIsPreset() && info.getCompany() == null) {
            errorMsg.append(EASResource.getString((String)INVOICEPARAMCONFIG_RESOURCE, (String)"COMPANY"));
        }
        if (info.getBizBillType() != null && MeasureUnitCarryTypeEnum.SourceBill.equals((Object)info.getMeasureUnitCarryType()) && (StringUtils.isEmpty((String)info.getMeasureUnitField()) || StringUtils.isEmpty((String)info.getMeasureUnitName()))) {
            errorMsg.append(EASResource.getString((String)INVOICEPARAMCONFIG_RESOURCE, (String)"MeasureUnitField"));
        }
        if (errorMsg.length() > 0) {
            errorMsg.append(EASResource.getString((String)INVOICEPARAMCONFIG_RESOURCE, (String)"NOTNULL")).append(NEXTLINE);
        }
        if (info.getRemark() != null && IMUtils.getStringlength(info.getRemark()) > this.REMARK_MAX_LENGTH) {
            errorMsg.append(EASResource.getString((String)INVOICEPARAMCONFIG_RESOURCE, (String)"RemarkTooLong", (Object[])new Object[]{this.REMARK_MAX_LENGTH + ""}).substring(1));
        }
        if (errorMsg.length() > 0) {
            throw new InvoiceParamConfigException(InvoiceParamConfigException.ERRORMSG, new Object[]{errorMsg.substring(1)});
        }
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        InvoiceParamConfigInfo info = InvoiceParamConfigFactory.getLocalInstance(ctx).getInvoiceParamConfigInfo(pk);
        if (ParamConfigStatusEnum.Active.equals((Object)info.getStatus())) {
            throw new InvoiceParamConfigException(InvoiceParamConfigException.HASACTIVE);
        }
        info.setStatus(ParamConfigStatusEnum.Active);
        this.checkUnique(ctx, info);
        this._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        InvoiceParamConfigInfo info = InvoiceParamConfigFactory.getLocalInstance(ctx).getInvoiceParamConfigInfo(pk);
        if (!ParamConfigStatusEnum.Active.equals((Object)info.getStatus())) {
            throw new InvoiceParamConfigException(InvoiceParamConfigException.NOTACTIVE);
        }
        info.setStatus(ParamConfigStatusEnum.UnActive);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceParamConfigInfo invoiceParamConfigInfo = InvoiceParamConfigFactory.getLocalInstance(ctx).getInvoiceParamConfigInfo(pk);
        if (ParamConfigStatusEnum.Active.equals((Object)invoiceParamConfigInfo.getStatus())) {
            throw new InvoiceParamConfigException(InvoiceParamConfigException.ERRORMSG, new Object[]{EASResource.getString((String)INVOICEPARAMCONFIG_RESOURCE, (String)"CANNOTREMOVE")});
        }
        if (invoiceParamConfigInfo.isIsPreset()) {
            throw new InvoiceParamConfigException(InvoiceParamConfigException.ERRORMSG, new Object[]{EASResource.getString((String)INVOICEPARAMCONFIG_RESOURCE, (String)"CANNOTREMOVEPRESET")});
        }
        this.recycleNumber(ctx, pk, invoiceParamConfigInfo);
        super._delete(ctx, pk);
    }

    private void recycleNumber(Context ctx, IObjectPK pk, InvoiceParamConfigInfo info) throws EASBizException, BOSException {
        if (info.getNumber() != null) {
            String cuID = info.getCU().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, cuID);
            if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, cuID) || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)info, cuID, info.getNumber());
            }
        }
    }

    private String trimStr(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return str.trim();
    }

    private void checkNumberUnique(Context ctx, InvoiceParamConfigInfo info) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)info.getNumber())) {
            super._checkNumberDup(ctx, (IObjectValue)info);
        } else {
            info.setNumber(this.getNewNumber(ctx, info, null, false));
        }
    }

    private void checkUnique(Context ctx, InvoiceParamConfigInfo info) throws BOSException, InvoiceParamConfigException {
        if (info.isIsPreset() || ParamConfigStatusEnum.UnActive == info.getStatus()) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"1", CompareType.EQUALS));
        if (info.getBizBillType() != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizBillType", (Object)info.getBizBillType().getValue(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("bizBillType", null, CompareType.EQUALS));
        }
        view.setFilter(filter);
        InvoiceParamConfigCollection collection = InvoiceParamConfigFactory.getLocalInstance(ctx).getInvoiceParamConfigCollection(view);
        if (collection != null && collection.size() > 0) {
            throw new InvoiceParamConfigException(InvoiceParamConfigException.INVOICERI_MUST_UNIQUE);
        }
    }

    private String getNewNumber(Context ctx, InvoiceParamConfigInfo info, String cuID, boolean addNew) throws EASBizException, BOSException {
        IInvoiceParamConfig iInvoiceParamConfig = InvoiceParamConfigFactory.getLocalInstance(ctx);
        if (cuID == null || cuID.isEmpty()) {
            cuID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)info, cuID);
        if (addNew && (codingRule == null || !codingRule.isIsAddView())) {
            return "";
        }
        String number = (String)info.get("number");
        int maxCycleNum = 100;
        String filterString = "where number = '" + number + "' " + (info.get("id") != null ? "and id !='" + info.get("id") + "'" : "");
        while (number == null || number.equals("") || iInvoiceParamConfig.exists(filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            number = iCodingRuleManager.getNumber((IObjectValue)info, cuID);
            filterString = "where number = '" + number + "' " + (info.get("id") != null ? "and id !='" + info.get("id") + "'" : "");
        }
        return number;
    }
}

