/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.basedata.IPwyData;
import com.kingdee.eas.tm.im.basedata.PwyDataCollection;
import com.kingdee.eas.tm.im.basedata.PwyDataFactory;
import com.kingdee.eas.tm.im.basedata.PwyDataInfo;
import com.kingdee.eas.tm.im.basedata.PwyDataStatus;
import com.kingdee.eas.tm.im.basedata.app.AbstractPwyDataControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PwyDataControllerBean
extends AbstractPwyDataControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.basedata.app.PwyDataControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PwyDataInfo info = (PwyDataInfo)model;
        if (PwyDataStatus.USING.equals((Object)info.getStatus())) {
            this.checkUnique(ctx, info);
        }
        this.setNewNumber(ctx, info);
        info.setTaxNumber(info.getTaxNumber() == null ? null : info.getTaxNumber().trim());
        info.setClientId(info.getClientId() == null ? null : info.getClientId().trim());
        info.setClientSecret(info.getClientSecret() == null ? null : info.getClientSecret().trim());
        info.setEncryptKey(info.getEncryptKey() == null ? null : info.getEncryptKey().trim());
        return super._save(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PwyDataInfo info = this.getPwyDataInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_pwyData_delete");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (PwyDataStatus.USING.equals((Object)info.getStatus())) {
            String deleteMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_DELETE", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{deleteMsg});
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" Select 1 From T_TM_TaxPlate where FPwyDataID = '");
            sql.append(pk.toString()).append("' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                String referencedMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_PWYDATAREF", ctx);
                throw new IMException(IMException.ERRORMSG, new Object[]{referencedMsg});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (info.getNumber() != null) {
            String cuID = info.getCU().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, cuID);
            if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, cuID) || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)info, cuID, info.getNumber());
            }
        }
        super._delete(ctx, pk);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getPwyDataInfo(ctx, pk);
        }
        PwyDataInfo info = (PwyDataInfo)model;
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_pwyData_cancel");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (info.getStatus() == PwyDataStatus.FORBIDDEN) {
            String cancel = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_CANCEL", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + cancel});
        }
        info.setStatus(PwyDataStatus.FORBIDDEN);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getPwyDataInfo(ctx, pk);
        }
        PwyDataInfo info = (PwyDataInfo)model;
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_pwyData_cancelcancel");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        this.checkUnique(ctx, info);
        if (info.getStatus() == PwyDataStatus.USING) {
            String active = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_CANCELCANCEL", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + active});
        }
        info.setStatus(PwyDataStatus.USING);
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void checkUnique(Context ctx, PwyDataInfo info) throws BOSException, EASBizException {
        String taxNumber = info.getTaxNumber();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taxNumber", (Object)taxNumber));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"0"));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        viewInfo.setFilter(filter);
        PwyDataCollection coll = this.getPwyDataCollection(ctx, viewInfo);
        if (!coll.isEmpty()) {
            String uniqueMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_PWYDATAUNIQUE", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + uniqueMsg});
        }
    }

    private void checkNumber(Context ctx, PwyDataInfo info) throws BOSException, IMException {
        String number = info.getNumber();
        if (number != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            if (info.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            }
            view.setFilter(filter);
            PwyDataCollection coll = this.getPwyDataCollection(ctx, view);
            if (coll.size() > 0) {
                String uniqueMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_PWYDATANUMBERUNIQUE", ctx);
                throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + uniqueMsg});
            }
        }
    }

    public void setNewNumber(Context ctx, PwyDataInfo info) throws EASBizException, BOSException {
        if (info.getNumber() != null) {
            this.checkNumber(ctx, info);
            return;
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            String number = this.getNumber(ctx, info);
            info.setNumber(number);
        }
    }

    private String getNumber(Context ctx, PwyDataInfo caller) throws BOSException, EASBizException {
        IPwyData iBillBase = PwyDataFactory.getLocalInstance(ctx);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = (String)caller.get("number");
        String cuID = caller.getCU() == null ? ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() : caller.getCU().getId().toString();
        int maxCycleNum = 100;
        String filterString = "where number = '" + number + "' and CU.id = '" + cuID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        while (number == null || number.equals("") || iBillBase.exists(filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)caller, cuID);
            number = iCodingRuleManager.getNumber((IObjectValue)caller, ruleInfo);
            filterString = "where number = '" + number + "' and CU.id = '" + cuID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        }
        return number;
    }
}

