/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.basedata.ITaxPlate;
import com.kingdee.eas.tm.im.basedata.TaxPlateCollection;
import com.kingdee.eas.tm.im.basedata.TaxPlateFactory;
import com.kingdee.eas.tm.im.basedata.TaxPlateInfo;
import com.kingdee.eas.tm.im.basedata.TaxPlateStatus;
import com.kingdee.eas.tm.im.basedata.app.AbstractTaxPlateControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class TaxPlateControllerBean
extends AbstractTaxPlateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.basedata.app.TaxPlateControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxPlateInfo info = (TaxPlateInfo)model;
        if (TaxPlateStatus.USING.equals((Object)info.getStatus())) {
            this.checkUnique(ctx, info);
        }
        this.setNewNumber(ctx, info);
        info.setPlateNo(info.getPlateNo() == null ? null : info.getPlateNo().trim());
        info.setExtensionNo(info.getExtensionNo() == null ? null : info.getExtensionNo().trim());
        return super._save(ctx, model);
    }

    public void setNewNumber(Context ctx, TaxPlateInfo info) throws EASBizException, BOSException {
        info.setNumber(info.getNumber() == null ? null : info.getNumber().trim());
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.basedata.TaxPlateResource", "NUMER_IS_NOT_NULL")});
        }
        if (info.getNumber() != null) {
            this.checkNumber(ctx, info);
            return;
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            String number = this.getNumber(ctx, info);
            info.setNumber(number);
        }
    }

    private String getNumber(Context ctx, TaxPlateInfo caller) throws BOSException, EASBizException {
        ITaxPlate iBillBase = TaxPlateFactory.getLocalInstance(ctx);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = (String)caller.get("number");
        String cuID = caller.getCU() == null ? ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString() : caller.getCU().getId().toString();
        int maxCycleNum = 100;
        String filterString = "where number = '" + number + "' and CU.id = '" + cuID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        while (number == null || number.equals("") || iBillBase.exists(filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)caller, cuID);
            number = iCodingRuleManager.getNumber((IObjectValue)caller, ruleInfo);
            filterString = "where number = '" + number + "' and CU.id = '" + cuID + "' " + (caller.get("id") != null ? "and id !='" + caller.get("id") + "'" : "");
        }
        return number;
    }

    private void checkNumber(Context ctx, TaxPlateInfo info) throws BOSException, IMException {
        String number = info.getNumber();
        if (number != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            if (info.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            }
            view.setFilter(filter);
            TaxPlateCollection coll = this.getTaxPlateCollection(ctx, view);
            if (coll.size() > 0) {
                String uniqueMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_TAXPLATENUMBERUNIQUE", ctx);
                throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + uniqueMsg});
            }
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TaxPlateInfo info = this.getTaxPlateInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_taxPlate_delete");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (TaxPlateStatus.USING.equals((Object)info.getStatus())) {
            String deleteMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_DELETE", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{deleteMsg});
        }
        try {
            String referencedMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_TAXPLATEREF", ctx);
            StringBuffer sql = new StringBuffer();
            IRowSet rs = null;
            sql.append(" Select 1 From T_IM_InvoiceInvMgr where FTaxPlateID = '");
            sql.append(pk.toString()).append("' ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{referencedMsg});
            }
            sql.setLength(0);
            sql.append(" Select 1 From T_IM_InvoiceAlarm where FTaxPlateID = '");
            sql.append(pk.toString()).append("' ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{referencedMsg});
            }
            sql.setLength(0);
            sql.append(" Select 1 From T_IM_InvoiceReceive where FTaxPlateID = '");
            sql.append(pk.toString()).append("' ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{referencedMsg});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        super._delete(ctx, pk);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("pwyData.*"));
            model = this.getTaxPlateInfo(ctx, pk, sic);
        }
        TaxPlateInfo info = (TaxPlateInfo)model;
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_taxPlate_cancel");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (info.getStatus() == TaxPlateStatus.FORBIDDEN) {
            String cancel = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_CANCEL", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + cancel});
        }
        info.setStatus(TaxPlateStatus.FORBIDDEN);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("pwyData.*"));
            model = this.getTaxPlateInfo(ctx, pk, sic);
        }
        TaxPlateInfo info = (TaxPlateInfo)model;
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_taxPlate_cancelcancel");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        this.checkUnique(ctx, info);
        if (info.getStatus() == TaxPlateStatus.USING) {
            String active = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_CANCELCANCEL", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + active});
        }
        info.setStatus(TaxPlateStatus.USING);
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void checkUnique(Context ctx, TaxPlateInfo info) throws BOSException, EASBizException {
        String plateNo = info.getPlateNo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("plateNo", (Object)plateNo));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"0"));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        TaxPlateCollection tpColl = this.getTaxPlateCollection(ctx, viewInfo);
        if (!tpColl.isEmpty()) {
            String uniqueMsg = IMUtils.getResource("com.kingdee.eas.tm.im.basedata.TaxPlateResource", "ERR_UNIQUE", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + uniqueMsg});
        }
        if (info.isIsMain()) {
            String taxNumber = info.getPwyData().getTaxNumber();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("pwyData.taxNumber", (Object)taxNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isMain", (Object)true, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)"0", CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            view.setFilter(filter);
            TaxPlateCollection coll = this.getTaxPlateCollection(ctx, view);
            if (!coll.isEmpty()) {
                String uniqueMsg = IMUtils.getResource("com.kingdee.eas.tm.im.basedata.TaxPlateResource", "ERR_TAXNUMONEMAIN", ctx);
                throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + uniqueMsg});
            }
        }
    }
}

