/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app.transformer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.bot.runtime.BotUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.app.util.IMServerUtil;
import com.kingdee.eas.tm.im.app.util.IMServiceCache;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleCollection;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleFactory;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleInfo;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleSegmentInfo;
import com.kingdee.eas.tm.im.basedata.app.transformer.ClassfiyRule;
import com.kingdee.eas.tm.im.basedata.app.transformer.IBaseDataTransformer;
import com.kingdee.eas.tm.im.common.formula.app.engine.BDSyncInterpreter;
import com.kingdee.eas.tm.im.common.model.ClassfiyOverLengthField;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class BaseDataTransformer
implements IBaseDataTransformer {
    private static final Logger logger = Logger.getLogger(BaseDataTransformer.class);
    protected Context ctx = null;
    protected BDSyncInterpreter interpreter = null;
    private List<String> mutiLangProperty = new ArrayList<String>(10);

    public BaseDataTransformer(Context ctx) {
        this.ctx = ctx;
        this.interpreter = new BDSyncInterpreter(ctx);
    }

    @Override
    public IObjectCollection transform(Set srcIdSet, Map param) throws Exception {
        IObjectCollection values = (IObjectCollection)IMServiceCache.getClass(this.getDestEntity().getObjectCollectionClass()).newInstance();
        if (!this.filterExist(srcIdSet)) {
            logger.error((Object)"[BaseDataTransformer] filterExist  not records !");
            return values;
        }
        this.initMutiLangProperty();
        Set cuIdSet = this.getCuIdSet(srcIdSet);
        ClassfiyRule classfiyRule = this.loadRules(cuIdSet);
        this.buildSrcSelector(classfiyRule);
        this.buildFitRulesMap(srcIdSet, classfiyRule);
        IObjectCollection srcColls = this.getSyncDataColls(srcIdSet, classfiyRule.getSrcSelector());
        IObjectValue srcObj = null;
        IObjectValue destObj = null;
        int size = srcColls.size();
        for (int i = 0; i < size; ++i) {
            srcObj = srcColls.getObject(i);
            this.beforeTranfor(srcObj);
            destObj = this.objTransfor(srcColls.getObject(i), classfiyRule);
            if (destObj == null) continue;
            this.afterTranfor(destObj);
            values.addObject(destObj);
        }
        return values;
    }

    public void initMutiLangProperty() {
        PropertyCollection props = this.getDestEntity().getInheritedNoDuplicatedProperties();
        for (PropertyInfo propInfo : props) {
            if (this.mutiLangProperty == null || !"true".equals(propInfo.get("isMultilingual"))) continue;
            this.mutiLangProperty.add(propInfo.getName());
        }
    }

    protected void beforeTranfor(IObjectValue srcObj) {
    }

    protected void afterTranfor(IObjectValue destObj) throws Exception {
        this.cutOverLengthFields(destObj);
    }

    protected void cutOverLengthFields(IObjectValue destObj) throws Exception {
        ClassfiyOverLengthField classfiyField = this.getClassfiyOverLengthField();
        BDSyncRuleInfo rule = (BDSyncRuleInfo)destObj.get("_SyncRule");
        if (rule != null) {
            String field = null;
            for (int i = 0; i < rule.getDestExprStrFields().size(); ++i) {
                field = rule.getDestExprStrFields().get(i);
                if (classfiyField.getOverLengthFields().contains(field)) continue;
                classfiyField.getOverLengthFields().add(field);
            }
        }
        IMServerUtil.cutOverLengthFields(this.ctx, destObj, classfiyField);
        if (classfiyField.getOverLengthLogs().length() > 0) {
            logger.error((Object)("[BaseDataTransformer]:" + classfiyField.getOverLengthLogs().toString()));
            destObj.put("syncRemark", (Object)classfiyField.getOverLengthLogs().toString());
            IMServerUtil.cutOverLengthFields(this.ctx, destObj, ClassfiyOverLengthField.custom().setOverLengthFields(new String[]{"syncRemark"}).build());
        }
    }

    protected ClassfiyOverLengthField getClassfiyOverLengthField() {
        return ClassfiyOverLengthField.custom().build();
    }

    protected IObjectValue objTransfor(IObjectValue obj, ClassfiyRule classfiyRule) throws Exception {
        String srcBillId = obj.get("id").toString();
        String cuId = obj.getObjectValue("CU").get("id").toString();
        BDSyncRuleCollection filterRules = this.getRules(classfiyRule.getFilterRulesMap(), cuId);
        BDSyncRuleCollection noFilterRules = this.getRules(classfiyRule.getNoFilterRulesMap(), cuId);
        IObjectValue value = null;
        if (filterRules.size() == 0 && noFilterRules.size() == 0) {
            value = this.defaultTransfor(obj);
        } else if (filterRules.size() == 0 && noFilterRules.size() > 0) {
            value = this.segTransfor(obj, noFilterRules.get(0));
        } else if (filterRules.size() > 0) {
            BDSyncRuleCollection volidRules = classfiyRule.getFitRulesMap().get(srcBillId);
            if (volidRules != null && volidRules.size() > 0) {
                value = this.segTransfor(obj, volidRules.get(0));
            } else if (noFilterRules.size() > 0) {
                value = this.segTransfor(obj, noFilterRules.get(0));
            } else {
                value = null;
                logger.error((Object)("[BaseDataTransformer] not fit Rule , productCode not create! srcBillId :" + srcBillId));
            }
        }
        return value;
    }

    protected boolean filterExist(Set srcIdSet) throws BOSException, SQLException {
        String relationField = this.getDestEntity().getPropertyByName(this.getRelationField()).getMappingField().getName();
        String destTableName = this.getDestEntity().getTable().getName();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ").append(relationField).append(" FROM " + destTableName + " WHERE ");
        sql.append(relationField).append(" IN ").append(IMUtils.getInStringFromSet(srcIdSet));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        String billId = null;
        while (rowSet.next()) {
            billId = rowSet.getString(1);
            srcIdSet.remove(billId);
            logger.debug((Object)("[BaseDataTransformer] filterExist remove srcBillId : " + billId));
        }
        return srcIdSet.size() > 0;
    }

    protected Set getCuIdSet(Set srcIdSet) throws BOSException, SQLException {
        String cuField = this.getSrcEntity().getPropertyByName("CU").getMappingField().getName();
        String srcTableName = this.getSrcEntity().getTable().getName();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ").append(cuField).append(" FROM " + srcTableName);
        sql.append(" WHERE FID IN ").append(IMUtils.getInStringFromSet(srcIdSet));
        sql.append(" GROUP BY " + cuField);
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        HashSet<String> orgIdSet = new HashSet<String>();
        while (rowSet.next()) {
            orgIdSet.add(rowSet.getString(1));
        }
        return orgIdSet;
    }

    protected ClassfiyRule loadRules(Set<String> cuIdSet) throws BOSException {
        BDSyncRuleCollection allRules = new BDSyncRuleCollection();
        BDSyncRuleCollection allFilterRules = new BDSyncRuleCollection();
        HashMap<String, BDSyncRuleCollection> filterRulesMap = new HashMap<String, BDSyncRuleCollection>();
        HashMap<String, BDSyncRuleCollection> noFilterRulesMap = new HashMap<String, BDSyncRuleCollection>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("mapping.srcBosType", (Object)this.getSrcBosType(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("mapping.destBosType", (Object)this.getDestBosType(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", cuIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.*"));
        sic.add(new SelectorItemInfo("ruleSegments.*"));
        view.setSelector(sic);
        BDSyncRuleCollection rules = BDSyncRuleFactory.getLocalInstance(this.ctx).getBDSyncRuleCollection(view);
        BDSyncRuleInfo rule = null;
        BDSyncRuleCollection noFilterRules = null;
        BDSyncRuleCollection filterRules = null;
        String cuId = null;
        int size = rules.size();
        for (int i = 0; i < size; ++i) {
            rule = rules.get(i);
            cuId = rule.getCU().getId().toString();
            noFilterRules = this.getRules(noFilterRulesMap, cuId);
            filterRules = this.getRules(filterRulesMap, cuId);
            allRules.add(rule);
            if (StringUtils.isEmpty((String)rule.getDataFilter())) {
                noFilterRules.add(rule);
                continue;
            }
            filterRules.add(rule);
            allFilterRules.add(rule);
        }
        ClassfiyRule classfiyRule = new ClassfiyRule();
        classfiyRule.setAllRules(allRules);
        classfiyRule.setAllFilterRules(allFilterRules);
        classfiyRule.setFilterRulesMap(filterRulesMap);
        classfiyRule.setNoFilterRulesMap(noFilterRulesMap);
        return classfiyRule;
    }

    protected BDSyncRuleCollection getRules(Map<String, BDSyncRuleCollection> ruleMap, String cuId) {
        BDSyncRuleCollection rules = ruleMap.get(cuId);
        if (rules == null) {
            rules = new BDSyncRuleCollection();
            ruleMap.put(cuId, rules);
        }
        return rules;
    }

    protected void buildSrcSelector(ClassfiyRule classfiyRule) {
        HashSet<String> selectorSet = new HashSet<String>();
        BDSyncRuleInfo rule = null;
        BDSyncRuleSegmentInfo entryInfo = null;
        BDSyncRuleCollection allRules = classfiyRule.getAllRules();
        List propertyNameList = null;
        int size = allRules.size();
        for (int i = 0; i < size; ++i) {
            rule = allRules.get(i);
            Iterator it = rule.getRuleSegments().iterator();
            while (it.hasNext()) {
                entryInfo = (BDSyncRuleSegmentInfo)it.next();
                if (StringUtils.isEmpty((String)entryInfo.getSrcExpr())) continue;
                propertyNameList = this.getPropertyNameInExpr(entryInfo);
                selectorSet.addAll(propertyNameList);
            }
        }
        classfiyRule.setSrcSelector(this.buildSet2Selector(selectorSet));
    }

    private List getPropertyNameInExpr(BDSyncRuleSegmentInfo entryInfo) {
        String expression;
        ArrayList<String> propertyNameList = new ArrayList<String>();
        String propertyName = entryInfo.getSrcPropertyName();
        if (!StringUtils.isEmpty((String)propertyName) && propertyName.indexOf("_Src") >= 0) {
            propertyNameList.add(propertyName.substring(5));
        }
        if (!StringUtils.isEmpty((String)(expression = entryInfo.getExpression()))) {
            try {
                String iden = null;
                ArrayList idenList = new ArrayList();
                BotUtil.computeIdent((String)expression, idenList);
                int size = idenList.size();
                for (int i = 0; i < size; ++i) {
                    iden = (String)idenList.get(i);
                    if (StringUtils.isEmpty((String)iden) || iden.indexOf("_Src") < 0) continue;
                    propertyNameList.add(iden.substring(5));
                }
            }
            catch (KScriptException e) {
                logger.error((Object)("[BaseDataTransformer] BotUtil.computeIdent Error , expr : " + expression));
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return propertyNameList;
    }

    private SelectorItemCollection buildSet2Selector(Set<String> sicSet) {
        SelectorItemCollection sic = new SelectorItemCollection();
        Iterator<String> it = sicSet.iterator();
        while (it.hasNext()) {
            sic.add(it.next());
        }
        return sic;
    }

    protected void buildFitRulesMap(Set srcIdSet, ClassfiyRule classfiyRule) throws Exception {
        CoreBaseCollection coll = null;
        BDSyncRuleInfo rule = null;
        EntityViewInfo view = null;
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)BOSObjectType.create((String)this.getSrcBosType()));
        FilterInfo idFilter = new FilterInfo();
        idFilter.getFilterItems().add(new FilterItemInfo("id", (Object)srcIdSet, CompareType.INCLUDE));
        IObjectValue obj2 = null;
        BDSyncRuleCollection rules = null;
        String billId = null;
        BDSyncRuleCollection allFilterRules = classfiyRule.getAllFilterRules();
        HashMap<String, BDSyncRuleCollection> fitRulesMap = new HashMap<String, BDSyncRuleCollection>();
        int size = allFilterRules.size();
        for (int i = 0; i < size; ++i) {
            rule = allFilterRules.get(i);
            view = this.getEntityViewInfo(rule, idFilter);
            coll = iCoreBase.getCollection(view);
            for (IObjectValue obj2 : coll) {
                if (obj2.get("id") == null) continue;
                billId = obj2.get("id").toString();
                rules = (BDSyncRuleCollection)((Object)fitRulesMap.get(billId));
                if (rules == null) {
                    rules = new BDSyncRuleCollection();
                    fitRulesMap.put(billId, rules);
                }
                rules.add(rule);
            }
        }
        classfiyRule.setFitRulesMap(fitRulesMap);
    }

    private EntityViewInfo getEntityViewInfo(BDSyncRuleInfo rule, FilterInfo idFilter) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = rule.getFilterInfo();
        FilterInfo cuFilterInfo = new FilterInfo();
        cuFilterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)rule.getCU().getId().toString(), CompareType.EQUALS));
        filter.mergeFilter(cuFilterInfo, "AND");
        filter.mergeFilter(idFilter, "AND");
        FilterInfo newFilter = BaseDataTransformer.rebuildFilterInfo(filter);
        view.setFilter(newFilter);
        return view;
    }

    private static FilterInfo rebuildFilterInfo(FilterInfo filter) {
        String TODAY = "TODAY";
        String BEFORETODAY = "BEFORETODAY";
        String AFTERTODAY = "AFTERTODAY";
        String maskString = filter.getMaskString();
        FilterItemCollection filterItems = filter.getFilterItems();
        FilterInfo newFilterInfo = new FilterInfo();
        ArrayList<Integer> replaceItemsIndex = new ArrayList<Integer>();
        ArrayList<String> replaceItemsType = new ArrayList<String>();
        FilterItemInfo filterItemInfo = null;
        String condition = null;
        for (int i = 0; i < filterItems.size(); ++i) {
            String compareValue = null;
            filterItemInfo = filterItems.get(i);
            condition = filterItemInfo.getPropertyName();
            if (filterItemInfo.getCompareValue() != null) {
                compareValue = filterItemInfo.getCompareValue().toString();
            } else if (filterItemInfo.getCompareType() == CompareType.NOTEQUALS && filterItemInfo.getCompareValue() == null) {
                compareValue = null;
            }
            if (TODAY.equalsIgnoreCase(compareValue)) {
                newFilterInfo = QueryUtils.getTodayFilterInfo((FilterInfo)newFilterInfo, (String)condition);
                replaceItemsIndex.add(i);
                replaceItemsType.add(TODAY);
                continue;
            }
            if (BEFORETODAY.equalsIgnoreCase(compareValue)) {
                newFilterInfo = QueryUtils.getBeforetoDayFilterInfo((FilterInfo)newFilterInfo, (String)condition);
                replaceItemsIndex.add(i);
                replaceItemsType.add(BEFORETODAY);
                continue;
            }
            if (AFTERTODAY.equalsIgnoreCase(compareValue)) {
                newFilterInfo = QueryUtils.getAftertoDayFilterInfo((FilterInfo)newFilterInfo, (String)condition);
                replaceItemsIndex.add(i);
                replaceItemsType.add(AFTERTODAY);
                continue;
            }
            newFilterInfo.getFilterItems().add(filterItemInfo);
        }
        int index = 0;
        int changIndex = 0;
        Integer replaceIndex = null;
        String replaceType = null;
        if (replaceItemsIndex.size() > 0 && replaceItemsType.size() > 0) {
            while (maskString.contains("#" + index) && changIndex < replaceItemsIndex.size()) {
                replaceIndex = (Integer)replaceItemsIndex.get(changIndex);
                replaceType = (String)replaceItemsType.get(changIndex);
                if (index == replaceIndex) {
                    maskString = TODAY.equals(replaceType) ? maskString.replaceFirst("#" + index, "(#X AND #X)") : maskString.replace("#" + index, "#X");
                    ++changIndex;
                } else {
                    maskString = maskString.replace("#" + index, "#X");
                }
                ++index;
            }
            String[] maskStringArray = maskString.split("#");
            StringBuffer newMaskString = new StringBuffer(maskStringArray[0]);
            for (int i = 0; i < maskStringArray.length - 1; ++i) {
                newMaskString.append("#" + i + maskStringArray[i + 1].substring(1));
            }
            newFilterInfo.setMaskString(newMaskString.toString());
        } else {
            newFilterInfo.setMaskString(filter.getMaskString());
        }
        String entryName = filter.getEntryName();
        if (!StringUtils.isEmpty((String)entryName)) {
            newFilterInfo.setEntryName(entryName);
        }
        return newFilterInfo;
    }

    protected abstract IObjectValue defaultTransfor(IObjectValue var1) throws BOSException, EASBizException;

    protected IObjectValue segTransfor(IObjectValue srcObj, BDSyncRuleInfo rule) throws Exception {
        IObjectValue destObj = this.defaultTransfor(srcObj);
        BDSyncRuleSegmentInfo entryInfo = null;
        ArrayList<String> destExprFields = new ArrayList<String>();
        ArrayList<String> destExprStrFields = new ArrayList<String>();
        int size = rule.getRuleSegments().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = rule.getRuleSegments().get(i);
            if (StringUtils.isEmpty((String)entryInfo.getSrcExpr())) continue;
            this.calculateAndSetValue(srcObj, destObj, entryInfo);
            destExprFields.add(entryInfo.getDestPropertyName());
            if (!IMServerUtil.isStringProperty(this.getDestEntity(), entryInfo.getDestPropertyName())) continue;
            destExprStrFields.add(entryInfo.getDestPropertyName());
        }
        rule.setDestExprStrFields(destExprStrFields);
        rule.setDestExprFields(destExprFields);
        destObj.put("_SyncRule", (Object)rule);
        return destObj;
    }

    private void calculateAndSetValue(IObjectValue srcObj, IObjectValue destObj, BDSyncRuleSegmentInfo entryInfo) throws Exception {
        String destPropertyName = entryInfo.getDestPropertyName();
        Object value = this.calculateValue(srcObj, destObj, entryInfo);
        if (IMServerUtil.isLinkProperty(this.getDestEntity(), destPropertyName) && value instanceof String) {
            if (BOSUuid.isValid((String)value.toString(), (boolean)false)) {
                PropertyInfo property = this.getDestEntity().getPropertyByName(destPropertyName);
                LinkPropertyInfo pro = (LinkPropertyInfo)property;
                EntityObjectInfo entity = pro.getRelationship().getSupplierObject();
                BOSUuid id = BOSUuid.read((String)value.toString());
                IObjectValue objValue = (IObjectValue)IMServiceCache.getClass(entity.getObjectValueClass()).newInstance();
                objValue.put("id", (Object)id);
                value = objValue;
            } else {
                value = null;
            }
        }
        if (this.mutiLangProperty.contains(destPropertyName)) {
            destObj.put(destPropertyName, value);
            destObj.put(destPropertyName + "_" + this.ctx.getLocale().toString(), value);
        } else {
            destObj.put(destPropertyName, value);
        }
    }

    protected Object calculateValue(IObjectValue obj, IObjectValue destObj, BDSyncRuleSegmentInfo entryInfo) {
        HashMap<String, Object> localCtx = new HashMap<String, Object>();
        localCtx.put("__bosContext", this.ctx);
        localCtx.put("_Src", obj);
        localCtx.put("_Dest", destObj);
        String srcExpr = entryInfo.getSrcExpr();
        Object result = null;
        try {
            result = this.interpreter.eval(srcExpr, localCtx);
        }
        catch (Exception e) {
            String srcBillId = obj.get("id").toString();
            logger.error((Object)("[BaseDataTransformer] calculateValue Error , srcBillId : " + srcBillId + "\uff0csrcExpr \uff1a" + srcExpr));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected IObjectCollection getSyncDataColls(Set srcIdSet, SelectorItemCollection srcSelector) throws BOSException {
        ICoreBase bizInterface = (ICoreBase)BOSObjectFactory.createBOSObject((Context)this.ctx, (BOSObjectType)BOSObjectType.create((String)this.getSrcBosType()));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)srcIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getMergeSelector(srcSelector));
        return bizInterface.getCollection(view);
    }

    private SelectorItemCollection getMergeSelector(SelectorItemCollection selectors) {
        SelectorItemCollection sic = this.getSelector();
        IMUtils.mergeSelector(sic, this.getRuleSrcSelector());
        IMUtils.mergeSelector(sic, selectors);
        return sic;
    }

    protected SelectorItemCollection getRuleSrcSelector() {
        return null;
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    /*
     * Exception decompiling
     */
    protected String getSyncNumber(Context ctx, String number) throws BOSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract String getRelationField();

    public EntityObjectInfo getSrcEntity() {
        return IMServiceCache.getEntity(this.ctx, this.getSrcBosType());
    }

    public EntityObjectInfo getDestEntity() {
        return IMServiceCache.getEntity(this.ctx, this.getDestBosType());
    }

    public abstract String getSrcBosType();

    public abstract String getDestBosType();
}

