/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app.transformer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.ProductCodeSourceTypeEnum;
import com.kingdee.eas.tm.im.ProductCodeStatusEnum;
import com.kingdee.eas.tm.im.basedata.app.transformer.ProductCodeTransformer;
import com.kingdee.eas.tm.im.common.model.ClassfiyOverLengthField;
import org.apache.log4j.Logger;

public class ExpenseItem2ProductCodeTransformer
extends ProductCodeTransformer {
    private static final Logger logger = Logger.getLogger(ExpenseItem2ProductCodeTransformer.class);

    public ExpenseItem2ProductCodeTransformer(Context ctx) {
        super(ctx);
    }

    @Override
    protected IObjectValue defaultTransfor(IObjectValue object) throws BOSException, EASBizException {
        ExpenseTypeInfo info = (ExpenseTypeInfo)object;
        ProductCodeInfo product = new ProductCodeInfo();
        product.setId(BOSUuid.create((String)this.getDestBosType()));
        String number = info.getNumber();
        logger.debug((Object)("[ExpenseItem2ProductCodeTransformer] defaultTransfor number : " + number));
        product.setNumber(this.getSyncNumber(this.ctx, number));
        product.setName(info.getName());
        product.setExpenseItem(info);
        product.setStatus(ProductCodeStatusEnum.FORBIDDEN);
        product.setIsTax(true);
        product.setSourceType(ProductCodeSourceTypeEnum.SYNC);
        product.setCU(info.getCU());
        return product;
    }

    @Override
    protected ClassfiyOverLengthField getClassfiyOverLengthField() {
        return ClassfiyOverLengthField.custom().setOverLengthFields(new String[]{"number", "name"}).build();
    }

    @Override
    protected String getRelationField() {
        return "expenseItem";
    }

    @Override
    public String getSrcBosType() {
        return "78E4BC94";
    }

    @Override
    protected SelectorItemCollection getSelector() {
        return super.getSelector();
    }
}

