/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.app.AbstractPwyServiceFacadeControllerBean;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.model.ReqMsg;
import com.kingdee.eas.tm.im.common.comm.model.ResqMsg;
import com.kingdee.eas.tm.im.common.comm.msg.HttpSender;
import com.kingdee.eas.tm.im.common.comm.msg.PwyDebugHelper;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.LogService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PwyServiceFacadeControllerBean
extends AbstractPwyServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.app.PwyServiceFacadeControllerBean");

    @Override
    protected PwyInvokeParam _invoke(Context ctx, PwyActionParam actionParam) throws BOSException, EASBizException {
        Map params = actionParam.getParams();
        Boolean isInvokeWriteLog = true;
        if (params != null && params.containsKey("isInvokeWriteLog")) {
            isInvokeWriteLog = (Boolean)params.get("isInvokeWriteLog");
        }
        PwyInvokeParam invokeParam = new PwyInvokeParam(actionParam);
        IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, invokeParam);
        pwyService.buildPwyParam(isInvokeWriteLog);
        return pwyService.getInvokeParam();
    }

    @Override
    protected List _buildPwyParam(Context ctx, List list) throws BOSException, EASBizException {
        ArrayList<PwyInvokeParam> resultList = new ArrayList<PwyInvokeParam>();
        PwyActionParam actionParam = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            boolean isNotNeedDisk;
            actionParam = (PwyActionParam)list.get(i);
            PwySettingInfo pwyInfo = (PwySettingInfo)BizInterfaceFactory.getPwySetting(ctx).getPwySetting(actionParam.getOrgId(), OPTypeEnum.RecInvoice, null, null);
            boolean bl = isNotNeedDisk = (PwyServiceType.OPR_POOL_DISK_DOWNLOAD_SINGLE == actionParam.getMsgType() || PwyServiceType.OPR_POOL_DISK_DOWNLOAD == actionParam.getMsgType()) && pwyInfo != null && pwyInfo.isFpdkType();
            if (isNotNeedDisk) continue;
            resultList.add(this._invoke(ctx, actionParam));
        }
        return resultList;
    }

    @Override
    protected PwyInvokeParam _invokeBegin(Context ctx, PwyInvokeParam params) throws BOSException, EASBizException {
        TaxTransLogInfo pwyLog;
        if (params.isNeedWriterLog() && (pwyLog = params.getPwyLog()) != null) {
            pwyLog.setIsSended(true);
            new LogService().updatePwyLog(ctx, pwyLog);
        }
        return params;
    }

    @Override
    protected PwyInvokeParam _invokeAfter(Context ctx, PwyInvokeParam params) throws BOSException, EASBizException {
        IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, params);
        pwyService.invokeAfter();
        return pwyService.getInvokeParam();
    }

    @Override
    protected PwyInvokeParam _reInvoke(Context ctx, PwyInvokeParam params) throws BOSException, EASBizException {
        IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, params);
        pwyService.reBuildPwyParam();
        return pwyService.getInvokeParam();
    }

    @Override
    protected String _getRespJson(Context ctx, String msgType) throws BOSException, EASBizException {
        return PwyDebugHelper.getPwyRespJson(msgType);
    }

    @Override
    public PwyInvokeParam _sendMsg(Context ctx, PwyInvokeParam invokeParam) throws BOSException, EASBizException {
        String dataStr = invokeParam.getSendMsg();
        if (invokeParam.isNeedEncrypt()) {
            if (invokeParam.getSetting() == null) {
                throw new BOSException("PwySetting is NULL !");
            }
            dataStr = BizInterfaceFactory.getIMInvoiceFacade(ctx).encryptAES(invokeParam.getSendMsg(), invokeParam.getSetting().getSecretKey());
        }
        invokeParam.setRequestMsg(dataStr);
        HttpSender sender = new HttpSender();
        ResqMsg resqMsg = null;
        try {
            invokeParam.setSendTime(IMUtils.getCurrentTime());
            resqMsg = sender.send(ctx, new ReqMsg(invokeParam));
            invokeParam.setRevTime(IMUtils.getCurrentTime());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        invokeParam.setRevMsg(resqMsg.getRevMsg());
        return invokeParam;
    }
}

