/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.app.util.IMServerUtil;
import com.kingdee.eas.tm.im.common.comm.IMCommException;
import com.kingdee.eas.tm.im.common.comm.RemoteServiceFactory;
import com.kingdee.eas.tm.im.common.comm.RemoteServiceInfo;
import com.kingdee.eas.tm.im.common.comm.ServiceException;
import com.kingdee.eas.tm.im.common.comm.ServiceStateEnum;
import com.kingdee.eas.tm.im.common.comm.app.AbstractRemoteServiceControllerBean;
import com.kingdee.eas.tm.im.common.comm.app.service.IRemoteServicePlugin;
import com.kingdee.eas.tm.im.common.comm.app.service.RemoteServicePluginUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class RemoteServiceControllerBean
extends AbstractRemoteServiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.app.RemoteServiceControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBeforeSubmit(ctx, model);
        return super._submit(ctx, model);
    }

    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String[] emptyFields = new String[]{"number", "name", "serviceURL", "tokenUrl", "loginUrl", "appId", "appSecuret", "accountId", "user"};
        IMServerUtil.checkEmptyFields(ctx, model, emptyFields, null);
        String[] lengthFields = new String[]{"number", "name", "serviceURL", "tokenUrl", "loginUrl", "appId", "appSecuret", "accountId", "user", "language", "publicKey", "FServicePlugin"};
        IMServerUtil.checkLengthFields(ctx, model, lengthFields);
        super._checkNumberDup(ctx, model);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return null;
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("localService.*"));
        RemoteServiceInfo info = RemoteServiceFactory.getLocalInstance(ctx).getRemoteServiceInfo(pk, sic);
        if (ServiceStateEnum.INITED.equals((Object)info.getState())) {
            throw new ServiceException(ServiceException.EPX_REMOTESERVICE_INITED);
        }
        if (!StringUtils.isEmpty((String)info.getServicePlugin())) {
            IRemoteServicePlugin servicePlugin = RemoteServicePluginUtil.getRemoteServicePlugin(info.getServicePlugin());
            servicePlugin.execute(ctx, info);
        }
        info.setState(ServiceStateEnum.INITED);
        this._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        RemoteServiceInfo info = RemoteServiceFactory.getLocalInstance(ctx).getRemoteServiceInfo(pk);
        if (ServiceStateEnum.UNINIT.equals((Object)info.getState())) {
            throw new ServiceException(ServiceException.EPX_REMOTESERVICE_UNINIT);
        }
        info.setState(ServiceStateEnum.UNINIT);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RemoteServiceInfo info = RemoteServiceFactory.getLocalInstance(ctx).getRemoteServiceInfo(pk);
        this.beforeDelete(ctx, info);
        super._delete(ctx, pk);
    }

    private void beforeDelete(Context ctx, RemoteServiceInfo info) throws BOSException, EASBizException {
        if (info.isIsScheduled()) {
            throw new IMCommException(IMCommException.PRESET_NOT_DELETE);
        }
        if (ServiceStateEnum.INITED.equals((Object)info.getState())) {
            throw new ServiceException(ServiceException.EPX_REMOTESERVICE_INITED_NOTDELET);
        }
    }
}

