/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.log.common.Resource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.CommunicationSetFactory;
import com.kingdee.eas.tm.im.common.comm.CommunicationSetInfo;
import com.kingdee.eas.tm.im.common.comm.app.AbstractTaxTransLogFacadeControllerBean;
import com.kingdee.eas.tm.im.common.comm.log.LogHelper;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class TaxTransLogFacadeControllerBean
extends AbstractTaxTransLogFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.app.TaxTransLogFacadeControllerBean");

    @Override
    protected void _setDumpPolicy(Context ctx, int days) throws BOSException, EASBizException {
        CommunicationSetInfo info = PwyServiceHelper.getCommSetting(ctx);
        info.setDumpUpLimit(days);
        ObjectUuidPK pk = new ObjectUuidPK(info.getId().toString());
        CommunicationSetFactory.getLocalInstance(ctx).update((IObjectPK)pk, info);
    }

    @Override
    protected int _getDumpPolicy(Context ctx) throws BOSException, EASBizException {
        CommunicationSetInfo info = PwyServiceHelper.getCommSetting(ctx);
        return info.getDumpUpLimit();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _dump(Context ctx, int days) throws BOSException, EASBizException {
        Connection cn = null;
        Date currentDate = new Date(System.currentTimeMillis());
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(currentDate);
        cal.set(5, cal.get(5) - days + 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date dumpDate = cal.getTime();
        SimpleDateFormat formater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (!LogHelper.requestMutex(ctx)) {
                throw new BOSException(Resource.IS_STORING_NOW + Resource.PLEASE_TRY_LATER);
            }
            cn = this.getConnection(ctx);
            String strIns = "INSERT INTO T_TM_TaxTransLogHis SELECT * FROM T_TM_TaxTransLog WHERE FCreateTime < {ts'" + formater.format(dumpDate) + "'}";
            String strDel = "DELETE FROM T_TM_TaxTransLog WHERE FCreateTime < {ts'" + formater.format(dumpDate) + "'}";
            SQLUtils.execute((Connection)cn, (String)strIns);
            SQLUtils.execute((Connection)cn, (String)strDel);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                LogHelper.releaseMutex(ctx);
                SQLUtils.cleanup(cn);
                throw throwable;
            }
        }
        LogHelper.releaseMutex(ctx);
        SQLUtils.cleanup((Connection)cn);
    }

    @Override
    protected void _dump(Context ctx) throws BOSException, EASBizException {
        int days = this._getDumpPolicy(ctx);
        this._dump(ctx, days);
    }
}

