/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.tm.im.common.comm.app.service.IRemoteServicePlugin;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RemoteServicePluginUtil {
    private static Logger logger = Logger.getLogger(RemoteServicePluginUtil.class);
    private static Map<String, IRemoteServicePlugin> pluginCache = new HashMap<String, IRemoteServicePlugin>();

    public static IRemoteServicePlugin getRemoteServicePlugin(String serviceName) throws BOSException {
        IRemoteServicePlugin servicePlugin = pluginCache.get(serviceName);
        if (servicePlugin == null) {
            try {
                servicePlugin = (IRemoteServicePlugin)Class.forName(serviceName).newInstance();
                pluginCache.put(serviceName, servicePlugin);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return servicePlugin;
    }
}

