/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg.parser;

import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckTypeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckWayEnum;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.utils.TMJsonParser;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.common.comm.service.util.IncomeInvoicePwyHelper;
import com.kingdee.eas.tm.im.common.logger.IMLoggerFactory;
import com.kingdee.eas.tm.im.common.logger.IMTraceLogger;
import com.kingdee.eas.tm.im.util.CheckAbsUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

public class IncomeInvoiceDiskParser {
    private static IMTraceLogger logger = IMLoggerFactory.getTraceLogger("IncomeInvoiceDiskParser");
    private static final String BOSTYPE_INCOMEINVOICE = "1343913D";
    private Context ctx;
    private TMJsonParser parser;

    public IncomeInvoiceDiskParser(Context ctx) {
        this.ctx = ctx;
    }

    public IncomeInvoiceDiskParser(Context ctx, JSONObject jsonObject) {
        this.ctx = ctx;
        this.parser = new TMJsonParser(jsonObject);
    }

    public void reloadJson(JSONObject jsonObject) {
        this.parser = new TMJsonParser(jsonObject);
    }

    public String getMutex() {
        String invoiceCode = this.parser.getString("invoiceCode");
        String invoiceNo = this.parser.getString("invoiceNo");
        return invoiceCode + "_" + invoiceNo;
    }

    public IncomeInvoiceInfo getIncomeInvoiceInfo() {
        String invoiceType = this.parser.getString("invoiceType");
        if (!"4".equals(invoiceType) && !"2".equals(invoiceType)) {
            return null;
        }
        String invoiceCode = this.parser.getString("invoiceCode");
        String invoiceNo = this.parser.getString("invoiceNo");
        Date invoiceDate = this.parser.getDate("invoiceDate");
        String salerName = this.parser.getString("salerName");
        BigDecimal invoiceAmount = this.parser.getBigDecimal("invoiceAmount");
        BigDecimal taxAmount = this.parser.getBigDecimal("totalTaxAmount");
        BigDecimal effectiveTaxAmount = this.parser.getBigDecimal("effectiveTaxAmount");
        String invoiceStatus = this.parser.getString("invoiceStatus");
        String checkFlag = this.parser.getString("checkFlag");
        String deductionPurpose = this.parser.getString("deductionPurpose");
        Timestamp selectTime = this.parser.getTimestamp("selectTime");
        Boolean checkAuthenticateFlag = this.parser.getBoolean("checkAuthenticateFlag");
        Timestamp selectAuthenticateTime = this.parser.getTimestamp("selectAuthenticateTime");
        Boolean scanAuthenticateFlag = this.parser.getBoolean("scanAuthenticateFlag");
        Timestamp scanAuthenticateTime = this.parser.getTimestamp("scanAuthenticateTime");
        String salerTaxNo = this.parser.getString("salerTaxNo");
        String taxPeriod = this.parser.getString("taxPeriod");
        IncomeInvoiceInfo invoiceInfo = IncomeInvoicePwyHelper.getInfoWithNumber(this.ctx, invoiceCode, invoiceNo);
        invoiceInfo.setInvoiceCode(invoiceCode);
        invoiceInfo.setInvoiceNumber(invoiceNo);
        invoiceInfo.setNumber(invoiceInfo.getInvoiceCode() + "_" + invoiceInfo.getInvoiceNumber());
        invoiceInfo.setBizDate(invoiceDate);
        invoiceInfo.setBillingCompany(salerName);
        if (salerTaxNo != null && !salerTaxNo.trim().isEmpty()) {
            invoiceInfo.setTaxNumber(salerTaxNo);
        }
        invoiceInfo.setBillingCompany(this.parser.getString("salerName"));
        invoiceInfo.setBuyerName(this.parser.getString("buyerName"));
        invoiceInfo.setBuyerTaxNo(this.parser.getString("buyerTaxNo"));
        invoiceInfo.setAmount(invoiceAmount);
        invoiceInfo.setTax(taxAmount);
        invoiceInfo.setAmountTax(invoiceInfo.getAmount().add(invoiceInfo.getTax()));
        IncomeStatusEnum incomeStatusEnum = this.getIncomeStatusEnum(invoiceStatus);
        if (incomeStatusEnum == null) {
            logger.debug("Ignore! incomeStatusEnum is null ");
            return null;
        }
        if (invoiceInfo.getStatus() != null && !incomeStatusEnum.equals((Object)invoiceInfo.getStatus())) {
            invoiceInfo.put("statusChaged", true);
            invoiceInfo.put("oldStatus", invoiceInfo.getStatus().getAlias());
            invoiceInfo.put("CurStatus", incomeStatusEnum.getAlias());
        }
        invoiceInfo.setStatus(incomeStatusEnum);
        if ("4".equals(invoiceType)) {
            invoiceInfo.setInvoiceType(PayInvoiceTypeEnum.VALUEADDEDTAXINV);
            invoiceInfo.setTmInvoiceType(TMInvoiceType.INVOICETYPE_SPECIAL_PAPER);
        } else if ("2".equals(invoiceType)) {
            invoiceInfo.setInvoiceType(PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE);
            invoiceInfo.setTmInvoiceType(TMInvoiceType.INVOICETYPE_ELECTRONIC_SPECIAL);
        }
        CheckAbsInfo checkAbs = invoiceInfo.getCheckAbs();
        if (checkAbs == null) {
            checkAbs = CheckAbsUtil.createCheckAbs(invoiceInfo);
            invoiceInfo.setCheckAbs(checkAbs);
        }
        if (effectiveTaxAmount != null) {
            checkAbs.setEffectiveTaxAmt(effectiveTaxAmount);
        } else {
            checkAbs.setEffectiveTaxAmt(invoiceInfo.getTax());
        }
        checkAbs.setSalerName(salerName);
        checkAbs.setSalerTaxNo(salerTaxNo);
        CheckStateEnum checkState = this.getCheckStateEnum(checkFlag);
        checkAbs.setCheckState(checkState);
        if (CheckStateEnum.Checked.equals((Object)checkState)) {
            checkAbs.setCheckTime((Date)selectTime);
            checkAbs.setCheckPurpose(CheckAbsUtil.getPurposeByValue(deductionPurpose));
            if (scanAuthenticateFlag.booleanValue()) {
                checkAbs.setCheckWay(CheckWayEnum.Scan);
                checkAbs.setConfirmTime((Date)scanAuthenticateTime);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else if (checkAuthenticateFlag.booleanValue()) {
                checkAbs.setCheckWay(CheckWayEnum.Check);
                checkAbs.setConfirmTime((Date)selectAuthenticateTime);
                checkAbs.setConfirmState(ConfirmStateEnum.Confirmed);
            } else {
                checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            }
            if (checkAbs.getCheckType() == null) {
                checkAbs.setCheckType(CheckTypeEnum.OFFLINE);
            }
            if (invoiceInfo.getCompany() == null) {
                checkAbs.put("taxPeriodStr", (Object)taxPeriod);
            } else {
                checkAbs.setTaxPeriod(CheckAbsUtil.getPeriodInfo(this.ctx, taxPeriod, invoiceInfo.getCompany()));
            }
        } else {
            checkAbs.setCheckTime(null);
            checkAbs.setCheckWay(null);
            checkAbs.setCheckPurpose(null);
            checkAbs.setCheckUser(null);
            checkAbs.setTaxPeriod(null);
            checkAbs.setConfirmTime(null);
            checkAbs.setConfirmState(ConfirmStateEnum.UnConfirm);
            checkAbs.setConfirmUser(null);
            checkAbs.setCheckType(null);
        }
        return invoiceInfo;
    }

    public IncomeStatusEnum getIncomeStatusEnum(String value) {
        if ("0".equals(value)) {
            return IncomeStatusEnum.NORMAL;
        }
        if ("1".equals(value)) {
            return IncomeStatusEnum.LOSECONTROL;
        }
        if ("2".equals(value)) {
            return IncomeStatusEnum.CANCEL;
        }
        if ("3".equals(value)) {
            return IncomeStatusEnum.CREDIT;
        }
        if ("4".equals(value)) {
            return IncomeStatusEnum.UNUSUAL;
        }
        if ("5".equals(value)) {
            return IncomeStatusEnum.UNNORMAL;
        }
        if ("6".equals(value)) {
            return IncomeStatusEnum.UNCONFIRMRED;
        }
        if ("7".equals(value)) {
            return IncomeStatusEnum.PARTLYRED;
        }
        if ("8".equals(value)) {
            return IncomeStatusEnum.FULLRED;
        }
        return null;
    }

    protected CheckStateEnum getCheckStateEnum(String value) {
        if ("0".equals(value)) {
            return CheckStateEnum.Unchecked;
        }
        if ("1".equals(value)) {
            return CheckStateEnum.Checked;
        }
        return CheckStateEnum.Checked;
    }
}

