/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg.result;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.common.comm.msg.result.DownloadResult;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class PoolDownloadResult
extends DownloadResult {
    public static final String BILL_COUNT = "billCount";
    public static final String BILLENTRY_COUNT = "billEntryCount";
    private Map<String, Map<String, Map<String, BigDecimal>>> invoiceTypeBillMap = new HashMap<String, Map<String, Map<String, BigDecimal>>>();
    private Map<String, Map<String, BigDecimal>> invoiceTypeTotalMap = new HashMap<String, Map<String, BigDecimal>>();

    @Override
    public void add(IObjectValue objectValue) {
        TMInvoiceType invoiceType = this.getTMInvoiceType(objectValue);
        if (!this.invoiceTypeBillMap.containsKey(invoiceType.getValue())) {
            this.invoiceTypeBillMap.put(invoiceType.getValue(), new HashMap());
        }
        Map<String, Map<String, BigDecimal>> billMap = this.invoiceTypeBillMap.get(invoiceType.getValue());
        String[] fields = this.getTotalFields(invoiceType.getValue());
        String entryName = this.getEntryName(invoiceType.getValue());
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            String id = objectValue.get("id").toString();
            BigDecimal value = objectValue.getBigDecimal(field);
            if (!billMap.containsKey(id)) {
                billMap.put(id, new HashMap());
            }
            Map<String, BigDecimal> invoiceMap = billMap.get(id);
            invoiceMap.put(field, this.isNull2Zero(value));
            if (!StringUtils.isEmpty((String)entryName)) {
                BigDecimal billEntryCount = new BigDecimal(((IObjectCollection)objectValue.get(entryName)).size());
                invoiceMap.put(BILLENTRY_COUNT, billEntryCount);
                continue;
            }
            invoiceMap.put(BILLENTRY_COUNT, BigDecimal.ZERO);
        }
    }

    @Override
    public void merge(DownloadResult ret) {
        PoolDownloadResult result = (PoolDownloadResult)ret;
        for (Map.Entry<String, Map<String, Map<String, BigDecimal>>> entry : result.getInvoiceTypeBillMap().entrySet()) {
            String key = entry.getKey();
            Map<String, Map<String, BigDecimal>> value = entry.getValue();
            if (this.invoiceTypeBillMap.containsKey(key)) {
                this.invoiceTypeBillMap.get(key).putAll(value);
                continue;
            }
            this.invoiceTypeBillMap.put(key, value);
        }
    }

    @Override
    public void calculate() {
        this.invoiceTypeTotalMap = new HashMap<String, Map<String, BigDecimal>>();
        for (String invoiceType : this.invoiceTypeBillMap.keySet()) {
            String[] fields = this.getTotalFields(invoiceType);
            Map<String, Map<String, BigDecimal>> billMap = this.invoiceTypeBillMap.get(invoiceType);
            if (!this.invoiceTypeTotalMap.containsKey(invoiceType)) {
                this.invoiceTypeTotalMap.put(invoiceType, new HashMap());
            }
            Map<String, BigDecimal> totalMap = this.invoiceTypeTotalMap.get(invoiceType);
            totalMap.put(BILL_COUNT, new BigDecimal(billMap.keySet().size()));
            for (Map<String, BigDecimal> bill : billMap.values()) {
                for (int i = 0; i < fields.length; ++i) {
                    totalMap.put(fields[i], this.isNull2Zero(totalMap.get(fields[i])).add(bill.get(fields[i])));
                }
                totalMap.put(BILLENTRY_COUNT, this.isNull2Zero(totalMap.get(BILLENTRY_COUNT)).add(bill.get(BILLENTRY_COUNT)));
            }
        }
    }

    public BigDecimal isNull2Zero(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    public TMInvoiceType getTMInvoiceType(IObjectValue objectValue) {
        TMInvoiceType invoiceType = null;
        if (objectValue instanceof IncomeInvoiceInfo) {
            invoiceType = TMInvoiceType.getEnum((String)objectValue.getString("tmInvoiceType"));
        } else if (objectValue instanceof InvoiceBaseInfo) {
            invoiceType = TMInvoiceType.getEnum((String)objectValue.getString("invoiceType"));
        }
        return invoiceType;
    }

    protected String getEntryName(String invoiceType) {
        String entryName = null;
        if ("1".equals(invoiceType) || "2".equals(invoiceType) || "3".equals(invoiceType) || "4".equals(invoiceType) || "5".equals(invoiceType)) {
            entryName = "entries";
        } else if ("10".equals(invoiceType) || "15".equals(invoiceType) || "26".equals(invoiceType) || "27".equals(invoiceType)) {
            entryName = "entry";
        }
        return entryName;
    }

    public String[] getTotalFields(String invoiceType) {
        String[] totalFields = null;
        totalFields = "1".equals(invoiceType) || "2".equals(invoiceType) || "3".equals(invoiceType) || "4".equals(invoiceType) || "5".equals(invoiceType) ? new String[]{"amount", "tax", "amountTax"} : ("10".equals(invoiceType) ? new String[]{"invoiceAmount", "totalTaxAmount", "totalAmount"} : ("12".equals(invoiceType) ? new String[]{"invoiceMoney", "totalTaxAmount", "totalAmount"} : ("15".equals(invoiceType) ? new String[]{"invoiceAmount", "totalTaxAmount", "totalAmount"} : ("26".equals(invoiceType) || "27".equals(invoiceType) ? new String[]{"invoiceAmount", "totalTaxAmount"} : new String[]{"totalAmount"}))));
        return totalFields;
    }

    public Map<String, Map<String, Map<String, BigDecimal>>> getInvoiceTypeBillMap() {
        return this.invoiceTypeBillMap;
    }

    public void setInvoiceTypeBillMap(Map<String, Map<String, Map<String, BigDecimal>>> invoiceTypeBillMap) {
        this.invoiceTypeBillMap = invoiceTypeBillMap;
    }

    public Map<String, Map<String, BigDecimal>> getInvoiceTypeTotalMap() {
        return this.invoiceTypeTotalMap;
    }

    public void setInvoiceTypeTotalMap(Map<String, Map<String, BigDecimal>> invoiceTypeTotalMap) {
        this.invoiceTypeTotalMap = invoiceTypeTotalMap;
    }
}

