/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.Kson;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.PwyHelper;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.common.comm.LogStatusEnum;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.TransDestSystemEnum;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.model.ReqMsg;
import com.kingdee.eas.tm.im.common.comm.model.ResqMsg;
import com.kingdee.eas.tm.im.common.comm.msg.HttpSender;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.LogService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractPwyService
implements IPwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.service.AbstractPwyService");
    private Context ctx;
    private PwyInvokeParam invokeParam = null;
    private LogService logService = null;
    private IPwyService tokenService = null;
    private PwyHelper pwyHelper = null;
    private int retryTimes = 0;
    private boolean isLogRetry = false;

    public AbstractPwyService(Context ctx, PwyInvokeParam invokeParam) {
        this.ctx = ctx;
        this.invokeParam = invokeParam;
        this.pwyHelper = new PwyHelper();
        this.logService = new LogService();
    }

    public AbstractPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        this.ctx = ctx;
        this.initInvokeParam(pwyLog);
        this.pwyHelper = new PwyHelper();
        this.logService = new LogService();
        this.isLogRetry = true;
    }

    private void initInvokeParam(TaxTransLogInfo pwyLog) {
        try {
            String companyId = pwyLog.getCompany() != null ? pwyLog.getCompany().getId().toString() : null;
            PwyInvokeParam invokeParam = new PwyInvokeParam(pwyLog.getLogType(), pwyLog.getSrcSystem(), companyId, pwyLog.getInvoices(), null);
            invokeParam.setPwyLog(pwyLog);
            invokeParam.setUrl(pwyLog.getUrl());
            invokeParam.setSendMsg(pwyLog.getSendMsg());
            invokeParam.setRequestMsg(this.isNeedEncrypt() ? this.encryptData(pwyLog.getSendMsg()) : pwyLog.getSendMsg());
            invokeParam.setRevMsg(pwyLog.getRevMsg());
            this.invokeParam = invokeParam;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.invokeParam.setSuccess(false);
            this.invokeParam.setPartSuccess(false);
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    public void buildPwyParam(boolean isWriteLog) throws BOSException, EASBizException {
        if (this.invokeParam.getCommSettingInfo() == null) {
            this.invokeParam.setCommSettingInfo(PwyServiceHelper.getCommSetting(this.ctx));
        }
        if (!this.invokeParam.isInit()) {
            this.invokeParam.setValues(this.getValues());
            this.invokeParam.setSetting(this.getPwySetting());
        }
        if (this.invokeParam.getMsgSettingInfo() == null) {
            String msgType = this.invokeParam.getMsgType();
            if (!StringUtils.isEmpty((String)this.getPwyCzlx())) {
                msgType = this.getPwyCzlx();
            }
            this.invokeParam.setMsgSettingInfo(PwyServiceHelper.getMsgSetting(this.ctx, msgType));
        }
        this.invokeParam.setNeedEncrypt(this.isNeedEncrypt());
        this.invokeParam.setSendMode(this.getSendMode());
        if (this.invokeParam.getSetting() != null) {
            this.invokeParam.setOrgUnit(this.invokeParam.getSetting().getCompany());
            this.invokeParam.setUrl(this.getPwyURL());
        }
        if (this.invokeParam.getSendMsg() == null) {
            Map data = this.getPwyData();
            String sendMsg = Kson.getGson().toJson((Object)data);
            this.invokeParam.setSendMsg(sendMsg);
            this.invokeParam.setRequestMsg(this.isNeedEncrypt() ? this.encryptData(this.invokeParam.getSendMsg()) : this.invokeParam.getSendMsg());
        }
        this.invokeParam.setRetryTimes(this.getRetryTimes());
        TaxTransLogInfo pwyLog = null;
        pwyLog = this.createPwyLog();
        this.invokeParam.setPwyLog(pwyLog);
        this.invokeParam.setInit(true);
        if (this.isNeedToken()) {
            PwyInvokeParam invokeParam = new PwyInvokeParam();
            invokeParam.setMsgType(this.getTokenMsgType().getValue());
            invokeParam.setOwnerSystem(this.invokeParam.getOwnerSystem());
            invokeParam.setOrgId(this.invokeParam.getOrgId());
            invokeParam.setSetting(this.invokeParam.getSetting());
            invokeParam.setClientId(this.invokeParam.getClientId());
            invokeParam.setClientSecret(this.invokeParam.getClientSecret());
            invokeParam.setInit(true);
            this.tokenService = PwyServiceHelper.getPwyService(this.ctx, invokeParam);
            this.tokenService.buildPwyParam(false);
            this.invokeParam.getBeforeInvokeParam().put(invokeParam.getMsgType(), invokeParam);
        }
        if (isWriteLog) {
            this.updatePwyLog();
        }
    }

    @Override
    public void buildPwyParam() throws BOSException, EASBizException {
        this.buildPwyParam(true);
    }

    @Override
    public void reBuildPwyParam() throws BOSException, EASBizException {
        if (this.getPwyData() instanceof Map && this.getPwyData().get("pageNo") != null && !IMUtils.isEmpty(this.getPwyData().get("pageNo").toString())) {
            this.getPwyData().put("pageNo", (int)Float.parseFloat(this.getPwyData().get("pageNo").toString()));
        }
        if (this.getPwyData() instanceof Map && this.getPwyData().get("pageSize") != null && !IMUtils.isEmpty(this.getPwyData().get("pageSize").toString())) {
            this.getPwyData().put("pageSize", (int)Float.parseFloat(this.getPwyData().get("pageSize").toString()));
        }
        String sendMsg = Kson.getGson().toJson((Object)this.getPwyData());
        this.invokeParam.setUrl(this.getPwyURL());
        this.invokeParam.setSendMsg(sendMsg);
        this.invokeParam.setRequestMsg(this.isNeedEncrypt() ? this.encryptData(this.invokeParam.getSendMsg()) : this.invokeParam.getSendMsg());
        this.invokeParam.getPwyLog().setUrl(this.invokeParam.getUrl());
        this.invokeParam.getPwyLog().setSendMsg(this.invokeParam.getSendMsg());
        this.updatePwyLog();
    }

    public abstract List getValues() throws EASBizException, BOSException;

    public String getPwyURL() throws EASBizException, BOSException {
        String url = this.getBaseURL() + this.getInterfacePath();
        return url;
    }

    protected abstract Map getPwyData() throws EASBizException, BOSException;

    protected TaxTransLogInfo createPwyLog() throws EASBizException, BOSException {
        TaxTransLogInfo pwyLog = this.invokeParam.getPwyLog();
        if (pwyLog == null) {
            pwyLog = BizInterfaceFactory.getTaxTransLog(this.ctx).createNewData();
            pwyLog.setCompany(this.invokeParam.getOrgUnit());
            pwyLog.setUrl(this.invokeParam.getUrl());
            pwyLog.setSendMsg(this.invokeParam.getSendMsg());
            pwyLog.setLogType(PwyServiceType.getEnum(this.invokeParam.getMsgType()));
            pwyLog.setSrcSystem(TransSrcSystemEnum.getEnum(this.invokeParam.getOwnerSystem()));
            pwyLog.setDestSystem(TransDestSystemEnum.pwy);
            pwyLog.setInvoices(this.invokeParam.getInvoices());
        }
        return pwyLog;
    }

    protected int getSendMode() {
        if (this.invokeParam.getSetting() != null && (this.invokeParam.getSetting().isFpdkType() || this.invokeParam.isWssUrl())) {
            return 2;
        }
        if (this.invokeParam.getMsgSettingInfo() != null && this.invokeParam.getMsgSettingInfo().getSendMode() != null) {
            return this.invokeParam.getMsgSettingInfo().getSendMode().getValue();
        }
        return 1;
    }

    protected int getRequestMode() {
        if (this.invokeParam.getMsgSettingInfo() != null && this.invokeParam.getMsgSettingInfo().getRequestMode() != null) {
            return this.invokeParam.getMsgSettingInfo().getRequestMode().getValue();
        }
        return 1;
    }

    protected LogService getLogService() {
        return this.logService;
    }

    public abstract String getBaseURL() throws EASBizException, BOSException;

    public String getInterfacePath() {
        if (this.invokeParam.getMsgSettingInfo() != null) {
            return this.invokeParam.getMsgSettingInfo().getInterfacePath() == null ? "" : this.invokeParam.getMsgSettingInfo().getInterfacePath();
        }
        return this.getDefaultInterfacePath();
    }

    public String getDefaultInterfacePath() {
        return "";
    }

    protected abstract PwySettingInfo getPwySetting() throws EASBizException, BOSException;

    @Override
    public void updatePwyLog() throws EASBizException, BOSException {
        if (this.isNeedWriterLog()) {
            this.getLogService().updatePwyLog(this.ctx, this.invokeParam.getPwyLog());
        }
    }

    protected boolean isNeedWriterLog() {
        return this.invokeParam.isNeedWriterLog();
    }

    @Override
    public void invoke() {
        try {
            this.buildPwyParam();
            this.invokePwy();
            this.invokeAction();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.invokeParam.setSuccess(false);
            this.invokeParam.setPartSuccess(false);
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    public void doInvoke() {
        try {
            this.invokePwy();
            this.invokeAction();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.invokeParam.setSuccess(false);
            this.invokeParam.setPartSuccess(false);
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    public void invokePwy() throws EASBizException, BOSException {
        this.retryTimes = this.getRetryTimes();
        do {
            ResqMsg msg = this.sendReq();
            this.resolveResp(msg);
            this.updatePwyLog();
            if ("3".equals(this.invokeParam.getPwyLog().getLogStatus().getValue())) {
                --this.retryTimes;
                continue;
            }
            this.retryTimes = 0;
        } while (this.isNeedRetry());
    }

    @Override
    public void invokeAction() throws EASBizException, BOSException {
        if ("2".equals(this.invokeParam.getPwyLog().getLogStatus().getValue())) {
            this.handleSuccess();
            this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FINISH);
            this.updatePwyLog();
        }
    }

    @Override
    public void invokeAfter() {
        try {
            ResqMsg msg = new ResqMsg();
            HashMap<String, String> resp = new HashMap<String, String>();
            resp.put("result", this.invokeParam.getRevMsg());
            msg.setResp(resp);
            if (resp.get("errcode") != null) {
                msg.setRevMsg(Kson.getGson().toJson(resp));
                msg.setErrcode((String)resp.get("errcode"));
                msg.setDescription((String)resp.get("description"));
            } else {
                msg.setRevMsg((String)resp.get("result"));
                JSONObject retJson = new JSONObject(msg.getRevMsg());
                if (retJson.has("errcode")) {
                    msg.setErrcode(retJson.getString("errcode"));
                }
                if (retJson.has("description")) {
                    msg.setDescription(retJson.getString("description"));
                }
            }
            this.resolveResp(msg);
            this.updatePwyLog();
            this.invokeAction();
        }
        catch (Exception e2) {
            IMException e2;
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            if (e2 instanceof JSONException) {
                e2 = new IMException(IMException.CON_TIME_OUT);
            }
            this.invokeParam.setSuccess(false);
            this.invokeParam.setPartSuccess(false);
            this.setReturn(this.getUnKownCode(), ((Throwable)((Object)e2)).getMessage());
        }
    }

    @Override
    public boolean isSuccess() {
        return this.getSuccessCode().equals(this.invokeParam.getErrcode());
    }

    public boolean isPartSuccess() {
        return this.getPartSuccessCode() != null && this.getPartSuccessCode().equals(this.invokeParam.getErrcode());
    }

    protected abstract void handleSuccess() throws EASBizException, BOSException;

    protected int getRetryTimes() {
        if (this.invokeParam.getMsgSettingInfo() != null) {
            return this.invokeParam.getMsgSettingInfo().getSendCount();
        }
        return this.getDefaultRetryTimes();
    }

    protected int getDefaultRetryTimes() {
        return 0;
    }

    protected boolean isNeedRetry() {
        return this.retryTimes > 0;
    }

    protected ResqMsg sendReq() throws EASBizException, BOSException {
        if (this.isNeedToken() && this.invokeParam.getToken() == null) {
            PwyInvokeParam invokeParam = new PwyInvokeParam();
            invokeParam.setMsgType(this.getTokenMsgType().getValue());
            invokeParam.setOwnerSystem(this.invokeParam.getOwnerSystem());
            invokeParam.setOrgId(this.invokeParam.getOrgId());
            invokeParam.setSetting(this.invokeParam.getSetting());
            invokeParam.setClientId(this.invokeParam.getClientId());
            invokeParam.setClientSecret(this.invokeParam.getClientSecret());
            invokeParam.setInit(true);
            this.tokenService = PwyServiceHelper.getPwyService(this.ctx, invokeParam);
            this.tokenService.invoke();
            if (!this.tokenService.getInvokeParam().isSuccess()) {
                return this.tokenService.getInvokeParam().getResqMsg();
            }
            this.invokeParam.setToken(this.tokenService.getInvokeParam().getToken());
            this.invokeParam.setUrl(this.getPwyURL());
            String sendMsg = Kson.getGson().toJson((Object)this.getPwyData());
            this.invokeParam.setSendMsg(sendMsg);
            invokeParam.setRequestMsg(this.isNeedEncrypt() ? this.encryptData(invokeParam.getSendMsg()) : invokeParam.getSendMsg());
            this.invokeParam.getPwyLog().setUrl(this.invokeParam.getUrl());
            this.invokeParam.getPwyLog().setSendMsg(this.invokeParam.getSendMsg());
        }
        this.invokeParam.getPwyLog().setIsSended(true);
        this.updatePwyLog();
        HttpSender sender = new HttpSender();
        ResqMsg resqMsg = null;
        try {
            this.invokeParam.setSendTime(IMUtils.getCurrentTime());
            resqMsg = sender.send(this.ctx, new ReqMsg(this.invokeParam));
            this.invokeParam.setRevTime(IMUtils.getCurrentTime());
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return resqMsg;
    }

    protected abstract PwyServiceType getTokenMsgType();

    protected boolean isNeedEncrypt() {
        return false;
    }

    protected String encryptData(String data) throws EASBizException, BOSException {
        if (this.invokeParam.getSetting() == null) {
            return data;
        }
        String content = BizInterfaceFactory.getIMInvoiceFacade(this.ctx).encryptAES(data, this.invokeParam.getSetting().getSecretKey());
        return content;
    }

    protected void resolveResp(ResqMsg msg) {
        this.invokeParam.setResqMsg(msg);
        this.invokeParam.setRevMsg(msg.getRevMsg());
        this.invokeParam.getPwyLog().setRevMsg(msg.getRevMsg());
        if (this.invokeParam.getSendTime() != null) {
            this.invokeParam.getPwyLog().setSendTime(new Timestamp(this.invokeParam.getSendTime().getTime()));
        }
        if (this.invokeParam.getRevTime() != null) {
            this.invokeParam.getPwyLog().setRevTime(new Timestamp(this.invokeParam.getRevTime().getTime()));
        }
        this.invokeParam.setErrcode(msg.getErrcode());
        this.invokeParam.setDescription(msg.getDescription());
        if (this.getSuccessCode().equals(msg.getErrcode())) {
            this.invokeParam.setSuccess(true);
            this.resolveSuccess();
            if (this.isNeedReverse()) {
                this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.SUCCESS);
            } else {
                this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FINISH);
                this.invokeParam.getPwyLog().setDescription(null);
            }
        } else if (this.getPartSuccessCode() != null && this.getPartSuccessCode().equals(msg.getErrcode())) {
            this.invokeParam.setPartSuccess(true);
            this.resolvePartSuccess();
            if (this.isNeedReverse()) {
                this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.SUCCESS);
            } else {
                this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FINISH);
                this.invokeParam.getPwyLog().setDescription(null);
            }
        } else if (this.getUnKownCode().equals(msg.getErrcode())) {
            this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FAILURE);
            this.invokeParam.getPwyLog().setDescription(msg.getDescription());
        } else {
            this.invokeParam.getPwyLog().setLogStatus(LogStatusEnum.FAILURE);
        }
    }

    protected void setReturn(String errorCode, String description) {
        this.invokeParam.setErrcode(errorCode);
        this.invokeParam.setDescription(description);
    }

    protected String getUnKownCode() {
        return "60000";
    }

    protected void resolveSuccess() {
    }

    protected void resolvePartSuccess() {
    }

    protected boolean isNeedReverse() {
        return false;
    }

    protected boolean isNeedToken() {
        return false;
    }

    public abstract String getPwyCzlx();

    public abstract String getSuccessCode();

    public String getPartSuccessCode() {
        return null;
    }

    @Override
    public PwyInvokeParam getInvokeParam() {
        return this.invokeParam;
    }

    public void setInvokeParam(PwyInvokeParam invokeParam) {
        this.invokeParam = invokeParam;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void setLogService(LogService logService) {
        this.logService = logService;
    }

    public PwyHelper getPwyHelper() {
        return this.pwyHelper;
    }

    public boolean isLogRetry() {
        return this.isLogRetry;
    }

    public void setLogRetry(boolean isLogRetry) {
        this.isLogRetry = isLogRetry;
    }
}

