/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.incomeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.msg.result.IncomeInvoiceDownloadResult;
import com.kingdee.eas.tm.im.common.comm.service.incomeinvoice.IncomeInvoiceWebPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IncomeInvoiceBillQueryPwyService
extends IncomeInvoiceWebPwyService {
    private IncomeInvoiceBillQueryPwyService nextService = null;
    private int totalPage = 0;
    private int currentPage = 0;

    public IncomeInvoiceBillQueryPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public IncomeInvoiceBillQueryPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public Map getPwyData() {
        return this.getInvokeParam().getParams();
    }

    @Override
    public String getDefaultInterfacePath() {
        return "/m6/bill/invoice/query";
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    protected void resolveSuccess() {
        JSONObject retJson = null;
        try {
            retJson = new JSONObject(this.getInvokeParam().getRevMsg());
            if ("0000".equals(retJson.get("errcode"))) {
                this.totalPage = retJson.getInt("totalPage");
                this.currentPage = retJson.getInt("currentPage");
            }
        }
        catch (JSONException e) {
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("retInfo", this.getInvokeParam().getRevMsg());
        params.put("orgid", this.getInvokeParam().getOrgId());
        params.put("parserClass", "com.kingdee.eas.tm.im.common.comm.msg.parser.IncomeInvoiceDownloadWebParser");
        Map retValue = BizInterfaceFactory.getIncomeInvoiceReWriteFacade(this.getCtx()).billQueryDownload(params);
        this.getInvokeParam().setInvokeActionMap(retValue);
        ++this.currentPage;
        if (this.currentPage <= this.totalPage) {
            params = new HashMap();
            params.putAll(this.getInvokeParam().getParams());
            params.put("pageNo", this.currentPage);
            PwyInvokeParam invokeParam = PwyInvokeParam.newPwyInvokeParam(this.getInvokeParam());
            invokeParam.setParams(params);
            invokeParam.setInit(true);
            this.nextService = (IncomeInvoiceBillQueryPwyService)PwyServiceHelper.getPwyService(this.getCtx(), invokeParam);
            this.nextService.invoke();
        }
    }

    public List getErrorList() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (!this.isSuccess()) {
            errorList.add(this.getInvokeParam().getDescription());
        }
        for (IncomeInvoiceBillQueryPwyService nextService = this.getNextService(); nextService != null; nextService = nextService.getNextService()) {
            if (nextService.isSuccess()) continue;
            errorList.add(nextService.getInvokeParam().getDescription());
        }
        return errorList;
    }

    public Map getInvokeActionMap() {
        HashMap retValue = new HashMap();
        ArrayList<IncomeInvoiceDownloadResult> resultList = new ArrayList<IncomeInvoiceDownloadResult>();
        IncomeInvoiceDownloadResult result = (IncomeInvoiceDownloadResult)this.getInvokeParam().getInvokeActionMap().get(this.getInvokeParam().getOrgId());
        resultList.add(result);
        IncomeInvoiceDownloadResult invokeResult = null;
        for (IncomeInvoiceBillQueryPwyService nextService = this.getNextService(); nextService != null; nextService = nextService.getNextService()) {
            Map invokeActionMap = nextService.getInvokeParam().getInvokeActionMap();
            if (invokeActionMap == null) continue;
            invokeResult = (IncomeInvoiceDownloadResult)invokeActionMap.get(this.getInvokeParam().getOrgId());
            resultList.add(invokeResult);
        }
        retValue.put("result", resultList);
        return retValue;
    }

    public IncomeInvoiceBillQueryPwyService getNextService() {
        return this.nextService;
    }

    public void setNextService(IncomeInvoiceBillQueryPwyService nextService) {
        this.nextService = nextService;
    }

    @Override
    public String getPwyCzlx() {
        return "9002";
    }
}

