/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.incomeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.TransOperTypeEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.AbstractPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class IncomeInvoicePwyService
extends AbstractPwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.service.incomeinvoice.IncomeInvoicePwyService");

    public IncomeInvoicePwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public IncomeInvoicePwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public List getValues() throws EASBizException, BOSException {
        String billId = this.getInvokeParam().getBillId();
        ArrayList<IncomeInvoiceInfo> invoiceList = null;
        if (!StringUtils.isEmpty((String)billId)) {
            String[] invoiceArr = billId.split(",");
            HashSet<String> invoiceSet = new HashSet<String>(Arrays.asList(invoiceArr));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", invoiceSet, CompareType.INCLUDE));
            view.setFilter(filter);
            invoiceList = new ArrayList<IncomeInvoiceInfo>();
            IncomeInvoiceCollection invoiceColl = BizInterfaceFactory.getIncomeInvoice(this.getCtx()).getIncomeInvoiceCollection(view);
            IncomeInvoiceInfo invoice = null;
            for (int i = 0; i < invoiceColl.size(); ++i) {
                invoice = invoiceColl.get(i);
                invoiceList.add(invoice);
            }
        }
        return invoiceList;
    }

    @Override
    protected TaxTransLogInfo createPwyLog() throws EASBizException, BOSException {
        TaxTransLogInfo pwyLog = super.createPwyLog();
        pwyLog.setOperType(TransOperTypeEnum.incomeinvoice);
        if (this.getInvoice() != null) {
            pwyLog.setInvoiceNumber(this.getInvoice().getNumber());
            pwyLog.setInvoiceNum(this.getInvoice().getInvoiceNumber());
            pwyLog.setInvoiceCode(this.getInvoice().getInvoiceCode());
        }
        return pwyLog;
    }

    @Override
    protected PwySettingInfo getPwySetting() throws BOSException, EASBizException {
        FullOrgUnitInfo company;
        String orgid = this.getInvokeParam().getOrgId();
        IncomeInvoiceInfo invoice = null;
        if (orgid == null) {
            invoice = this.getInvoice();
            orgid = invoice.getCompany().getId().toString();
        }
        if ((company = FullOrgUnitFactory.getLocalInstance((Context)this.getCtx()).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid))).isIsCompanyOrgUnit()) {
            CompanyOrgUnitInfo org = BizInterfaceFactory.getCompanyOrgUnit(this.getCtx()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
            this.getInvokeParam().setCompany(org);
        }
        logger.error((Object)("getPwySetting() : " + orgid + " - " + (invoice != null ? invoice.getId().toString() : null) + " - " + this.getInterfacePath()));
        PwySettingInfo pwyInfo = (PwySettingInfo)BizInterfaceFactory.getPwySetting(this.getCtx()).getPwySetting(orgid, OPTypeEnum.RecInvoice, null, null);
        if (pwyInfo == null) {
            this.setReturn(this.getUnKownCode(), company.getName() + IMUtils.getIMResource(this.getCtx(), "NO_PWYSETTING", new String[0]));
            throw new IMException(IMException.ERRORMSG, new Object[]{company.getName() + IMUtils.getIMResource(this.getCtx(), "NO_PWYSETTING", new String[0])});
        }
        return pwyInfo;
    }

    @Override
    protected void resolveSuccess() {
    }

    @Override
    protected void resolvePartSuccess() {
    }

    public IncomeInvoiceInfo getInvoice() {
        IncomeInvoiceInfo invoice = null;
        if (this.getInvokeParam().getValues() != null && this.getInvokeParam().getValues().size() == 1) {
            invoice = (IncomeInvoiceInfo)this.getInvokeParam().getValues().get(0);
        }
        return invoice;
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
    }

    @Override
    public boolean isNeedToken() {
        return false;
    }

    @Override
    public String getSuccessCode() {
        return "0000";
    }

    @Override
    public String getPartSuccessCode() {
        return null;
    }

    @Override
    protected PwyServiceType getTokenMsgType() {
        return PwyServiceType.OPR_WEB_GETTOKEN_INCOMEINV;
    }
}

