/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.pool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.msg.result.DownloadResult;
import com.kingdee.eas.tm.im.common.comm.msg.result.IncomeInvoiceDownloadResult;
import com.kingdee.eas.tm.im.common.comm.msg.result.PoolDownloadResult;
import com.kingdee.eas.tm.im.common.comm.service.pool.PoolWebPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.IncomeInvoicePwyHelper;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class WebDownloadPwyService
extends PoolWebPwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.service.pool.WebDownloadPwyService");
    private WebDownloadPwyService nextService = null;
    private int totalPage = 0;
    private int currentPage = 0;

    public WebDownloadPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public WebDownloadPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public Map getPwyData() {
        Object pageNo;
        Object pageSize;
        Map map = (Map)this.getInvokeParam().getParams().get("pwyData");
        if (map.containsKey("pageSize") && (pageSize = map.get("pageSize")) != null) {
            int pageSizeNum = Double.valueOf(pageSize.toString()).intValue();
            map.put("pageSize", pageSizeNum);
        }
        if (map.containsKey("pageNo") && (pageNo = map.get("pageNo")) != null) {
            int pageNoNum = Double.valueOf(pageNo.toString()).intValue();
            map.put("pageNo", pageNoNum);
        }
        return map;
    }

    @Override
    public String getDefaultInterfacePath() {
        return "/m6/bill/invoice/query";
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    protected void resolveSuccess() {
        JSONObject retJson = null;
        try {
            retJson = new JSONObject(this.getInvokeParam().getRevMsg());
            if ("0000".equals(retJson.get("errcode"))) {
                this.totalPage = retJson.getInt("totalPage");
                this.currentPage = retJson.getInt("currentPage");
            }
        }
        catch (JSONException e) {
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(this.getInvokeParam().getParams());
        params.put("retInfo", this.getInvokeParam().getRevMsg());
        params.put("orgid", this.getInvokeParam().getOrgId());
        params.put("parserClass", "com.kingdee.eas.tm.im.common.comm.msg.parser.WebDownloadParser");
        Map retValue = BizInterfaceFactory.getIncomeInvoiceReWriteFacade(this.getCtx()).billQueryDownload(params);
        this.getInvokeParam().setInvokeActionMap(retValue);
        this.invokePages(retValue);
    }

    protected boolean invokePages(Map retValue) throws EASBizException, BOSException {
        if (this.isInvokeMultithread()) {
            this.invokePagesWithMultithread(retValue);
        } else {
            this.invokeNextPage(retValue);
        }
        return false;
    }

    protected boolean isInvokeMultithread() {
        return this.totalPage > 2;
    }

    protected void invokeNextPage(Map retValue) throws EASBizException, BOSException {
        ++this.currentPage;
        if (this.currentPage <= this.totalPage) {
            Map pwyData = this.getPwyData();
            pwyData.put("pageNo", this.currentPage);
            CompanyOrgUnitInfo company = null;
            try {
                company = BizInterfaceFactory.getCompanyOrgUnit(this.getCtx()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.getInvokeParam().getOrgId()));
                if (!StringUtils.isEmpty((String)company.getTaxNumber())) {
                    pwyData.put("buyerTaxNo", company.getTaxNumber().trim());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            HashMap<String, Map> newParams = new HashMap<String, Map>();
            newParams.putAll(this.getInvokeParam().getParams());
            newParams.put("pwyData", pwyData);
            newParams.put("totalMap", retValue);
            PwyInvokeParam invokeParam = PwyInvokeParam.newPwyInvokeParam(this.getInvokeParam());
            invokeParam.setParams(newParams);
            invokeParam.setInit(true);
            this.nextService = (WebDownloadPwyService)PwyServiceHelper.getPwyService(this.getCtx(), invokeParam);
            this.nextService.invoke();
            this.getInvokeParam().setInvokeActionMap(this.nextService.getInvokeParam().getInvokeActionMap());
        }
    }

    protected void invokePagesWithMultithread(Map retValue) throws BOSException {
        if (this.currentPage > 1) {
            return;
        }
        ExecutorService service = null;
        try {
            int defaultThreadPoolSize = 16;
            int size = this.totalPage - 1;
            int threadPoolsize = size > defaultThreadPoolSize ? defaultThreadPoolSize : size;
            service = Executors.newFixedThreadPool(threadPoolsize);
            CountDownLatch latch = new CountDownLatch(size);
            Map totalMap = retValue;
            ArrayList<PwyInvokeParam> resultList = new ArrayList<PwyInvokeParam>();
            for (int i = 0; i < size; ++i) {
                int curPage = i + 2;
                InvokePageTask task = new InvokePageTask(curPage, this.getInvokeParam(), resultList, latch);
                service.execute(task);
            }
            latch.await();
            ArrayList<Map> nextTotalList = new ArrayList<Map>();
            PwyInvokeParam invokeParam = null;
            WebDownloadPwyService nextService = null;
            int length = resultList.size();
            for (int i = 0; i < length; ++i) {
                invokeParam = (PwyInvokeParam)resultList.get(i);
                nextService = (WebDownloadPwyService)PwyServiceHelper.getPwyService(this.getCtx(), invokeParam);
                nextService.invokeAfter();
                nextTotalList.add(invokeParam.getInvokeActionMap());
            }
            DownloadResult totalResult = null;
            DownloadResult result = null;
            Map nextTotalMap = null;
            int length2 = nextTotalList.size();
            for (int i = 0; i < length2; ++i) {
                nextTotalMap = (Map)nextTotalList.get(i);
                String companyID2 = null;
                for (String companyID2 : nextTotalMap.keySet()) {
                    result = (DownloadResult)nextTotalMap.get(companyID2);
                    if (totalMap.containsKey(companyID2)) {
                        totalResult = (DownloadResult)totalMap.get(companyID2);
                        totalResult.merge(result);
                        totalResult.calculate();
                        continue;
                    }
                    totalMap.put(companyID2, result);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
    }

    public DownloadResult getDownloadResult(Map params) {
        DownloadResult result = null;
        result = IncomeInvoicePwyHelper.isPoolDownload(params) ? new PoolDownloadResult() : new IncomeInvoiceDownloadResult();
        return result;
    }

    public WebDownloadPwyService getNextService() {
        return this.nextService;
    }

    public void setNextService(WebDownloadPwyService nextService) {
        this.nextService = nextService;
    }

    @Override
    public String getPwyCzlx() {
        return "PS1908";
    }

    @Override
    public List getValues() throws EASBizException, BOSException {
        return null;
    }

    class InvokePageTask
    implements Runnable {
        private List<PwyInvokeParam> resultList = null;
        private int curPage = 0;
        private PwyInvokeParam invokeParam = null;
        private CountDownLatch latch = null;

        public InvokePageTask(int curPage, PwyInvokeParam invokeParam, List<PwyInvokeParam> resultList, CountDownLatch latch) {
            this.curPage = curPage;
            this.resultList = resultList;
            this.invokeParam = invokeParam;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap newParams = new HashMap();
            newParams.putAll(this.invokeParam.getParams());
            newParams.put("totalMap", null);
            try {
                HashMap<String, Object> pwyData = new HashMap<String, Object>();
                pwyData.putAll((Map)this.invokeParam.getParams().get("pwyData"));
                pwyData.put("pageNo", this.curPage);
                CompanyOrgUnitInfo company = null;
                try {
                    company = BizInterfaceFactory.getCompanyOrgUnit(WebDownloadPwyService.this.getCtx()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.invokeParam.getOrgId()));
                    if (!StringUtils.isEmpty((String)company.getTaxNumber())) {
                        pwyData.put("buyerTaxNo", company.getTaxNumber().trim());
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                newParams.put("pwyData", pwyData);
                PwyInvokeParam invokeParam = PwyInvokeParam.newPwyInvokeParam(this.invokeParam);
                invokeParam.setParams(newParams);
                invokeParam.setToken(this.invokeParam.getToken());
                invokeParam.setInit(true);
                WebDownloadPwyService nextService = (WebDownloadPwyService)PwyServiceHelper.getPwyService(WebDownloadPwyService.this.getCtx(), invokeParam);
                nextService.buildPwyParam();
                nextService.invokePwy();
                if (nextService.isSuccess()) {
                    this.resultList.add(nextService.getInvokeParam());
                } else {
                    DownloadResult result = WebDownloadPwyService.this.getDownloadResult(newParams);
                    result.setCompany(company);
                    result.getErrMsgList().add(nextService.getInvokeParam().getDescription());
                    invokeParam.getInvokeActionMap().put(invokeParam.getOrgId(), result);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                CompanyOrgUnitInfo company = null;
                try {
                    company = BizInterfaceFactory.getCompanyOrgUnit(WebDownloadPwyService.this.getCtx()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.invokeParam.getOrgId()));
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                DownloadResult result = WebDownloadPwyService.this.getDownloadResult(newParams);
                result.setCompany(company);
                result.getErrMsgList().add(e.getMessage());
                this.invokeParam.getInvokeActionMap().put(this.invokeParam.getOrgId(), result);
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

