/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.uihelper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwyUrlHelp;
import com.kingdee.eas.tm.im.common.actionproxy.IMActionProxy;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoicePwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.im.common.uihelper.UIHelper;
import com.kingdee.eas.tm.im.util.ExplorerUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class ListUIHelper
extends UIHelper {
    private static final Logger logger = CoreUIObject.getLogger(UIHelper.class);
    private ListUI ui = null;
    private OrgUnitCollection authorizedMainOrgs = null;

    public ListUIHelper(ListUI ui) {
        super((CoreUI)ui);
        this.ui = ui;
    }

    public void bindPermission(AbstractButton button, IItemAction target, Map serviceContext) {
        IMActionProxy actionProxy = new IMActionProxy(serviceContext, null, target);
        String text = button.getText();
        Icon icon = button.getIcon();
        String toolTip = button.getToolTipText();
        int mnemonic = button.getMnemonic();
        boolean isVisible = button.isVisible();
        ActionListener[] listeners = button.getActionListeners();
        if (listeners != null && listeners.length > 0) {
            for (int i = 0; i < listeners.length; ++i) {
                button.removeActionListener(listeners[i]);
            }
        }
        button.setAction((Action)((Object)actionProxy));
        button.setText(text);
        button.setMnemonic(mnemonic);
        button.setVisible(isVisible);
        button.setIcon(icon);
        if (button instanceof KDWorkButton) {
            ((KDWorkButton)button).setAutoToolTipText(true);
        }
        button.setToolTipText(toolTip);
    }

    public FilterInfo getHasPermissionOrgFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        if (!(this.ui instanceof IPermSupport4ListUI)) {
            return filterInfo;
        }
        try {
            IPermSupport4ListUI uiSupport = (IPermSupport4ListUI)this.ui;
            if (this.authorizedMainOrgs == null) {
                this.authorizedMainOrgs = this.getAuthOrgsByType(this.ui.getMainType(), this.ui.getMainQueryPK());
            }
            HashSet<String> keys = new HashSet<String>();
            String key = uiSupport.getBizOrgProperty(this.ui.getMainType());
            if (this.authorizedMainOrgs != null && this.authorizedMainOrgs.size() > 0) {
                if (key == null) {
                    throw new IllegalArgumentException("getMainBizOrgType() should return a correct value.");
                }
                int index = 0;
                for (int i = 0; i < this.authorizedMainOrgs.size(); ++i) {
                    if (this.ui.getMainOrgInfo() != null && this.authorizedMainOrgs.get(i).getId().toString().equals(this.ui.getMainOrgInfo().getId().toString())) {
                        index = i;
                    }
                    keys.add(this.authorizedMainOrgs.get(i).getId().toString());
                }
                filterInfo.getFilterItems().add(new FilterItemInfo(key + ".id", keys, CompareType.INCLUDE));
                if (OrgType.Company.equals((Object)this.ui.getMainType())) {
                    uiSupport.initPermMainOrgContext(this.authorizedMainOrgs.get(index).getId().toString());
                }
                return filterInfo;
            }
        }
        catch (Exception e) {
            this.ui.handUIException((Throwable)e);
        }
        return filterInfo;
    }

    protected OrgUnitCollection getAuthOrgsByType(OrgType orgType, IMetaDataPK queryPK) throws EASBizException, BOSException {
        return IMFacadeFactory.getRemoteInstance().getAuthOrgsByType(orgType, queryPK);
    }

    public OrgUnitCollection getAuthorizedMainOrgs() {
        return this.authorizedMainOrgs;
    }

    public void setAuthorizedMainOrgs(OrgUnitCollection authorizedMainOrgs) {
        this.authorizedMainOrgs = authorizedMainOrgs;
    }

    public void actionMailOrderSearch_actionPerformed(ActionEvent e) throws Exception {
        this.ui.checkSelected();
        ArrayList ids = this.ui.getSelectedIdValuesArrayList();
        String id = (String)ids.get(0);
        Map ret = IMInvoiceFacadeFactory.getRemoteInstance().buildMailOrderSearchPwyParam(id);
        String errorMsg = (String)ret.get("errorMsg");
        if (!StringUtils.isEmpty((String)errorMsg)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"MAILORDERSEARCH_MSG_BILL");
            MsgBox.showDetailAndOK((Component)this.ui, (String)msg, (String)errorMsg, (int)1);
            SysUtil.abort();
        }
        String url = PwyUrlHelp.getWebExpressDetailUrl();
        List expressBillNums = (List)ret.get("expressBillNums");
        String companyID = (String)ret.get("companyID");
        PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_GET_AUTHCODE, TransSrcSystemEnum.easgui, companyID, new HashMap());
        PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getRemoteInstance().invoke(actionParam);
        MakeInvoicePwyService pwyService = (MakeInvoicePwyService)PwyServiceHelper.getPwyService(null, invokeParam);
        pwyService.invoke();
        if (pwyService.isSuccess()) {
            String authcode = pwyService.getInvokeParam().getAuthcode();
            for (String expressBillNum : expressBillNums) {
                String pwyURL = url + "?auth_code=" + authcode + "&fexpress_num=" + expressBillNum;
                logger.debug((Object)("\u3010\u67e5\u8be2\u5feb\u9012\u7269\u6d41:\u3011" + pwyURL));
                try {
                    ExplorerUtil.browse(pwyURL.toString());
                }
                catch (IOException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    this.ui.handUIException((Throwable)ex);
                }
            }
        } else {
            MsgBox.showInfo((String)pwyService.getInvokeParam().getDescription());
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e, KDTable tblMain, String companyField, String permItemName) throws Exception {
        int size = tblMain.getSelectManager().size();
        HashSet<String> companyIdSet = new HashSet<String>();
        for (int j = 0; j < size; ++j) {
            KDTSelectBlock selectBlock = tblMain.getSelectManager().get(j);
            if (selectBlock == null) continue;
            int num = selectBlock.getEndRow();
            for (int i = selectBlock.getTop(); i <= num && i >= 0; ++i) {
                String companyId = tblMain.getRow(i).getCell(companyField).getValue().toString();
                companyIdSet.add(companyId);
            }
        }
        for (String companyId : companyIdSet) {
            PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(companyId), permItemName);
        }
    }

    public void batchOperation(String method, KDTable table, String keyFieldName, String numberColumn, String billBosType) throws Exception {
        String summaryMsg;
        this.ui.checkSelected();
        String bizMethodName = this.getBizMethodName(method);
        ArrayList ids = this.ui.getSelectedIdValuesArrayList();
        int billCount = ids.size();
        ListUiHelper listUiHelper = new ListUiHelper();
        Map mapNumber = listUiHelper.getSelectColumnValue(table, keyFieldName, numberColumn);
        Map rowNumberMap = null;
        if (mapNumber.isEmpty()) {
            rowNumberMap = listUiHelper.getSelectRowNumberMap(table, keyFieldName);
        }
        Map result = IMFacadeFactory.getRemoteInstance().batchOperation(billBosType, method, ids.toArray(new String[ids.size()]));
        String numbetMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_ByNumber", IMUtils.getLocale());
        String rowIndexMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_ByRowIndex", IMUtils.getLocale());
        int errorCount = 0;
        StringBuffer errorMsg = new StringBuffer();
        if (!"0".equals(result.get("ERROR_COUNT"))) {
            for (Object cause : result.keySet()) {
                if ("ERROR_COUNT".equals(cause.toString())) {
                    errorCount = Integer.parseInt(result.get(cause).toString());
                    continue;
                }
                String id = cause.toString();
                if (mapNumber.isEmpty() && rowNumberMap != null) {
                    errorMsg.append(MessageFormat.format(rowIndexMsg, rowNumberMap.get(id)));
                } else {
                    errorMsg.append(MessageFormat.format(numbetMsg, mapNumber.get(id)));
                }
                errorMsg.append("\uff1a" + result.get(cause).toString() + "\n");
            }
        }
        if (errorCount > 0) {
            summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_Error", IMUtils.getLocale(), new Object[]{bizMethodName, String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
            MsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorMsg.toString(), (int)1);
        } else {
            summaryMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "Msg_Success", IMUtils.getLocale(), new Object[]{bizMethodName});
            MsgBox.showInfo((String)summaryMsg);
        }
    }

    protected String getBizMethodName(String method) {
        HashMap<String, String> bizAliasMap = new HashMap<String, String>();
        bizAliasMap.put("delete", "OPER_Delete");
        bizAliasMap.put("cancel", "OPER_Cancel");
        bizAliasMap.put("cancelCancel", "OPER_CancelCancel");
        String methodAlias = null;
        String value = (String)bizAliasMap.get(method);
        methodAlias = value != null ? IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", value, IMUtils.getLocale()) : IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "OPER_Default", IMUtils.getLocale());
        return methodAlias;
    }
}

