/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.common.writeback.app.handler.IExpressInfoDisposer;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.ws.msg.resq.ExpressInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpressInfoDisposer
implements IExpressInfoDisposer {
    @Override
    public void dispose(Context ctx, ExpressInfo expressInfo) throws EASBizException, BOSException {
        int bizAction = this.getBizDirection(expressInfo.getType());
        Map<String, MakeInvoiceInfo> invoiceMap = this.buildInvoiceMap(ctx, expressInfo, bizAction);
        String updateSQL = "update T_IM_MakeInvoice set FExpressBillNum=?,FExpressCompany=?,FMailDate=? where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        HashSet<String> ids = new HashSet<String>();
        MakeInvoiceInfo invoice = null;
        String billID2 = null;
        for (String billID2 : invoiceMap.keySet()) {
            invoice = invoiceMap.get(billID2);
            ids.add(billID2);
            ArrayList<Object> param = new ArrayList<Object>();
            param.add(invoice.getExpressBillNum());
            param.add(invoice.getExpressCompany());
            param.add(invoice.getMailDate());
            param.add(billID2);
            paramList.add(param.toArray());
        }
        if (paramList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateSQL, paramList);
        }
        if (ids.size() > 0) {
            this.disposeSrcBill(ctx, expressInfo, ids, bizAction);
        }
    }

    protected int getBizDirection(String action) throws EASBizException, BOSException {
        int bizDirection = 0;
        Object[] forward = new String[]{"FILLEXPNUM"};
        Object[] reverse = new String[]{"DELEXP"};
        if (Arrays.asList((Object[])forward).indexOf(action) > -1) {
            bizDirection = 0;
        } else if (Arrays.asList((Object[])reverse).indexOf(action) > -1) {
            bizDirection = 1;
        } else {
            throw new BOSException("action is illegal");
        }
        return bizDirection;
    }

    protected Map<String, MakeInvoiceInfo> buildInvoiceMap(Context ctx, ExpressInfo expressInfo, int bizAction) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = expressInfo.getFilterInfo();
        view.setFilter(filter);
        MakeInvoiceCollection invoices = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
        MakeInvoiceInfo invoice = null;
        HashMap<String, MakeInvoiceInfo> invoiceMap = new HashMap<String, MakeInvoiceInfo>();
        int size = invoices.size();
        for (int i = 0; i < size; ++i) {
            invoice = invoices.get(i);
            String key = invoice.getId().toString();
            this.fillExpressInfo2Invoice(invoice, expressInfo, bizAction);
            invoiceMap.put(key, invoice);
        }
        return invoiceMap;
    }

    protected void fillExpressInfo2Invoice(MakeInvoiceInfo invoice, ExpressInfo expressInfo, int bizAction) {
        if (bizAction == 0) {
            invoice.setExpressBillNum(expressInfo.getExpressBillNum());
            invoice.setExpressCompany(expressInfo.getExpressCompany());
            invoice.setMailDate(expressInfo.getMailDate());
        } else {
            invoice.setExpressBillNum(null);
            invoice.setExpressCompany(null);
            invoice.setMailDate(null);
        }
    }

    protected void disposeSrcBill(Context ctx, ExpressInfo expressInfo, Set ids, int bizAction) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT relation.FBizBillID,relation.FInvoiceBillID").append("\n");
        sql.append(" FROM T_IM_MakeInvoiceRelation relation").append("\n");
        sql.append(" INNER JOIN T_IM_MakeInvoice invoice on invoice.fid = relation.FInvoiceBillID").append("\n");
        sql.append(" WHERE FInvoiceBillID  in (").append(CollectionUtil.convertSet2String(ids)).append(")");
        HashMap bizMap = new HashMap();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String srcBosType2 = null;
        String bizBillID = null;
        try {
            while (rs.next()) {
                bizBillID = rs.getString("FBizBillID");
                srcBosType2 = BOSUuid.read((String)bizBillID).getType().toString();
                if (!bizMap.containsKey(srcBosType2)) {
                    bizMap.put(srcBosType2, new HashSet());
                }
                ((Set)bizMap.get(srcBosType2)).add(bizBillID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Set bizIds = null;
        for (String srcBosType2 : bizMap.keySet()) {
            bizIds = (Set)bizMap.get(srcBosType2);
            if ("AC368D2D".equals(srcBosType2)) {
                this.dispose2InvoiceReq(ctx, srcBosType2, expressInfo, bizIds, bizAction);
                continue;
            }
            if (!"FC910EF3".equals(srcBosType2)) continue;
            this.dispose2OtherBill(ctx, srcBosType2, expressInfo, bizIds, bizAction);
        }
    }

    protected void dispose2OtherBill(Context ctx, String billBosType, ExpressInfo expressInfo, Set<String> bizIds, int bizAction) throws BOSException {
        this.dipsose2Common(ctx, billBosType, expressInfo, bizIds, "T_AR_OtherBill", bizAction);
    }

    protected void dispose2InvoiceReq(Context ctx, String billBosType, ExpressInfo expressInfo, Set<String> bizIds, int bizAction) throws BOSException {
        Set srcIds = this.dipsose2Common(ctx, billBosType, expressInfo, bizIds, "T_IM_MakeInvoiceReq", bizAction);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT dest.fid,dest.FSourceBillID ").append("\n");
        sql.append(" FROM T_IM_MakeInvoiceReq dest ").append("\n");
        sql.append(" INNER JOIN T_IM_MakeInvoiceReqEntry destEntry ON destEntry.FParentID = dest.FID").append("\n");
        sql.append(" WHERE dest.FID in (").append(CollectionUtil.convertSet2String(srcIds)).append(") ").append("\n");
        sql.append(" AND dest.FSourceBillType = '").append("0").append("'").append("\n");
        sql.append(" GROUP BY dest.fid,dest.FSourceBillID").append("\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> arIds = new HashSet<String>();
        try {
            while (rs.next()) {
                arIds.add(rs.getString("FSourceBillID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (arIds.size() > 0) {
            this.dispose2OtherBill(ctx, "FC910EF3", expressInfo, arIds, bizAction);
        }
    }

    protected Set dipsose2Common(Context ctx, String billBosType, ExpressInfo expressInfo, Set<String> bizIds, String srcTable, int bizAction) throws BOSException {
        Map<String, IObjectValue> billMap = this.buildBillMap(ctx, billBosType, expressInfo, bizIds, bizAction);
        String updateSQL = "update " + srcTable + " set FExpressBillNum=?,FExpressCompany=?,FMailDate=?  where fid = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList<Object> param = null;
        HashSet<String> ids = new HashSet<String>();
        String billID2 = null;
        IObjectValue value = null;
        for (String billID2 : bizIds) {
            value = billMap.get(billID2);
            if (value == null) continue;
            param = new ArrayList<Object>();
            param.add(value.getString("expressBillNum"));
            param.add(value.getString("expressCompany"));
            java.util.Date utilDate = (java.util.Date)value.get("mailDate");
            param.add(utilDate != null ? new Date(utilDate.getTime()) : null);
            param.add(billID2);
            paramList.add(param.toArray());
            ids.add(billID2);
        }
        if (paramList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateSQL, paramList);
        }
        return ids;
    }

    protected Map<String, IObjectValue> buildBillMap(Context ctx, String billBosType, ExpressInfo expressInfo, Set<String> bizIds, int bizAction) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bizIds, CompareType.INCLUDE));
        view.setFilter(filter);
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)billBosType));
        CoreBaseCollection coll = iCoreBase.getCollection(view);
        IObjectValue value = null;
        HashMap<String, IObjectValue> billMap = new HashMap<String, IObjectValue>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            value = coll.getObject(i);
            this.fillExpressInfo2Bill(value, expressInfo, bizAction);
            billMap.put(value.get("id").toString(), value);
        }
        return billMap;
    }

    protected void fillExpressInfo2Bill(IObjectValue value, ExpressInfo expressInfo, int bizAction) {
        String expressBillNum = value.getString("expressBillNum");
        String expressCompany = value.getString("expressCompany");
        java.util.Date mailDate = (java.util.Date)value.get("mailDate");
        value.setString("expressBillNum", this.merge(expressBillNum, expressInfo.getExpressBillNum(), bizAction));
        value.setString("expressCompany", this.merge(expressCompany, expressInfo.getExpressCompany(), bizAction));
        if (!StringUtils.isEmpty((String)value.getString("expressBillNum"))) {
            value.setDate("mailDate", expressInfo.getMailDate());
        } else {
            value.setDate("mailDate", null);
        }
    }

    protected String merge(String value1, String value2, int bizAction) {
        if (value2 == null) {
            return value1;
        }
        String ret = null;
        if (value1 == null) {
            ret = bizAction == 0 ? value2 : value1;
        } else {
            Object[] arr = value1.split(";");
            List list = Arrays.asList((Object[])arr);
            HashSet<String> value = new HashSet<String>();
            value.addAll(list);
            if (bizAction == 0) {
                value.add(value2);
            } else {
                value.remove(value2);
            }
            if (value.size() > 0) {
                ret = CollectionUtil.convertSet2String(value, ";", false);
            }
        }
        return ret;
    }
}

