/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.utils.TMSqlUtil;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReserveUtils;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class InvoiceBaseDisposer {
    public static final String NEWLINE = "\n";

    protected void dispose2Ar(Context ctx, InvoiceInfo invoice, Set destIdSet, Map<String, BigDecimal> reqCurAmtMap, int bizAction, int bizDirection) throws BOSException {
        String selectArSql = this.getSelectArSql(destIdSet, bizDirection);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectArSql);
        if (rs.size() == 0) {
            return;
        }
        try {
            HashMap<String, String> unique = new HashMap<String, String>();
            String updateSql = "update t_ar_otherbill set FInvoiceCode=?,FInvoiceNo=? where fid=?";
            HashSet<String> srcIdSet = new HashSet<String>();
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            while (rs.next()) {
                String srcID = rs.getString("srcID");
                if (unique.containsKey(srcID)) continue;
                srcIdSet.add(srcID);
                String invoiceCode = rs.getString("invoiceCode");
                String invoiceNo = rs.getString("invoiceNo");
                if (bizAction == 0) {
                    invoiceNo = this.merge(invoiceNo, invoice.getInvoiceNo());
                    invoiceCode = this.merge(invoiceCode, invoice.getInvoiceNumber());
                } else {
                    invoiceNo = this.reduce(invoiceNo, invoice.getInvoiceNo());
                    invoiceCode = this.reduce(invoiceCode, invoice.getInvoiceNumber());
                }
                Object[] param = new Object[]{invoiceCode, invoiceNo, srcID};
                paramList.add(param);
                unique.put(srcID, srcID);
            }
            if (paramList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramList);
            }
            Map result = this.buildSrcAmtMap(ctx, rs, reqCurAmtMap, bizAction, bizDirection);
            Map curAmtMap = (Map)result.get("curAmtMap");
            Map totalAmtMap = (Map)result.get("totalAmtMap");
            ArrayList<Object[]> paramAmtList = new ArrayList<Object[]>();
            String updateAmtSql = " update t_ar_otherbill set FInvoicedAmt=? where fid=?";
            ArrayList<Object[]> paramMarkList = new ArrayList<Object[]>();
            String updateMarkSql = " update t_ar_otherbill set FInvoiceDate=?,FIsInvoiced=? where fid=?";
            for (String billID : totalAmtMap.keySet()) {
                BigDecimal invoiceAmt = (BigDecimal)totalAmtMap.get(billID);
                if (invoiceAmt.compareTo(BigDecimal.ZERO) == 0) {
                    Object[] paramMark = new Object[]{null, 0, billID};
                    paramMarkList.add(paramMark);
                } else {
                    Date invoiceDate = invoice.getInvoiceDate(bizAction);
                    int isInvoiced = 1;
                    Object[] paramMark = new Object[]{invoiceDate, isInvoiced, billID};
                    paramMarkList.add(paramMark);
                }
                Object[] paramAmt = new Object[]{invoiceAmt, billID};
                paramAmtList.add(paramAmt);
            }
            if (paramAmtList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateAmtSql, paramAmtList);
            }
            if (paramMarkList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateMarkSql, paramMarkList);
            }
            if (srcIdSet.size() > 0) {
                this.dispose2Order(ctx, invoice, srcIdSet, curAmtMap, false, bizAction, bizDirection);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void dispose2Ap(Context ctx, InvoiceInfo invoice, Set destIdSet, Map<String, BigDecimal> reqCurAmtMap, int bizAction, int bizDirection) throws BOSException {
        String selectApSql = this.getSelectApSql(destIdSet, bizDirection);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectApSql);
        if (rs.size() == 0) {
            return;
        }
        try {
            HashMap<String, String> unique = new HashMap<String, String>();
            String updateSql = "update t_ap_otherbill set FInvoiceCode=?,FInvoiceNumber=? where fid=?";
            HashSet<String> srcIdSet = new HashSet<String>();
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            while (rs.next()) {
                String srcID = rs.getString("srcID");
                if (unique.containsKey(srcID)) continue;
                srcIdSet.add(srcID);
                String invoiceCode = rs.getString("invoiceCode");
                String invoiceNo = rs.getString("invoiceNo");
                if (bizAction == 0) {
                    invoiceCode = this.merge(invoiceCode, invoice.getInvoiceNumber());
                    invoiceNo = this.merge(invoiceNo, invoice.getInvoiceNo());
                } else {
                    invoiceCode = this.reduce(invoiceCode, invoice.getInvoiceNumber());
                    invoiceNo = this.reduce(invoiceNo, invoice.getInvoiceNo());
                }
                Object[] param = new Object[]{invoiceCode, invoiceNo, srcID};
                paramList.add(param);
                unique.put(srcID, srcID);
            }
            if (paramList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected int getBizAction(String action) throws EASBizException, BOSException {
        int bizDirection = 0;
        String[] forward = new String[]{"make", "addSrcBill"};
        String[] reverse = new String[]{"cancel", "cancelSrcBill"};
        if (Arrays.asList(forward).indexOf(action) > -1) {
            bizDirection = 0;
        } else if (Arrays.asList(reverse).indexOf(action) > -1) {
            bizDirection = 1;
        } else {
            throw new BOSException("action is illegal");
        }
        return bizDirection;
    }

    protected int getBizDirection(InvoiceInfo invoice, int bizAction) {
        int bizDirection = 0;
        boolean isRed = invoice.isRedInvoice();
        if (!isRed && bizAction == 1 || isRed && bizAction == 0) {
            bizDirection = 1;
        }
        return bizDirection;
    }

    protected String getSelectArSql(Set destIdSet, int bizDirection) {
        return null;
    }

    protected String getSelectApSql(Set destIdSet, int bizDirection) {
        return null;
    }

    protected int navigateBizAction(int bizAction) {
        return bizAction == 0 ? 1 : 0;
    }

    protected Map buildSrcAmtMap(Context ctx, IRowSet rs, Map<String, BigDecimal> destAmtMap, int bizAction, int bizDirection) throws BOSException, SQLException {
        HashMap<String, BizInfo> bizMap = new HashMap<String, BizInfo>();
        ArrayList<BizInfo> bizList = new ArrayList<BizInfo>();
        HashMap bizRelationMap = new HashMap();
        BigDecimal srcTotalInvoiceAmt = BigDecimal.ZERO;
        ArrayList<String> destIdList = new ArrayList<String>();
        BizInfo bizInfo = null;
        BizRelationInfo bizRelationInfo = null;
        HashMap<String, String> unique = new HashMap<String, String>();
        rs.beforeFirst();
        while (rs.next()) {
            String key;
            String destID = rs.getString("destID");
            String srcID = rs.getString("srcID");
            BigDecimal invoiceAmt = this.isNullToZero(rs.getBigDecimal("invoiceAmt"));
            BigDecimal billAmount = this.isNullToZero(rs.getBigDecimal("billAmount"));
            BigDecimal reqAmount = this.isNullToZero(rs.getBigDecimal("reqAmount"));
            Timestamp auditTime = rs.getTimestamp("auditTime");
            if (!destIdList.contains(destID)) {
                destIdList.add(destID);
            }
            if ((bizInfo = (BizInfo)bizMap.get(srcID)) == null) {
                bizInfo = new BizInfo(srcID, invoiceAmt, billAmount, reqAmount, auditTime);
                srcTotalInvoiceAmt = srcTotalInvoiceAmt.add(billAmount);
                bizList.add(bizInfo);
                bizMap.put(srcID, bizInfo);
            }
            if (unique.containsKey(key = srcID + "_" + destID)) continue;
            if (!bizRelationMap.containsKey(destID)) {
                bizRelationMap.put(destID, new ArrayList());
            }
            bizRelationInfo = new BizRelationInfo(destID, reqAmount, bizInfo);
            ((List)bizRelationMap.get(destID)).add(bizRelationInfo);
            unique.put(key, key);
        }
        this.setSrcBillReqAmount(ctx, bizMap);
        BigDecimal destTotalAssignAmt = BigDecimal.ZERO;
        String billId2 = null;
        for (String billId2 : destAmtMap.keySet()) {
            if (!destIdList.contains(billId2)) continue;
            destTotalAssignAmt = destTotalAssignAmt.add(destAmtMap.get(billId2));
        }
        HashMap<String, BigDecimal> curAmtMap = new HashMap<String, BigDecimal>();
        final int orientation = srcTotalInvoiceAmt.signum() == destTotalAssignAmt.signum() ? bizAction : this.navigateBizAction(bizAction);
        Collections.sort(bizList, new Comparator<BizInfo>(){

            @Override
            public int compare(BizInfo o1, BizInfo o2) {
                if (o1.getAuditTime().equals(o2.getAuditTime())) {
                    return 0;
                }
                if (o1.getAuditTime().after(o2.getAuditTime())) {
                    return orientation == 0 ? 1 : -1;
                }
                return orientation == 0 ? -1 : 1;
            }
        });
        this.bizWriteoff(bizList, curAmtMap, orientation, false);
        String destID = null;
        BigDecimal assignAmt = null;
        List bizRelationList = null;
        List<BizRelationInfo> sortBizList = null;
        int size = destIdList.size();
        for (int i = 0; i < size; ++i) {
            destID = (String)destIdList.get(i);
            assignAmt = this.isNullToZero(destAmtMap.get(destID));
            bizRelationList = (List)bizRelationMap.get(destID);
            sortBizList = this.getSortBizRelationList(bizRelationList, orientation, assignAmt.compareTo(BigDecimal.ZERO) > 0);
            this.bizWriteBack(sortBizList, destID, destAmtMap, curAmtMap, bizAction);
        }
        BigDecimal totalInvoicedAmt = BigDecimal.ZERO;
        int size2 = bizList.size();
        for (int i = 0; i < size2; ++i) {
            bizInfo = (BizInfo)bizList.get(i);
            totalInvoicedAmt = totalInvoicedAmt.add(bizInfo.getInvoicedAmt());
        }
        if (totalInvoicedAmt.compareTo(BigDecimal.ZERO) == 0) {
            this.bizWriteoff(bizList, curAmtMap, 1, orientation != 1);
        } else {
            this.bizWriteoff(bizList, curAmtMap, 0, orientation != 0);
        }
        HashMap<String, BigDecimal> totalAmtMap = new HashMap<String, BigDecimal>();
        int size3 = bizList.size();
        for (int i = 0; i < size3; ++i) {
            bizInfo = (BizInfo)bizList.get(i);
            totalAmtMap.put(bizInfo.getId(), bizInfo.getInvoicedAmt());
        }
        HashMap<String, HashMap<String, BigDecimal>> result = new HashMap<String, HashMap<String, BigDecimal>>();
        result.put("curAmtMap", curAmtMap);
        result.put("totalAmtMap", totalAmtMap);
        return result;
    }

    private void setSrcBillReqAmount(Context ctx, Map<String, BizInfo> bizMap) throws BOSException {
        if (bizMap.size() == 0) {
            return;
        }
        String billId = bizMap.keySet().iterator().next();
        if ("C48A423A".equals(BOSUuid.read((String)billId).getType().toString())) {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FParentId,sum(isnull(FInvoiceReqAmountLocal,0)) as FBillReqAmount  ");
            sql.append(" FROM t_sd_saleorderentry");
            sql.append(" WHERE FParentId in ({0})");
            sql.append(" GROUP BY FParentId");
            IRowSet rs = TMSqlUtil.executeQueryNotInject((Context)ctx, (String)sql.toString(), (Object[])new Object[]{bizMap.keySet()});
            String parentId = null;
            BigDecimal billReqAmmout = null;
            try {
                while (rs.next()) {
                    parentId = rs.getString("FParentId");
                    billReqAmmout = rs.getBigDecimal("FBillReqAmount");
                    bizMap.get(parentId).setBillReqAmount(billReqAmmout);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected List<BizRelationInfo> getSortBizRelationList(List<BizRelationInfo> bizRelationList, final int orientation, boolean isBlue) {
        int i;
        Collections.sort(bizRelationList, new Comparator<BizRelationInfo>(){

            @Override
            public int compare(BizRelationInfo o1, BizRelationInfo o2) {
                if (o1.getBizInfo().getAuditTime().equals(o2.getBizInfo().getAuditTime())) {
                    return 0;
                }
                if (o1.getBizInfo().getAuditTime().after(o2.getBizInfo().getAuditTime())) {
                    return orientation == 0 ? 1 : -1;
                }
                return orientation == 0 ? -1 : 1;
            }
        });
        ArrayList<BizRelationInfo> sortBizList = new ArrayList<BizRelationInfo>();
        BizRelationInfo bizRelationInfo = null;
        BigDecimal billAmount = null;
        int size = bizRelationList.size();
        for (i = 0; i < size; ++i) {
            bizRelationInfo = bizRelationList.get(i);
            billAmount = this.isNullToZero(bizRelationInfo.getBizInfo().getBillAmount());
            if ((billAmount.compareTo(BigDecimal.ZERO) <= 0 || !isBlue) && (billAmount.compareTo(BigDecimal.ZERO) >= 0 || isBlue)) continue;
            sortBizList.add(bizRelationInfo);
        }
        size = bizRelationList.size();
        for (i = 0; i < size; ++i) {
            bizRelationInfo = bizRelationList.get(i);
            billAmount = this.isNullToZero(bizRelationInfo.getBizInfo().getBillAmount());
            if ((billAmount.compareTo(BigDecimal.ZERO) <= 0 || isBlue) && (billAmount.compareTo(BigDecimal.ZERO) >= 0 || !isBlue)) continue;
            sortBizList.add(bizRelationInfo);
        }
        return sortBizList;
    }

    protected void bizWriteBack(List<BizRelationInfo> bizRelationList, String destID, Map<String, BigDecimal> destAmtMap, Map<String, BigDecimal> curAmtMap, int bizAction) throws SQLException {
        BizRelationInfo bizRelationInfo = null;
        BizInfo bizInfo = null;
        int size = bizRelationList.size();
        for (int i = 0; i < size; ++i) {
            int orientation;
            bizRelationInfo = bizRelationList.get(i);
            bizInfo = bizRelationInfo.getBizInfo();
            BigDecimal reqAmount = this.isNullToZero(bizRelationInfo.getReqAmount());
            bizInfo.setReqAmount(reqAmount);
            BigDecimal invoicedAmt = bizInfo.getInvoicedAmt();
            BigDecimal assignAmt = this.isNullToZero(destAmtMap.get(destID));
            BigDecimal limitAmt = bizInfo.getLimitAmt(bizInfo.getBillAmount().signum() == assignAmt.signum() ? bizAction : this.navigateBizAction(bizAction));
            if (assignAmt.compareTo(BigDecimal.ZERO) == 0 || limitAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal curAmt = null;
            curAmt = assignAmt.abs().compareTo(limitAmt.abs()) > 0 ? (assignAmt.signum() != limitAmt.signum() ? limitAmt.negate() : limitAmt) : assignAmt;
            invoicedAmt = bizAction == 0 ? invoicedAmt.add(curAmt) : invoicedAmt.subtract(curAmt);
            int n = orientation = bizInfo.getBillAmount().signum() == assignAmt.signum() ? bizAction : this.navigateBizAction(bizAction);
            if (orientation == 0 && bizInfo.getBillReqAmount().abs().compareTo(invoicedAmt.abs()) < 0 || invoicedAmt.compareTo(BigDecimal.ZERO) != 0 && bizInfo.getBillAmount().signum() != invoicedAmt.signum()) continue;
            bizInfo.setInvoicedAmt(invoicedAmt);
            assignAmt = assignAmt.subtract(curAmt);
            destAmtMap.put(destID, assignAmt);
            curAmtMap.put(bizInfo.getId(), this.isNullToZero(curAmtMap.get(bizInfo.getId())).add(curAmt));
        }
    }

    protected void dispose2Order(Context ctx, InvoiceInfo invoice, Set destIdSet, Map<String, BigDecimal> arCurAmtMap, boolean isReq, int bizAction, int bizDirection) throws BOSException {
        if (!InvoiceReserveUtils.isOrderSupport(ctx)) {
            return;
        }
        String selectOrderSql = this.getSelectOrderSql(destIdSet, isReq, bizDirection);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectOrderSql);
        if (rs.size() == 0) {
            return;
        }
        try {
            HashMap<String, String> unique = new HashMap<String, String>();
            String updateSql = " update t_sd_saleorder set FInvoiceNumber=? where fid=?";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            while (rs.next()) {
                String srcID = rs.getString("srcID");
                if (unique.containsKey(srcID)) continue;
                String invoiceNo = rs.getString("invoiceNo");
                invoiceNo = bizAction == 0 ? this.merge(invoiceNo, invoice.getInvoiceNo(), true) : this.reduce(invoiceNo, invoice.getInvoiceNo());
                Object[] param = new Object[]{invoiceNo, srcID};
                paramList.add(param);
                unique.put(srcID, srcID);
            }
            if (paramList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramList);
            }
            Map result = this.buildSrcAmtMap(ctx, rs, arCurAmtMap, bizAction, bizDirection);
            Map totalAmtMap = (Map)result.get("totalAmtMap");
            ArrayList<Object[]> paramAmtList = new ArrayList<Object[]>();
            String updateAmtSql = " update t_sd_saleorder set FInvoiceAmt=? where fid=?";
            for (String billID : totalAmtMap.keySet()) {
                Object[] paramAmt = new Object[]{totalAmtMap.get(billID), billID};
                paramAmtList.add(paramAmt);
            }
            if (paramAmtList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateAmtSql, paramAmtList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void bizWriteoff(List<BizInfo> bizList, Map<String, BigDecimal> curAmtMap, int bizDirection, boolean isNegate) throws SQLException {
        ArrayList<BizInfo> redList = new ArrayList<BizInfo>();
        ArrayList<BizInfo> blueList = new ArrayList<BizInfo>();
        BizInfo bizInfo = null;
        String srcBosType = null;
        int size = bizList.size();
        for (int i = 0; i < size; ++i) {
            bizInfo = bizList.get(i);
            srcBosType = BOSUuid.read((String)bizInfo.getId()).getType().toString();
            if (bizInfo.getBillAmount().compareTo(BigDecimal.ZERO) < 0) {
                redList.add(bizInfo);
                continue;
            }
            blueList.add(bizInfo);
        }
        BizInfo redInfo2 = null;
        BizInfo blueInfo = null;
        String redId = null;
        String blueId = null;
        block1: for (BizInfo redInfo2 : redList) {
            redId = redInfo2.getId().toString();
            int size2 = blueList.size();
            for (int i = 0; i < size2; ++i) {
                blueInfo = (BizInfo)blueList.get(i);
                blueId = blueInfo.getId().toString();
                if (redInfo2.getLimitAmt(bizDirection).compareTo(BigDecimal.ZERO) == 0) continue block1;
                BigDecimal curAmt = BigDecimal.ZERO;
                curAmt = redInfo2.getLimitAmt(bizDirection).abs().compareTo(blueInfo.getLimitAmt(bizDirection)) > 0 ? blueInfo.getLimitAmt(bizDirection).abs() : redInfo2.getLimitAmt(bizDirection).abs();
                if (bizDirection == 0) {
                    redInfo2.setInvoicedAmt(redInfo2.getInvoicedAmt().add(curAmt.negate()));
                    blueInfo.setInvoicedAmt(blueInfo.getInvoicedAmt().add(curAmt));
                } else {
                    redInfo2.setInvoicedAmt(redInfo2.getInvoicedAmt().add(curAmt));
                    blueInfo.setInvoicedAmt(blueInfo.getInvoicedAmt().add(curAmt.negate()));
                }
                if ("AC368D2D".equals(srcBosType)) continue;
                curAmtMap.put(redId, this.isNullToZero(curAmtMap.get(redId)).add(isNegate ? curAmt : curAmt.negate()));
                curAmtMap.put(blueId, this.isNullToZero(curAmtMap.get(blueId)).add(isNegate ? curAmt.negate() : curAmt));
            }
        }
    }

    protected String getSelectOrderSql(Set destIdSet, boolean isReq, int bizDirection) {
        StringBuffer sql = new StringBuffer();
        if (isReq) {
            sql.append(" SELECT src.FID as srcID,t.destID as destID,").append(NEWLINE);
            sql.append(" src.FInvoiceNumber as invoiceNo,src.FInvoiceAmt as invoiceAmt,src.FLocalTotalTaxAmount as billAmount,t.reqAmount as reqAmount,src.FAudittime as auditTime").append(NEWLINE);
            sql.append(" FROM  t_sd_saleorder src INNER JOIN");
            sql.append(" (SELECT srcEntry.FParentID as srcID,destEntry.FParentID as destID,sum(destEntry.FPriceIncludingTaxLocal) as reqAmount");
            sql.append(" FROM t_sd_saleorderentry srcEntry").append(NEWLINE);
            sql.append(" INNER JOIN  t_im_makeinvoicereqentry destEntry on destEntry.FSourceBillEntryId= srcEntry.FID").append(NEWLINE);
            sql.append(" WHERE destEntry.FParentId in (").append(CollectionUtil.convertSet2String(destIdSet, ",", true)).append(")").append(NEWLINE);
            sql.append(" group by srcEntry.FParentID,destEntry.FParentID");
            sql.append(" ) t on src.fid = t.srcID");
            sql.append(" order by src.FAudittime ").append(bizDirection == 0 ? "asc" : "desc");
        } else {
            sql.append(" SELECT src1.FID as srcID,t.destID as destID,").append(NEWLINE);
            sql.append(" src1.FInvoiceNumber as invoiceNo,src1.FInvoiceAmt as invoiceAmt,src1.FLocalTotalTaxAmount as billAmount,t.reqAmount as reqAmount,src1.FAudittime as auditTime").append(NEWLINE);
            sql.append(" FROM  t_sd_saleorder src1 INNER JOIN");
            sql.append(" (SELECT srcEntry.FParentID as srcID,destEntry.FParentID as destID,sum(destEntry.FRecievePayAmountLocal) as reqAmount");
            sql.append(" FROM t_sd_saleorderentry srcEntry").append(NEWLINE);
            sql.append(" INNER JOIN  t_ar_otherbillentry destEntry on destEntry.FCoreBillEntryId= srcEntry.FID").append(NEWLINE);
            sql.append(" INNER JOIN  t_sd_saleorder src on src.fid= srcEntry.FParentID").append(NEWLINE);
            sql.append(" INNER JOIN  t_ar_otherbill dest on dest.fid= destEntry.fParentID").append(NEWLINE);
            sql.append(" WHERE destEntry.FParentId in (").append(CollectionUtil.convertSet2String(destIdSet, ",", true)).append(")").append(NEWLINE);
            sql.append(" AND ((src.FIsCentralBalance = 1 and dest.FCompanyId = src.FCompanyOrgUnitID) ").append(NEWLINE);
            sql.append(" or (src.FIsCentralBalance = 0 and dest.FCompanyId = srcEntry.FCompanyOrgUnitID))").append(NEWLINE);
            sql.append(" group by srcEntry.FParentID,destEntry.FParentID");
            sql.append(" ) t on src1.fid = t.srcID");
            sql.append(" order by src1.FAudittime ").append(bizDirection == 0 ? "asc" : "desc");
        }
        return sql.toString();
    }

    protected String merge(String number1, String number2) {
        if (StringUtils.isEmpty((String)number1)) {
            return number2;
        }
        ArrayList<String> numberList = new ArrayList<String>();
        String[] numberArr = number1.split(";");
        int size = numberArr.length;
        for (int i = 0; i < size; ++i) {
            numberList.add(numberArr[i]);
        }
        numberList.add(number2);
        return CollectionUtil.convertList2String(numberList, ";", false);
    }

    protected String merge(String number1, String number2, boolean isUnique) {
        if (StringUtils.isEmpty((String)number1)) {
            return number2;
        }
        ArrayList<String> numberList = new ArrayList<String>();
        String[] numberArr = number1.split(";");
        int size = numberArr.length;
        for (int i = 0; i < size; ++i) {
            numberList.add(numberArr[i]);
        }
        if (!isUnique || isUnique && !numberList.contains(number2)) {
            numberList.add(number2);
        }
        return CollectionUtil.convertList2String(numberList, ";", false);
    }

    protected String reduce(String number1, String number2) {
        if (StringUtils.isEmpty((String)number1)) {
            return null;
        }
        ArrayList<String> numberList = new ArrayList<String>();
        String[] numberArr = number1.split(";");
        int size = numberArr.length;
        for (int i = 0; i < size; ++i) {
            numberList.add(numberArr[i]);
        }
        numberList.remove(number2);
        return CollectionUtil.convertList2String(numberList, ";", false);
    }

    protected BigDecimal isNullToZero(BigDecimal value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value;
    }

    class BizRelationInfo {
        private String destID;
        private BigDecimal reqAmount;
        private BizInfo bizInfo;

        public BizRelationInfo() {
        }

        public BizRelationInfo(String destID, BigDecimal reqAmount, BizInfo bizInfo) {
            this.destID = destID;
            this.reqAmount = reqAmount;
            this.bizInfo = bizInfo;
        }

        public String getDestID() {
            return this.destID;
        }

        public void setDestID(String destID) {
            this.destID = destID;
        }

        public BigDecimal getReqAmount() {
            return this.reqAmount;
        }

        public void setReqAmount(BigDecimal reqAmount) {
            this.reqAmount = reqAmount;
        }

        public BizInfo getBizInfo() {
            return this.bizInfo;
        }

        public void setBizInfo(BizInfo bizInfo) {
            this.bizInfo = bizInfo;
        }
    }

    class BizInfo {
        private String id;
        private BigDecimal invoicedAmt;
        private BigDecimal billAmount;
        private BigDecimal reqAmount;
        private Timestamp auditTime;
        private BigDecimal billReqAmount;

        public BizInfo() {
        }

        public BizInfo(String id, BigDecimal invoicedAmt, BigDecimal billAmount, BigDecimal reqAmount, Timestamp auditTime) {
            this.id = id;
            this.invoicedAmt = invoicedAmt;
            this.billAmount = billAmount;
            this.reqAmount = reqAmount;
            this.auditTime = auditTime;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public BigDecimal getInvoicedAmt() {
            return this.invoicedAmt;
        }

        public void setInvoicedAmt(BigDecimal invoicedAmt) {
            this.invoicedAmt = invoicedAmt;
        }

        public BigDecimal getBillAmount() {
            return this.billAmount;
        }

        public void setBillAmount(BigDecimal billAmount) {
            this.billAmount = billAmount;
        }

        public BigDecimal getLimitAmt(int bizAction) {
            BigDecimal limitAmt = null;
            limitAmt = bizAction == 0 ? this.getBillReqAmount().subtract(this.invoicedAmt) : this.invoicedAmt;
            if (limitAmt.compareTo(BigDecimal.ZERO) > 0 && limitAmt.compareTo(this.reqAmount) > 0) {
                limitAmt = this.reqAmount;
            } else if (limitAmt.compareTo(BigDecimal.ZERO) < 0 && limitAmt.compareTo(this.reqAmount) < 0) {
                limitAmt = this.reqAmount;
            }
            return limitAmt;
        }

        public BigDecimal getReqAmount() {
            return this.reqAmount;
        }

        public void setReqAmount(BigDecimal reqAmount) {
            this.reqAmount = reqAmount;
        }

        public Timestamp getAuditTime() {
            return this.auditTime;
        }

        public void setAuditTime(Timestamp auditTime) {
            this.auditTime = auditTime;
        }

        public BigDecimal getBillReqAmount() {
            if (!this.isOrderBill()) {
                return this.billAmount;
            }
            return this.billReqAmount;
        }

        public void setBillReqAmount(BigDecimal billReqAmount) {
            this.billReqAmount = billReqAmount;
        }

        public boolean isOrderBill() {
            return !StringUtils.isEmpty((String)this.id) && "C48A423A".equals(BOSUuid.read((String)this.id).getType().toString());
        }
    }

    class InvoiceInfo {
        private String invoiceNumber;
        private String invoiceNo;
        private Date invoiceDate;
        private BigDecimal invoiceAmt = BigDecimal.ZERO;
        private Date buleInvoiceDate;

        InvoiceInfo() {
        }

        public boolean isRedInvoice() {
            return this.getInvoiceAmt().compareTo(BigDecimal.ZERO) < 0;
        }

        public Date getInvoiceDate(int bizAction) {
            Date invoiceDate = null;
            invoiceDate = this.isRedInvoice() && bizAction == 1 ? this.getBuleInvoiceDate() : this.getInvoiceDate();
            return invoiceDate;
        }

        public String getInvoiceNumber() {
            return this.invoiceNumber;
        }

        public void setInvoiceNumber(String invoiceNumber) {
            this.invoiceNumber = invoiceNumber;
        }

        public String getInvoiceNo() {
            return this.invoiceNo;
        }

        public void setInvoiceNo(String invoiceNo) {
            this.invoiceNo = invoiceNo;
        }

        public Date getInvoiceDate() {
            return this.invoiceDate;
        }

        public BigDecimal getInvoiceAmt() {
            return this.invoiceAmt;
        }

        public void setInvoiceAmt(BigDecimal invoiceAmt) {
            this.invoiceAmt = invoiceAmt;
        }

        public void setInvoiceDate(Date invoiceDate) {
            this.invoiceDate = invoiceDate;
        }

        public Date getBuleInvoiceDate() {
            return this.buleInvoiceDate;
        }

        public void setBuleInvoiceDate(Date buleInvoiceDate) {
            this.buleInvoiceDate = buleInvoiceDate;
        }
    }
}

