/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReq2ArSQLHelper;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReq2SaleOrderDisposer;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReqDisposer;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReserveUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class InvoiceReq2ArDisposer
extends InvoiceReqDisposer {
    private static Logger logger = Logger.getLogger(InvoiceReq2ArDisposer.class);
    private String coreBosType = null;
    private boolean isOrderSupport = false;

    public InvoiceReq2ArDisposer() {
        super(1);
    }

    public InvoiceReq2ArDisposer(int disposeType) {
        super(disposeType);
        this.setSrcBosType("FC910EF3");
    }

    @Override
    protected boolean isNeedUpdateIsMakeInvoiceReq() {
        return true;
    }

    @Override
    protected void init(Context ctx, String action, String destId) throws BOSException, EASBizException {
        super.init(ctx, action, destId);
        this.isOrderSupport = InvoiceReserveUtils.isOrderSupport(ctx);
    }

    @Override
    protected String getCreateTempTableSQL(String temptable) {
        return InvoiceReq2ArSQLHelper.getCreateTempTableSQL(temptable);
    }

    @Override
    protected String getInitSelectSQL(String destId, String tableName) {
        String sql = null;
        if (this.getDisposeType() == 1) {
            sql = InvoiceReq2ArSQLHelper.getArInitSelectSQL(destId, tableName);
        } else if (this.getDisposeType() == 2) {
            sql = InvoiceReq2ArSQLHelper.getOrderInitSelectSQL(destId, tableName);
        } else if (this.getDisposeType() == 3) {
            sql = InvoiceReq2ArSQLHelper.getBillInitSelectSQL(destId, tableName);
        }
        return sql;
    }

    @Override
    protected void lockBill(String tablename, String destId) throws SQLException {
        super.lockBill(tablename, destId);
        if (this.isOrderSupport) {
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE " + this.getCoreEntryTable() + " set FID = FID where FID in(");
            sql.append("SELECT FCoreBillEntryId FROM ").append(tablename).append(")");
            PreparedStatement ps = this.createPreparedStatement("lockCoreBill", sql.toString());
            this.executeUpdate(ps, null);
        }
    }

    @Override
    protected void updateInvoiceReq(Context ctx, String destId, String tablename, int bizDirection) throws SQLException, BOSException, EASBizException {
        LowTimer timer = new LowTimer();
        super.updateInvoiceReq(ctx, destId, tablename, bizDirection);
        logger.debug((Object)("\u3010updateInvoiceReq \u3011\u82b1\u8d39:" + timer.msValue()));
        timer.reset();
        if (this.isOrderSupport) {
            this.assignSrcBill(ctx, destId, tablename, bizDirection);
            logger.debug((Object)("\u3010assignSrcBill \u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
        }
    }

    @Override
    protected String getUpdateInvoiceReq2SrcSQL(String destID, String tableName, int bizDirection) {
        String sql = InvoiceReq2ArSQLHelper.getUpdateInvoiceReq2SrcSQL(destID, tableName, this.getSrcTable(), this.getSrcEntryTable(), bizDirection, this.getDisposeType());
        return sql;
    }

    protected boolean assignSrcBill(Context ctx, String destID, String tablename, int bizDirection) throws BOSException, SQLException {
        String sql = InvoiceReq2ArSQLHelper.getInvoiceReq2OrderSelectSQL(destID, tablename, this.getCoreTable(), this.getCoreEntryTable(), bizDirection, this.getDisposeType());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String FSourceBillEntryId = null;
        BigDecimal FQty = null;
        BigDecimal FBaseQty = null;
        BigDecimal FAmount = null;
        BigDecimal FAmountLocal = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        block0: while (rs.next()) {
            FSourceBillEntryId = rs.getString("FSourceBillEntryId");
            FQty = rs.getBigDecimal("FQty");
            FBaseQty = rs.getBigDecimal("FBaseQty");
            FAmount = rs.getBigDecimal("FAmount");
            FAmountLocal = rs.getBigDecimal("FAmountLocal");
            String selSQL = InvoiceReq2ArSQLHelper.getCurrentAssignDataSelectSQL(destID, tablename, FSourceBillEntryId);
            IRowSet selRs = DbUtil.executeQuery((Context)ctx, (String)selSQL);
            BigDecimal FUnQty = null;
            BigDecimal FUnBaseQty = null;
            BigDecimal FUnAmount = null;
            BigDecimal FUnAmountLocal = null;
            String FEntryId = null;
            int FBillStatus = 0;
            while (selRs.next()) {
                ArrayList<Object> param = new ArrayList<Object>();
                FEntryId = selRs.getString("FSourceBillEntryId");
                FBillStatus = selRs.getInt("FBillStatus");
                FUnQty = selRs.getBigDecimal("FUnQty");
                FUnBaseQty = selRs.getBigDecimal("FUnBaseQty");
                FUnAmount = selRs.getBigDecimal("FUnAmount");
                FUnAmountLocal = selRs.getBigDecimal("FUnAmountLocal");
                param.add(FUnQty);
                param.add(FUnBaseQty);
                param.add(FUnAmount);
                param.add(FUnAmountLocal);
                param.add(FEntryId);
                if (FBillStatus != 3) {
                    paramList.add(param.toArray());
                    continue;
                }
                if (FBaseQty.compareTo(BigDecimal.ZERO) == 0 && FAmountLocal.compareTo(BigDecimal.ZERO) == 0) {
                    paramList.add(param.toArray());
                    continue block0;
                }
                param.clear();
                if (FBaseQty.abs().compareTo(FUnBaseQty.abs()) <= 0) {
                    FUnQty = FUnQty.subtract(FQty);
                    FUnBaseQty = FUnBaseQty.subtract(FBaseQty);
                    FUnAmount = FUnAmount.subtract(FAmount);
                    FUnAmountLocal = FUnAmountLocal.subtract(FAmountLocal);
                    FQty = BigDecimal.ZERO;
                    FBaseQty = BigDecimal.ZERO;
                    FAmount = BigDecimal.ZERO;
                    FAmountLocal = BigDecimal.ZERO;
                } else {
                    FQty = FQty.subtract(FUnQty);
                    FBaseQty = FBaseQty.subtract(FUnBaseQty);
                    FAmount = FAmount.subtract(FUnAmount);
                    FAmountLocal = FAmountLocal.subtract(FUnAmountLocal);
                    FUnQty = BigDecimal.ZERO;
                    FUnBaseQty = BigDecimal.ZERO;
                    FUnAmount = BigDecimal.ZERO;
                    FUnAmountLocal = BigDecimal.ZERO;
                }
                param.add(FUnQty);
                param.add(FUnBaseQty);
                param.add(FUnAmount);
                param.add(FUnAmountLocal);
                param.add(FEntryId);
                paramList.add(param.toArray());
            }
        }
        StringBuffer updSQL = new StringBuffer();
        updSQL.append(" UPDATE " + tablename + " set ");
        updSQL.append(" FUnQty=?,FUnBaseQty=?,");
        updSQL.append(" FUnAmount=?,FUnAmountLocal=?");
        updSQL.append(" where FSourceBillEntryId=?");
        if (paramList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updSQL.toString(), paramList);
            return true;
        }
        return false;
    }

    @Override
    protected String getUpdateSrcBillSQL(int bizDirection, String tableName) {
        return InvoiceReq2ArSQLHelper.getUpdateSrcBillSQL(bizDirection, tableName, this.getSrcTable(), this.getSrcEntryTable());
    }

    @Override
    protected void cascadeDispose(Context ctx, String action, String destId) throws EASBizException, BOSException {
        if (this.getDisposeType() == 1 && this.isOrderSupport) {
            InvoiceReq2SaleOrderDisposer orderDisposer = new InvoiceReq2SaleOrderDisposer(2);
            orderDisposer.dispose(ctx, action, destId);
        }
    }

    @Override
    protected String getSrcTable() {
        return "T_AR_OtherBill";
    }

    @Override
    protected String getSrcEntryTable() {
        return "T_AR_OtherBillEntry";
    }

    protected String getCoreTable() {
        return "T_SD_SaleOrder";
    }

    protected String getCoreEntryTable() {
        return "T_SD_SaleOrderEntry";
    }

    public String getCoreBosType() {
        return this.coreBosType;
    }

    public void setCoreBosType(String coreBosType) {
        this.coreBosType = coreBosType;
    }

    public boolean isOrderSupport() {
        return this.isOrderSupport;
    }

    public void setOrderSupport(boolean isOrderSupport) {
        this.isOrderSupport = isOrderSupport;
    }
}

