/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.writeback.WriteBackDefInfo;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReqSQLHelper;
import com.kingdee.eas.tm.im.common.writeback.app.handler.TempTableDisposer;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public abstract class InvoiceReqDisposer
extends TempTableDisposer {
    private static Logger logger = Logger.getLogger(InvoiceReqDisposer.class);
    private WriteBackDefInfo writeBackDefInfo = null;
    private String srcBosType = null;
    private int disposeType = 1;

    public InvoiceReqDisposer() {
        this(1);
    }

    public InvoiceReqDisposer(int disposeType) {
        this.disposeType = disposeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDispose(Context ctx, String action, String destId) throws EASBizException, BOSException, SQLException {
        LowTimer totalTimer = new LowTimer();
        LowTimer timer = new LowTimer();
        logger.debug((Object)("\u3010" + this.getClass().getName() + "\u3011\u5f00\u59cb\uff1a"));
        this.init(ctx, action, destId);
        String tablename = null;
        int bizDirection = this.getBizDirection(action);
        try {
            tablename = this.createTempTable(ctx, destId);
            logger.debug((Object)("\u3010\u521b\u5efa\u4e34\u65f6\u8868 \u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
            this.insertInitData(tablename, destId);
            logger.debug((Object)("\u3010\u63d2\u5165\u521d\u59cb\u5316\u6570\u636e \u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
            if (!this.verify(ctx, tablename)) {
                return;
            }
            this.lockBill(tablename, destId);
            logger.debug((Object)("\u3010\u9501\u5355\u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
            this.updateInvoiceReq(ctx, destId, tablename, bizDirection);
            logger.debug((Object)("\u3010\u66f4\u65b0\u5f00\u7968\u7533\u8bf7\u5230\u4e34\u65f6\u8868\u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
            this.updateSrcBill(bizDirection, tablename);
            logger.debug((Object)("\u3010\u66f4\u65b0\u6e90\u5355\u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
            if (this.isNeedCancelBOTRelation(action)) {
                this.cancelBOTRelation(destId, tablename);
                logger.debug((Object)("\u3010\u4f5c\u5e9fBOT\u5173\u7cfb\u3011\u82b1\u8d39:" + timer.msValue()));
                timer.reset();
            }
            if (this.isNeedUpdateIsMakeInvoiceReq()) {
                this.updateIsMakeInvoiceReq(ctx, action, destId, tablename, bizDirection);
                logger.debug((Object)("\u3010\u66f4\u65b0\u662f\u5426\u5df2\u5f00\u7968\u7533\u8bf7\u6807\u8bc6\u3011\u82b1\u8d39:" + timer.msValue()));
                timer.reset();
            }
            this.cascadeDispose(ctx, action, destId);
            logger.debug((Object)("\u3010\u5173\u8054\u53cd\u5199\u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
            this.doOther(ctx, action, destId, tablename, bizDirection);
            logger.debug((Object)("\u3010\u6267\u884c\u5176\u4ed6\u64cd\u4f5c\u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
            if (bizDirection == 0) {
                this.verify(ctx, destId, tablename);
                logger.debug((Object)("\u3010\u68c0\u9a8c\u5408\u6cd5\u6027\u3011\u82b1\u8d39:" + timer.msValue()));
                timer.reset();
            }
        }
        finally {
            if (tablename != null) {
                try {
                    this.releaseTable(ctx, tablename);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            logger.debug((Object)("\u3010" + this.getClass().getName() + "\u3011 \u7ed3\u675f\uff0c\u603b\u8017\u65f6:" + totalTimer.msValue()));
        }
    }

    protected void doSrcBillDiffer(int bizDirection, String tablename) throws SQLException {
        String[] sqls = InvoiceReqSQLHelper.getUpdateSrcBillDifferSQL(bizDirection, tablename, this.getSrcTable(), this.getSrcEntryTable());
        String sql = null;
        int size = sqls.length;
        for (int i = 0; i < size; ++i) {
            sql = sqls[i];
            PreparedStatement ps = this.createPreparedStatement("doSrcBillDiffer" + i, sql);
            this.executeUpdate(ps, null);
        }
    }

    protected String getSrcTable() {
        return null;
    }

    protected String getSrcEntryTable() {
        return null;
    }

    protected String getSrcBosType() {
        return this.srcBosType;
    }

    protected boolean isNeedUpdateIsMakeInvoiceReq() {
        return false;
    }

    protected boolean isNeedCancelBOTRelation(String action) {
        return this.writeBackDefInfo != null && "AC368D2D".equals(this.writeBackDefInfo.getDestBillBosType()) && ("cancel".equals(action) || "delete".equals(action));
    }

    protected void init(Context ctx, String action, String destId) throws BOSException, EASBizException {
        if (this.getDisposeType() == 1) {
            this.writeBackDefInfo = (WriteBackDefInfo)ctx.get((Object)"CTX_WRITEBACKDEFINFO");
            this.srcBosType = this.writeBackDefInfo.getSrcBillBosType();
        }
    }

    protected int getBizDirection(String action) throws EASBizException, BOSException {
        int bizDirection = 0;
        Object[] forward = new String[]{"addnew", "save", "submit", "audit"};
        Object[] reverse = new String[]{"delete", "unaudit", "cancel"};
        Object[] restore = new String[]{"restore"};
        if (Arrays.asList((Object[])forward).indexOf(action) > -1) {
            bizDirection = 0;
        } else if (Arrays.asList((Object[])reverse).indexOf(action) > -1) {
            bizDirection = 1;
        } else if (Arrays.asList((Object[])restore).indexOf(action) > -1) {
            bizDirection = -1;
        } else {
            throw new BOSException("action is illegal");
        }
        return bizDirection;
    }

    protected String createTempTable(Context ctx, String destID) throws EASBizException, BOSException, SQLException {
        String tablename = this.getTableName(ctx, InvoiceReqDisposer.class.getName());
        String createSQL = this.getCreateTempTableSQL(tablename);
        this.createTable(ctx, createSQL);
        return tablename;
    }

    protected boolean verify(Context ctx, String tablename) throws BOSException, SQLException {
        boolean success = false;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select 1 from ").append(tablename);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        if (rs.next()) {
            success = true;
        }
        return success;
    }

    protected String getCreateTempTableSQL(String tablename) {
        String createSQL = InvoiceReqSQLHelper.getCreateTempTableSQL(tablename);
        return createSQL;
    }

    protected void insertInitData(String tableName, String destId) throws SQLException {
        String sql = this.getInitSelectSQL(destId, tableName);
        PreparedStatement ps = this.createPreparedStatement("insertInitData", sql);
        this.executeUpdate(ps, null);
    }

    protected String getInitSelectSQL(String destId, String tableName) {
        String sql = InvoiceReqSQLHelper.getInitSelectSQL(destId, tableName, this.getSrcTable(), this.getSrcEntryTable());
        return sql;
    }

    protected void lockBill(String tablename, String destId) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + this.getSrcEntryTable() + " set FID = FID where FID in(");
        sql.append("SELECT FSourceBillEntryId FROM ").append(tablename).append(")");
        PreparedStatement ps = this.createPreparedStatement("lockBill", sql.toString());
        this.executeUpdate(ps, null);
    }

    protected void updateInvoiceReq(Context ctx, String destId, String tablename, int bizDirection) throws EASBizException, BOSException, SQLException {
        this.updateInvoiceReq2Src(ctx, destId, tablename, bizDirection);
    }

    protected void updateInvoiceReq2Src(Context ctx, String destID, String tableName, int bizDirection) throws SQLException {
        String sql = this.getUpdateInvoiceReq2SrcSQL(destID, tableName, bizDirection);
        PreparedStatement ps = this.createPreparedStatement("updateInvoiceReq2Src", sql);
        this.executeUpdate(ps, null);
    }

    protected String getUpdateInvoiceReq2SrcSQL(String destID, String tableName, int bizDirection) {
        String sql = InvoiceReqSQLHelper.getUpdateInvoiceReq2SrcSQL(destID, tableName, this.getSrcTable(), this.getSrcEntryTable(), bizDirection, this.getDisposeType());
        return sql;
    }

    protected void updateSrcBill(int bizDirection, String tablename) throws SQLException {
        String sql = this.getUpdateSrcBillSQL(bizDirection, tablename);
        PreparedStatement ps = this.createPreparedStatement("UPDATE_SRCBILL", sql);
        this.executeUpdate(ps, null);
    }

    protected String getUpdateSrcBillSQL(int bizDirection, String tablename) {
        String sql = InvoiceReqSQLHelper.getUpdateSrcBillSQL(bizDirection, tablename, this.getSrcTable(), this.getSrcEntryTable());
        return sql;
    }

    protected void cascadeDispose(Context ctx, String action, String destId) throws EASBizException, BOSException {
    }

    protected void doOther(Context ctx, String action, String destId, String tablename, int bizDirection) throws EASBizException, BOSException, SQLException {
    }

    protected void updateIsMakeInvoiceReq(Context ctx, String action, String destId, String tablename, int bizDirection) throws SQLException, BOSException {
        if (bizDirection == -1 || this.getDisposeType() != 1 && this.getDisposeType() != 4 && this.getDisposeType() != 5) {
            return;
        }
        int isMakeInvoiceReq = 0;
        if (bizDirection == 1) {
            String selectSql = this.getSelectSrcInvoiceFlagSQL(destId, tablename, bizDirection);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
            if (rs.next()) {
                isMakeInvoiceReq = 1;
            }
        } else if (bizDirection == 0) {
            isMakeInvoiceReq = 1;
        }
        String updateSql = this.getUpdateSrcInvoiceFlagSQL(destId, tablename, isMakeInvoiceReq);
        PreparedStatement ps = this.createPreparedStatement("updateIsMakeInvoiceReq", updateSql);
        this.executeUpdate(ps, null);
    }

    protected String getSelectSrcInvoiceFlagSQL(String destId, String tablename, int bizDirection) {
        return InvoiceReqSQLHelper.getSelectSrcInvoiceFlagSQL(destId, tablename, this.getSrcTable(), this.getSrcEntryTable(), this.getSrcBosType(), bizDirection);
    }

    protected String getUpdateSrcInvoiceFlagSQL(String destId, String tablename, int isMakeInvoiceReq) {
        return InvoiceReqSQLHelper.getUpdateSrcInvoiceFlagSQL(destId, tablename, isMakeInvoiceReq, this.getSrcTable(), this.getSrcEntryTable());
    }

    protected void cancelBOTRelation(String destId, String tablename) throws EASBizException, BOSException, SQLException {
        String sql = this.getUpdateBOTRelatoinSQL(destId, tablename);
        PreparedStatement ps = this.createPreparedStatement("updateBOTRelation", sql);
        this.executeUpdate(ps, null);
    }

    protected String getUpdateBOTRelatoinSQL(String destId, String tablename) {
        return InvoiceReqSQLHelper.getUpdateBOTRelatoinSQL(destId, tablename, this.getSrcBosType());
    }

    protected void verify(Context ctx, String destId, String tablename) throws EASBizException, SQLException {
        String sql = this.getVerifySQL(destId, tablename);
        PreparedStatement ps = this.createPreparedStatement("verify", sql);
        IRowSet rs = this.executeQuery(ps, null);
        InvoiceReqSQLHelper.verifyWriteBack(ctx, rs);
    }

    protected String getVerifySQL(String destId, String tablename) {
        return InvoiceReqSQLHelper.createWriteBackVerifySQL(destId, tablename, this.getSrcTable(), this.getSrcEntryTable());
    }

    public WriteBackDefInfo getWriteBackDefInfo() {
        return this.writeBackDefInfo;
    }

    public void setWriteBackDefInfo(WriteBackDefInfo writeBackDefInfo) {
        this.writeBackDefInfo = writeBackDefInfo;
    }

    public int getDisposeType() {
        return this.disposeType;
    }

    public void setDisposeType(int disposeType) {
        this.disposeType = disposeType;
    }

    public void setSrcBosType(String srcBosType) {
        this.srcBosType = srcBosType;
    }
}

