/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback.app.handler;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.MakeInvoiceReqBillTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

public final class InvoiceReqSQLHelper {
    public static final String NEWLINE = "\n";

    public static String getCreateTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ").append(NEWLINE);
        sql.append(temptable).append(NEWLINE);
        sql.append("(").append(NEWLINE);
        sql.append("FSourceBillEntryId VARCHAR(44),").append(NEWLINE);
        sql.append("FQty DECIMAL(21,8),").append(NEWLINE);
        sql.append("FBaseQty DECIMAL(21,8),").append(NEWLINE);
        sql.append("FAmount DECIMAL(21,8),").append(NEWLINE);
        sql.append("FAmountLocal DECIMAL(21,8)").append(NEWLINE);
        sql.append(")").append(NEWLINE);
        return sql.toString();
    }

    public static String getInitSelectSQL(String destId, String tableName, String srcTable, String srcEntryTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tableName).append(NEWLINE);
        sql.append("SELECT srcEntry.FID as FSourceBillEntryId,").append(NEWLINE);
        sql.append("0,0,0,0").append(NEWLINE);
        sql.append("FROM " + srcTable + " src ").append(NEWLINE);
        sql.append("INNER JOIN " + srcEntryTable + " srcEntry on src.fid = srcEntry.fparentid").append(NEWLINE);
        sql.append("INNER JOIN T_IM_MakeInvoiceReqEntry destEntry on destEntry.FSourceBillEntryId = srcEntry.fid").append(NEWLINE);
        sql.append("WHERE destEntry.FParentID ='").append(destId).append("'").append(NEWLINE);
        sql.append("GROUP BY srcEntry.FID");
        return sql.toString();
    }

    public static String getUpdateInvoiceReq2SrcSQL(String destId, String tableName, String srcTable, String srcEntryTable, int bizDirection, int disposeType) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(tableName).append(" as t ").append(NEWLINE);
        sql.append("SET (FQty,FBaseQty,FAmount,FAmountLocal ) = (").append(NEWLINE);
        sql.append(" SELECT preReq.FQty,preReq.FBaseQty,").append(NEWLINE);
        sql.append(" preReq.FAmount,preReq.FAmountLocal ").append(NEWLINE);
        sql.append(" FROM ").append(tableName).append(" tmp").append(NEWLINE);
        sql.append("INNER JOIN (").append(NEWLINE);
        sql.append(" SELECT destEntry.FSourceBillEntryId,").append(NEWLINE);
        if ("T_SD_SaleOrderEntry".equalsIgnoreCase(srcEntryTable)) {
            sql.append(" SUM(CASE WHEN destEntry.FUnitID = srcEntry.FUnitID THEN destEntry.FQty").append(NEWLINE);
        } else {
            sql.append(" SUM(CASE WHEN destEntry.FUnitID = srcEntry.FMeasureUnitID THEN destEntry.FQty").append(NEWLINE);
        }
        sql.append(" WHEN destEntry.FUnitID is null THEN destEntry.FQty").append(NEWLINE);
        sql.append(" ELSE ROUND(DECIMAL(destEntry.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) end) as FQty,").append(NEWLINE);
        sql.append(" SUM(destEntry.FBaseQty) as FBaseQty,").append(NEWLINE);
        sql.append(" SUM(CASE WHEN dest.FCurrencyID = src.FCurrencyID then destEntry.FPriceIncludingTax").append(NEWLINE);
        sql.append(" WHEN ISNULL(aux.FConvertMode,0)=0 THEN ROUND(DECIMAL((destEntry.FPriceIncludingTaxLocal)/ISNULL(src.FExchangeRate, 1),21,8),currency.FPrecision)").append(NEWLINE);
        sql.append(" ELSE ROUND(DECIMAL((destEntry.FPriceIncludingTaxLocal)*ISNULL(src.FExchangeRate, 1),21,8),currency.FPrecision) END) as FAmount,").append(NEWLINE);
        sql.append(" SUM(destEntry.FPriceIncludingTaxLocal) as FAmountLocal").append(NEWLINE);
        sql.append(" FROM ").append(tableName).append(" tmp ").append(NEWLINE);
        sql.append(" INNER JOIN " + srcEntryTable + " srcEntry ON tmp.FSourceBillEntryId = srcEntry.FId ").append(NEWLINE);
        sql.append(" INNER JOIN " + srcTable + " src on src.fid = srcEntry.fparentid").append(NEWLINE);
        sql.append(" INNER JOIN T_IM_MakeInvoiceReqEntry destEntry on destEntry.FSourceBillEntryId = srcEntry.fid").append(NEWLINE);
        sql.append(" INNER JOIN T_IM_MakeInvoiceReq dest ON dest.FID = destEntry.FParentID").append(NEWLINE);
        sql.append(" INNER JOIN T_BD_Currency currency on currency.fid = src.FCurrencyID").append(NEWLINE);
        if ("T_SD_SaleOrderEntry".equalsIgnoreCase(srcEntryTable)) {
            sql.append(" LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID = srcEntry.FMaterialID and mmu.FMeasureUnitID = srcEntry.FUnitID ").append(NEWLINE);
            sql.append(" INNER JOIN T_ORG_Company company ON company.FID = src.FCompanyOrgUnitID").append(NEWLINE);
        } else {
            sql.append(" LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID = srcEntry.FMaterialID and mmu.FMeasureUnitID = srcEntry.FMeasureUnitID ").append(NEWLINE);
            sql.append(" INNER JOIN T_ORG_Company company ON company.FID = src.FCompanyID").append(NEWLINE);
        }
        sql.append(" LEFT JOIN t_bd_exchangeaux aux ON aux.FSOURCECURRENCYID = src.FCurrencyID").append(NEWLINE);
        sql.append("  AND aux.FTARGETCURRENCYID = company.FBaseCurrencyID and aux.FExchangeTableId = company.FBaseExgTableID").append(NEWLINE);
        sql.append(" WHERE 1=1").append(NEWLINE);
        if (bizDirection != 0 && disposeType == 1) {
            sql.append(" and dest.FID <> '").append(destId).append("'").append(NEWLINE);
        }
        sql.append(" and dest.FStatus <> 3").append(NEWLINE);
        sql.append(" GROUP BY destEntry.FSourceBillEntryId ").append(NEWLINE);
        sql.append(" ) preReq  ON tmp.FSourceBillEntryId = preReq.FSourceBillEntryId").append(NEWLINE);
        sql.append("where t.FSourceBillEntryId = tmp.FSourceBillEntryId )").append(NEWLINE);
        return sql.toString();
    }

    public static String getUpdateSrcBillSQL(int bizDirection, String tableName, String srcTable, String srcEntryTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + srcEntryTable + " AS t SET (").append(NEWLINE);
        sql.append("FInvoiceReqQty,FInvoiceReqBaseQty,FUnInvoiceReqQty,FUnInvoiceReqBaseQty,").append(NEWLINE);
        sql.append("FInvoiceReqAmount,FInvoiceReqAmountLocal,FUnInvoiceReqAmount,FUnInvoiceReqAmountLocal)=").append(NEWLINE);
        sql.append("(SELECT ").append(NEWLINE);
        if ("T_SD_SaleOrderEntry".equalsIgnoreCase(srcEntryTable)) {
            sql.append(" tmp.FQty,").append(NEWLINE);
            sql.append(" tmp.FBaseQty,").append(NEWLINE);
            sql.append(" t.FQty- tmp.FQty,").append(NEWLINE);
            sql.append(" t.FBaseQty - tmp.FBaseQty,").append(NEWLINE);
            sql.append(" tmp.FAmount,").append(NEWLINE);
            sql.append(" tmp.FAmountLocal,").append(NEWLINE);
            sql.append(" t.FTaxAmount - tmp.FAmount,").append(NEWLINE);
            sql.append(" t.FLocalTaxAmount - tmp.FAmountLocal").append(NEWLINE);
        } else {
            sql.append(" tmp.FQty,").append(NEWLINE);
            sql.append(" tmp.FBaseQty,").append(NEWLINE);
            sql.append(" t.FQuantity- tmp.FQty,").append(NEWLINE);
            sql.append(" t.FBaseQty - tmp.FBaseQty,").append(NEWLINE);
            sql.append(" tmp.FAmount,").append(NEWLINE);
            sql.append(" tmp.FAmountLocal,").append(NEWLINE);
            sql.append(" t.FRecievePayAmount - tmp.FAmount,").append(NEWLINE);
            sql.append(" t.FRecievePayAmountLocal - tmp.FAmountLocal").append(NEWLINE);
        }
        sql.append(" FROM " + tableName + " tmp WHERE tmp.FSourceBillEntryId = t.FID )").append(NEWLINE);
        sql.append(" WHERE t.FID in (select FSourceBillEntryId from " + tableName + ")");
        return sql.toString();
    }

    public static String[] getUpdateSrcBillDifferSQL(int bizDirection, String tableName, String srcTable, String srcEntryTable) {
        String qtyField = "FQuantity";
        String amountField = "FRecievePayAmount";
        if ("T_SD_SaleOrderEntry".equalsIgnoreCase(srcEntryTable)) {
            qtyField = "FQty";
            amountField = "FTaxAmount";
        }
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE ").append(srcEntryTable).append(" SET FInvoiceReqQty=" + qtyField + ",FUnInvoiceReqQty=0 WHERE FUnInvoiceReqBaseQty = 0 and FUnInvoiceReqQty <>0");
        sql.append(" and FID in (").append("SELECT FSourceBillEntryId from ").append(tableName).append(")");
        sqls.add(sql.toString());
        sql.setLength(0);
        sql.append(" UPDATE ").append(srcEntryTable).append(" SET FInvoiceReqAmount=" + amountField + ",FUnInvoiceReqAmount=0 WHERE FUnInvoiceReqAmountLocal = 0 and FUnInvoiceReqAmount <>0");
        sql.append(" and FID in (").append("SELECT FSourceBillEntryId from ").append(tableName).append(")");
        sqls.add(sql.toString());
        String[] strSqls = new String[sqls.size()];
        return sqls.toArray(strSqls);
    }

    public static String createWriteBackVerifySQL(String destId, String tablename, String srcTable, String srcEntryTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT 1 as FErrType, dest.FSourceBillType as sourceBillType,src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq").append(NEWLINE);
        sql.append("FROM " + srcTable + " src").append(NEWLINE);
        sql.append("INNER JOIN " + srcEntryTable + " srcEntry ON src.FID=srcEntry.FParentID").append(NEWLINE);
        sql.append("INNER JOIN T_IM_MakeInvoiceReqEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID").append(NEWLINE);
        sql.append("INNER JOIN T_IM_MakeInvoiceReq dest ON dest.FID=destEntry.FParentID").append(NEWLINE);
        sql.append("WHERE dest.FID ='").append(destId).append("'").append(NEWLINE);
        sql.append("AND ((srcEntry.FUnInvoiceReqBaseQty < 0 and srcEntry.FBaseQty>0) ").append(NEWLINE);
        sql.append("OR (srcEntry.FUnInvoiceReqBaseQty > 0 and srcEntry.FBaseQty<0)").append(NEWLINE);
        sql.append("OR (srcEntry.FUnInvoiceReqBaseQty <> 0 and srcEntry.FBaseQty=0))").append(NEWLINE);
        if (sql.length() > 0) {
            sql.append("UNION ALL").append(NEWLINE);
        }
        sql.append("SELECT 2 as FErrType, dest.FSourceBillType as sourceBillType,src.FNumber as srcNumber, srcEntry.FSeq as srcSeq, dest.FNumber as destNumber, destEntry.FSeq as destSeq").append(NEWLINE);
        sql.append("FROM " + srcEntryTable + " srcEntry").append(NEWLINE);
        sql.append("INNER JOIN " + srcTable + " src ON src.FID=srcEntry.FParentID ").append(NEWLINE);
        sql.append("INNER JOIN T_IM_MakeInvoiceReqEntry destEntry ON destEntry.FSourceBillEntryId=srcEntry.FID ").append(NEWLINE);
        sql.append("INNER JOIN T_IM_MakeInvoiceReq dest ON dest.FID=destEntry.FParentID ").append(NEWLINE);
        sql.append("WHERE dest.FID ='").append(destId).append("'").append(NEWLINE);
        if ("T_SD_SaleOrderEntry".equalsIgnoreCase(srcEntryTable)) {
            sql.append("AND ((srcEntry.FUnInvoiceReqAmountLocal < 0 and srcEntry.FLocalTaxAmount>0) ").append(NEWLINE);
            sql.append("OR (srcEntry.FUnInvoiceReqAmountLocal > 0 and srcEntry.FLocalTaxAmount<0)").append(NEWLINE);
            sql.append("OR (srcEntry.FUnInvoiceReqAmountLocal <> 0 and srcEntry.FLocalTaxAmount=0))").append(NEWLINE);
        } else {
            sql.append("AND ((srcEntry.FUnInvoiceReqAmountLocal < 0 and srcEntry.FRecievePayAmountLocal>0) ").append(NEWLINE);
            sql.append("OR (srcEntry.FUnInvoiceReqAmountLocal > 0 and srcEntry.FRecievePayAmountLocal<0)").append(NEWLINE);
            sql.append("OR (srcEntry.FUnInvoiceReqAmountLocal <> 0 and srcEntry.FRecievePayAmountLocal=0))").append(NEWLINE);
        }
        return sql.toString();
    }

    public static void verifyWriteBack(Context ctx, IRowSet rs) throws SQLException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.common.writeback.InvoiceWBResource", (String)"InvoiceReqWriteBackFailure", (Locale)ctx.getLocale())).append(NEWLINE);
        boolean isError = false;
        String srcAlias = "";
        String destAlias = "";
        if (rs.next()) {
            isError = true;
            switch (rs.getInt("FErrType")) {
                case 1: {
                    errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.common.writeback.InvoiceWBResource", (String)"WriteBackQtyOver", (Locale)ctx.getLocale())).append(NEWLINE);
                    break;
                }
                case 2: {
                    errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.common.writeback.InvoiceWBResource", (String)"WriteBackAmountOver", (Locale)ctx.getLocale())).append(NEWLINE);
                }
            }
            String sourceBillType = rs.getString("sourceBillType");
            srcAlias = MakeInvoiceReqBillTypeEnum.getEnum(sourceBillType).getAlias();
            destAlias = ResourceBase.getString((String)"com.kingdee.eas.tm.im.common.writeback.InvoiceWBResource", (String)"MakeInvoiceReq", (Locale)ctx.getLocale());
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.common.writeback.InvoiceWBResource", (String)"WriteBackDetailErrorMsg", (Locale)ctx.getLocale(), (Object[])new Object[]{srcAlias, rs.getString("srcNumber"), rs.getInt("srcSeq"), destAlias, rs.getString("destNumber"), rs.getInt("destSeq")})).append(NEWLINE);
        }
        if (isError) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    public static String getUpdateBOTRelatoinSQL(String destId, String temptable, String srcBosType) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_BOT_Relation set FType = 99").append(NEWLINE);
        sql.append("WHERE FSRCENTITYID ='" + srcBosType + "' and FDESTENTITYID ='" + "AC368D2D" + "'").append(NEWLINE);
        sql.append("and FDESTOBJECTID ='").append(destId).append("'").append(NEWLINE);
        return sql.toString();
    }

    public static String getSelectSrcInvoiceFlagSQL(String destId, String tableName, String srcTable, String srcEntryTable, String srcBosType, int bizDirection) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT 1 FROM T_BOT_Relation").append(NEWLINE);
        sql.append("WHERE FSRCENTITYID ='" + srcBosType + "' and FDESTENTITYID ='" + "AC368D2D" + "'").append(NEWLINE);
        sql.append("AND FTYPE = 0").append(NEWLINE);
        sql.append("AND FSRCOBJECTID  in (");
        sql.append(" SELECT FParentID FROM ").append(srcEntryTable).append(NEWLINE);
        sql.append(" WHERE FID in (");
        sql.append(" SELECT FSourceBillEntryId FROM T_IM_MakeInvoiceReqEntry");
        sql.append(" WHERE FParentID = '").append(destId).append("')");
        sql.append(")");
        if (bizDirection == 1) {
            sql.append(" and FDESTOBJECTID <> '").append(destId).append("'").append(NEWLINE);
        }
        return sql.toString();
    }

    public static String getUpdateSrcInvoiceFlagSQL(String destId, String tableName, int isMakeInvoiceReq, String srcTable, String srcEntryTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE " + srcTable + " AS t1 SET ").append(NEWLINE);
        sql.append("FIsMakeInvoiceReq=").append(isMakeInvoiceReq).append(NEWLINE);
        sql.append("WHERE t1.fid IN (").append(NEWLINE);
        sql.append(" SELECT FParentID FROM ").append(srcEntryTable).append(NEWLINE);
        sql.append(" WHERE FID in (");
        sql.append(" SELECT FSourceBillEntryId FROM T_IM_MakeInvoiceReqEntry");
        sql.append(" WHERE FParentID = '").append(destId).append("')");
        sql.append(")");
        return sql.toString();
    }
}

