/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class TempTableDisposer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.writeback.app.handler.TempTableDisposer");
    Connection con = null;
    Map psMap = null;

    public void dispose(Context ctx, String action, String destID) throws EASBizException, BOSException {
        try {
            this.initConnection(ctx);
            this.doDispose(ctx, action, destID);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            this.cleanup();
        }
    }

    protected abstract void doDispose(Context var1, String var2, String var3) throws EASBizException, BOSException, SQLException;

    protected void initConnection(Context ctx) throws SQLException {
        if (this.con == null) {
            this.con = EJBFactory.getConnection((Context)ctx);
            this.psMap = new HashMap();
        }
    }

    protected void cleanup() {
        Iterator iter = this.psMap.keySet().iterator();
        while (iter.hasNext()) {
            SQLUtils.cleanup((Statement)((PreparedStatement)this.psMap.get(iter.next())));
        }
        SQLUtils.cleanup((Connection)this.con);
    }

    protected final IRowSet executeQuery(PreparedStatement ps, Object[] params) throws SQLException {
        if (ps == null) {
            return null;
        }
        ResultSet rs = null;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
        }
        rs = ps.executeQuery();
        JdbcRowSet rowset = new JdbcRowSet();
        rowset.populate(rs);
        return rowset;
    }

    protected final PreparedStatement createPreparedStatement(String key, String sql) throws SQLException {
        if (this.psMap.containsKey(key)) {
            return (PreparedStatement)this.psMap.get(key);
        }
        PreparedStatement ps = this.con.prepareStatement(sql);
        this.psMap.put(key, ps);
        return ps;
    }

    protected final PreparedStatement getPreparedStatement(String key) throws SQLException {
        return (PreparedStatement)this.psMap.get(key);
    }

    protected final void executeUpdate(PreparedStatement ps, Object[] params) throws SQLException {
        if (ps == null) {
            return;
        }
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
        }
        ps.execute();
        if (ps != null) {
            ps.close();
        }
    }

    protected final String getTableName(Context ctx, String classAlias) throws SQLException {
        return TableManager.getTableManager((Context)ctx).getTableName(classAlias);
    }

    protected final void createTable(Context ctx, String sql) throws BOSException, SQLException {
        try {
            TableManager.getTableManager((Context)ctx).createTable(sql);
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected final void releaseTable(Context ctx, String tablename) throws SQLException {
        TableManager.getTableManager((Context)ctx).releaseTable(tablename);
    }
}

