/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.UsedCarMakeInvoiceFactory;
import com.kingdee.eas.tm.im.UsedCarMakeInvoiceInfo;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceBaseDisposer;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReserveUtils;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UsedCarInvoice2InvoiceReqDisposer
extends InvoiceBaseDisposer {
    public void dispose(Context ctx, String action, String destID) throws EASBizException, BOSException {
        UsedCarMakeInvoiceInfo invoice = UsedCarMakeInvoiceFactory.getLocalInstance(ctx).getUsedCarMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(destID));
        InvoiceBaseDisposer.InvoiceInfo invoiceInfo = new InvoiceBaseDisposer.InvoiceInfo();
        invoiceInfo.setInvoiceNumber(invoice.getInvoiceNumber());
        invoiceInfo.setInvoiceNo(invoice.getInvoiceNo());
        invoiceInfo.setInvoiceDate(invoice.getInvoiceDate());
        invoiceInfo.setInvoiceAmt(invoice.getPriceTaxTotal());
        if (!StringUtils.isEmpty((String)invoice.getRedBillId())) {
            UsedCarMakeInvoiceInfo blueInvoice = UsedCarMakeInvoiceFactory.getLocalInstance(ctx).getUsedCarMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoice.getRedBillId()));
            invoiceInfo.setBuleInvoiceDate(blueInvoice.getInvoiceDate());
        }
        int bizAction = this.getBizAction(action);
        int bizDirection = this.getBizDirection(invoiceInfo, bizAction);
        HashMap<String, BigDecimal> destAmtMap = new HashMap<String, BigDecimal>();
        destAmtMap.put(invoice.getId().toString(), invoice.getPriceTaxTotal());
        String invoiceId = invoice.getId().toString();
        String selectSql = this.getSelectReqSql(bizDirection);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{invoiceId});
        try {
            HashMap<String, String> unique = new HashMap<String, String>();
            String updateSql = "update T_IM_UsedCarInvoiceReqEntry set FInvoiceCode=?,FInvoiceNo=? where fid=?";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            HashSet<String> srcIdSet = new HashSet<String>();
            while (rs.next()) {
                String srcID = rs.getString("srcID");
                if (unique.containsKey(srcID)) continue;
                srcIdSet.add(srcID);
                String invoiceCode = rs.getString("invoiceCode");
                String invoiceNo = rs.getString("invoiceNo");
                if (bizAction == 0) {
                    invoiceCode = this.merge(invoiceCode, invoice.getInvoiceNumber());
                    invoiceNo = this.merge(invoiceNo, invoice.getInvoiceNo());
                } else {
                    invoiceCode = this.reduce(invoiceCode, invoice.getInvoiceNumber());
                    invoiceNo = this.reduce(invoiceNo, invoice.getInvoiceNo());
                }
                Object[] param = new Object[]{invoiceCode, invoiceNo, srcID};
                paramList.add(param);
                unique.put(srcID, srcID);
            }
            if (paramList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
            }
            Map result = this.buildSrcAmtMap(ctx, rs, destAmtMap, bizAction, bizDirection);
            Map curAmtMap = (Map)result.get("curAmtMap");
            Map totalAmtMap = (Map)result.get("totalAmtMap");
            ArrayList<Object[]> paramAmtList = new ArrayList<Object[]>();
            String updateAmtSql = " update T_IM_UsedCarInvoiceReqEntry set FInvoicedAmt=? where fid=?";
            ArrayList<Object[]> paramMarkList = new ArrayList<Object[]>();
            String updateMarkSql = " update T_IM_UsedCarInvoiceReqEntry set FInvoiceDate=?,FIsInvoiced=? where fid=?";
            for (String billID : totalAmtMap.keySet()) {
                BigDecimal invoiceAmt = (BigDecimal)totalAmtMap.get(billID);
                if (invoiceAmt.compareTo(BigDecimal.ZERO) == 0) {
                    Object[] paramMark = new Object[]{null, 0, billID};
                    paramMarkList.add(paramMark);
                } else {
                    Date invoiceDate = invoiceInfo.getInvoiceDate(bizAction);
                    int isInvoiced = 1;
                    Object[] paramMark = new Object[]{invoiceDate, isInvoiced, billID};
                    paramMarkList.add(paramMark);
                }
                Object[] paramAmt = new Object[]{invoiceAmt, billID};
                paramAmtList.add(paramAmt);
            }
            if (paramAmtList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateAmtSql, paramAmtList);
            }
            if (paramMarkList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateMarkSql, paramMarkList);
            }
            if (srcIdSet.size() > 0 && InvoiceReserveUtils.isUsedCar2ArSupport(ctx)) {
                this.dispose2ArUsedCarFields(ctx, invoiceInfo, srcIdSet, curAmtMap, bizAction, bizDirection);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void dispose2ArUsedCarFields(Context ctx, InvoiceBaseDisposer.InvoiceInfo invoice, Set destIdSet, Map<String, BigDecimal> reqCurAmtMap, int bizAction, int bizDirection) throws BOSException {
        String selectArSql = this.getSelectArSql(destIdSet, bizDirection);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectArSql);
        if (rs.size() == 0) {
            return;
        }
        try {
            HashMap<String, String> unique = new HashMap<String, String>();
            String updateSql = "update t_ar_otherbill set FUsedCarInvoiceCode=?,FUsedCarNumber=? where fid=?";
            HashSet<String> srcIdSet = new HashSet<String>();
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            while (rs.next()) {
                String srcID = rs.getString("srcID");
                if (unique.containsKey(srcID)) continue;
                srcIdSet.add(srcID);
                String invoiceCode = rs.getString("invoiceCode");
                String invoiceNo = rs.getString("invoiceNo");
                if (bizAction == 0) {
                    invoiceCode = this.merge(invoiceCode, invoice.getInvoiceNumber());
                    invoiceNo = this.merge(invoiceNo, invoice.getInvoiceNo());
                } else {
                    invoiceCode = this.reduce(invoiceCode, invoice.getInvoiceNumber());
                    invoiceNo = this.reduce(invoiceNo, invoice.getInvoiceNo());
                }
                Object[] param = new Object[]{invoiceCode, invoiceNo, srcID};
                paramList.add(param);
                unique.put(srcID, srcID);
            }
            if (paramList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
            }
            Map result = this.buildSrcAmtMap(ctx, rs, reqCurAmtMap, bizAction, bizDirection);
            Map curAmtMap = (Map)result.get("curAmtMap");
            Map totalAmtMap = (Map)result.get("totalAmtMap");
            ArrayList<Object[]> paramAmtList = new ArrayList<Object[]>();
            String updateAmtSql = " update t_ar_otherbill set FUsedCarIssuedInvoiceAmount=? where fid=?";
            ArrayList<Object[]> paramMarkList = new ArrayList<Object[]>();
            String updateMarkSql = " update t_ar_otherbill set FUsedCarInvoiceDate=?,FIsUsedCarInvoiceIssued=? where fid=?";
            for (String billID : totalAmtMap.keySet()) {
                BigDecimal invoiceAmt = (BigDecimal)totalAmtMap.get(billID);
                if (invoiceAmt.compareTo(BigDecimal.ZERO) == 0) {
                    Object[] paramMark = new Object[]{null, 0, billID};
                    paramMarkList.add(paramMark);
                } else {
                    Date invoiceDate = invoice.getInvoiceDate(bizAction);
                    int isInvoiced = 1;
                    Object[] paramMark = new Object[]{invoiceDate, isInvoiced, billID};
                    paramMarkList.add(paramMark);
                }
                Object[] paramAmt = new Object[]{invoiceAmt, billID};
                paramAmtList.add(paramAmt);
            }
            if (paramAmtList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateAmtSql, paramAmtList);
            }
            if (paramMarkList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateMarkSql, paramMarkList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected String getSelectReqSql(int bizDirection) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT srcEntry.FID as srcID,relationEntry.FDestObjectID as destID,").append("\n");
        sql.append(" srcEntry.FInvoiceCode as invoiceCode,srcEntry.FInvoiceNo as invoiceNo,").append("\n");
        sql.append(" srcEntry.FInvoicedAmt as invoiceAmt,srcEntry.FPriceIncludingTax as billAmount,srcEntry.FPriceIncludingTax as reqAmount,src.FAudittime as auditTime").append("\n");
        sql.append(" FROM T_IM_UsedCarInvoiceReqEntry srcEntry").append("\n");
        sql.append(" INNER JOIN T_IM_UsedCarInvoiceReq src on src.fid = srcEntry.FParentID").append("\n");
        sql.append(" INNER JOIN T_IM_MakeInvoiceRelationEntry relationEntry on srcEntry.fid = relationEntry.FSrcEntryID").append("\n");
        sql.append(" WHERE relationEntry.FDestObjectID = ?").append("\n");
        sql.append(" and srcEntry.FPriceIncludingTax<>0");
        sql.append(" ORDER BY srcEntry.fseq ").append(bizDirection == 0 ? "asc" : "desc");
        return sql.toString();
    }

    @Override
    protected String getSelectArSql(Set destIdSet, int bizDirection) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t.destID as destID,src.FID as srcID,").append("\n");
        sql.append(" src.FUsedCarInvoiceCode as invoiceCode,src.FUsedCarNumber as invoiceNo,").append("\n");
        sql.append(" src.FUsedCarIssuedInvoiceAmount as invoiceAmt,src.FAmountLocal as billAmount,t.reqAmount as reqAmount,src.FAuditDate as auditTime").append("\n");
        sql.append(" FROM  t_ar_otherbill src INNER JOIN");
        sql.append(" (SELECT srcEntry.FParentID as srcID,destEntry.FID as destID,sum(destEntry.FPriceIncludingTax) as reqAmount");
        sql.append(" from T_IM_UsedCarInvoiceReqEntry destEntry").append("\n");
        sql.append(" inner join t_ar_otherbillentry srcEntry on srcEntry.fid = destEntry.FSourceBillEntryId").append("\n");
        sql.append(" where destEntry.fid in (").append(CollectionUtil.convertSet2String(destIdSet)).append(")").append("\n");
        sql.append(" group by srcEntry.FParentID,destEntry.FID");
        sql.append(" ) t on src.fid = t.srcID");
        sql.append(" order by src.FAuditDate ").append(bizDirection == 0 ? "asc" : "desc");
        return sql.toString();
    }
}

