/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.basedata.TaxPlateInfo;
import com.kingdee.eas.tm.im.inv.CheckMethodEnum;
import com.kingdee.eas.tm.im.inv.IInvoiceCheckTask;
import com.kingdee.eas.tm.im.inv.InvoiceCheckFormEntryInfo;
import com.kingdee.eas.tm.im.inv.InvoiceCheckFormFactory;
import com.kingdee.eas.tm.im.inv.InvoiceCheckFormInfo;
import com.kingdee.eas.tm.im.inv.InvoiceCheckFormStatus;
import com.kingdee.eas.tm.im.inv.InvoiceCheckTaskEntryCollection;
import com.kingdee.eas.tm.im.inv.InvoiceCheckTaskFactory;
import com.kingdee.eas.tm.im.inv.InvoiceCheckTaskInfo;
import com.kingdee.eas.tm.im.inv.InvoiceCheckTaskStatus;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrCollection;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrEntryCollection;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrEntryInfo;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrFactory;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrInfo;
import com.kingdee.eas.tm.im.inv.app.AbstractInvoiceCheckTaskControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class InvoiceCheckTaskControllerBean
extends AbstractInvoiceCheckTaskControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.inv.app.InvoiceCheckTaskControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceCheckTaskInfo task = (InvoiceCheckTaskInfo)model;
        if (task.getCU() == null) {
            task.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.setNewNumber(ctx, task);
        super._checkNumberBlank(ctx, null, (IObjectValue)task);
        super._checkNumberDup(ctx, null, (IObjectValue)task);
        this.checkNameBlank(ctx, model);
        return super._save(ctx, model);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getInvoiceCheckTaskInfo(ctx, pk);
        }
        this._submit(ctx, (IObjectValue)model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceCheckTaskInfo task = (InvoiceCheckTaskInfo)model;
        if (task.getCU() == null) {
            task.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(task.getCU().getId().toString(), "im_invoiceCheckTask_submit");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{task.getNumber() + ":" + e.getMessage()});
        }
        if (!InvoiceCheckTaskStatus.SAVED.equals((Object)task.getStatus()) && !InvoiceCheckTaskStatus.SUBMITED.equals((Object)task.getStatus())) {
            String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_TASKSUBMIT", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{task.getNumber() + ":" + errMsg});
        }
        task.setStatus(InvoiceCheckTaskStatus.SUBMITED);
        task.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this.setNewNumber(ctx, task);
        super._checkNumberBlank(ctx, null, (IObjectValue)task);
        super._checkNumberDup(ctx, null, model);
        this.checkNameBlank(ctx, model);
        return super._submit(ctx, (IObjectValue)task);
    }

    public void setNewNumber(Context ctx, InvoiceCheckTaskInfo task) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)task.getNumber())) {
            String number = this.getNumer(ctx, task);
            task.setNumber(number);
        }
    }

    protected void checkNameBlank(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceCheckTaskInfo dataBaseInfo = (InvoiceCheckTaskInfo)model;
        String name = dataBaseInfo.getName();
        if (name == null || name.trim().equals("")) {
            throw new DataBaseException(DataBaseException.NAMENOTNULL);
        }
    }

    private String getNumer(Context ctx, InvoiceCheckTaskInfo task) throws BOSException, EASBizException {
        IInvoiceCheckTask iBillBase = InvoiceCheckTaskFactory.getLocalInstance(ctx);
        String strCompanyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = (String)task.get("number");
        task.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + strCompanyID + "'").getCU());
        int maxCycleNum = 100;
        String filterString = "where number = '" + number + "' and cu.id = '" + task.getCU().getId().toString() + "' " + (task.get("id") != null ? "and id !='" + task.get("id") + "'" : "");
        while (number == null || number.equals("") || iBillBase.exists(filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)task, task.getCU().getId().toString());
            number = iCodingRuleManager.getNumber((IObjectValue)task, ruleInfo);
            filterString = "where number = '" + number + "' and cu.id = '" + task.getCU().getId().toString() + "' " + (task.get("id") != null ? "and id !='" + task.get("id") + "'" : "");
        }
        return number;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceCheckTaskInfo task = this.getInvoiceCheckTaskInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(task.getCU().getId().toString(), "im_invoiceCheckTask_audit");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{task.getNumber() + ":" + e.getMessage()});
        }
        if (!InvoiceCheckTaskStatus.SUBMITED.equals((Object)task.getStatus())) {
            String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_TASKAUDIT", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{task.getNumber() + ":" + errMsg});
        }
        task.setStatus(InvoiceCheckTaskStatus.AUDITED);
        task.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        task.setAuditTime(new Timestamp(System.currentTimeMillis()));
        this._update(ctx, pk, (IObjectValue)task);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceCheckTaskInfo task = this.getInvoiceCheckTaskInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(task.getCU().getId().toString(), "im_invoiceCheckTask_unAudit");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{task.getNumber() + ":" + e.getMessage()});
        }
        if (!InvoiceCheckTaskStatus.AUDITED.equals((Object)task.getStatus()) || task.isIsGenerateForm()) {
            String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_TASKUNAUDIT", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{task.getNumber() + ":" + errMsg});
        }
        task.setStatus(InvoiceCheckTaskStatus.SAVED);
        task.setAuditor(null);
        task.setAuditTime(null);
        this._update(ctx, pk, (IObjectValue)task);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceCheckTaskInfo task = this.getInvoiceCheckTaskInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(task.getCU().getId().toString(), "im_invoiceCheckTask_delete");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{task.getNumber() + ":" + e.getMessage()});
        }
        if (!InvoiceCheckTaskStatus.SAVED.equals((Object)task.getStatus()) && !InvoiceCheckTaskStatus.SUBMITED.equals((Object)task.getStatus())) {
            String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_TASK_DEL", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{task.getNumber() + ":" + errMsg});
        }
        if (task.getNumber() != null) {
            String cuID = task.getCU().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)task, cuID);
            if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)task, cuID) || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)task, cuID, task.getNumber());
            }
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _genForm(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceCheckTaskInfo task = this.getInvoiceCheckTaskInfo(ctx, pk, this.getSelector());
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(task.getCU().getId().toString(), "im_invoiceCheckTask_genForm");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{task.getNumber() + ":" + e.getMessage()});
        }
        if (!InvoiceCheckTaskStatus.AUDITED.equals((Object)task.getStatus()) || task.isIsGenerateForm()) {
            String genMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_GENCHECKFORM", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{task.getNumber() + ":" + genMsg});
        }
        InvoiceCheckTaskEntryCollection coll = task.getEntry();
        HashMap<String, String> plateInfos = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            TaxPlateInfo taxPlate = coll.get(i).getTaxPlate();
            plateInfos.put(taxPlate.getId().toString(), taxPlate.getNumber());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taxPlate", plateInfos.keySet(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"0"));
        view.setFilter(filter);
        InvoiceInvMgrCollection invMgrColl = InvoiceInvMgrFactory.getLocalInstance(ctx).getInvoiceInvMgrCollection(view);
        if (invMgrColl.size() != plateInfos.size()) {
            StringBuffer plateNumber = new StringBuffer();
            for (int j = 0; j < invMgrColl.size(); ++j) {
                String plateID = invMgrColl.get(j).getTaxPlate().getId().toString();
                plateInfos.remove(plateID);
            }
            for (String number : plateInfos.values()) {
                if (plateNumber.length() > 0) {
                    plateNumber.append(", ");
                }
                plateNumber.append(number);
            }
            String genMsg = IMUtils.getString("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_GENNOMGR", ctx.getLocale(), new Object[]{plateNumber.toString()});
            throw new IMException(IMException.ERRORMSG, new Object[]{task.getNumber() + ":" + genMsg});
        }
        if (CheckMethodEnum.TaxNumber.equals((Object)task.getCheckMethod())) {
            this.genFormByTaxNumber(ctx, task, invMgrColl);
        } else {
            this.genFormByTaxPlate(ctx, task, invMgrColl);
        }
        task.setIsGenerateForm(true);
        this._update(ctx, pk, (IObjectValue)task);
    }

    private void genFormByTaxNumber(Context ctx, InvoiceCheckTaskInfo task, InvoiceInvMgrCollection invMgrColl) throws BOSException {
        try {
            InvoiceCheckFormInfo form = new InvoiceCheckFormInfo();
            String numberSuffix = this.getNumberSuffix(1);
            form.setNumber(task.getNumber() + "_" + numberSuffix);
            form.setInvoiceCheckTask(task);
            form.setTaxNumber(task.getTaxNumber());
            form.setStatus(InvoiceCheckFormStatus.UNDO);
            for (int i = 0; i < invMgrColl.size(); ++i) {
                InvoiceInvMgrInfo invMgrInfo = invMgrColl.get(i);
                InvoiceInvMgrEntryCollection invMgrEnColl = invMgrInfo.getEntry();
                for (int j = 0; j < invMgrEnColl.size(); ++j) {
                    InvoiceInvMgrEntryInfo invMgrEn = invMgrEnColl.get(j);
                    InvoiceCheckFormEntryInfo formEn = new InvoiceCheckFormEntryInfo();
                    formEn.setTaxPlate(invMgrInfo.getTaxPlate());
                    formEn.setInvoiceType(invMgrEn.getInvoiceType());
                    formEn.setInvoiceCode(invMgrEn.getInvoiceCode());
                    String firstNumber = invMgrEn.getNextNumber();
                    formEn.setFirstNumber(firstNumber);
                    String lastNumber = invMgrEn.getLastNumber();
                    formEn.setLastNumber(lastNumber);
                    formEn.setRemainderQty(Integer.valueOf(lastNumber) - Integer.valueOf(firstNumber) + 1);
                    form.getEntry().add(formEn);
                }
            }
            InvoiceCheckFormFactory.getLocalInstance(ctx).save((CoreBaseInfo)form);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void genFormByTaxPlate(Context ctx, InvoiceCheckTaskInfo task, InvoiceInvMgrCollection invMgrColl) throws BOSException {
        try {
            CoreBaseCollection formColl = new CoreBaseCollection();
            for (int i = 0; i < invMgrColl.size(); ++i) {
                InvoiceInvMgrInfo invMgrInfo = invMgrColl.get(i);
                InvoiceCheckFormInfo form = new InvoiceCheckFormInfo();
                String numberSuffix = this.getNumberSuffix(i + 1);
                form.setNumber(task.getNumber() + "_" + numberSuffix);
                form.setInvoiceCheckTask(task);
                form.setTaxNumber(task.getTaxNumber());
                form.setStatus(InvoiceCheckFormStatus.UNDO);
                InvoiceInvMgrEntryCollection invMgrEnColl = invMgrInfo.getEntry();
                for (int j = 0; j < invMgrEnColl.size(); ++j) {
                    InvoiceInvMgrEntryInfo invMgrEn = invMgrEnColl.get(j);
                    InvoiceCheckFormEntryInfo formEn = new InvoiceCheckFormEntryInfo();
                    formEn.setTaxPlate(invMgrInfo.getTaxPlate());
                    formEn.setInvoiceType(invMgrEn.getInvoiceType());
                    formEn.setInvoiceCode(invMgrEn.getInvoiceCode());
                    String firstNumber = invMgrEn.getNextNumber();
                    formEn.setFirstNumber(firstNumber);
                    String lastNumber = invMgrEn.getLastNumber();
                    formEn.setLastNumber(lastNumber);
                    formEn.setRemainderQty(Integer.valueOf(lastNumber) - Integer.valueOf(firstNumber) + 1);
                    form.getEntry().add(formEn);
                }
                formColl.add((CoreBaseInfo)form);
            }
            InvoiceCheckFormFactory.getLocalInstance(ctx).addnew(formColl);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String getNumberSuffix(int i) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumIntegerDigits(4);
        numberFormat.setGroupingUsed(false);
        String numberSuffix = numberFormat.format(i);
        return numberSuffix;
    }

    @Override
    protected void _delForm(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceCheckTaskInfo task = this.getInvoiceCheckTaskInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(task.getCU().getId().toString(), "im_invoiceCheckTask_delForm");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{task.getNumber() + ":" + e.getMessage()});
        }
        if (!InvoiceCheckTaskStatus.AUDITED.equals((Object)task.getStatus()) || !task.isIsGenerateForm()) {
            String genMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_DELCHECKFORM", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{task.getNumber() + ":" + genMsg});
        }
        InvoiceCheckFormFactory.getLocalInstance(ctx).delete(" where invoiceCheckTask = '" + pk.toString() + "' ");
        task.setIsGenerateForm(false);
        task.setStatus(InvoiceCheckTaskStatus.AUDITED);
        this._update(ctx, pk, (IObjectValue)task);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("taxPlate.*"));
        sic.add(new SelectorItemInfo("entry.taxPlate.*"));
        sic.add(new SelectorItemInfo("entry.taxPlate.pwyData.*"));
        return sic;
    }

    @Override
    protected void _updateStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceCheckTaskInfo task = this.getInvoiceCheckTaskInfo(ctx, pk);
        ArrayList<String> statusList = new ArrayList<String>();
        try {
            String status;
            StringBuffer sql = new StringBuffer();
            sql.append(" Select FStatus From T_IM_InvoiceCheckForm Where FInvoiceCheckTaskID = '");
            sql.append(pk.toString()).append("' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                status = rs.getString("FStatus");
                if (statusList.contains(status)) continue;
                statusList.add(status);
            }
            if (1 == statusList.size()) {
                status = (String)statusList.get(0);
                if ("0".equals(status)) {
                    task.setCheckStartTime(null);
                    task.setStatus(InvoiceCheckTaskStatus.AUDITED);
                } else if ("4".equals(status)) {
                    task.setStatus(InvoiceCheckTaskStatus.CHECKING);
                    if (null == task.getCheckStartTime()) {
                        task.setCheckStartTime(new Timestamp(System.currentTimeMillis()));
                    } else if (null != task.getCheckStartTime() && InvoiceCheckTaskStatus.CHECKED == task.getStatus()) {
                        task.setCheckCompleteTime(null);
                    }
                } else if ("5".equals(status)) {
                    task.setStatus(InvoiceCheckTaskStatus.CHECKED);
                    if (null == task.getCheckCompleteTime()) {
                        task.setCheckCompleteTime(new Timestamp(System.currentTimeMillis()));
                    } else if (null != task.getCheckCompleteTime() && InvoiceCheckTaskStatus.HANDLED == task.getStatus()) {
                        task.setHandleTime(null);
                    }
                } else if ("6".equals(status)) {
                    task.setStatus(InvoiceCheckTaskStatus.HANDLED);
                    if (null == task.getHandleTime()) {
                        task.setHandleTime(new Timestamp(System.currentTimeMillis()));
                    }
                    if (null == task.getCheckCompleteTime()) {
                        task.setCheckCompleteTime(new Timestamp(System.currentTimeMillis()));
                    }
                    if (null == task.getCheckStartTime()) {
                        task.setCheckStartTime(new Timestamp(System.currentTimeMillis()));
                    }
                }
            } else if (statusList.contains("4") || statusList.contains("0")) {
                task.setStatus(InvoiceCheckTaskStatus.CHECKING);
                task.setCheckCompleteTime(null);
                if (null == task.getCheckStartTime()) {
                    task.setCheckStartTime(new Timestamp(System.currentTimeMillis()));
                }
            } else if (statusList.contains("5")) {
                task.setStatus(InvoiceCheckTaskStatus.CHECKED);
                task.setHandleTime(null);
                if (null == task.getCheckCompleteTime()) {
                    task.setCheckCompleteTime(new Timestamp(System.currentTimeMillis()));
                }
            }
            this._update(ctx, pk, (IObjectValue)task);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

