/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.inv.InvoiceDetailCollection;
import com.kingdee.eas.tm.im.inv.InvoiceDetailCompareStatus;
import com.kingdee.eas.tm.im.inv.InvoiceDetailFactory;
import com.kingdee.eas.tm.im.inv.InvoiceDetailInfo;
import com.kingdee.eas.tm.im.inv.InvoiceDetailStatus;
import com.kingdee.eas.tm.im.inv.OutputInvoiceType;
import com.kingdee.eas.tm.im.inv.app.AbstractInvoiceDetailControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.EnumUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class InvoiceDetailControllerBean
extends AbstractInvoiceDetailControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.inv.app.InvoiceDetailControllerBean");
    public static final String CONNECTOR = "_";
    public static final String MAKEINVOICE_BOSTYPE = "412A6F98";

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceDetailInfo info = (InvoiceDetailInfo)model;
        return super._save(ctx, (IObjectValue)info);
    }

    @Override
    protected void _makeReverse(Context ctx, MakeInvoiceInfo makeInvoiceInfo) throws BOSException, EASBizException {
        boolean isSupport = IMUtils.getBooleanParam(ctx, makeInvoiceInfo.getCompany().getId().toString(), "VATM008");
        if (!isSupport) {
            return;
        }
        InvoiceDetailInfo detail = this.conventerInvoice(ctx, makeInvoiceInfo);
        IObjectPK detailID = this._save(ctx, (IObjectValue)detail);
        this.traceUpAndDown(ctx, makeInvoiceInfo.getId().toString(), makeInvoiceInfo.getBOSType().toString(), detailID.toString(), this.getBOSType().toString());
    }

    private InvoiceDetailInfo conventerInvoice(Context ctx, MakeInvoiceInfo makeInvoiceInfo) throws BOSException {
        String invoiceCode = makeInvoiceInfo.getInvoiceNumber();
        String invoiceNo = makeInvoiceInfo.getInvoiceNo();
        InvoiceDetailInfo detail = InvoiceDetailControllerBean.getInvoiceDetailInfo(ctx, invoiceCode, invoiceNo);
        detail.setNumber(invoiceCode + CONNECTOR + invoiceNo);
        detail.setInvoiceCode(invoiceCode);
        detail.setInvoiceNo(invoiceNo);
        detail.setInvoiceType(InvoiceDetailControllerBean.getOutputInvoiceType(makeInvoiceInfo.getInvoiceType()));
        detail.setCompany(makeInvoiceInfo.getCompany());
        detail.setSalerTaxNo(makeInvoiceInfo.getCompany().getTaxNumber());
        detail.setCurrAcctCustomer(makeInvoiceInfo.getCurrAcctCustomer());
        detail.setReceiveCompany(makeInvoiceInfo.getReceiveCompany());
        detail.setBuyerTaxNo(makeInvoiceInfo.getTaxNumber());
        detail.setStatus(InvoiceDetailStatus.Maked);
        detail.setPlateNo(makeInvoiceInfo.getPlateNo());
        detail.setExtensionNo(makeInvoiceInfo.getExtensionNo());
        detail.setInvoiceDate(makeInvoiceInfo.getInvoiceDate());
        detail.setSrcSystem(makeInvoiceInfo.getSrcSystem());
        detail.setTotalAmount(makeInvoiceInfo.getNoTaxAmtTotal());
        detail.setTotalTax(makeInvoiceInfo.getTaxAmtTotal());
        detail.setTotalPriceTax(makeInvoiceInfo.getPriceTaxTotal());
        detail.setIsDelete(makeInvoiceInfo.isIsDelete());
        UserInfo deleteUser = makeInvoiceInfo.getDeleteUser();
        if (deleteUser != null) {
            detail.setDeleteUser(deleteUser.getName());
        }
        detail.setDeleteDate(makeInvoiceInfo.getDeleteDate());
        detail.setIsRed(makeInvoiceInfo.isIsRedVoice());
        if (makeInvoiceInfo.getDrawertxt() != null) {
            detail.setDrawer(makeInvoiceInfo.getDrawertxt());
        } else if (makeInvoiceInfo.getDrawer() != null && makeInvoiceInfo.getDrawer().getName() != null) {
            detail.setDrawer(makeInvoiceInfo.getDrawer().getName());
        }
        return detail;
    }

    private static OutputInvoiceType getOutputInvoiceType(PayInvoiceTypeEnum invoiceType) {
        if (PayInvoiceTypeEnum.COMMONINVOICE.equals((Object)invoiceType)) {
            return OutputInvoiceType.OUTPUT_COMMON;
        }
        if (PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)invoiceType)) {
            return OutputInvoiceType.OUPPUT_ELECTRONIC;
        }
        if (PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)invoiceType)) {
            return OutputInvoiceType.OUTPUT_SPECIAL;
        }
        if (PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)invoiceType)) {
            return OutputInvoiceType.OUTPUT_ELECTRONICSPECIAL;
        }
        if (PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)invoiceType)) {
            return OutputInvoiceType.OUPPUT_DIG_ELECTRONIC;
        }
        if (PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)invoiceType)) {
            return OutputInvoiceType.OUTPUT_DIG_ELECTRONICSPECIAL;
        }
        return OutputInvoiceType.OUTPUT_COMMON;
    }

    private static InvoiceDetailInfo getInvoiceDetailInfo(Context ctx, String invoiceCode, String invoiceNo) throws BOSException {
        InvoiceDetailInfo detail = new InvoiceDetailInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode));
        filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)invoiceNo));
        view.setFilter(filter);
        InvoiceDetailCollection coll = InvoiceDetailFactory.getLocalInstance(ctx).getInvoiceDetailCollection(view);
        if (coll != null && coll.size() > 0) {
            detail = coll.get(0);
        } else {
            detail.setId(BOSUuid.create((BOSObjectType)detail.getBOSType()));
        }
        return detail;
    }

    @Override
    protected void _invoiceSync(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceDetailInfo info = this.getInvoiceDetailInfo(ctx, pk);
        try {
            if (info.getCompany() != null && info.getCompany().getId() != null) {
                IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), "im_invoiceDetail_sync");
            }
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FSrcObjectID FROM T_BOT_Relation WHERE ");
            sql.append(" FDestObjectID = '").append(pk.toString()).append("' ");
            sql.append(" AND FSrcEntityID = '").append(MAKEINVOICE_BOSTYPE).append("' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (!rs.next()) {
                String invoiceSync = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_INVOICESYNC", ctx);
                throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + invoiceSync});
            }
            String srcObjectID = rs.getString("FSrcObjectID");
            MakeInvoiceInfo makeInvoiceInfo = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(srcObjectID), this.getMakeInvoiceSelectors());
            InvoiceDetailInfo detail = this.conventerInvoice(ctx, makeInvoiceInfo);
            this._save(ctx, (IObjectValue)detail);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private SelectorItemCollection getMakeInvoiceSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("invoiceNo"));
        sic.add(new SelectorItemInfo("invoiceType"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.taxNumber"));
        sic.add(new SelectorItemInfo("currAcctCustomer.id"));
        sic.add(new SelectorItemInfo("receiveCompany"));
        sic.add(new SelectorItemInfo("taxNumber"));
        sic.add(new SelectorItemInfo("plateNo"));
        sic.add(new SelectorItemInfo("extensionNo"));
        sic.add(new SelectorItemInfo("invoiceDate"));
        sic.add(new SelectorItemInfo("srcSystem"));
        sic.add(new SelectorItemInfo("noTaxAmtTotal"));
        sic.add(new SelectorItemInfo("taxAmtTotal"));
        sic.add(new SelectorItemInfo("priceTaxTotal"));
        sic.add(new SelectorItemInfo("isDelete"));
        sic.add(new SelectorItemInfo("deleteUser.id"));
        sic.add(new SelectorItemInfo("deleteUser.name"));
        sic.add(new SelectorItemInfo("deleteDate"));
        sic.add(new SelectorItemInfo("isRedVoice"));
        sic.add(new SelectorItemInfo("drawertxt"));
        return sic;
    }

    @Override
    protected void _invoiceCompare(Context ctx, IObjectPK pk, Map param) throws BOSException, EASBizException {
        InvoiceDetailInfo info = this.getInvoiceDetailInfo(ctx, pk);
        try {
            if (info.getCompany() != null && info.getCompany().getId() != null) {
                IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), "im_invoiceDetail_compare");
            }
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        String compareStatus = (String)param.get("compareStatus");
        String compareRemark = (String)param.get("compareRemark");
        if (info.getStatus() != InvoiceDetailStatus.Maked && !info.isIsDelete()) {
            throw new IMException(IMException.INVOICE_DETAIL_COMPARE, new Object[]{info.getNumber()});
        }
        info.setCompareStatus((InvoiceDetailCompareStatus)EnumUtils.getEnumByValue(InvoiceDetailCompareStatus.class, (String)compareStatus));
        info.setCompareRemark(compareRemark);
        info.setCompareUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setCompareDate(new Date());
        info.setIsCompared(true);
        this._save(ctx, (IObjectValue)info);
    }

    @Override
    protected void _blankDelete(Context ctx, IObjectPK pk, Map param) throws BOSException, EASBizException {
        InvoiceDetailInfo info = this.getInvoiceDetailInfo(ctx, pk);
        try {
            if (info.getCompany() != null && info.getCompany().getId() != null) {
                IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), "im_invoiceDetail_blankDelete");
            }
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (InvoiceDetailStatus.Used.equals((Object)info.getStatus())) {
            info.setIsDelete(true);
            info.setIsBlankDelete(true);
            info.setStatus(InvoiceDetailStatus.Maked);
            info.setDeleteUser((String)param.get("deleteUser"));
            String deleteDate = (String)param.get("deleteDate");
            if (deleteDate != null && !deleteDate.isEmpty()) {
                String substring = deleteDate.substring(1);
                info.setDeleteDate(new Date(Long.valueOf(substring)));
            } else {
                info.setDeleteDate(new Date());
            }
        } else {
            String blankDelete = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_BLANKDELETE", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + blankDelete});
        }
        super._save(ctx, (IObjectValue)info);
    }

    @Override
    protected void _cancelDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceDetailInfo info = this.getInvoiceDetailInfo(ctx, pk);
        try {
            if (info.getCompany() != null && info.getCompany().getId() != null) {
                IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), "im_invoiceDetail_cancelDelete");
            }
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (!info.isIsBlankDelete()) {
            String cancelDelete = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_CANCELDELETE", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + cancelDelete});
        }
        info.setIsDelete(false);
        info.setIsBlankDelete(false);
        info.setStatus(InvoiceDetailStatus.Used);
        info.setDeleteUser(null);
        info.setDeleteDate(null);
        super._save(ctx, (IObjectValue)info);
    }

    private void traceUpAndDown(Context ctx, String srcObjectID, String srcEntityID, String destObjectID, String destEntityID) throws BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FID FROM T_BOT_Relation WHERE FSrcObjectID = '");
            sql.append(srcObjectID).append("' ");
            sql.append(" and FSrcEntityID = ' ");
            sql.append(srcEntityID).append("' ");
            sql.append(" and FDestObjectID = ' ");
            sql.append(destObjectID).append("' ");
            sql.append(" and FDestEntityID = ' ");
            sql.append(destEntityID).append("' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (!rs.next()) {
                sql.setLength(0);
                sql.append(" INSERT INTO T_BOT_Relation  ");
                sql.append(" (FID, FSrcEntityID, FSrcObjectID, FDestEntityID, FDestObjectID, FOperatorID, FisEffected, FType) ");
                sql.append(" values( ");
                sql.append(" '").append(BOSUuid.create((String)"59302EC6").toString()).append("', ");
                sql.append(" '").append(srcEntityID).append("', ");
                sql.append(" '").append(srcObjectID).append("', ");
                sql.append(" '").append(destEntityID).append("', ");
                sql.append(" '").append(destObjectID).append("', ");
                sql.append(" 'makeReverse',1,0)");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
        catch (SQLException e) {
            logger.equals(e);
            throw new BOSException((Throwable)e);
        }
    }
}

