/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.inv.IInvoiceAlarm;
import com.kingdee.eas.tm.im.inv.IInvoiceDetail;
import com.kingdee.eas.tm.im.inv.InvoiceAlarmFactory;
import com.kingdee.eas.tm.im.inv.InvoiceAlarmInfo;
import com.kingdee.eas.tm.im.inv.InvoiceDetailFactory;
import com.kingdee.eas.tm.im.inv.InvoiceDetailInfo;
import com.kingdee.eas.tm.im.inv.InvoiceDetailStatus;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrCollection;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrEntryCollection;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrEntryInfo;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrInfo;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrStatus;
import com.kingdee.eas.tm.im.inv.app.AbstractInvoiceInvMgrControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class InvoiceInvMgrControllerBean
extends AbstractInvoiceInvMgrControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.inv.app.InvoiceInvMgrControllerBean");
    public static final String CONNECTOR = "_";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceInvMgrInfo info = (InvoiceInvMgrInfo)model;
        this.checkNumber(ctx, info);
        this.checkUnique(ctx, info);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceInvMgrInfo info = (InvoiceInvMgrInfo)model;
        if (InvoiceInvMgrStatus.USING.equals((Object)info.getStatus())) {
            this.checkUnique(ctx, info);
        }
        this.checkNumber(ctx, info);
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        this.handleDetail(ctx, pk);
        return pk;
    }

    private void checkUnique(Context ctx, InvoiceInvMgrInfo info) throws BOSException, EASBizException {
        String tpID = info.getTaxPlate().getId().toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taxPlate.id", (Object)tpID));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"0"));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        InvoiceInvMgrCollection coll = this.getInvoiceInvMgrCollection(ctx, viewInfo);
        if (!coll.isEmpty()) {
            String uniqueMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_UNIQUE", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + uniqueMsg});
        }
    }

    private void checkNumber(Context ctx, InvoiceInvMgrInfo info) throws BOSException, IMException {
        String number = info.getNumber();
        if (number != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            if (info.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            }
            view.setFilter(filter);
            InvoiceInvMgrCollection coll = this.getInvoiceInvMgrCollection(ctx, view);
            if (coll.size() > 0) {
                String uniqueMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_INVMGRNUMBERUNIQUE", ctx);
                throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + uniqueMsg});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDetail(Context ctx, IObjectPK pk) {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(" Select 1 From T_IM_InvoiceDetail Where FInvoiceCode = ? And FInvoiceNo = ? ");
            IInvoiceDetail iInvoiceDetail = InvoiceDetailFactory.getLocalInstance(ctx);
            InvoiceInvMgrInfo info = this.getInvoiceInvMgrInfo(ctx, pk, this.getSelector());
            String plateNo = info.getTaxPlate().getPlateNo();
            String extensionNo = info.getTaxPlate().getExtensionNo();
            InvoiceInvMgrEntryCollection entryColl = info.getEntry();
            for (int i = 0; i < entryColl.size(); ++i) {
                InvoiceInvMgrEntryInfo entryInfo = entryColl.get(i);
                int first = Integer.valueOf(entryInfo.getFirstNumber());
                int next = Integer.valueOf(entryInfo.getNextNumber());
                String code = entryInfo.getInvoiceCode();
                NumberFormat numberFormat = IMUtils.getInvoiceNumberFmt();
                String noStr = null;
                for (int no = first; no < next; ++no) {
                    noStr = numberFormat.format(no);
                    pstmt.setString(1, code);
                    pstmt.setString(2, noStr);
                    rs = pstmt.executeQuery();
                    if (rs.next()) continue;
                    InvoiceDetailInfo detail = new InvoiceDetailInfo();
                    detail.setNumber(code + CONNECTOR + noStr);
                    detail.setInvoiceCode(code);
                    detail.setInvoiceNo(noStr);
                    detail.setInvoiceType(entryInfo.getInvoiceType());
                    detail.setStatus(InvoiceDetailStatus.Used);
                    detail.setPlateNo(plateNo);
                    detail.setExtensionNo(extensionNo);
                    detail.setIsTaxPlateSync(true);
                    iInvoiceDetail.save((CoreBaseInfo)detail);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pstmt != null) {
                    pstmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceInvMgrInfo info = this.getInvoiceInvMgrInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "im_invoiceInvMgr_delete");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (InvoiceInvMgrStatus.USING.equals((Object)info.getStatus())) {
            String deleteMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_DELETE", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{deleteMsg});
        }
        if (info.isIsAlarm()) {
            String deleteMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_INVMGRDELETE", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{deleteMsg});
        }
        if (info.getNumber() != null) {
            String cuID = info.getCU().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, cuID);
            if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, cuID) || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)info, cuID, info.getNumber());
            }
        }
        super._delete(ctx, pk);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getInvoiceInvMgrInfo(ctx, pk);
        }
        InvoiceInvMgrInfo info = (InvoiceInvMgrInfo)model;
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "im_invoiceInvMgr_cancel");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (info.getStatus() == InvoiceInvMgrStatus.FORBIDDEN) {
            String cancel = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_CANCEL", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + cancel});
        }
        info.setStatus(InvoiceInvMgrStatus.FORBIDDEN);
        this._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getInvoiceInvMgrInfo(ctx, pk);
        }
        InvoiceInvMgrInfo info = (InvoiceInvMgrInfo)model;
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "im_invoiceInvMgr_cancelcancel");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        this.checkUnique(ctx, info);
        if (info.getStatus() == InvoiceInvMgrStatus.USING) {
            String active = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_CANCELCANCEL", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + active});
        }
        info.setStatus(InvoiceInvMgrStatus.USING);
        this._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected IObjectPK _createInvoiceAlarm(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceInvMgrInfo info = this.getInvoiceInvMgrInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "im_invoiceInvMgr_createInvoiceAlarm");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (info.isIsAlarm()) {
            String alarmMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_ALARM", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + alarmMsg});
        }
        if (info.getStatus() == InvoiceInvMgrStatus.FORBIDDEN) {
            String cancel = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_FORBIDDENALARM", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + cancel});
        }
        InvoiceAlarmInfo alarmInfo = new InvoiceAlarmInfo();
        alarmInfo.setTaxPlate(info.getTaxPlate());
        alarmInfo.setInvoiceInvMgr(info);
        IInvoiceAlarm iInvoiceAlarm = InvoiceAlarmFactory.getLocalInstance(ctx);
        IObjectPK alarmPk = iInvoiceAlarm.save((CoreBaseInfo)alarmInfo);
        iInvoiceAlarm.reCalculate(alarmPk);
        IMUtils.traceUpAndDown(ctx, pk.toString(), info.getBOSType().toString(), alarmPk.toString(), alarmInfo.getBOSType().toString());
        info.setIsAlarm(true);
        super._save(ctx, (IObjectValue)info);
        return alarmPk;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("taxPlate.*"));
        sic.add(new SelectorItemInfo("entry.*"));
        return sic;
    }

    @Override
    protected Map _updateInvMgr(Context ctx, MakeInvoiceInfo makeInvoiceInfo) throws BOSException, EASBizException {
        HashMap<String, Object> result;
        block9: {
            result = new HashMap<String, Object>();
            boolean isSupport = IMUtils.getBooleanParam(ctx, makeInvoiceInfo.getCompany().getId().toString(), "VATM008");
            if (!isSupport) {
                return result;
            }
            try {
                String plateNo = makeInvoiceInfo.getPlateNo();
                InvoiceInvMgrCollection coll = this.getInvMgrByPlateNo(ctx, plateNo);
                if (coll.size() <= 0) break block9;
                InvoiceInvMgrInfo info = coll.get(0);
                InvoiceInvMgrEntryCollection entries = info.getEntry();
                NumberFormat numberFormat = IMUtils.getInvoiceNumberFmt();
                String invoiceCode = makeInvoiceInfo.getInvoiceNumber();
                int invoiceNo = Integer.valueOf(makeInvoiceInfo.getInvoiceNo());
                for (int i = 0; i < entries.size(); ++i) {
                    InvoiceInvMgrEntryInfo entry = entries.get(i);
                    int first = Integer.valueOf(entry.getFirstNumber());
                    int last = Integer.valueOf(entry.getLastNumber());
                    if (!invoiceCode.equals(entry.getInvoiceCode()) || invoiceNo < first || invoiceNo > last) continue;
                    if (invoiceNo == last) {
                        entry.setNextNumber(numberFormat.format(invoiceNo));
                        entry.setUsedQty(entry.getQuantity());
                        entry.setRemainderQty(0);
                    } else {
                        entry.setNextNumber(numberFormat.format((long)invoiceNo + 1L));
                        entry.setUsedQty(invoiceNo - first + 1);
                        entry.setRemainderQty(last - invoiceNo + 1);
                    }
                    ObjectUuidPK pk = new ObjectUuidPK(info.getId().toString());
                    this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
                    if (info.isIsAlarm()) {
                        this.updateAlarm(ctx, info);
                    }
                    result.put("invMgrID", pk.toString());
                    break;
                }
            }
            catch (Exception e) {
                result.put("Exception", e);
                logger.error((Object)e.getMessage(), (Throwable)e);
                if (e instanceof EASBizException) {
                    throw (EASBizException)((Object)e);
                }
                if (e instanceof BOSException) {
                    throw (BOSException)((Object)e);
                }
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    private void updateAlarm(Context ctx, InvoiceInvMgrInfo info) throws BOSException, SQLException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select FDestObjectID From T_BOT_Relation Where FSrcObjectID = '");
        sql.append(info.getId().toString()).append("'");
        sql.append(" And FDestEntityID = 'A5BE6F68' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            String alarmID = rs.getString("FDestObjectID");
            InvoiceAlarmFactory.getLocalInstance(ctx).reCalculate((IObjectPK)new ObjectUuidPK(alarmID));
        }
    }

    private InvoiceInvMgrCollection getInvMgrByPlateNo(Context ctx, String plateNo) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taxPlate.plateNo", (Object)plateNo));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"0"));
        view.setFilter(filter);
        InvoiceInvMgrCollection coll = this.getInvoiceInvMgrCollection(ctx, view);
        return coll;
    }
}

