/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ps.app;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.TjbbStatusEnum;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolConstant;
import com.kingdee.eas.tm.im.ps.app.AbstractInvStatisticCompareFacadeControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvStatisticCompareFacadeControllerBean
extends AbstractInvStatisticCompareFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.ps.app.InvStatisticCompareFacadeControllerBean");

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = null;
        tempTable = this.createTempTable(ctx, this.getCreateTempTable(tempTable, params));
        params.setString("tempTable", tempTable);
        this.insertOrgUnitData(ctx, params);
        this.updateEASData(ctx, params);
        this.insertSubTotalData(ctx, params);
        this.updateTaxBureauData(ctx, params);
        this.updateDiffData(ctx, params);
        this.insertTotalData(ctx, params);
        this.insertSumData(ctx, params);
        RptTableHeader header = this.createTableHeader(ctx, params);
        params.setObject("header", (Object)header);
        return params;
    }

    protected void insertOrgUnitData(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        Map conditionParams = (Map)params.getObject("conditionParams");
        Map pwyParams = new HashMap();
        String taxNo = "";
        String orgId = "";
        String periodNumber = "";
        String tjbbStatus = "";
        List tjbbEnum = TjbbStatusEnum.getEnumList();
        for (Object key : conditionParams.keySet()) {
            taxNo = key != null ? key.toString() : null;
            pwyParams = (Map)conditionParams.get(taxNo);
            String skssq = (String)pwyParams.get("skssq");
            tjbbStatus = (String)pwyParams.get("tjbbStatus");
            String[] date = skssq.split(";");
            periodNumber = date[0];
            List orgList = (List)pwyParams.get("orgList");
            for (TjbbStatusEnum status : tjbbEnum) {
                if (!status.getValue().equals(tjbbStatus)) continue;
                tjbbStatus = status.getAlias();
                break;
            }
            for (int i = 0; i < orgList.size(); ++i) {
                if (orgList.get(i) instanceof CompanyOrgUnitInfo) {
                    orgId = ((CompanyOrgUnitInfo)orgList.get(i)).getId().toString();
                } else if (orgList.get(i) instanceof LinkedTreeMap) {
                    orgId = ((LinkedTreeMap)orgList.get(i)).get((Object)"id").toString();
                }
                if (taxNo == null || "null".equals(taxNo)) {
                    taxNo = "  ";
                }
                this.insertOrgData(ctx, tempTable, taxNo, orgId, periodNumber, tjbbStatus);
            }
        }
    }

    protected void insertOrgData(Context ctx, String tempTable, String taxNo, String orgId, String periodNumber, String tjbbStatus) throws EASBizException, BOSException {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append(" insert into  ").append(tempTable).append(" (FTN, FID, FLevel, FTaxNo, FPeriod, FStatus, FInvoiceType, FTypeFlag, FCompanyID ) ");
        String selectSQL = this.getSelectDataSQL(ctx, tempTable, "1343913D", (Boolean)false, taxNo, orgId, periodNumber, tjbbStatus);
        String sql = insertSQL + selectSQL;
        logger.error((Object)("\u5411\u4e34\u65f6\u8868\u63d2\u5165\u6570\u636eSQL\uff1a" + sql));
        this.executeUpdate(ctx, sql, null);
        selectSQL = this.getSelectDataSQL(ctx, tempTable, "1343913D", (Boolean)true, taxNo, orgId, periodNumber, tjbbStatus);
        sql = insertSQL + selectSQL;
        logger.error((Object)("\u5411\u4e34\u65f6\u8868\u63d2\u5165\u6570\u636eSQL\uff1a" + sql));
        this.executeUpdate(ctx, sql, null);
        selectSQL = this.getSelectDataSQL(ctx, tempTable, "0329A272", (Boolean)false, taxNo, orgId, periodNumber, tjbbStatus);
        sql = insertSQL + selectSQL;
        this.executeUpdate(ctx, sql, null);
        logger.error((Object)("\u5411\u4e34\u65f6\u8868\u63d2\u5165\u6570\u636eSQL\uff1a" + sql));
        selectSQL = this.getSelectDataSQL(ctx, tempTable, PoolConstant.BOSTYPE_VEHICLEINVOICE, (Boolean)false, taxNo, orgId, periodNumber, tjbbStatus);
        sql = insertSQL + selectSQL;
        logger.error((Object)("\u5411\u4e34\u65f6\u8868\u63d2\u5165\u6570\u636eSQL\uff1a" + sql));
        this.executeUpdate(ctx, sql, null);
    }

    protected String getSelectDataSQL(Context ctx, String tempTable, String bosType, Boolean isElecSpecial, String taxNo, String orgId, String periodNumber, String tjbbStatus) throws BOSException, EASBizException {
        StringBuffer selectSQL = new StringBuffer();
        String invoiceType = "";
        String typeFlag = "0";
        if ("1343913D".equals(bosType)) {
            if (isElecSpecial.booleanValue()) {
                invoiceType = "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968\uff08\u542b\u6570\u7535\u4e13\u7968\uff09";
                typeFlag = "8";
            } else {
                invoiceType = "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968";
                typeFlag = "1";
            }
        } else if ("0329A272".equals(bosType)) {
            invoiceType = "\u901a\u884c\u8d39\u7535\u5b50\u53d1\u7968";
            typeFlag = "15";
        } else if (PoolConstant.BOSTYPE_VEHICLEINVOICE.equals(bosType)) {
            invoiceType = TMInvoiceType.INVOICETYPE_VEHICLE.getAlias();
            typeFlag = TMInvoiceType.INVOICETYPE_VEHICLE.getValue();
        }
        selectSQL.append(" select '" + taxNo + "' as FTN,newbosid('55555555') as FID,1 as FLevel,'" + taxNo + "' as FTaxNo, " + periodNumber + " as FPeriod,'" + tjbbStatus + "' as FStatus, '" + invoiceType + "' as FInvoiceType, " + typeFlag + " as FTypeFlag, '" + orgId + "' as FCompanyID");
        return selectSQL.toString();
    }

    protected void updateEASData(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        Map conditionParams = (Map)params.getObject("conditionParams");
        Map pwyParams = new HashMap();
        String taxNo = "";
        HashSet<String> orgIds = new HashSet<String>();
        String periodNumber = "";
        String tjbbStatus = "";
        List tjbbEnum = TjbbStatusEnum.getEnumList();
        for (Object key : conditionParams.keySet()) {
            taxNo = key != null ? key.toString() : null;
            pwyParams = (Map)conditionParams.get(taxNo);
            String skssq = (String)pwyParams.get("skssq");
            tjbbStatus = (String)pwyParams.get("tjbbStatus");
            String[] date = skssq.split(";");
            periodNumber = date[0];
            List orgList = (List)pwyParams.get("orgList");
            String orgId = null;
            for (int i = 0; i < orgList.size(); ++i) {
                if (orgList.get(i) instanceof CompanyOrgUnitInfo) {
                    orgId = ((CompanyOrgUnitInfo)orgList.get(i)).getId().toString();
                } else if (orgList.get(i) instanceof LinkedTreeMap) {
                    orgId = ((LinkedTreeMap)orgList.get(i)).get((Object)"id").toString();
                }
                orgIds.add(orgId);
            }
            for (TjbbStatusEnum status : tjbbEnum) {
                if (!status.getValue().equals(tjbbStatus)) continue;
                tjbbStatus = status.getAlias();
                break;
            }
            if (taxNo == null) {
                taxNo = "";
            }
            this.updateTempData(ctx, tempTable, taxNo, orgIds, periodNumber, tjbbStatus);
        }
    }

    protected void updateTempData(Context ctx, String tempTable, String taxNo, Set orgIds, String periodNumber, String tjbbStatus) throws EASBizException, BOSException {
        this.updateInvoiceData(ctx, tempTable, "1343913D", false, taxNo, orgIds, periodNumber, tjbbStatus);
        this.updateInvoiceData(ctx, tempTable, "1343913D", true, taxNo, orgIds, periodNumber, tjbbStatus);
        this.updateInvoiceData(ctx, tempTable, "0329A272", false, taxNo, orgIds, periodNumber, tjbbStatus);
        this.updateInvoiceData(ctx, tempTable, PoolConstant.BOSTYPE_VEHICLEINVOICE, false, taxNo, orgIds, periodNumber, tjbbStatus);
    }

    protected void updateInvoiceData(Context ctx, String tempTable, String bosType, Boolean isElecSpecial, String taxNo, Set orgIds, String periodNumber, String tjbbStatus) throws BOSException, EASBizException {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append(" update ").append(tempTable).append(" as tmp ");
        updateSQL.append(" set (FDeductQty,FDeductAmount,FDeductEffTaxAmt,FNoDeductQty,FNoDeductAmount,FNoDeductEffTaxAmt) ");
        updateSQL.append(" = ( ");
        updateSQL.append(" select  easData.FDeductQty,easData.FDeductAmount,easData.FDeductEffTaxAmt,easData.FNoDeductQty,easData.FNoDeductAmount,easData.FNoDeductEffTaxAmt ");
        updateSQL.append(" from ").append(tempTable).append(" as t ");
        updateSQL.append(" inner join ( ");
        String selectSQL = this.getSelectDataSQL(ctx, tempTable, bosType, isElecSpecial, taxNo, orgIds, periodNumber, tjbbStatus);
        updateSQL.append(selectSQL);
        updateSQL.append(" ) as easData ");
        updateSQL.append(" on t.FTaxNo = easData.FTaxNo ");
        updateSQL.append(" and t.FPeriod = easData.FPeriod ");
        updateSQL.append(" and t.FStatus = easData.FStatus ");
        updateSQL.append(" and t.FTypeFlag = easData.FTypeFlag ");
        updateSQL.append(" and t.FCompanyID = easData.FCompanyID ");
        updateSQL.append(" where tmp.fid = t.fid ");
        updateSQL.append(" ) ");
        logger.error((Object)("bosType:" + bosType + ",\u66f4\u65b0\u4e34\u65f6\u8868\u53d1\u7968\u6570\u636eSQL\uff1a" + updateSQL.toString()));
        this.executeUpdate(ctx, updateSQL.toString(), null);
    }

    protected String getSelectDataSQL(Context ctx, String tempTable, String bosType, Boolean isElecSpecial, String taxNo, Set orgIds, String periodNumber, String tjbbStatus) throws BOSException, EASBizException {
        StringBuffer selectSQL = new StringBuffer();
        String typeFlag = "";
        String invoiceType = "";
        if ("1343913D".equals(bosType)) {
            if (isElecSpecial.booleanValue()) {
                typeFlag = "8";
                invoiceType = "2','27";
            } else {
                typeFlag = "1";
                invoiceType = "4";
            }
        } else if ("0329A272".equals(bosType)) {
            typeFlag = "15";
            invoiceType = "15";
        } else if (PoolConstant.BOSTYPE_VEHICLEINVOICE.equals(bosType)) {
            typeFlag = TMInvoiceType.INVOICETYPE_VEHICLE.getValue();
            invoiceType = TMInvoiceType.INVOICETYPE_VEHICLE.getValue();
        }
        selectSQL.append(" select '" + taxNo + "' as FTaxNo, TAXPERIOD.FNUMBER as FPeriod,'" + tjbbStatus + "' as FStatus," + typeFlag + " as FTypeFlag, CHECKABS.FCompanyID as FCompanyID,").append(" sum(case when FCheckPurpose = '0' then 1 else 0 end) as FDeductQty,").append(" sum(case when FCheckPurpose = '0' then FAmount else 0 end) as FDeductAmount,").append(" sum(case when FCheckPurpose = '0' then FEffectiveTaxAmt else 0 end) as FDeductEffTaxAmt,").append(" sum(case when FCheckPurpose = '1' then 1 else 0 end) as FNoDeductQty,").append(" sum(case when FCheckPurpose = '1' then FAmount else 0 end) as FNoDeductAmount,").append(" sum(case when FCheckPurpose = '1' then FEffectiveTaxAmt else 0 end) as FNoDeductEffTaxAmt").append(" from T_TM_CheckAbs as CHECKABS").append(" LEFT OUTER JOIN T_BD_Period AS TAXPERIOD ON CHECKABS.FTaxPeriodID = TAXPERIOD.FID").append(" where CHECKABS.FinvoiceType in('" + invoiceType + "') and CHECKABS.FCheckState = '1' and CHECKABS.FInvoiceState in ('0','7') ").append(" and CHECKABS.FCompanyID  in " + IMUtils.getInStringFromSet(orgIds)).append(" and TAXPERIOD.FNUMBER = '" + periodNumber + "' ").append(" group by  TAXPERIOD.FNUMBER,CHECKABS.FCompanyID ");
        return selectSQL.toString();
    }

    protected void insertSubTotalData(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        String subTotal = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "SubTotal", ctx.getLocale());
        sql.append(" insert into  ").append(tempTable).append(" (FTN, FID, FLevel, FTaxNo, FPeriod, FStatus, FInvoiceType, FTypeFlag, FDeductQty, FDeductAmount, FDeductEffTaxAmt, FNoDeductQty, FNoDeductAmount, FNoDeductEffTaxAmt) ");
        sql.append(" select FTN,newbosid('55555555') as FID,2 AS Flevel,FTaxNo,FPeriod,FStatus,'" + subTotal + "' as FInvoiceType, FTypeFlag, ");
        sql.append(" SUM(FDeductQty) as FDeductQty ,SUM(FDeductAmount) as FDeductAmount , SUM(FDeductEffTaxAmt) as FDeductEffTaxAmt, ");
        sql.append(" SUM(FNoDeductQty) as FNoDeductQty ,SUM(FNoDeductAmount) as FNoDeductAmount , SUM(FNoDeductEffTaxAmt) as FNoDeductEffTaxAmt ");
        sql.append(" from ").append(tempTable);
        sql.append(" where flevel = 1 ");
        sql.append(" group by FTN,FTaxNo, FPeriod, FStatus, FTypeFlag ");
        this.executeUpdate(ctx, sql.toString(), null);
    }

    protected void updateTaxBureauData(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        Map conditionParams = (Map)params.getObject("conditionParams");
        Map pwyParams = new HashMap();
        String taxNo = "";
        String periodNumber = "";
        String tjInfo = "";
        for (Object key : conditionParams.keySet()) {
            taxNo = key != null ? key.toString() : null;
            pwyParams = (Map)conditionParams.get(taxNo);
            String skssq = (String)pwyParams.get("skssq");
            String[] date = skssq.split(";");
            periodNumber = date[0];
            tjInfo = (String)pwyParams.get("tjInfo");
            if (taxNo == null) {
                taxNo = "";
            }
            this.insertTaxNoData(ctx, tempTable, taxNo, periodNumber, tjInfo);
        }
    }

    protected void insertTaxNoData(Context ctx, String tempTable, String taxNo, String periodNumber, String tjInfo) throws EASBizException, BOSException {
        if (IMUtils.isEmpty(tjInfo)) {
            return;
        }
        String[] invoiceInfos = tjInfo.split(";");
        String invoiceType = "";
        int typeFlag = 0;
        BigDecimal taxDeductQty = BigDecimal.ZERO;
        BigDecimal taxDeductAmount = BigDecimal.ZERO;
        BigDecimal taxDeductEffTaxAmt = BigDecimal.ZERO;
        BigDecimal taxNoDeductQty = BigDecimal.ZERO;
        BigDecimal taxNoDeductAmount = BigDecimal.ZERO;
        BigDecimal taxNoDeductEffTaxAmt = BigDecimal.ZERO;
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < invoiceInfos.length; ++i) {
            String[] invoiceInfo = invoiceInfos[i].split("=");
            invoiceType = invoiceInfo[0];
            if ("01".equals(invoiceType)) {
                typeFlag = 1;
            } else if ("08".equals(invoiceType)) {
                typeFlag = 8;
            } else if ("14".equals(invoiceType)) {
                typeFlag = 15;
            } else {
                if (!"03".equals(invoiceType)) continue;
                typeFlag = 12;
            }
            taxDeductQty = new BigDecimal(invoiceInfo[1]);
            taxDeductAmount = new BigDecimal(invoiceInfo[2]);
            taxDeductEffTaxAmt = new BigDecimal(invoiceInfo[3]);
            taxNoDeductQty = new BigDecimal(invoiceInfo[4]);
            taxNoDeductAmount = new BigDecimal(invoiceInfo[5]);
            taxNoDeductEffTaxAmt = new BigDecimal(invoiceInfo[6]);
            sql.setLength(0);
            sql.append(" update " + tempTable + " set FTaxDeductQty = " + taxDeductQty + " ,");
            sql.append(" FTaxDeductAmount = " + taxDeductAmount + " ,");
            sql.append(" FTaxDeductEffTaxAmt = " + taxDeductEffTaxAmt + " ,");
            sql.append(" FTaxNoDeductQty = " + taxNoDeductQty + " ,");
            sql.append(" FTaxNoDeductAmount = " + taxNoDeductAmount + " ,");
            sql.append(" FTaxNoDeductEffTaxAmt = " + taxNoDeductEffTaxAmt + " ");
            sql.append(" where FTaxNo = '" + taxNo + "' and FPeriod = " + periodNumber + " and fTypeFlag = " + typeFlag + " ;");
            this.executeUpdate(ctx, sql.toString(), null);
        }
    }

    protected void updateDiffData(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        sql.append(" update " + tempTable + " set ");
        sql.append(" FDiffDeductQty = isnull(FDeductQty,0) - isnull(FTaxDeductQty,0) ,");
        sql.append(" FDiffDeductAmount = isnull(FDeductAmount,0) - isnull(FTaxDeductAmount,0) ,");
        sql.append(" FDiffDeductEffTaxAmt = isnull(FDeductEffTaxAmt,0) - isnull(FTaxDeductEffTaxAmt,0) ,");
        sql.append(" FDiffNoDeductQty = isnull(FNoDeductQty,0) - isnull(FTaxNoDeductQty,0) ,");
        sql.append(" FDiffNoDeductAmount = isnull(FNoDeductAmount,0) - isnull(FTaxNoDeductAmount,0) ,");
        sql.append(" FDiffNoDeductEffTaxAmt = isnull(FNoDeductEffTaxAmt,0) - isnull(FTaxNoDeductEffTaxAmt,0) ");
        sql.append(" where FLevel = 2");
        this.executeUpdate(ctx, sql.toString(), null);
    }

    protected void insertTotalData(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        String total = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "SumTotal", ctx.getLocale());
        sql.append(" insert into  ").append(tempTable).append(" (FTN, FID, FLevel, FTaxNo, FPeriod, FStatus, FInvoiceType, FTypeFlag, ").append(" FDeductQty, FDeductAmount, FDeductEffTaxAmt, ").append(" FNoDeductQty, FNoDeductAmount, FNoDeductEffTaxAmt,").append(" FTaxDeductQty, FTaxDeductAmount, FTaxDeductEffTaxAmt, ").append(" FTaxNoDeductQty, FTaxNoDeductAmount, FTaxNoDeductEffTaxAmt, ").append(" FDiffDeductQty, FDiffDeductAmount, FDiffDeductEffTaxAmt, ").append(" FDiffNoDeductQty, FDiffNoDeductAmount, FDiffNoDeductEffTaxAmt )");
        sql.append(" select FTN,newbosid('55555555') as FID,3 AS Flevel,FTaxNo,FPeriod,FStatus,'" + total + "' as FInvoiceType,999 as FTypeFlag, ");
        sql.append(" SUM(FDeductQty) as FDeductQty ,SUM(FDeductAmount) as FDeductAmount , SUM(FDeductEffTaxAmt) as FDeductEffTaxAmt, ");
        sql.append(" SUM(FNoDeductQty) as FNoDeductQty ,SUM(FNoDeductAmount) as FNoDeductAmount , SUM(FNoDeductEffTaxAmt) as FNoDeductEffTaxAmt, ");
        sql.append(" SUM(FTaxDeductQty) as FTaxDeductQty ,SUM(FTaxDeductAmount) as FTaxDeductAmount , SUM(FTaxDeductEffTaxAmt) as FTaxDeductEffTaxAmt,  ");
        sql.append(" SUM(FTaxNoDeductQty) as FTaxNoDeductQty ,SUM(FTaxNoDeductAmount) as FTaxNoDeductAmount , SUM(FTaxNoDeductEffTaxAmt) as FTaxNoDeductEffTaxAmt, ");
        sql.append(" SUM(FDiffDeductQty) as FDiffDeductQty ,SUM(FDiffDeductAmount) as FDiffDeductAmount , SUM(FDiffDeductEffTaxAmt) as FDiffDeductEffTaxAmt,  ");
        sql.append(" SUM(FDiffNoDeductQty) as FDiffNoDeductQty ,SUM(FDiffNoDeductAmount) as FDiffNoDeductAmount , SUM(FDiffNoDeductEffTaxAmt) as FDiffNoDeductEffTaxAmt ");
        sql.append(" from ").append(tempTable);
        sql.append(" where flevel = 2 ");
        sql.append(" group by FTN,FTaxNo, FPeriod, FStatus ");
        this.executeUpdate(ctx, sql.toString(), null);
    }

    protected void insertSumData(Context ctx, RptParams params) throws EASBizException, BOSException {
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FID from  ").append(tempTable).append(" where flevel = 3;");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                String sumTotal = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "Total", ctx.getLocale());
                sql.setLength(0);
                sql.append(" insert into  ").append(tempTable).append(" (FID, FLevel,  FInvoiceType, FTypeFlag, FTaxNo, ").append(" FDeductQty, FDeductAmount, FDeductEffTaxAmt, ").append(" FNoDeductQty, FNoDeductAmount, FNoDeductEffTaxAmt,").append(" FTaxDeductQty, FTaxDeductAmount, FTaxDeductEffTaxAmt, ").append(" FTaxNoDeductQty, FTaxNoDeductAmount, FTaxNoDeductEffTaxAmt, ").append(" FDiffDeductQty, FDiffDeductAmount, FDiffDeductEffTaxAmt, ").append(" FDiffNoDeductQty, FDiffNoDeductAmount, FDiffNoDeductEffTaxAmt ) ");
                sql.append(" select newbosid('55555555') as FID,4 AS Flevel,'" + sumTotal + "' as FInvoiceType,9999 as FTypeFlag, ' ',");
                sql.append(" SUM(FDeductQty) as FDeductQty ,SUM(FDeductAmount) as FDeductAmount , SUM(FDeductEffTaxAmt) as FDeductEffTaxAmt, ");
                sql.append(" SUM(FNoDeductQty) as FNoDeductQty ,SUM(FNoDeductAmount) as FNoDeductAmount , SUM(FNoDeductEffTaxAmt) as FNoDeductEffTaxAmt, ");
                sql.append(" SUM(FTaxDeductQty) as FTaxDeductQty ,SUM(FTaxDeductAmount) as FTaxDeductAmount , SUM(FTaxDeductEffTaxAmt) as FTaxDeductEffTaxAmt,  ");
                sql.append(" SUM(FTaxNoDeductQty) as FTaxNoDeductQty ,SUM(FTaxNoDeductAmount) as FTaxNoDeductAmount , SUM(FTaxNoDeductEffTaxAmt) as FTaxNoDeductEffTaxAmt, ");
                sql.append(" SUM(FDiffDeductQty) as FDiffDeductQty ,SUM(FDiffDeductAmount) as FDiffDeductAmount , SUM(FDiffDeductEffTaxAmt) as FDiffDeductEffTaxAmt,  ");
                sql.append(" SUM(FDiffNoDeductQty) as FDiffNoDeductQty ,SUM(FDiffNoDeductAmount) as FDiffNoDeductAmount , SUM(FDiffNoDeductEffTaxAmt) as FDiffNoDeductEffTaxAmt ");
                sql.append(" from ").append(tempTable);
                sql.append(" where flevel = 3 ");
                this.executeUpdate(ctx, sql.toString(), null);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected RptTableHeader createTableHeader(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("FTN");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FSelect");
        col.setWidth(40);
        header.addColumn(col);
        col = new RptTableColumn("FID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FLevel");
        col.setWidth(-1);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FTaxNo");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("FPeriod");
        col.setWidth(80);
        header.addColumn(col);
        col = new RptTableColumn("FStatus");
        col.setWidth(80);
        header.addColumn(col);
        col = new RptTableColumn("FInvoiceType");
        col.setWidth(200);
        header.addColumn(col);
        col = new RptTableColumn("FCompanyID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FCompanyName");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FDiffDeductQty");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FDiffDeductAmount");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FDiffDeductEffTaxAmt");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FDiffNoDeductQty");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FDiffNoDeductAmount");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FDiffNoDeductEffTaxAmt");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FDeductQty");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FDeductAmount");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FDeductEffTaxAmt");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FNoDeductQty");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FNoDeductAmount");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FNoDeductEffTaxAmt");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FTaxDeductQty");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FTaxDeductAmount");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FTaxDeductEffTaxAmt");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FTaxNoDeductQty");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FTaxNoDeductAmount");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        col = new RptTableColumn("FTaxNoDeductEffTaxAmt");
        col.setWidth(100);
        col.setFormatPattern("%r-[=]{#,##0.##########}f");
        header.addColumn(col);
        String taxNo_alias = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "TaxNo", ctx.getLocale());
        String period_alias = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "Period", ctx.getLocale());
        String status_alias = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "Status", ctx.getLocale());
        String invoiceType_alias = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "InvoiceType", ctx.getLocale());
        String company_alias = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "CompanyName", ctx.getLocale());
        String taxBureau = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "TaxBureau", ctx.getLocale());
        String difference = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "Difference", ctx.getLocale());
        String qty_alias = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "Qty", ctx.getLocale());
        String amount_alias = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "Amount", ctx.getLocale());
        String effTaxAmt_alias = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "EffTaxAmt", ctx.getLocale());
        String deduct_alias = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "Deduct", ctx.getLocale());
        String noDeduct_alias = IMUtils.getString("com.kingdee.eas.tm.im.ps.InvStatisticCompareResource", "NoDeduct", ctx.getLocale());
        header.setLabels((Object[][])new Object[][]{{"FTN", "\u9009\u62e9", "FID", "FLevel", taxNo_alias, period_alias, status_alias, invoiceType_alias, "FCompanyID", company_alias, difference, difference, difference, difference, difference, difference, "EAS Cloud", "EAS Cloud", "EAS Cloud", "EAS Cloud", "EAS Cloud", "EAS Cloud", taxBureau, taxBureau, taxBureau, taxBureau, taxBureau, taxBureau}, {"FTN", "\u9009\u62e9", "FID", "FLevel", taxNo_alias, period_alias, status_alias, invoiceType_alias, "FCompanyID", company_alias, deduct_alias, deduct_alias, deduct_alias, noDeduct_alias, noDeduct_alias, noDeduct_alias, deduct_alias, deduct_alias, deduct_alias, noDeduct_alias, noDeduct_alias, noDeduct_alias, deduct_alias, deduct_alias, deduct_alias, noDeduct_alias, noDeduct_alias, noDeduct_alias}, {"FTN", "\u9009\u62e9", "FID", "FLevel", taxNo_alias, period_alias, status_alias, invoiceType_alias, "FCompanyID", company_alias, qty_alias, amount_alias, effTaxAmt_alias, qty_alias, amount_alias, effTaxAmt_alias, qty_alias, amount_alias, effTaxAmt_alias, qty_alias, amount_alias, effTaxAmt_alias, qty_alias, amount_alias, effTaxAmt_alias, qty_alias, amount_alias, effTaxAmt_alias}}, true);
        return header;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        RptRowSet rs = null;
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        sql.append(" select temp.FTN as FTN,'' as FSelect, temp.FID  as FID,temp.FLevel as FLevel,temp.FTaxNo as FTaxNo , temp.FPeriod as FPeriod, temp.FStatus as FStatus, temp.FInvoiceType as FinvoiceType, temp.FCompanyID as FCompanyID,COMPANY.FName_l2 as  FCompanyName, ").append(" FDiffDeductQty, FDiffDeductAmount, FDiffDeductEffTaxAmt, ").append(" FDiffNoDeductQty, FDiffNoDeductAmount, FDiffNoDeductEffTaxAmt, ").append(" FDeductQty, FDeductAmount, FDeductEffTaxAmt, ").append(" FNoDeductQty, FNoDeductAmount, FNoDeductEffTaxAmt,").append(" FTaxDeductQty, FTaxDeductAmount, FTaxDeductEffTaxAmt, ").append(" FTaxNoDeductQty, FTaxNoDeductAmount, FTaxNoDeductEffTaxAmt ").append(" from ").append(tempTable).append(" as temp").append(" LEFT OUTER JOIN T_ORG_Company AS COMPANY ON temp.FCompanyID = COMPANY.FID").append(" order by FTaxNo desc, FPeriod asc, FStatus asc,FTypeFlag asc,FLevel asc");
        logger.error((Object)("\u67e5\u8be2\u52fe\u9009\u7edf\u8ba1SQL\uff1a" + sql.toString()));
        rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempInvStaComTable(");
        sql.append("FTN varchar(80),");
        sql.append("FSelect Int,");
        sql.append("FID varchar(44),");
        sql.append("FLevel int,");
        sql.append("FTaxNo varchar(80),");
        sql.append("FPeriod int,");
        sql.append("FStatus nvarchar(100),");
        sql.append("FTypeFlag int,");
        sql.append("FInvoiceType nvarchar(100),");
        sql.append("FCompanyID varchar(44),");
        sql.append("FDiffDeductQty Decimal(28, 10)  default 0,");
        sql.append("FDiffDeductAmount Decimal(28, 10)  default 0,");
        sql.append("FDiffDeductEffTaxAmt Decimal(28, 10)  default 0,");
        sql.append("FDiffNoDeductQty Decimal(28, 10)  default 0,");
        sql.append("FDiffNoDeductAmount Decimal(28, 10)  default 0,");
        sql.append("FDiffNoDeductEffTaxAmt Decimal(28, 10)  default 0,");
        sql.append("FDeductQty Decimal(28, 10)  default 0,");
        sql.append("FDeductAmount Decimal(28, 10)  default 0,");
        sql.append("FDeductEffTaxAmt Decimal(28, 10)  default 0,");
        sql.append("FNoDeductQty Decimal(28, 10)  default 0,");
        sql.append("FNoDeductAmount Decimal(28, 10)  default 0,");
        sql.append("FNoDeductEffTaxAmt Decimal(28, 10)  default 0,");
        sql.append("FTaxDeductQty Decimal(28, 10)  default 0,");
        sql.append("FTaxDeductAmount Decimal(28, 10)  default 0,");
        sql.append("FTaxDeductEffTaxAmt Decimal(28, 10)  default 0,");
        sql.append("FTaxNoDeductQty Decimal(28, 10)  default 0,");
        sql.append("FTaxNoDeductAmount Decimal(28, 10)  default 0,");
        sql.append("FTaxNoDeductEffTaxAmt Decimal(28, 10)  default 0");
        sql.append(");");
        logger.error((Object)("\u521b\u5efa\u4e34\u65f6\u8868SQL\uff1a" + sql.toString()));
        return sql.toString();
    }
}

