/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceCollection;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceFactory;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.app.AbstractDataUpgradeTraceControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataUpgradeTraceControllerBean
extends AbstractDataUpgradeTraceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.upgrade.app.DataUpgradeTraceControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _executeUpgrade(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        HashSet idSet = new HashSet(ids);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        DataUpgradeTraceCollection colls = this.getDataUpgradeTraceCollection(ctx, view);
        HashMap<String, DataUpgradeTraceInfo> dataUpgradeMap = new HashMap<String, DataUpgradeTraceInfo>();
        int size = colls.size();
        for (int i = 0; i < size; ++i) {
            DataUpgradeTraceInfo info = colls.get(i);
            dataUpgradeMap.put(info.getId().toString(), info);
        }
        HashMap<String, Throwable> exceptionMap = new HashMap<String, Throwable>();
        ArrayList<String> exceptionIds = new ArrayList<String>();
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList<Map> upgradeList = new ArrayList<Map>();
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ArrayList<String> errList = new ArrayList<String>();
        try {
            String id;
            Map map = mutexServiceControl.batchRequestObjIDForUpdate(ids);
            Iterator lt = ids.iterator();
            while (lt.hasNext()) {
                id = (String)lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                String mutexMsg = ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Error_ObjectUpdateLock_Request", (Locale)ctx.getLocale());
                EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", mutexMsg));
                exceptionMap.put(id, mutexException);
                exceptionIds.add(id);
                lt.remove();
            }
            if (ids.size() > 0) {
                id = null;
                DataUpgradeTraceInfo info = null;
                for (int i = 0; i < ids.size(); ++i) {
                    id = (String)ids.get(i);
                    info = (DataUpgradeTraceInfo)dataUpgradeMap.get(id);
                    try {
                        Map result = DataUpgradeTraceFactory.getLocalInstance(ctx).doDataUpgrade(info);
                        if (result.get("errMsg") != null) {
                            errList.add(((DataUpgradeTraceInfo)dataUpgradeMap.get(id)).getOperation() + ":" + result.get("errMsg"));
                        }
                        upgradeList.add(result);
                        continue;
                    }
                    catch (Throwable e) {
                        exceptionMap.put(id, e);
                        exceptionIds.add(id);
                        continue;
                    }
                    finally {
                        this._save(ctx, (IObjectValue)info);
                    }
                }
            }
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(ids);
        }
        if (exceptionIds.size() > 0) {
            for (String id : exceptionIds) {
                errList.add(((DataUpgradeTraceInfo)dataUpgradeMap.get(id)).getOperation() + ":" + ((Throwable)exceptionMap.get(id)).getMessage());
            }
        }
        ret.put("upgradeList", upgradeList);
        ret.put("errList", errList);
        ret.put("doneCount", Integer.valueOf(idSet.size() - errList.size()));
        return ret;
    }

    @Override
    protected Map _doDataUpgrade(Context ctx, DataUpgradeTraceInfo info) throws BOSException, EASBizException {
        String implClass = info.getImplClass();
        logger.error((Object)("IM executeUpgrade " + implClass));
        Map result = null;
        try {
            Class<?> clazz = Class.forName(implClass);
            Method method = clazz.getMethod("executeUpgrade", Context.class, DataUpgradeTraceInfo.class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(clazz.newInstance());
            method.setAccessible(true);
            result = (Map)txInvoker.invoke(method, new Object[]{ctx, info}, 0);
        }
        catch (Throwable e) {
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                throw new BOSException(e.getCause().getMessage());
            }
            if (e.getCause() != null) {
                throw new BOSException(e.getCause());
            }
            throw new BOSException(e);
        }
        return result;
    }

    @Override
    protected DataUpgradeTraceCollection _checkNeedDataUpgrade(Context ctx, String subsystem) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isProcessed", (Object)false));
        filter.getFilterItems().add(new FilterItemInfo("isAutoExcute", (Object)true));
        if (!StringUtils.isEmpty((String)subsystem)) {
            filter.getFilterItems().add(new FilterItemInfo("subsystem", (Object)subsystem));
        }
        view.setFilter(filter);
        DataUpgradeTraceCollection colls = this.getDataUpgradeTraceCollection(ctx, view);
        return colls;
    }

    @Override
    protected Map _checkUseDefaultFilter(Context ctx, List ids) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (ids == null || ids.size() == 0) {
            return result;
        }
        HashSet idSet = new HashSet();
        idSet.addAll(ids);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("operation"));
        sic.add(new SelectorItemInfo("hasDefualtFilter"));
        sic.add(new SelectorItemInfo("filterDescription"));
        sic.add(new SelectorItemInfo("defineConfig"));
        view.setSelector(sic);
        view.setFilter(filter);
        DataUpgradeTraceCollection colls = this.getDataUpgradeTraceCollection(ctx, view);
        DataUpgradeTraceInfo upgradeInfo = null;
        StringBuffer msg = new StringBuffer();
        boolean isShowDefultFilterMsg = false;
        if (colls != null && colls.size() > 0) {
            int j = colls.size();
            for (int i = 0; i < j; ++i) {
                upgradeInfo = colls.get(i);
                if (!StringUtils.isEmpty((String)upgradeInfo.getDefineConfig()) || !upgradeInfo.isHasDefualtFilter()) continue;
                msg.append("\u3010").append(upgradeInfo.getOperation()).append("\u3011\uff1a").append(upgradeInfo.getFilterDescription()).append("\r\n");
                isShowDefultFilterMsg = true;
            }
            if (isShowDefultFilterMsg) {
                msg.append("------------------------------------------------------------------------------------------------");
                msg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", (String)"DefineConfigTip", (Locale)ctx.getOriginLocale()));
                result.put("defultFilterMsg", msg.toString());
            }
        }
        return result;
    }
}

