/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.PoolInvoiceInfo;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.api.AbstractDataUpgrade;
import com.kingdee.eas.tm.im.util.IMSQLUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.invoice.IncomeInvoiceServerService;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AP2CoverNumberRelationUpgrade
extends AbstractDataUpgrade {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.upgrade.impl.AP2CoverNumberRelationUpgrade");
    private static final String TYPEID_APOTHERBILL = "9Rg2HWkfSP6nrCBS+MJLEEUgBI8=";

    @Override
    protected void doUpgrade(Context ctx, DataUpgradeTraceInfo info) throws EASBizException, BOSException {
        try {
            if (StringUtils.isEmpty((String)info.getDefineConfig())) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", "DefineConfig_NOT_NULLl", IMUtils.getLocale())});
            }
            String filterSql = this.buildFilterSql(ctx, info);
            this.buildInvoiceInfoRelationByPWY(ctx, filterSql);
            info.setIsProcessed(true);
            logger.debug((Object)"upgrade success");
        }
        catch (Exception e) {
            info.setIsProcessed(false);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void buildInvoiceInfoRelationByPWY(Context ctx, String filterSql) throws BOSException {
        try {
            this.checkPwySetting(ctx, filterSql);
            IncomeInvoiceServerService service = new IncomeInvoiceServerService();
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.getInvoiceInfoSql(filterSql));
            int billStatus = -1;
            while (rs.next()) {
                String billId = rs.getString("billId");
                String bizBillNumber = rs.getString("bizBillNumber");
                billStatus = rs.getInt("billStatus");
                String companyId = rs.getString("companyId");
                String taxNumber = rs.getString("taxNumber");
                String coverNumber = rs.getString("coverNumber");
                String invoiceCode = rs.getString("invoiceCode");
                String[] invoiceCodes = invoiceCode == null ? new String[]{} : invoiceCode.split(";");
                String invoiceNumber = rs.getString("invoiceNumber");
                String[] invoiceNumbers = invoiceNumber == null ? new String[]{} : invoiceNumber.split(";");
                PoolInvoiceInfo invoiceInfo = null;
                ArrayList<String> codeNumber = new ArrayList<String>();
                ArrayList<String> fidArray = new ArrayList<String>();
                for (int i = 0; i < invoiceNumbers.length; ++i) {
                    String key;
                    String invCode = "";
                    if (invoiceCodes.length > i) {
                        invCode = invoiceCodes[i];
                    }
                    if (codeNumber.contains(key = invCode + "_" + invoiceNumbers[i])) continue;
                    codeNumber.add(key);
                    invoiceInfo = service.getInvoiceInfo(ctx, invCode, invoiceNumbers[i]);
                    if (invoiceInfo == null || StringUtils.isEmpty((String)invoiceInfo.getSerialNo())) continue;
                    fidArray.add(invoiceInfo.getSerialNo());
                }
                try {
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    paramMap.put("ctx", ctx);
                    paramMap.put("bizBillType", TYPEID_APOTHERBILL);
                    paramMap.put("bizBillNumber", bizBillNumber);
                    paramMap.put("billId", billId);
                    paramMap.put("companyId", companyId);
                    paramMap.put("taxNumber", taxNumber);
                    if (!StringUtils.isEmpty((String)coverNumber)) {
                        paramMap.put("coverNumber", coverNumber);
                    }
                    if (fidArray.size() == 0) {
                        logger.error((Object)"fidArray is null.");
                    }
                    service.getPoolSyncService().saveInvoiceStatus(paramMap, fidArray);
                    if (2 == billStatus) {
                        service.getPoolSyncService().updateInvoiceStatus(paramMap, "30");
                        continue;
                    }
                    if (3 != billStatus) continue;
                    service.getPoolSyncService().updateInvoiceStatus(paramMap, "60");
                }
                catch (Exception e) {
                    logger.error((Object)("saveInvoiceStatus/updateInvoiceStatus error,e=" + e));
                    throw new BOSException(e.getMessage());
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private void checkPwySetting(Context ctx, String filterSql) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT OTHERBILL.FCompanyID as companyId, ").append("  COMPANY.FName_l2 as companyName ").append("FROM T_AP_OTHERBILL OTHERBILL ").append("INNER JOIN T_ORG_Company AS COMPANY ON OTHERBILL.FCompanyID = COMPANY.FID ").append("INNER JOIN T_WSC_BILLIMAGEMAP AS BILLIMAGE ON OTHERBILL.FID = BILLIMAGE.FBILLID ").append("where OTHERBILL.FBillStatus !=4  and OTHERBILL.FBillStatus !=-1  and OTHERBILL.FID in(").append(filterSql).append(")");
        logger.error((Object)("AP2CoverNumberRelationUpgradePwySettingCheck:" + sql.toString()));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String companyId = null;
            String companyName = null;
            HashMap<String, String> companyMap = new HashMap<String, String>();
            HashSet<String> companyIds = new HashSet<String>();
            StringBuffer companyNames = new StringBuffer();
            while (rs.next()) {
                companyId = rs.getString("companyId");
                companyName = rs.getString("companyName");
                companyMap.put(companyId, companyName);
                companyIds.add(companyId);
            }
            IncomeInvoiceServerService service = new IncomeInvoiceServerService();
            PwySettingInfo pwyInfo = null;
            for (String compangid : companyIds) {
                pwyInfo = service.getPwySettint(ctx, compangid);
                if (pwyInfo != null) continue;
                companyNames.append((String)companyMap.get(compangid)).append("\u3001");
            }
            if (companyNames.length() > 0) {
                throw new IMException(IMException.ERRORMSG, new Object[]{companyNames.toString().substring(0, companyNames.toString().length() - 1) + ": " + ResourceBase.getString((String)"com.kingdee.eas.tm.im.PwySettingResource", (String)"CHECK_PWYSETTING", (Locale)ctx.getLocale())});
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private String getInvoiceInfoSql(String filterSql) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT OTHERBILL.FID as billId, ").append("OTHERBILL.FNumber as bizBillNumber, ").append("OTHERBILL.FBillStatus as billStatus, ").append("OTHERBILL.FCompanyID as companyId, ").append("COMPANY.FTaxNumber as taxNumber, ").append("OTHERBILL.FInvoiceCode as invoiceCode, ").append("OTHERBILL.FInvoiceNumber as invoiceNumber, ").append("BILLIMAGE.FIMAGENUMBER as coverNumber ").append("FROM T_AP_OTHERBILL OTHERBILL ").append("INNER JOIN T_ORG_Company AS COMPANY ON OTHERBILL.FCompanyID = COMPANY.FID ").append("INNER JOIN T_WSC_BILLIMAGEMAP AS BILLIMAGE ON OTHERBILL.FID = BILLIMAGE.FBILLID ").append("where OTHERBILL.FBillStatus !=4  and OTHERBILL.FBillStatus !=-1  and OTHERBILL.FID in(").append(filterSql).append(")");
        logger.error((Object)("AP2CoverNumberRelationUpgrade:" + sql.toString()));
        return sql.toString();
    }

    protected String buildFilterSql(Context ctx, DataUpgradeTraceInfo info) throws BOSException {
        String sql = IMSQLUtil.structureFilter(ctx, info.getDefineConfig(), info.getQuery());
        return sql;
    }
}

