/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.MakeInvoiceTypeEnum;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.api.AbstractDataUpgrade;
import com.kingdee.eas.tm.im.util.IMSQLUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class BizYearMonthDataUpgrade
extends AbstractDataUpgrade {
    protected static Logger logger = Logger.getLogger(BizYearMonthDataUpgrade.class);

    @Override
    protected void doUpgrade(Context ctx, DataUpgradeTraceInfo info) throws EASBizException, BOSException {
        try {
            ctx.put((Object)"disablePermissionForKScript", (Object)true);
            if (StringUtils.isEmpty((String)info.getDefineConfig())) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", "DefineConfig_NOT_NULLl", IMUtils.getLocale())});
            }
            String billId = this.buildFilterSql(ctx, info);
            if (!StringUtils.isEmpty((String)billId)) {
                Map<String, Map<String, Set<String>>> idRelation = this.combinInvoiceRelation(ctx, billId);
                this.doOtherBeforeExecute(ctx, info, idRelation);
                List invoiceIDBizList = this.generateInvoiceToUpdate(ctx, idRelation);
                String sql = this.getUpdateSql();
                DbUtil.executeBatch((Context)ctx, (String)sql, (List)invoiceIDBizList);
            }
            info.setIsProcessed(true);
            logger.debug((Object)(this.getUpdateSql() + ":upgrade success"));
        }
        catch (Exception e) {
            info.setIsProcessed(false);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            ctx.remove((Object)"disablePermissionForKScript");
        }
    }

    protected void doOtherBeforeExecute(Context ctx, DataUpgradeTraceInfo info, Map<String, Map<String, Set<String>>> idRelation) throws Exception {
    }

    protected abstract List generateInvoiceToUpdate(Context var1, Map<String, Map<String, Set<String>>> var2) throws BOSException, EASBizException, SQLException;

    protected abstract Map<String, Map<String, Set<String>>> combinInvoiceRelation(Context var1, String var2) throws BOSException, EASBizException, SQLException;

    protected abstract String getUpdateSql();

    protected String buildFilterSql(Context ctx, DataUpgradeTraceInfo info) throws BOSException, SQLException {
        String sql = IMSQLUtil.structureFilter(ctx, info.getDefineConfig(), info.getQuery());
        HashSet<String> idSet = new HashSet<String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            idSet.add(rs.getString("ID"));
        }
        return IMUtils.getInStringFromSet(idSet);
    }

    protected MakeInvoiceTypeEnum getMakeInvoiceType(Date invoiceDate, Integer bizYear, Integer bizMonth) {
        if (invoiceDate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        String format = sdf.format(invoiceDate);
        int year = Integer.valueOf(format.substring(0, 4));
        int month = Integer.valueOf(format.substring(5, 6));
        if (bizYear != null && bizMonth != null && bizYear != 0 && bizMonth != 0) {
            if (bizYear > year || bizYear == year && bizMonth > month) {
                return MakeInvoiceTypeEnum.PreMakeInvoice;
            }
            if (bizYear < year || bizYear == year && bizMonth < month) {
                return MakeInvoiceTypeEnum.ReMakeInvoice;
            }
            if (bizYear == year && bizMonth == month) {
                return MakeInvoiceTypeEnum.CurrentPeriodSale;
            }
        }
        return null;
    }

    protected Integer dealZerotoNull(Integer num) {
        if (num != null && num != 0) {
            return num;
        }
        return null;
    }
}

