/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.MakeInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqFactory;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceReqStatusEnum;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.TaxSeparationCollection;
import com.kingdee.eas.tm.im.TaxSeparationEntryInfo;
import com.kingdee.eas.tm.im.TaxSeparationFactory;
import com.kingdee.eas.tm.im.TaxSeparationInfo;
import com.kingdee.eas.tm.im.TaxSeparationStatusEnum;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.MakeInvoiceReqDataInfo;
import com.kingdee.eas.tm.im.upgrade.api.AbstractDataUpgrade;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MakeInvoiceReqDataUpgrade
extends AbstractDataUpgrade {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.upgrade.impl.MakeInvoiceReqDataUpgrade");
    private static final Map<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
    private AsstActTypeInfo defaultAsstActType = null;

    @Override
    protected void doUpgrade(Context ctx, DataUpgradeTraceInfo info) throws EASBizException, BOSException {
        try {
            if (info.isIsProcessed()) {
                return;
            }
            ctx.put((Object)"disablePermissionForKScript", (Object)true);
            this.init(ctx);
            List<MakeInvoiceReqDataInfo> upgradeData = this.buildUpgradeData(ctx, info);
            this.updateReserveFields(ctx, upgradeData);
            this.saveBill(ctx, upgradeData);
            this.updateBOTRelation(ctx, upgradeData);
            this.deleteOldMenu(ctx);
            info.setIsProcessed(true);
            logger.debug((Object)"upgrade success");
        }
        catch (Exception e) {
            info.setIsProcessed(false);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            ctx.remove((Object)"disablePermissionForKScript");
        }
    }

    protected void init(Context ctx) {
        this.defaultAsstActType = this.getAsstActType(ctx, "T_BD_Customer");
    }

    protected List<MakeInvoiceReqDataInfo> buildUpgradeData(Context ctx, DataUpgradeTraceInfo info) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("customer.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.productCode.*"));
        sic.add(new SelectorItemInfo("entries.measureUnit.*"));
        view.setSelector(sic);
        ArrayList<MakeInvoiceReqDataInfo> upgradeData = new ArrayList<MakeInvoiceReqDataInfo>();
        TaxSeparationCollection coll = TaxSeparationFactory.getLocalInstance(ctx).getTaxSeparationCollection(view);
        MakeInvoiceReqInfo newInfo = null;
        TaxSeparationInfo oldInfo = null;
        MakeInvoiceReqDataInfo dataInfo = null;
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            oldInfo = (TaxSeparationInfo)it.next();
            newInfo = this.createMakeInvoiceReqInfo(ctx, oldInfo);
            dataInfo = new MakeInvoiceReqDataInfo();
            dataInfo.setNewInfo(newInfo);
            dataInfo.setOldInfo(oldInfo);
            upgradeData.add(dataInfo);
        }
        return upgradeData;
    }

    protected void saveBill(Context ctx, List<MakeInvoiceReqDataInfo> upgradeData) throws EASBizException, BOSException {
        Iterator<MakeInvoiceReqDataInfo> it = upgradeData.iterator();
        while (it.hasNext()) {
            MakeInvoiceReqFactory.getLocalInstance(ctx).save((CoreBaseInfo)it.next().getNewInfo());
        }
    }

    public BigDecimal isNullToZero(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return (BigDecimal)value;
    }

    protected void updateBOTRelation(Context ctx, List<MakeInvoiceReqDataInfo> upgradeData) throws BOSException {
        MakeInvoiceReqDataInfo dataInfo2 = null;
        ArrayList<Object[]> updParamsList = new ArrayList<Object[]>();
        ArrayList<Object[]> delParamsList = new ArrayList<Object[]>();
        for (MakeInvoiceReqDataInfo dataInfo2 : upgradeData) {
            updParamsList.add(new Object[]{"AC368D2D", dataInfo2.getNewInfo().getId().toString(), "3D667D4A", "412A6F98", dataInfo2.getOldInfo().getId().toString()});
            delParamsList.add(new Object[]{"3D667D4A", "412A6F98", dataInfo2.getOldInfo().getId().toString()});
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO T_BOT_Relation (fid,fsrcentityid,FDestEntityID,FSrcObjectID,FDestObjectID,FDate,");
        sql.append(" FOperatorID,FisEffected,FBOTMappingID,FType)");
        sql.append(" SELECT  NEWBOSID('59302EC6'),?,FDestEntityID,?,FDestObjectID,");
        sql.append(" FDate,FOperatorID,FisEffected,FBOTMappingID,FType ");
        sql.append(" FROM T_BOT_Relation where FSrcEntityID = ? and FdestEntityID=? and FsrcObjectID=?");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), updParamsList);
        sql.setLength(0);
        sql.append("DELETE FROM T_BOT_Relation where FSrcEntityID = ? and FdestEntityID=? and FsrcObjectID=?");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), delParamsList);
    }

    protected void updateReserveFields(Context ctx, List<MakeInvoiceReqDataInfo> upgradeData) throws BOSException {
        MakeInvoiceReqDataInfo dataInfo2 = null;
        HashMap<String, MakeInvoiceReqDataInfo> dataMap = new HashMap<String, MakeInvoiceReqDataInfo>();
        ArrayList paramsList = new ArrayList();
        ArrayList<Object[]> updParamsList = new ArrayList<Object[]>();
        for (MakeInvoiceReqDataInfo dataInfo2 : upgradeData) {
            dataMap.put(dataInfo2.getNewInfo().getId().toString(), dataInfo2);
            updParamsList.add(new Object[]{"AC368D2D", dataInfo2.getNewInfo().getId().toString(), dataInfo2.getOldInfo().getId().toString()});
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO T_IM_MakeInvoiceRelation (fid,FSrcBosType,FBizBillID,FInvoiceBillID,FGroupID,FQty,FAmount,FOperateTime)");
        sql.append(" select newbosid('0EBBB5B4'),?,?,FInvoiceBillID,FGroupID,FQty,FAmount,FOperateTime");
        sql.append(" FROM T_IM_MakeInvoiceRelation relation");
        sql.append(" INNER JOIN T_IM_TaxSeparation taxseq  on relation.FBizBillID = taxseq.FID");
        sql.append(" WHERE relation.FsrcBosType = '3D667D4A' ");
        sql.append(" and taxseq.fid = ?");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), updParamsList);
        sql.setLength(0);
        sql.append(" SELECT relation.FBizBillID,relation.FInvoiceBillID,invoice.FInvoiceNo,invoice.FInvoiceNumber,invoice.FPriceTaxTotal,relation.FOPERATETIME,invoice.FStatus ");
        sql.append(" FROM T_IM_MakeInvoiceRelation relation ");
        sql.append(" Inner join T_IM_MakeInvoice invoice on relation.FInvoiceBillID =invoice.fid");
        sql.append(" WHERE relation.FsrcBosType = 'AC368D2D' ");
        sql.append(" and invoice.fid not in (");
        sql.append("  SELECT fid FROM  t_im_makeinvoice where   FStatus = '99' or (FStatus = '4' and FIsRedVoicedBill  = 1) or fisRedVoice  = 1");
        sql.append(" )");
        sql.append(" ORDER by FOperateTime asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            MakeInvoiceReqDataInfo info = null;
            String bizBillID = null;
            String invoiceBillID = null;
            String invoiceNo = null;
            String invoiceNum = null;
            BigDecimal invoiceAmt = BigDecimal.ZERO;
            Timestamp invoiceDate = null;
            InvoiceBillStatus status = null;
            HashMap<String, BigDecimal> invoiceAmountMap = new HashMap<String, BigDecimal>();
            while (rs.next()) {
                bizBillID = rs.getString("FBizBillID");
                invoiceBillID = rs.getString("FInvoiceBillID");
                invoiceAmt = rs.getBigDecimal("FPriceTaxTotal");
                invoiceNo = rs.getString("FInvoiceNo");
                invoiceNum = rs.getString("FInvoiceNumber");
                invoiceDate = rs.getTimestamp("FOPERATETIME");
                status = InvoiceBillStatus.getEnum(rs.getString("FStatus"));
                info = (MakeInvoiceReqDataInfo)dataMap.get(bizBillID);
                if (!invoiceAmountMap.containsKey(invoiceBillID)) {
                    invoiceAmountMap.put(invoiceBillID, invoiceAmt);
                }
                if (info == null) continue;
                info.getNewInfo().setIsMakeInoviced(true);
                if (!InvoiceBillStatus.MAKED.equals((Object)status)) continue;
                info.getNewInfo().setIsInvoiced(true);
                info.getNewInfo().setInvoiceNo(info.getNewInfo().getInvoiceNo() == null ? invoiceNo : info.getNewInfo().getInvoiceNo() + ";" + invoiceNo);
                info.getNewInfo().setInvoiceCode(info.getNewInfo().getInvoiceCode() == null ? invoiceNum : info.getNewInfo().getInvoiceCode() + ";" + invoiceNum);
                info.getNewInfo().setInvoiceDate(invoiceDate);
                BigDecimal amount = info.getNewInfo().getPriceIncludingTax().subtract(info.getNewInfo().getInvoicedAmt());
                BigDecimal invoiceAmount = (BigDecimal)invoiceAmountMap.get(invoiceBillID);
                if (invoiceAmount.compareTo(BigDecimal.ZERO) == 0) continue;
                if (invoiceAmount.compareTo(amount) > 0) {
                    info.getNewInfo().setInvoicedAmt(info.getNewInfo().getInvoicedAmt().add(invoiceAmt));
                    invoiceAmountMap.put(invoiceBillID, invoiceAmount.subtract(amount));
                    continue;
                }
                invoiceAmountMap.put(invoiceBillID, BigDecimal.ZERO);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected MakeInvoiceReqInfo createMakeInvoiceReqInfo(Context ctx, TaxSeparationInfo info) throws EASBizException, BOSException {
        MakeInvoiceReqInfo newInfo = new MakeInvoiceReqInfo();
        newInfo.setId(BOSUuid.create((String)"AC368D2D"));
        newInfo.setNumber(info.getNumber());
        newInfo.setCompany(info.getCompany());
        newInfo.setBizDate(info.getBizDate());
        newInfo.setAsstActType(info.getAsstActType() == null ? this.defaultAsstActType : info.getAsstActType());
        newInfo.setAsstActID(info.getCustomer() != null ? info.getCustomer().getId().toString() : null);
        newInfo.setAsstActNumber(info.getCustomer() != null ? info.getCustomer().getNumber() : null);
        newInfo.setAsstActName(info.getCustomer() != null ? info.getCustomer().getName() : null);
        newInfo.setSrcSystem(MakeInvoiceReqSrcSystem.UPGRADE);
        newInfo.setStatus(TaxSeparationStatusEnum.treated.equals((Object)info.getStatus()) ? MakeInvoiceReqStatusEnum.AUDITED : MakeInvoiceReqStatusEnum.TEMPSTROE);
        newInfo.setCurrency(info.getCurrency());
        ExchangeRateInfo exchangeRateInfo = this.getExchangeRateInfo(ctx, newInfo);
        newInfo.setExchangeRate(exchangeRateInfo != null ? exchangeRateInfo.getConvertRate() : BigDecimal.ONE);
        newInfo.setConvertMode(exchangeRateInfo != null ? exchangeRateInfo.getConvertMode() : ConvertModeEnum.DIRECTEXCHANGERATE);
        newInfo.setIsInTax(true);
        newInfo.setTax(this.isNullToZero(info.getTax()));
        newInfo.setPriceExcludingTax(this.isNullToZero(info.getPriceExcludingTax()));
        newInfo.setPriceIncludingTax(this.isNullToZero(info.getPriceIncludingTax()));
        newInfo.setIsMakeInvoiceReq(info.isIsTaxSeparation());
        if (MakeInvoiceReqStatusEnum.AUDITED.equals((Object)newInfo.getStatus())) {
            newInfo.setAuditor(info.getLastUpdateUser());
            newInfo.setAuditTime(info.getLastUpdateTime());
        }
        newInfo.setSourceBillType(null);
        newInfo.setSourceBillNumber(null);
        newInfo.setIsMakeInoviced(false);
        newInfo.setInvoicedAmt(BigDecimal.ZERO);
        newInfo.setAbstractName(info.getDescription());
        newInfo.setDescription(info.getId().toString());
        newInfo.setIsPriceWithoutTax(false);
        newInfo.setIsPurchaseInvoice(false);
        newInfo.setRecOrgName(info.getRecOrgName());
        newInfo.setTaxNumber(info.getTaxNumber());
        newInfo.setAddress(info.getAddress());
        newInfo.setBankAccount(info.getBankAccount());
        MakeInvoiceReqEntryInfo newEntryInfo = null;
        Iterator it = info.getEntries().iterator();
        while (it.hasNext()) {
            newEntryInfo = this.createMakeInvoiceReqEntryInfo(ctx, (TaxSeparationEntryInfo)it.next());
            newEntryInfo.setParent(newInfo);
            newInfo.getEntries().add(newEntryInfo);
        }
        return newInfo;
    }

    private AsstActTypeInfo getAsstActType(Context ctx, String realtion) {
        AsstActTypeInfo asstActTypeInfo = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("realtionDataObject", (Object)realtion));
        try {
            entityViewInfo.setFilter(filter);
            AsstActTypeCollection col = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(entityViewInfo);
            if (!col.isEmpty()) {
                asstActTypeInfo = col.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"getAsstActTypeCollection failed.");
        }
        return asstActTypeInfo;
    }

    protected MakeInvoiceReqEntryInfo createMakeInvoiceReqEntryInfo(Context ctx, TaxSeparationEntryInfo entryInfo) {
        MakeInvoiceReqEntryInfo newEntryInfo = new MakeInvoiceReqEntryInfo();
        newEntryInfo.setMaterial(this.getMaterial(entryInfo.getProductCode()));
        newEntryInfo.setUnit(entryInfo.getMeasureUnit());
        newEntryInfo.setProductName(entryInfo.getProductName());
        newEntryInfo.setTaxClassificationCode(entryInfo.getTaxClassificationCode());
        newEntryInfo.setUnitName(entryInfo.getMeasureUnit() != null ? entryInfo.getMeasureUnit().getName() : null);
        newEntryInfo.setQty(entryInfo.getQuantity());
        newEntryInfo.setSpecs(entryInfo.getSpecification());
        newEntryInfo.setPrice(entryInfo.getPrice());
        newEntryInfo.setQty(entryInfo.getQuantity());
        if (newEntryInfo.getUnit() == null) {
            newEntryInfo.setBaseQty(entryInfo.getQuantity());
        }
        newEntryInfo.setTaxRate(entryInfo.getTaxRate() != null ? entryInfo.getTaxRate().multiply(new BigDecimal(100)) : null);
        newEntryInfo.setNoTaxPrice(entryInfo.getNoTaxPrice());
        newEntryInfo.setTax(this.isNullToZero(entryInfo.getTax()));
        newEntryInfo.setPriceExcludingTax(this.isNullToZero(entryInfo.getPriceExcludingTax()));
        newEntryInfo.setPriceIncludingTax(this.isNullToZero(entryInfo.getPriceIncludingTax()));
        newEntryInfo.setDiscountType(DiscountModeEnum.PERCENT);
        newEntryInfo.setDiscountRate(entryInfo.getDiscountRate());
        newEntryInfo.setDiscountAmount(entryInfo.getDiscountAmount());
        newEntryInfo.setSourceBillEntryId(entryInfo.getSourceBillEntryId());
        return newEntryInfo;
    }

    protected ExchangeRateInfo getExchangeRateInfo(Context ctx, MakeInvoiceReqInfo info) throws EASBizException, BOSException {
        ExchangeRateInfo exchangeRateInfo = null;
        if (info.getCompany() != null) {
            String companyID = info.getCompany().getId().toString();
            CompanyOrgUnitInfo company = companyMap.get(companyID);
            if (company == null) {
                ObjectUuidPK pk = new ObjectUuidPK(companyID);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("CU.id"));
                sic.add(new SelectorItemInfo("isOnlyUnion"));
                sic.add(new SelectorItemInfo("baseCurrency.name"));
                sic.add(new SelectorItemInfo("baseCurrency.number"));
                sic.add(new SelectorItemInfo("baseCurrency.precision"));
                sic.add(new SelectorItemInfo("CU.longNumber"));
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk, sic);
                companyMap.put(companyID, company);
            }
            info.setCompany(company);
            if (info.getCurrency() == null) {
                info.setCurrency(company.getBaseCurrency());
            }
            exchangeRateInfo = IMUtils.getExchangeRate(ctx, info.getCompany(), info.getCurrency(), info.getBizDate());
        }
        return exchangeRateInfo;
    }

    protected MaterialInfo getMaterial(ProductCodeInfo productInfo) {
        if (productInfo == null) {
            return null;
        }
        MaterialInfo material = productInfo.getMaterial();
        return material;
    }

    protected void deleteOldMenu(Context ctx) throws BOSException {
        String menuID = "+tR4XqWKQFqg4oilITWP5BdCz6U=";
        ArrayList<String> sqlDelete = new ArrayList<String>();
        sqlDelete.add("delete from t_bas_sysmenuitem where fid = '" + menuID + "'");
        sqlDelete.add("delete from t_pm_mainmenuitem where fid = '" + menuID + "'");
        String[] delSql = new String[sqlDelete.size()];
        for (int i = 0; i < sqlDelete.size(); ++i) {
            delSql[i] = (String)sqlDelete.get(i);
        }
        DBUtil.executeBatch((Context)ctx, (String[])delSql);
    }
}

