/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.common.writeback.app.handler.Invoice2SaleOrderUpgradeDisposerAdapter;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReq2SaleOrderDisposer;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.api.AbstractDataUpgrade;
import com.kingdee.eas.tm.im.util.IMSQLUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class SaleOrderDataUpgrade
extends AbstractDataUpgrade {
    private static Logger logger = Logger.getLogger((String)SaleOrderDataUpgrade.class.getName());

    @Override
    protected void doUpgrade(Context ctx, DataUpgradeTraceInfo info) throws EASBizException, BOSException {
        try {
            ctx.put((Object)"disablePermissionForKScript", (Object)true);
            if (StringUtils.isEmpty((String)info.getDefineConfig())) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", "DefineConfig_NOT_NULLl", IMUtils.getLocale())});
            }
            String filterSql = this.buildFilterSql(ctx, info);
            this.initBillUpgrade(ctx, filterSql);
            InvoiceReq2SaleOrderDisposer entryDisposer = new InvoiceReq2SaleOrderDisposer(99, filterSql);
            entryDisposer.dispose(ctx, "save", null);
            Invoice2SaleOrderUpgradeDisposerAdapter billDisposer = new Invoice2SaleOrderUpgradeDisposerAdapter(filterSql);
            billDisposer.dispose(ctx, "make", null);
            logger.debug((Object)"upgrade success");
        }
        catch (Exception e) {
            info.setIsProcessed(false);
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            ctx.remove((Object)"disablePermissionForKScript");
        }
    }

    protected void initBillUpgrade(Context ctx, String filterSql) throws BOSException {
        String billInitSql = this.getUpdateBillInitSql(filterSql);
        DbUtil.execute((Context)ctx, (String)billInitSql);
        String billEntryInitSql = this.getUpdateBillEntryInitSql(filterSql);
        DbUtil.execute((Context)ctx, (String)billEntryInitSql);
    }

    protected String getUpdateBillInitSql(String filterSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_SD_SaleOrder set");
        sql.append(" FINVOICENUMBER=null,FINVOICEAMT = 0");
        sql.append(" where FID in (").append(filterSql).append(")");
        return sql.toString();
    }

    protected String getUpdateBillEntryInitSql(String filterSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_SD_SaleOrderEntry set");
        sql.append(" FUnInvoiceReqQty = FQty,");
        sql.append(" FUnInvoiceReqBaseQty = FBaseQty,");
        sql.append(" FUnInvoiceReqAmount = FTaxAmount,");
        sql.append(" FUnInvoiceReqAmountLocal = FLocalTaxAmount,");
        sql.append(" FInvoiceReqQty = 0,");
        sql.append(" FInvoiceReqBaseQty = 0,");
        sql.append(" FInvoiceReqAmount = 0,");
        sql.append(" FInvoiceReqAmountLocal = 0");
        sql.append(" where FPARENTID in (").append(filterSql).append(")");
        return sql.toString();
    }

    protected String buildFilterSql(Context ctx, DataUpgradeTraceInfo info) throws BOSException {
        return IMSQLUtil.structureFilter(ctx, info.getDefineConfig(), info.getQuery());
    }
}

