/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.tm.im.ITaxClassificationCode;
import com.kingdee.eas.tm.im.ProductCodeCollection;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Collection2MapUtils {
    public static Map<String, TaxClassificationCodeInfo> getTaxClassificationCodeInfoMap(Context ctx, Set tccCodeSet) throws BOSException {
        HashMap<String, TaxClassificationCodeInfo> tccMap = new HashMap<String, TaxClassificationCodeInfo>();
        if (tccCodeSet.size() == 0) {
            return tccMap;
        }
        ITaxClassificationCode iTaxClassificationCode = ctx == null ? TaxClassificationCodeFactory.getRemoteInstance() : TaxClassificationCodeFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)tccCodeSet, CompareType.INCLUDE));
        TaxClassificationCodeCollection tccColl = iTaxClassificationCode.getTaxClassificationCodeCollection(view);
        TaxClassificationCodeInfo tccInfo = null;
        int size = tccColl.size();
        for (int i = 0; i < size; ++i) {
            tccInfo = tccColl.get(i);
            tccMap.put(tccInfo.getMergeCode(), tccInfo);
        }
        return tccMap;
    }

    public static Map<String, ProductCodeInfo> getProductCodeInfoMap(Context ctx, Set prodoctIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)prodoctIdSet, CompareType.INCLUDE));
        ProductCodeCollection productColl = ProductCodeFactory.getLocalInstance(ctx).getProductCodeCollection(view);
        ProductCodeInfo productCodeInfo = null;
        HashMap<String, ProductCodeInfo> productCodeMap = new HashMap<String, ProductCodeInfo>();
        int size = productColl.size();
        for (int i = 0; i < size; ++i) {
            productCodeInfo = productColl.get(i);
            productCodeMap.put(productCodeInfo.getId().toString(), productCodeInfo);
        }
        return productCodeMap;
    }
}

