/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class IMDBUtils {
    public static IRowSet executeQuery(Context ctx, String selectSql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(selectSql);
            ResultSet rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)con);
        return jdbcRowSet;
    }

    public static IRowSet getRowSet(Context ctx, String sql, int start, int len) throws BOSException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (int)start, (int)len);
            int rowCount = 0;
            int idListSize = IMDBUtils.getCriticalIDSize();
            DynamicRowSet drs = IMDBUtils.createRowSet((ResultSet)rs);
            while (rs.next()) {
                drs.moveToInsertRow();
                for (int i = 1; i <= drs.getMetaData().getColumnCount(); ++i) {
                    IMDBUtils.populateRowSetCell(drs, (ResultSet)rs, i);
                }
                drs.insertRow();
                if (idListSize == 0 || ++rowCount <= idListSize) continue;
                throw new FetchedTooMuchRowsException("fetched too much rows:" + rowCount + " SQL: " + sql);
            }
            drs.beforeFirst();
            return drs;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static void populateRowSetCell(DynamicRowSet drs, ResultSet rs, int i) throws SQLException {
        int type = rs.getMetaData().getColumnType(i);
        Object colValue = rs.getObject(i);
        if (colValue == null) {
            drs.updateNull(i);
        } else {
            switch (type) {
                case -7: {
                    drs.updateByte(i, rs.getByte(i));
                    break;
                }
                case 91: {
                    drs.updateDate(i, rs.getDate(i));
                    break;
                }
                case 92: {
                    drs.updateTime(i, rs.getTime(i));
                    break;
                }
                case 93: {
                    drs.updateTimestamp(i, rs.getTimestamp(i));
                    break;
                }
                case 4: {
                    drs.updateInt(i, rs.getInt(i));
                    break;
                }
                case 6: {
                    drs.updateFloat(i, rs.getFloat(i));
                    break;
                }
                case 3: {
                    drs.updateBigDecimal(i, rs.getBigDecimal(i));
                    break;
                }
                case 8: {
                    drs.updateDouble(i, rs.getDouble(i));
                    break;
                }
                case 5: {
                    drs.updateShort(i, rs.getShort(i));
                    break;
                }
                case -5: {
                    drs.updateLong(i, rs.getLong(i));
                    break;
                }
                default: {
                    drs.updateObject(i, colValue);
                }
            }
        }
    }

    private static int getCriticalIDSize() {
        IDeployInfoManager manager = DeployInfoManagerFactory.getDeployInfoManager();
        return manager.getCriticalIDList();
    }

    private static DynamicRowSet createRowSet(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int colCount = meta.getColumnCount();
        DynamicRowSet drs = new DynamicRowSet(colCount);
        for (int i = 1; i < colCount + 1; ++i) {
            ColInfo col = new ColInfo(meta.getColumnName(i), meta.getColumnLabel(i), meta.getColumnType(i), null);
            drs.setColInfo(i, col);
        }
        return drs;
    }
}

