/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class PrecisionUtil {
    public static String formatDecimal(BigDecimal val, int scale) {
        if (val == null) {
            return "";
        }
        DecimalFormat decimalFormat = PrecisionUtil.getDecimalFormat();
        decimalFormat.applyPattern(PrecisionUtil.toPattern(scale));
        return decimalFormat.format(val);
    }

    private static String toPattern(int scale) {
        String pattern = null;
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        return pattern;
    }

    public static DecimalFormat getDecimalFormat() {
        NumberFormat nf;
        DecimalFormat decimalFormat = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        if (decimalFormat == null && (nf = BOSLocaleUtil.getNumberFormat()) instanceof DecimalFormat) {
            decimalFormat = (DecimalFormat)nf;
        }
        return decimalFormat;
    }
}

