/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TCCUtil {
    public static Set<PreferentialPoliciesEnum> getPreferentialPoliciesByTCC(String key) {
        HashSet<PreferentialPoliciesEnum> enums = new HashSet<PreferentialPoliciesEnum>();
        enums.add(PreferentialPoliciesEnum.DutyFree);
        enums.add(PreferentialPoliciesEnum.NoTaxation);
        if (null == key || key.isEmpty()) {
            return enums;
        }
        String[] keys = key.split("\u3001");
        block0: for (int i = 0; i < keys.length; ++i) {
            List enumList = PreferentialPoliciesEnum.getEnumList();
            for (PreferentialPoliciesEnum _enum : enumList) {
                if (!_enum.getAlias().equals(keys[i])) continue;
                enums.add(_enum);
                continue block0;
            }
        }
        return enums;
    }

    public static List<BigDecimal> getTaxRateByPolicies(PreferentialPoliciesEnum policies) {
        ArrayList<BigDecimal> taxRateList = new ArrayList<BigDecimal>();
        if (PreferentialPoliciesEnum.DutyFree.equals((Object)policies)) {
            taxRateList.add(new BigDecimal("0").setScale(4, 4));
        } else if (PreferentialPoliciesEnum.NoTaxation.equals((Object)policies)) {
            taxRateList.add(new BigDecimal("0").setScale(4, 4));
        } else if (PreferentialPoliciesEnum.Simple.equals((Object)policies)) {
            taxRateList.add(new BigDecimal("0.05").setScale(4, 4));
            taxRateList.add(new BigDecimal("0.04").setScale(4, 4));
            taxRateList.add(new BigDecimal("0.03").setScale(4, 4));
        } else if (PreferentialPoliciesEnum.Simple3Per.equals((Object)policies)) {
            taxRateList.add(new BigDecimal("0.03").setScale(4, 4));
        } else if (PreferentialPoliciesEnum.Simple5Per.equals((Object)policies)) {
            taxRateList.add(new BigDecimal("0.05").setScale(4, 4));
        } else if (PreferentialPoliciesEnum.Simple5Per15.equals((Object)policies)) {
            taxRateList.add(new BigDecimal("0.05").setScale(4, 4));
        } else {
            return null;
        }
        return taxRateList;
    }

    public static Map<String, List<BigDecimal>> getTaxRateByPoliciesMap() {
        HashMap<String, List<BigDecimal>> result = new HashMap<String, List<BigDecimal>>();
        ArrayList<BigDecimal> taxRateList = new ArrayList<BigDecimal>();
        taxRateList = new ArrayList();
        taxRateList.add(new BigDecimal("0"));
        result.put(PreferentialPoliciesEnum.DutyFree.getValue(), taxRateList);
        taxRateList = new ArrayList();
        taxRateList.add(new BigDecimal("0"));
        result.put(PreferentialPoliciesEnum.NoTaxation.getValue(), taxRateList);
        taxRateList = new ArrayList();
        taxRateList.add(new BigDecimal("0.05"));
        taxRateList.add(new BigDecimal("0.04"));
        taxRateList.add(new BigDecimal("0.03"));
        result.put(PreferentialPoliciesEnum.Simple.getValue(), taxRateList);
        taxRateList = new ArrayList();
        taxRateList.add(new BigDecimal("0.03"));
        result.put(PreferentialPoliciesEnum.Simple3Per.getValue(), taxRateList);
        taxRateList = new ArrayList();
        taxRateList.add(new BigDecimal("0.05"));
        result.put(PreferentialPoliciesEnum.Simple5Per.getValue(), taxRateList);
        taxRateList = new ArrayList();
        taxRateList.add(new BigDecimal("0.05"));
        result.put(PreferentialPoliciesEnum.Simple5Per15.getValue(), taxRateList);
        return result;
    }

    public static void initTaxClassificationCode(Map result, TaxClassificationCodeInfo taxClassificationCode, boolean hasPreferential) {
        String vatSpecialManagement = taxClassificationCode.getVATSpecialManagement();
        if (PreferentialPoliciesEnum.NoTaxation.getAlias().equals(vatSpecialManagement) && BigDecimal.ZERO.equals(taxClassificationCode.getTaxRate())) {
            result.put("zeroNoTaxationFlag", true);
            result.put("hasPreferential", true);
            result.put("preferentialPolicies", PreferentialPoliciesEnum.NoTaxation);
            hasPreferential = true;
        }
        Set<PreferentialPoliciesEnum> policiesSet = TCCUtil.getPreferentialPoliciesByTCC(vatSpecialManagement);
        ArrayList<PreferentialPoliciesEnum> policies = new ArrayList<PreferentialPoliciesEnum>();
        if (!hasPreferential) {
            policies.add(PreferentialPoliciesEnum.Null);
        }
        policies.addAll(policiesSet);
        result.put("policies", policies);
    }

    public static SelectorItemCollection getTCCSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("taxRate"));
        sic.add(new SelectorItemInfo("mergeCode"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("VATSpecialManagement"));
        sic.add(new SelectorItemInfo("VATSpecialNum"));
        return sic;
    }
}

