/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class ZipUtils {
    private static Logger logger = Logger.getLogger(ZipUtils.class);

    private ZipUtils() {
    }

    public static void doCompress(String srcFile, String zipFile) {
        ZipUtils.doCompress(new File(srcFile), new File(zipFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doCompress(File srcFile, File zipFile) {
        ZipOutputStream out = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(zipFile);
            out = new ZipOutputStream(fileOutputStream);
            ZipUtils.doCompress(srcFile, out);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void doCompress(String filelName, ZipOutputStream out) {
        ZipUtils.doCompress(new File(filelName), out);
    }

    public static void doCompress(File file, ZipOutputStream out) {
        ZipUtils.doCompress(file, out, "");
    }

    public static void doCompress(File inFile, ZipOutputStream out, String dir) {
        if (inFile.isDirectory()) {
            File[] files = inFile.listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    String name = inFile.getName();
                    if (!"".equals(dir)) {
                        name = dir + File.separator + name;
                    }
                    ZipUtils.doCompress(file, out, name);
                }
            }
        } else {
            ZipUtils.doZip(inFile, out, dir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doZip(File inFile, ZipOutputStream out, String dir) {
        String entryName = null;
        entryName = !"".equals(dir) ? dir + File.separator + inFile.getName() : inFile.getName();
        FileInputStream fis = null;
        try {
            ZipEntry entry = new ZipEntry(entryName);
            out.putNextEntry(entry);
            int len = 0;
            byte[] buffer = new byte[1024];
            fis = new FileInputStream(inFile);
            while ((len = fis.read(buffer)) > 0) {
                out.write(buffer, 0, len);
                out.flush();
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.closeEntry();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doZip(String fileName, byte[] data, ZipOutputStream out) {
        ZipEntry entry = new ZipEntry(fileName);
        try {
            out.putNextEntry(entry);
            out.write(data);
            out.flush();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.closeEntry();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        ZipUtils.doCompress("D:/java/", "D:/java.zip");
    }
}

