/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util.invoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ap.OtherBillCollection;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.common.httpClient.HttpClientUtil;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceType;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.PwyUrlHelp;
import com.kingdee.eas.tm.im.client.comp.IncomeInvoiceMutilSelectListUIPromptDialog;
import com.kingdee.eas.tm.im.client.comp.InvoiceHelperUI;
import com.kingdee.eas.tm.im.client.comp.PwyInvoiceHelper;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.param.InvoiceHelperParam;
import com.kingdee.eas.tm.im.util.ExplorerUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.invoice.interfaces.IIncomeInvoiceClientService;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IncomeInvoiceClientService
implements IIncomeInvoiceClientService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.util.invoice.IncomeInvoiceClientService");
    private static final String MSG = "msg";
    private static final String CONNECTOR = "_";

    public Map getIncomeInvoiceId(Map params) throws BOSException {
        EntityViewInfo view = (EntityViewInfo)params.get("view");
        IncomeInvoiceInfo invoiceInfo = null;
        String invoiceId = null;
        HashMap<String, String> ret = new HashMap<String, String>();
        IncomeInvoiceCollection invoiceColl = IncomeInvoiceFactory.getRemoteInstance().getIncomeInvoiceCollection(view);
        if (invoiceColl == null || invoiceColl.size() == 0) {
            invoiceId = BOSUuid.create((BOSObjectType)new IncomeInvoiceInfo().getBOSType()).toString();
            ret.put("newInvoiceId", invoiceId);
        } else {
            invoiceInfo = invoiceColl.get(0);
            invoiceId = invoiceInfo.getId().toString();
            ret.put("newInvoiceId", "");
        }
        ret.put("invoiceId", invoiceId);
        return ret;
    }

    public Map viewInvoiceId(Map params) throws BOSException {
        String otherbillId = (String)params.get("otherbillId");
        ArrayList<String> urls = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        StringBuffer str = new StringBuffer();
        HashMap<String, Serializable> invoiceUrl = new HashMap<String, Serializable>();
        SQLExecutor sqlExecutor = new SQLExecutor("select FInvoiceNumber,FPdfUrl as url from T_IM_IncomeInvoice where  FID in (   Select  FSrcObjectID from T_BOT_Relation where  FDESTEntityID = '48DA3A71'  and FSRCEntityID = '1343913D'   and FDestObjectID = '" + otherbillId + "') ;");
        IRowSet rs = sqlExecutor.executeSQL();
        try {
            while (rs.next()) {
                String viewInvoiceURL = rs.getString("url");
                String invoiceNumber = rs.getString("FInvoiceNumber");
                if (viewInvoiceURL == null) {
                    sb.append(EASResource.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"InvoiceUrlNotExist", (Object[])new Object[]{invoiceNumber}) + "\n");
                    continue;
                }
                urls.add(viewInvoiceURL);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (rs.size() == 0) {
            str.append(EASResource.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"OtherbillNotMatch") + "\n");
        }
        invoiceUrl.put("urls", urls);
        invoiceUrl.put(MSG, sb);
        invoiceUrl.put("OtherbillNotMatch", str);
        return invoiceUrl;
    }

    public Map getIncomeInvoiceInfo(Map params) throws Exception {
        CoreUI ui = (CoreUI)params.get("ui");
        Map otherData = (Map)params.get("otherData");
        InvoiceHelperParam helperParam = new InvoiceHelperParam();
        if (otherData.containsKey("invoiceCode")) {
            String invoiceCodeStr = otherData.get("invoiceCode").toString().replace("FULL", " ");
            helperParam.setInvoiceCode(invoiceCodeStr.split(";|\uff1b"));
            helperParam.setDefaultInvoiceCode(otherData.get("invoiceCode").toString());
        }
        if (otherData.containsKey("invoiceNumber")) {
            helperParam.setInvoiceNumber(otherData.get("invoiceNumber").toString().split(";|\uff1b"));
            helperParam.setDefaultInvoiceNumber(otherData.get("invoiceNumber").toString());
        }
        if (otherData.containsKey("CompanyOrgUnitInfo")) {
            helperParam.setCompany((CompanyOrgUnitInfo)otherData.get("CompanyOrgUnitInfo"));
        }
        if (otherData.containsKey("currAcct")) {
            helperParam.setCurrAcct((DataBaseInfo)otherData.get("currAcct"));
        } else if (otherData.containsKey("currAcctSupplier")) {
            helperParam.setCurrAcct((DataBaseInfo)otherData.get("currAcctSupplier"));
        }
        if (otherData.containsKey("billId")) {
            helperParam.getParams().put("billId", otherData.get("billId"));
        }
        if (otherData.containsKey("billNumber")) {
            helperParam.getParams().put("billNumber", otherData.get("billNumber"));
        }
        helperParam.setOtherbill(true);
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"InvoiceHelperParam", (Object)helperParam);
        String uiClass = "com.kingdee.eas.tm.im.client.comp.InvoiceHelperUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        InvoiceHelperUI scanUI = (InvoiceHelperUI)uiWindow.getUIObject();
        return scanUI.getResultMap();
    }

    public HashMap viewInvoicePdf(Map params) throws Exception {
        Set invoiceIds = IncomeInvoiceFacadeFactory.getRemoteInstance().getInvoiceIds(params);
        HashMap<String, String> result = new HashMap<String, String>();
        String msg = null;
        if (invoiceIds.size() == 0) {
            msg = IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "DESCBILL_NOTEXIST", IMUtils.getLocale());
        } else {
            boolean existUrl = false;
            Map PdfUrlMap = IncomeInvoiceFacadeFactory.getRemoteInstance().getPdfUrlMap(invoiceIds);
            for (String id : invoiceIds) {
                String viewInvoiceURL = (String)PdfUrlMap.get(id);
                if (StringUtils.isEmpty((String)viewInvoiceURL)) continue;
                existUrl = true;
                ExplorerUtil.browse(viewInvoiceURL);
            }
            if (!existUrl) {
                msg = IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "InvoiceURL_NotExist", IMUtils.getLocale());
            }
        }
        result.put(MSG, msg);
        return result;
    }

    public Map getAmountTaxSum(Map params) throws Exception {
        HashMap<String, BigDecimal> ret = new HashMap<String, BigDecimal>();
        BigDecimal totalAmountTax = BigDecimal.ZERO;
        BigDecimal amountTax = BigDecimal.ZERO;
        Set invoiceIds = IncomeInvoiceFacadeFactory.getRemoteInstance().getInvoiceIds(params);
        if (invoiceIds.size() == 0) {
            return ret;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)invoiceIds, CompareType.INCLUDE));
        view.setFilter(filter);
        IncomeInvoiceInfo info = null;
        IncomeInvoiceCollection invoiceBills = IncomeInvoiceFactory.getRemoteInstance().getIncomeInvoiceCollection(view);
        int size = invoiceBills.size();
        for (int i = 0; i < size; ++i) {
            info = invoiceBills.get(i);
            amountTax = BigDecimal.ZERO;
            if (info.getAmountTax() != null) {
                amountTax = info.getAmountTax();
            }
            totalAmountTax = totalAmountTax.add(amountTax);
        }
        if (invoiceBills.size() > 0) {
            ret.put("totalAmountTax", totalAmountTax);
        }
        return ret;
    }

    public HashMap viewInvoiceImage(Map params) throws Exception {
        HashMap result = new HashMap();
        String companyId = (String)params.get("companyId");
        String billNumber = (String)params.get("billNumber");
        String billId = (String)params.get("billId");
        Boolean isFromAp = (Boolean)params.get("isFromAp");
        String invoiceCode = (String)params.get("invoiceCode");
        String invoiceNumber = (String)params.get("invoiceNumber");
        result.put("invoiceCode", invoiceCode);
        result.put("invoiceNumber", invoiceNumber);
        if (isFromAp != null) {
            result.put("isFromAp", isFromAp);
        }
        Boolean isIntegratedByPWY = (Boolean)params.get("isIntegratedByPWY");
        if (result.get(MSG) == null) {
            if (isIntegratedByPWY.booleanValue()) {
                this.getUserKey(companyId, billNumber, billId, result);
                if (result.get(MSG) != null) {
                    return result;
                }
                ExplorerUtil.browse(PwyUrlHelp.getWebViewImageUrl() + result.get("userKey"));
                result.put("isSuccess", true);
            } else {
                result = this.viewInvoicePdf(params);
            }
        }
        return result;
    }

    private void getUserKey(String companyId, String billNumber, String billId, Map resultMap) throws BOSException, EASBizException, UnsupportedEncodingException {
        PwySettingInfo pwySetting;
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (!StringUtils.isEmpty((String)companyId)) {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        }
        if ((pwySetting = (PwySettingInfo)PwySettingFactory.getRemoteInstance().getPwySetting(company.getId().toString(), OPTypeEnum.RecInvoice, null, null)) == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "pwySettingIsNull", IMUtils.getLocale())});
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)billId)) {
            OtherBillCollection col = OtherBillFactory.getRemoteInstance().getOtherBillCollection("where number='" + billNumber + "'");
            if (col == null || col.size() == 0) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "billNumberIsNull", IMUtils.getLocale())});
            }
            params.put("bxd_key", col.get(0).getId().toString());
        } else {
            params.put("bxd_key", billId);
        }
        if (resultMap.get("isFromAp") != null && resultMap.get("isFromAp").equals(true)) {
            if (resultMap.get("invoiceCode") != null && resultMap.get("invoiceNumber") != null) {
                String[] invoiceCodes = ((String)resultMap.get("invoiceCode")).split(";|\uff1b");
                String[] invoiceNumbers = ((String)resultMap.get("invoiceNumber")).split(";|\uff1b");
                HashSet InvoiceSerialNoSet = IncomeInvoiceFacadeFactory.getRemoteInstance().getInvoiceSerialNo(Arrays.asList(invoiceCodes), Arrays.asList(invoiceNumbers));
                params.put("invoiceSerialNos", StringUtils.arrayToString((Object[])InvoiceSerialNoSet.toArray(), (String)","));
            } else {
                params.put("invoiceSerialNos", "");
            }
        }
        String clientID = pwySetting.getClientId();
        String secret = pwySetting.getClientSecret();
        long timestamp = System.currentTimeMillis();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String tin = company.getTaxNumber();
        String ghf_mc = company.getRegisteredCode();
        String eid = URLEncoder.encode(userID, "UTF-8");
        String sign = IMUtils.getSign(clientID, secret, timestamp);
        double random = new SecureRandom().nextDouble();
        StringBuffer url = new StringBuffer();
        params.put("timestamp", timestamp);
        params.put("client_id", clientID);
        params.put("tin", tin);
        params.put("ghf_mc", ghf_mc);
        params.put("eid", eid);
        params.put("sign", sign);
        params.put("billNumber", billNumber);
        params.put("random", random);
        params.put("billType", "");
        String tokenParam = Kson.getGson().toJson(params);
        String userKeyUrl = PwyUrlHelp.getUserKeyUrl();
        try {
            String userKey = HttpClientUtil.doPost((String)userKeyUrl, (String)tokenParam);
            if (userKey != null) {
                JSONObject json = new JSONObject(userKey);
                if ("0000".equals(json.getString("errcode"))) {
                    resultMap.put("userKey", json.getJSONObject("data").getString("userKey"));
                } else {
                    resultMap.put(MSG, json.getString("description"));
                }
            } else {
                resultMap.put(MSG, "\u8bf7\u6c42userKey\u5931\u8d25\uff01 url : " + url + " tokenParam : " + tokenParam);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u8bf7\u6c42userKey\u5931\u8d25\uff01 url : " + url + " e: " + e.getMessage()), (Throwable)e);
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
    }

    protected Map openPwyHelper(Map params) throws Exception {
        HashMap ret = new HashMap();
        CoreUI ui = (CoreUI)params.get("ui");
        PwyInvoiceHelper pwyinvoiceHelper = new PwyInvoiceHelper(ui);
        InvoiceHelperParam helperParam = new InvoiceHelperParam();
        helperParam.setCompany((CompanyOrgUnitInfo)params.get("CompanyOrgUnitInfo"));
        if (params.containsKey("currAcctSupplier")) {
            helperParam.setCurrAcct((DataBaseInfo)params.get("currAcctSupplier"));
        }
        helperParam.setOperation(InvoiceHelperParam.OPR_DOWNLOAD);
        helperParam.setOtherbill(true);
        Set invoiceSerialNo = (Set)params.get("invoiceSerialNos");
        helperParam.getParams().put("invoiceSerialNos", StringUtils.arrayToString((Object[])invoiceSerialNo.toArray(), (String)","));
        String billId = (String)params.get("billId");
        helperParam.getParams().put("billId", billId);
        String billNumber = (String)params.get("billNumber");
        helperParam.getParams().put("billNumber", billNumber);
        pwyinvoiceHelper.invoiceHelperAction(helperParam);
        return ret;
    }

    protected Map initIncomeInvoiceF7(Map params) throws Exception {
        HashMap<String, IncomeInvoiceMutilSelectListUIPromptDialog> ret = new HashMap<String, IncomeInvoiceMutilSelectListUIPromptDialog>();
        KDBizPromptBox prmtIncomeInvoice = (KDBizPromptBox)params.get("prmtIncomeInvoice");
        CoreUI ui = (CoreUI)params.get("ui");
        prmtIncomeInvoice.setEnabledMultiSelection(true);
        IncomeInvoiceMutilSelectListUIPromptDialog uiPromptDialog = new IncomeInvoiceMutilSelectListUIPromptDialog((IUIObject)ui);
        prmtIncomeInvoice.setSelector((KDPromptSelector)uiPromptDialog);
        prmtIncomeInvoice.setEditFormat("$number$");
        prmtIncomeInvoice.setDisplayFormat("$number$");
        prmtIncomeInvoice.setCommitFormat("$number$");
        ret.put("uiPromptDialog", uiPromptDialog);
        return ret;
    }

    protected Map addIncomeInvoiceF7Filter(Map params) throws Exception {
        HashMap res = new HashMap();
        InvoiceHelperParam helperParam = new InvoiceHelperParam();
        helperParam.setCurrAcct((DataBaseInfo)params.get("currAcctSupplier"));
        helperParam.setCompany((CompanyOrgUnitInfo)params.get("company"));
        IncomeInvoiceMutilSelectListUIPromptDialog uiPromptDialog = (IncomeInvoiceMutilSelectListUIPromptDialog)params.get("uiPromptDialog");
        InvoiceHelperUI ui = new InvoiceHelperUI();
        ui.setHelperParam(helperParam);
        uiPromptDialog.setBOTPFilter(ui.getIncomeInvoiceF7Filter());
        return res;
    }

    public void downloadInvoiceFormAP(Map params) throws EASBizException, BOSException {
        String retJsonStr = (String)params.get("invoiceJson");
        String companyId = (String)params.get("companyId");
        Context ctx = (Context)params.get("ctx");
        try {
            JSONObject retJson = null;
            retJson = new JSONObject(retJsonStr);
            if (retJson != null && "0000".equals(retJson.get("errcode"))) {
                logger.error((Object)"enter method downloadInvoiceFormAP.");
                DownloadInvoiceParams downloadParams = new DownloadInvoiceParams(DownloadInvoiceType.PWYHELP);
                downloadParams.setCompanyId(companyId);
                downloadParams.put((Object)"operation", (Object)InvoiceHelperParam.OPR_DOWNLOAD);
                downloadParams.setNeedFilterSave(false);
                BizInterfaceFactory.getTMCommonFacade(ctx).parseDownLoadInvoice(retJsonStr, downloadParams);
            } else {
                logger.error((Object)("downInvoiceBySn retJson=" + retJson));
            }
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

