/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ws.app.handler;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.service.ICallBackService;
import com.kingdee.eas.tm.im.common.comm.service.ierp.callback.IERPCallBackFactory;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.ws.ResultInfo;
import com.kingdee.eas.tm.im.ws.app.message.IMessageHandler;
import com.kingdee.util.LowTimer;
import org.apache.log4j.Logger;

public class SIMCallBackMessageHandler
implements IMessageHandler {
    private static Logger logger = Logger.getLogger(SIMCallBackMessageHandler.class);

    @Override
    public String process(Context ctx, String dataJSON) throws BOSException, EASBizException {
        try {
            logger.debug((Object)("dataJSON:" + dataJSON));
            LowTimer timer = new LowTimer();
            JSONObject json = new JSONObject(dataJSON);
            String interfaceCode = json.getString("interfaceCode");
            ICallBackService callBackService = IERPCallBackFactory.getSIMCallBackService(ctx, interfaceCode);
            ResultInfo resultInfo = callBackService.callback(dataJSON);
            logger.debug((Object)("\u3010SIMCallBackMessageHandler.process\u3011 take time\uff1a" + timer.msValue()));
            return JSON.toJSONString((Object)resultInfo);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return JSON.toJSONString((Object)ResultInfo.buildError(e.getMessage()));
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            return JSON.toJSONString((Object)ResultInfo.buildError(IMUtils.getString("com.kingdee.eas.tm.im.common.comm.IMCommResource", "UNKOWN_ERROR", ctx.getLocale())));
        }
    }
}

