/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.InvResourceType;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.ws.app.importbill.TMBillSupport;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IncomeInvoiceSupport
extends TMBillSupport {
    private Map pricePrecisionMap = new HashMap();

    @Override
    public ICoreBase getInterface() throws BOSException {
        return IncomeInvoiceFactory.getLocalInstance(this.getContext());
    }

    @Override
    public Class<IncomeInvoiceCollection> getInfoClass() {
        return IncomeInvoiceCollection.class;
    }

    @Override
    public String getEntryName() {
        return "entries";
    }

    @Override
    protected void setDefaultHeadData(CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        if (info.getCurrentAccountType() == null) {
            info.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        }
        if (info.getInvoiceType() != null) {
            PayInvoiceTypeEnum invoiceType = PayInvoiceTypeEnum.getEnum((String)info.getInvoiceType().getValue());
            info.setInvoiceType(invoiceType);
        }
        info.setResourceType(InvResourceType.INV_WEBSERVICE);
    }

    @Override
    protected void dealWithData(Context ctx, CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        super.dealWithData(ctx, model, errorMsg);
        this.calculateHeadData(model);
    }

    private void calculateHeadData(CoreBillBaseInfo model) {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal amountTax = BigDecimal.ZERO;
        IncomeInvoiceEntryCollection entries = info.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            amount = amount.add(entries.get(i).getMoney() != null ? entries.get(i).getMoney() : this.zero);
            tax = tax.add(entries.get(i).getTaxAmt() != null ? entries.get(i).getTaxAmt() : this.zero);
            amountTax = amountTax.add(entries.get(i).getTaxTotal() != null ? entries.get(i).getTaxTotal() : this.zero);
        }
        info.setAmount(amount);
        info.setTax(tax);
        info.setAmountTax(amountTax);
    }

    @Override
    protected void dealWithEntryData(int rownum, CoreBillEntryBaseInfo entryModel, CoreBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        IncomeInvoiceEntryInfo entry = (IncomeInvoiceEntryInfo)entryModel;
        CompanyOrgUnitInfo company = info.getCompany();
        if (company == null) {
            return;
        }
        int pricePrecision = this.getPricePrecision(this.getContext(), company.getId().toString());
        BigDecimal quantity = entry.getQuantity();
        BigDecimal taxExcluded = entry.getTaxExcluded();
        BigDecimal taxPrice = entry.getTaxPrice();
        BigDecimal money = entry.getMoney();
        BigDecimal taxRate = entry.getTaxRate();
        BigDecimal taxAmt = entry.getTaxAmt();
        BigDecimal taxTotal = entry.getTaxTotal();
        if (taxRate != null && taxRate.compareTo(this.zero) != 0) {
            if (taxPrice == null && taxExcluded != null) {
                taxPrice = taxExcluded.multiply(new BigDecimal(1).add(taxRate)).setScale(pricePrecision, 6);
                entry.setTaxPrice(taxPrice);
            }
            if (taxExcluded == null && taxPrice != null) {
                taxExcluded = taxPrice.divide(new BigDecimal(1).add(taxRate), pricePrecision, 6);
                entry.setTaxExcluded(taxExcluded);
            }
            if (quantity != null && quantity.compareTo(this.zero) != 0 && taxExcluded != null && money == null) {
                money = taxExcluded.multiply(new BigDecimal(1).add(quantity)).setScale(2, 6);
            }
            if (money == null && taxTotal != null) {
                money = taxTotal.divide(new BigDecimal(1).add(taxRate), 2, 6);
                entry.setMoney(money);
            }
            if (taxTotal == null && money != null) {
                taxTotal = money.multiply(new BigDecimal(1).add(taxRate)).setScale(2, 6);
                entry.setTaxTotal(taxTotal);
            }
            if (taxAmt == null && money != null) {
                taxAmt = money.multiply(taxRate).setScale(2, 6);
                entry.setTaxAmt(taxAmt);
            }
        }
    }

    private int getPricePrecision(Context ctx, String companyId) throws EASBizException, BOSException {
        Object value = this.pricePrecisionMap.get(companyId);
        int pricePrecision = 2;
        if (value == null) {
            pricePrecision = IMUtils.getDecimalParam(ctx, companyId, new String[]{"VATM001"}).intValue();
            this.pricePrecisionMap.put(companyId, pricePrecision);
        } else {
            pricePrecision = Integer.parseInt(value.toString());
        }
        return pricePrecision;
    }

    @Override
    protected void verifyHeadData(CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        IncomeInvoiceInfo info = (IncomeInvoiceInfo)model;
        StringBuffer sb = new StringBuffer();
        if (info.getCompany() != null) {
            try {
                IMFacadeFactory.getLocalInstance(this.getContext()).checkFunctionPermission(info.getCompany().getId().toString(), "im_incomeInvoice_new");
            }
            catch (Exception e) {
                sb.append(e.getMessage());
                errorMsg.add(sb.toString());
                return;
            }
        } else {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "Company", this.getContext().getLocale()));
        }
        if (StringUtils.isEmpty((String)info.getInvoiceCode())) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "InvoiceCode", this.getContext().getLocale()));
        }
        if (StringUtils.isEmpty((String)info.getInvoiceNumber())) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "InvoiceNumber", this.getContext().getLocale()));
        }
        if (info.getBizDate() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "InvoiceDate", this.getContext().getLocale()));
        }
        if (info.getInvoiceType() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "InvoiceType", this.getContext().getLocale()));
        }
        if (StringUtils.isEmpty((String)info.getBillingCompany())) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "BillCompany", this.getContext().getLocale()));
        }
        if ((PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)info.getInvoiceType()) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)info.getInvoiceType())) && StringUtils.isEmpty((String)info.getTaxNumber())) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "TaxNumber", this.getContext().getLocale()));
        }
        if (sb.length() > 0) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", "NotNull", this.getContext().getLocale())).append("\r\n");
        }
        String code = info.getInvoiceCode();
        String number = info.getInvoiceNumber();
        String oql = null;
        oql = info.getId() != null ? "select id where id !='" + info.getId().toString() + "' and invoiceCode = '" + code + "' and invoiceNumber = '" + number + "'" : "select id where invoiceCode = '" + code + "' and invoiceNumber = '" + number + "'";
        IncomeInvoiceCollection invoiceCollection = IncomeInvoiceFactory.getLocalInstance(this.getContext()).getIncomeInvoiceCollection(oql);
        if (!invoiceCollection.isEmpty()) {
            sb.append(new IMException(IMException.INCOMEREPETITION).getMessage());
            errorMsg.add(sb.substring(1));
        }
    }

    @Override
    protected void verifyEntryData(int rownum, CoreBillEntryBaseInfo entryModel, CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        IncomeInvoiceEntryInfo entry = (IncomeInvoiceEntryInfo)entryModel;
        StringBuffer errors = new StringBuffer();
        if (entry.getProductName() == null) {
            errors.append(",").append(IMUtils.getIMResource(this.getContext(), "PRODNAMEISNULL", new String[0]));
        }
        if (entry.getMoney() == null) {
            errors.append(",").append(IMUtils.getIMResource(this.getContext(), "NOTAXAMOUTISNULL", new String[0]));
        }
        if (entry.getTaxAmt() == null) {
            errors.append(",").append(IMUtils.getIMResource(this.getContext(), "TAXAMTISNULL", new String[0]));
        }
        if (entry.getTaxTotal() == null) {
            errors.append(",").append(IMUtils.getIMResource(this.getContext(), "PRICETAXISNULL", new String[0]));
        }
        if (errors.length() > 0) {
            errorMsg.add(errors.toString());
        }
    }
}

