/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMKBizTypeEnum;
import com.kingdee.eas.tm.im.MakeInvoiceReqCollection;
import com.kingdee.eas.tm.im.MakeInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqFactory;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqSrcSystem;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.ws.app.importbill.TMBillSupport;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;

public class MakeInvoiceReqSupport
extends TMBillSupport {
    @Override
    public String getEntryName() {
        return "entries";
    }

    @Override
    public ICoreBase getInterface() throws BOSException {
        return MakeInvoiceReqFactory.getLocalInstance(this.getContext());
    }

    @Override
    public Class<MakeInvoiceReqCollection> getInfoClass() {
        return MakeInvoiceReqCollection.class;
    }

    @Override
    public void setDefaultHeadData(CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)model;
        info.setSrcSystem(MakeInvoiceReqSrcSystem.DOWNLOAD);
        info.setBizType(IMKBizTypeEnum.EAS);
        AsstActTypeInfo asstActTypeInfo = info.getAsstActType();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            ProductCodeInfo productCodeInfo;
            MakeInvoiceReqEntryInfo entryInfo = info.getEntries().get(i);
            if (!StringUtils.isEmpty((String)entryInfo.getProductName()) || !StringUtils.isEmpty((String)entryInfo.getTaxClassificationCode())) continue;
            String materialID = null;
            String expenseTypeID = null;
            if (entryInfo.getMaterial() != null) {
                materialID = entryInfo.getMaterial().getId().toString();
                if (StringUtils.isEmpty((String)entryInfo.getProductName())) {
                    entryInfo.setProductName(entryInfo.getMaterial().getName());
                }
            } else {
                if (entryInfo.getExpenseItem() == null) continue;
                expenseTypeID = entryInfo.getExpenseItem().getId().toString();
                if (StringUtils.isEmpty((String)entryInfo.getProductName())) {
                    entryInfo.setProductName(entryInfo.getExpenseItem().getName());
                }
            }
            String customerId = null;
            if (asstActTypeInfo != null && "T_BD_Customer".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
                customerId = info.getAsstActID();
            }
            if ((productCodeInfo = ProductCodeFactory.getLocalInstance(this.getContext()).getMatchProduct(customerId, info.getCompany().getId().toString(), materialID, expenseTypeID, entryInfo.getTaxRate(), info.isIsVehicle(), info.isIsDiffTax())) == null) continue;
            entryInfo.setProductCode(productCodeInfo);
            entryInfo.setProductName(productCodeInfo.getName());
            if (productCodeInfo.getTaxClassificationCode() == null) continue;
            entryInfo.setTaxClassificationCode(productCodeInfo.getTaxClassificationCode().getMergeCode());
        }
    }

    @Override
    protected void verifyHeadData(CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)model;
        StringBuffer sb = new StringBuffer();
        if (info.getCompany() != null) {
            try {
                IMFacadeFactory.getLocalInstance(this.getContext()).checkFunctionPermission(info.getCompany().getId().toString(), "im_makeInvoiceReq_new");
            }
            catch (Exception e) {
                sb.append(e.getMessage());
                errorMsg.add(sb.toString());
                return;
            }
        } else {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "COMPANY", this.getContext().getLocale()));
        }
        if (info.getCurrency() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "Currency", this.getContext().getLocale()));
        }
        if (info.getExchangeRate() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ExchangeRate", this.getContext().getLocale()));
        }
        if (info.getTax() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "TB_NOTAXAMT", this.getContext().getLocale()));
        }
        if (info.getTaxLocal() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "TaxLocal", this.getContext().getLocale()));
        }
        if (info.getPriceIncludingTax() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "TB_PRICETAX", this.getContext().getLocale()));
        }
        if (info.getPriceIncludingTaxLocal() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "PriceIncludingTaxLocal", this.getContext().getLocale()));
        }
        if (info.getPriceExcludingTax() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "TB_TAXAMT", this.getContext().getLocale()));
        }
        if (info.getPriceExcludingTaxLocal() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "PriceExcludingTaxLocal", this.getContext().getLocale()));
        }
        if (sb.length() > 0) {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"NOTNULL", (Locale)this.getContext().getLocale()));
            errorMsg.add(sb.substring(1));
        }
        if (info.isIsPurchaseInvoice() && info.isIsVehicle()) {
            errorMsg.add(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "SGFP_REPEAT", this.getContext().getLocale()));
        }
    }

    @Override
    protected void verifyEntryData(int rownum, CoreBillEntryBaseInfo entryModel, CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)model;
        MakeInvoiceReqEntryInfo entry = (MakeInvoiceReqEntryInfo)entryModel;
        StringBuffer sb = new StringBuffer();
        if (entry.getProductName() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "ENTRY_PRODUCTNAME", this.getContext().getLocale()));
        }
        if (StringUtils.isEmpty((String)entry.getUnitName())) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "ENTRY_UNITNAME", this.getContext().getLocale()));
        }
        if (entry.getQty() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "ENTRY_QTY", this.getContext().getLocale()));
        }
        if (entry.getBaseUnit() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "ENTRY_BASEUNIT", this.getContext().getLocale()));
        }
        if (entry.getBaseQty() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "ENTRY_BASEQTY", this.getContext().getLocale()));
        }
        if (entry.getNoTaxPrice() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "ENTRY_NOTAXPRICE", this.getContext().getLocale()));
        }
        if (entry.getPrice() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "ENTRY_PRICE", this.getContext().getLocale()));
        }
        if (entry.getPriceExcludingTax() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "ENTRY_PRICEEXCLUDINGTAX", this.getContext().getLocale()));
        }
        if (entry.getPriceExcludingTaxLocal() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "ENTRY_PRICEEXCLUDINGTAXLOCAL", this.getContext().getLocale()));
        }
        if (entry.getTax() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "ENTRY_TAX", this.getContext().getLocale()));
        }
        if (entry.getTaxLocal() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "ENTRY_TAXLOCAL", this.getContext().getLocale()));
        }
        if (entry.getPriceIncludingTax() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "ENTRY_PRICEINCLUDINGTAX", this.getContext().getLocale()));
        }
        if (entry.getPriceIncludingTaxLocal() == null) {
            sb.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "ENTRY_PRICEINCLUDINGTAXLOCAL", this.getContext().getLocale()));
        }
        if (sb.length() > 0) {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"NOTNULL", (Locale)this.getContext().getLocale()));
            errorMsg.add(sb.substring(0, sb.toString().length() - 1));
        }
        if (info.isIsVehicle()) {
            TaxClassificationCodeInfo tccInfo;
            StringBuffer lineMsg = new StringBuffer();
            String billMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "VEHICLE_REQBILL", this.getContext().getLocale());
            if (entry.getPrice() == null || entry.getNoTaxPrice() == null || entry.getQty() == null || BigDecimal.ZERO.compareTo(entry.getPrice()) == 0 || BigDecimal.ZERO.compareTo(entry.getNoTaxPrice()) == 0 || BigDecimal.ZERO.compareTo(entry.getQty()) == 0) {
                lineMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_PRICEANDQTY_NOTNULL", this.getContext().getLocale())).append("\u3001");
            }
            if (!StringUtils.isEmpty((String)entry.getTaxClassificationCode()) && (tccInfo = TaxClassificationCodeFactory.getLocalInstance(this.getContext()).getTaxClassificationCodeInfo("where mergeCode = '" + entry.getTaxClassificationCode() + "'")) != null && !"\u673a\u52a8\u8f66".equals(tccInfo.getSimpleName())) {
                lineMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_TAXCLASSIFICATIONCODE_NOTVOLID", this.getContext().getLocale())).append("\u3001");
            }
            if (lineMsg.length() > 0) {
                String line = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_LINE_MSG", this.getContext().getLocale(), new Object[]{rownum});
                String msg = line + "\uff0c" + billMsg + lineMsg.substring(0, lineMsg.length() - 1);
                errorMsg.add(msg);
            }
        }
    }
}

